<?php
$Plugin = 'Vote';
$MyPlugin = "$MyPlugins/$Plugin/";	// This plugin folder

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = "$MyPlugData/$Plugin/";

$ConfigFile = $MyPluginDataFolder.'config.php';
$MyDB = new SQLite3($MyPluginDataFolder.'DB.db');

$strAuswahl = '<p>Sie müssen erst eine Auswahlliste auswählen.</p>';
$strDD = ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag'];

//	############
function AllowedChangers($R0,$R1) {
	global $WIBcmsRole,$Roles;

	echo '<tr><td>';
	echo '<select id="Gruppe" name="Gruppe">';
	echo txtOption(0,'keine Benutzergruppe');
	foreach ($WIBcmsRole as $nr=>$Role) {
		if ($nr>0) echo txtOption($nr,$Role,$R0);
	}
	echo '</select></td><td><select id="Rolle" name="Rolle">';
	echo txtOption(0,'keine Mitarbeiter-Rolle');
	foreach ($Roles as $Role) {
		echo txtOption($Role,$Role,$R1);
	}
	echo "</select></td></tr>\n";
}
/*
https://www.compart.com/de/unicode/html :
&circledast; &circleddash; &#8860; (&#x229C;) &cir; &xcirc; &olcir; &ofcir; &xodot; &#11095;
*/
function SymbolSelect($Name,$Wert) {
	$sym = '<select style="width:50px" name="'.$Name.'">';
	$sym.= txtOption('&nbsp;','&nbsp;',$Wert);

	$sym.= txtOption('✓','&check;',$Wert);
	$sym.= txtOption('<b>✓</b>','&check;',$Wert,'','font-weight:bold');
	$sym.= txtOption('<b>✔</b>','&#x2714;',$Wert,'','font-weight:bold');

	$sym.= txtOption('✗','&cross;',$Wert);
	$sym.= txtOption('<b>✗</b>','&cross;',$Wert,'','font-weight:bold');
	$sym.= txtOption('<b>✘</b>','&#x2718;',$Wert,'','font-weight:bold');

	$sym.= txtOption('<big>⊕</big>','&CirclePlus;',$Wert,'','font-size:large');
	$sym.= txtOption('<big>⊖</big>','&CircleMinus;',$Wert,'','font-size:large');
	$sym.= txtOption('<big>⊗</big>','&CircleTimes;',$Wert,'','font-size:large');

	$sym.= txtOption('<big>⊙</big>','&odot;',$Wert,'','font-size:large');
	$sym.= txtOption('<big>⊚</big>','&circledcirc;',$Wert,'','font-size:large');
	$sym.= txtOption('<big>★</big>','&starf;',$Wert,'','font-size:large');

	$sym.= "</select> Symbol $Wert";
	return $sym;
}
//	########################## Wir holen uns vorab die Daten, dann können wir eine Kopie anlegen! ###################################
if ($parm>0) {
	$sql = "SELECT * FROM List WHERE ID=$parm";
	$rec = $MyDB->query($sql);
	$res = $rec->fetchArray(SQLITE3_ASSOC);	// SQLITE3_NUM | SQLITE3_BOTH
	$Name  = $res['Name'];
	$Desc  = br2text($res['Desc']);
	$Type  = $res['Type'];
	$Options=$res['Options'];
	$Colors= $res['Colors'];
	$Summen= $res['Summen'];
	$Zeiten= $res['Zeiten'];
	$TimCol= $res['TimCol'];
	$ShowN = $res['ShowN'];
	$ShowD = $res['ShowD'];
	$ShowS = $res['ShowS'];
	$ShowT = $res['ShowT'];
	$BGSum = $res['BGSum'];
	$ShowL = $res['ShowL'];
	$Clean = $res['Clean'];
	$Rights= $res['Rights'];
	$Valid = $res['Valid'];
	$Akzent= $res['Akzent'];
	$Symbol= $res['Symbol'];
	$Cells = $res['Cell'];
	$Display=$res['Display'];
	$Leave = $res['Leaves'];
} else {
	$Type = $_GET['typ'] ?? 0;
	$Name = $Desc = 'Text';
	$ShowN = $ShowD = $ShowS = $Clean = 0;
	$ShowT = 1;
	$Options= 'Vielleicht;Ja;Nein';
	$Colors= $TimCol = $Akzent = '#ffffdd;#00ff00;#ff0000';
	$Summen= '1;1;1';
	$BGSum = '#dfdfdf';
	$Rights= '0;0;0;0;0;0;0;0';
	$Leave = '0;#c4f0ff';
	$Valid = $Symbol = $Cells = $Display = $Zeiten = $ShowL = ';;';
	if ($Type>4 && $Type<11) {
		$Zeiten = date('c');
	}
}
$Option = explode(';',$Options);
$Colour = explode(';',$Colors);
$SZeile = explode(';',$Summen);
$Item	= explode(';',$Zeiten);
$Farben = explode(';',$TimCol);
$Rechte = explode(';',$Rights);
$Valide = explode(';',$Valid);
$Accent = explode(';',$Akzent);
$Symbol = explode(';',$Symbol);
$Cell   = explode(';',$Cells);
$Display= explode(';',$Display);
$Leaves = explode(';',$Leave);
$ShowL  = explode(';',$ShowL);

formkopf("Hier konfigurieren Sie das $Plugin-Plugin");

// Tabs:
echo '<div class="configmenu"><span id="Config0">Eigenschaften</span><span id="Config1">Auswahlfelder</span><span id="Config2">Darstellung</span><span id="Config3">Automatiken</span><span id="Config4">Personen/Rechte</span></div>';

//	Die Sache mit der Kopie:
$Copy = $_GET['copy'] ?? 0;
if ($Copy) {
//	echo "Ich soll Liste $parm kopieren!!!!<br>";
	$Name .= ' - Kopie';
	$parm = 0;
}

//	Auswahl der Liste in jedem Tab:
echo "<fieldset>\n";
$sql = 'SELECT ID,Name FROM List';
$List = $MyDB->query($sql);
startSelect('ListID','Auswahlliste','onchange="idx=this.options[this.selectedIndex];if (idx.value>=0) {t=document.formbox.Type;s=t.selectedIndex;v=t.options[s].value;oeffne(\'Plugin:Vote\',idx.value+\'&typ=\'+v,0)}"');
echo txtOption(-1,'Bitte auswählen');
while ($Lib = $List->fetchArray()) {
	echo txtOption($Lib[0],$Lib[1],$parm);
}
echo txtOption(0,'Neue Auswahlliste',$parm);
echo '</select> ';
if ($parm==0) {
	startSelect('AutoPage',' Neue Seite:');
	echo '<option value="0">keine Seite anlegen</option><optgroup label="Ist Unterseite von">'."\n";
	echo pagemap(0,0);
	echo '</optgroup></select> nach oben: '.txtSelCheck('ToTop',0);;
}
echo "<br></fieldset>\n";
?>
<div id="divConfig0" class="helper">
<fieldset><legend>Seitentexte zur Auswahlliste</legend>
<?php
if ($parm<0) {
	echo $strAuswahl;
} else {
	echo txtInput('Name', 'Bezeichnung', $Name);
	echo '<label>Beschreibung</label><textarea name="Desk">'.$Desc."</textarea>\n";	// class="tinyMCE"
	echo '</fieldset><fieldset><legend>Anzeige</legend>';
	startSelect('ShowN','Bezeichnung');
	echo HeaderSelect($ShowN)."</select><br>\n";
	startSelect('ShowD','Beschreibung');
	echo HeaderSelect($ShowD)."</select><br>\n";
	echo "</fieldset><fieldset><legend>Funktionsweise der Auswahlliste</legend>\n";
	startSelect('Type','Listentyp');
	if ($parm)
		echo txtOption(-1,'Diese Anwendung LÖSCHEN (mit allen Daten!)',$Type,'','color:red;');
	echo txtOption( 0,'Ewiger Kalender mit tageweiser Zu-/Absage (mit Optionen)',$Type);
	echo txtOption( 1,'Ewiger Kalender mit tageweiser Zu-/Absage (nur ja/nein)',$Type);
	echo txtOption( 2,'Wiederkehrende Termine mit Zu-/Absage und Optionen',$Type);
	echo txtOption( 3,'Wiederkehrende Termine mit Zu-/Absage, ohne Optionen',$Type);
/*	echo txtOption( 4,'einzelne Teiltage mit echter Zeit von/bis, frei wählbar)',$Type);
	echo txtOption( 5,'Teiltage ein Tag (von) mit Zeitfenster ZeitVon (in Liste vorgegeben)',$Type);
	echo txtOption( 6,'mehrere Tage mit echter Zeit (von Tag,Zeit bis Tag,Zeit)',$Type);
	echo txtOption( 7,'zukünftige Erweiterung',$Type);	*/
	echo txtOption( 8,'Terminabsprache (mit Optionen)',$Type);
	echo txtOption( 9,'Terminabsprache (nur ja/nein)',$Type);
	echo txtOption(10,'Terminabsprache (1-aus-n)',$Type);

	echo txtOption(11,'Umfrage Multiple Choice (mit Optionen)',$Type);
	echo txtOption(12,'Umfrage Multiple Choice (nur ja/nein)',$Type);
	echo txtOption(13,'Umfrage 1-aus-n (nur ja/nein)',$Type);
//	echo txtOption(14,'Umfrage 1-aus-n (mit Optionen)',$Type);	//	wie soll das funktionieren? Radio oder Checkbox?
	echo "</select> Wie erfolgt die Auswahl von Tagen/Antworten?<br>\n";
}
?>
</fieldset></div>

<div id="divConfig1" class="helper">
<fieldset><legend>Auswahlmöglichkeiten (Bezeichnungen und Farben)</legend>
<?php
$is_MCwOpt = ($Type==0 || $Type==2 || $Type==8 || $Type==11);
$is_MConly = ($Type==1 || $Type==3 || $Type==9 || $Type==12);
$is_OneOfN = ($Type==10 || $Type==13);

if ($parm<0) {
	echo $strAuswahl;
} else {
	if ($Type<4) {
//	ewiger Kalender
		$opt = '';
		if ($Type<2) {
//		Tageskalender:
			startSelect('Times[0]','Wochenenden');
			echo txtOption(0,'nicht berücksichtigen (normaler Tag)',$Item[0]);
			echo txtOption(1,'nur markieren, aber aktiv wählbar',$Item[0]);
			echo txtOption(2,'markieren und nicht aktiv wählbar',$Item[0]);
			echo txtOption(3,'ganz ausblenden',$Item[0]);
			$txt = colInput("Farben[1]", "Hintergrund", $Farben[1], 'Akzent');
			echo '</select> ' . colInput('Farben[0]', 'Markierung', $Farben[0], $txt) . "<br>\n";
		} else {
//		Regel-Termine:
			$txt = explode('-',$Item[0]);
			$Period = $txt[1];
			$Weekday= $txt[0];
			$txt = '<input type="number" name="Period" min="1" max="4" step="1" value="'.$Period.'">';

			startSelect('Times[0]',"Jeder $txt .");
			foreach($strDD as $nr=>$Tag) {
				echo txtOption($nr,$Tag,$Weekday);
			}
			$txt = colInput("Farben[1]", "Hintergrund", $Farben[1], 'Akzent');
			echo '</select> ' . colInput('Farben[0]', 'im Monat', $Farben[0], $txt) . "<br>\n";
			$opt = txtOption(4,'um 1 Woche verschieben',$Item[1]);
			$opt.= txtOption(5,'auf nächsten Werktag verschieben',$Item[1]);
		}

		startSelect('Times[1]','Feiertage');
		echo txtOption(0,'nicht berücksichtigen (normaler Tag)',$Item[1]);
		echo txtOption(1,'nur markieren, aber aktiv wählbar',$Item[1]);
		echo txtOption(2,'markieren und nicht aktiv wählbar',$Item[1]);
		echo txtOption(3,'ganz ausblenden',$Item[1]);
		echo $opt;
		echo '</select> <select name="Times[2]">';
		$ArrayLaender = ArrayLaender('DE');
		foreach($ArrayLaender as $LK=>$Land) {
//			if ($LK!='AA')
				echo txtOption($LK,$Land,$Item[2]);
		}
		echo "</select> Bundesland<br>\n";

		echo "</fieldset><fieldset><legend>Betriebsschließungen</legend>\n";
		startSelect('Leaves[0]','Urlaubszeiten');
		echo txtOption(0,'nicht markieren',$Leaves[0]);
		echo txtOption(1,'nur markieren, aber aktiv wählbar',$Leaves[0]);
		echo txtOption(2,'markieren und nicht aktiv wählbar',$Leaves[0]);
		echo txtOption(3,'ganz ausblenden',$Leaves[0]);
		echo '</select> ' . colInput('Leaves[1]', ' Hintergrund', $Leaves[1]) . "<br>\n";
		$max = count($Leaves);
		$nr = 2; $i=1;
		while ($nr<$max) {
			$x = $nr+1;
			echo txtDateInput("Leaves[$nr]","Urlaubszeit $i", $Leaves[$nr], ' Ende <input type="date" name="Leaves['.$x.']" value="'.$Leaves[$x].'">','');
			$nr += 2; $i++;
		}
		echo txtDateInput("Leaves[$nr]",'Weiterer Urlaub', '', ' Ende <input type="date" name="Leaves['. $nr+1 .']">','');

		if ($Type<2) {
//		wegen der Reihenfolge des Arrays!
			startSelect('Times[3]','Ruhetag');
			echo txtOption(0,'nicht markieren',$Item[3]);
			echo txtOption(1,'nur markieren, aber aktiv wählbar',$Item[3]);
			echo txtOption(2,'markieren und nicht aktiv wählbar',$Item[3]);
			echo txtOption(3,'ganz ausblenden',$Item[3]);
			echo '</select> <select name="Farben[3]">';
			foreach($strDD as $nr=>$Tag) {
				echo txtOption($nr,$Tag,$Farben[3]);
			}
			echo txtOption(8,'kein Ruhetag',$Farben[3]);
			echo "</select> Wochentag<br>\n";
		}

	} elseif ($Type<11) {
//	Abfrage nach Terminen:
		foreach($Item as $nr=>$Feld) {
			$x = $nr+1;
			$Zeit = explode('T',$Feld);
			$txt = '<input type="time" name="Times['.$nr.'][1]" value="'.$Zeit[1].'">';
			$txt = colInput("Farben[$nr]", $txt, $Farben[$nr], "Farbe für Termin $x");
			echo txtDateInput("Times[$nr][0]","Termin $x", $Zeit[0], $txt,'');
		}
//		$nr++; $x++;
		$txt = '<input type="time" name="Times['.$x.'][1]" value="">';
		$txt = colInput("Farben[$x]", $txt, $Farben[$nr], 'Farbe für neuen Termin');
		echo txtDateInput("Times[$x][0]",'Neuer Termin', '', $txt,'');
// ++++++++++++++++++++++++++++++++++ neuer Termin +++++++++++++++++++++++++++++
	} else {
//	textliche Auswahlen
		foreach($Item as $nr=>$Feld) {
			$x = $nr+1;
			$txt = colInput("Farben[$nr]", "Bezeichnung", $Farben[$nr], "Farbe für Auswahl $x");
			echo txtInput("Times[$nr]","Auswahl $x", $Feld, $txt);
		}
		$nr++; $x++;
		$txt = colInput("Farben[$nr]", 'Bezeichnung', '#ffffff', "Farbe für neue Auswahl $x");
		echo txtInput("Times[$nr]","Auswahl $x (neu)", '', $txt);
	}

	echo "</fieldset><fieldset><legend>Bezeichnungen und Farben der Optionen</legend>\n";
	foreach($Option as $nr=>$Feld) {
		$x = $nr+1;
		$checked = $SZeile[$nr] ? ' checked>':'>';
		$sum = '<input type="checkbox" name="Summe['.$nr.']"'.$checked;
		$acc = colInput("Accent[$nr]", 'Farbe / Akzent', $Accent[$nr], SymbolSelect("Symbol[$nr]",$Symbol[$nr]));
		$txt = colInput("Colour[$nr]", "Summe? $sum", $Colour[$nr], $acc);
		echo txtInput("Option[$nr]","Option $x", $Feld, $txt);
	}
	$nr++; $x++;
	$sum = '<input type="checkbox" name="Summe['.$nr.']">';
	$acc = colInput("Accent[$nr]", 'Farbe / Akzent', '#ffffff', SymbolSelect("Symbol[$nr]",''));
	$txt = colInput("Colour[$nr]", "Summe? $sum", '#ffffff', $acc);
	echo txtInput("Option[$nr]","Option $x (neu)", '', $txt);

	if ($Type==0 || $Type==2) {	//	oder generell bei $is_MCwOpt - dann aber andere Variable, weil Farben[] schon verwendet
		$Farben[2] = 1;
		startSelect('Farben[2]','Löschoption');
		echo txtOption(0,'nein, Option 1 ist Option wie jede andere auch',$Farben[2]);
		echo txtOption(1,'ja, Option 1 setzt bisherige Auswahl zurück',$Farben[2]);
		echo "</select> Mit Option 1 alle anderen Optionen zurücksetzen?<br>\n";
	}

	echo "</fieldset><fieldset><legend>Summen und Berechnungen</legend>\n";
	startSelect('ShowS','Summenzeile');
	echo txtOption(  0,'keine Summen anzeigen',$ShowS);
	echo txtOption(  1,'Summen anzeigen wie ausgewählt (Standardfarbe)',$ShowS);
	echo txtOption(  2,'Summen anzeigen wie ausgewählt (Optionsfarbe)',$ShowS);
	echo txtOption(  3,'Summen anzeigen wie ausgewählt (Akzentfarbe)',$ShowS);
//	echo txtOption(129,'Summen anzeigen wie ausgewählt (farbig)',$ShowS);
	echo '</select> ' . colInput('BGSum',' Hintergrund',$BGSum,'Hintergrundfarbe');
}
?>
</fieldset>
</div>

<div id="divConfig2" class="helper">
<fieldset><legend>Darstellung der Auswahlliste</legend>
<?php
if ($parm<0) {
	echo $strAuswahl;
} else {
	startSelect('ShowT','Teilnehmerliste');
	echo txtOption( 0,'anonymisiert ("Teinehmer X")',$ShowT);
	echo txtOption( 1,'Vorname Nachname (alphabetisch)',$ShowT);
	echo txtOption( 2,'Nur Vorname (alphabetisch)',$ShowT);
	echo txtOption( 3,'Nachname, Vorname (alphabetisch)',$ShowT);
	echo txtOption( 4,'Nur Nachname (alphabetisch)',$ShowT);
	echo txtOption( 5,'Alias-Name (alphabetisch)',$ShowT);
	echo "</select> Wie soll die 1. Spalte (Teilnehmer) angezeigt werden? (gleiche Namen möglich)<br>\n";

/*	startSelect('Display[0]','2. Kopfzeile');
	echo txtOption( 0,'Kopfzeile nicht wiederholen',$Display[0]);
	echo txtOption( 1,'Kopfzeile unbedingt wiederholen',$Display[0]);
	echo txtOption( 2,'Kopfzeile wiederholen, wenn mehr als 10 Teilnehmer',$Display[0]);
	echo "</select> Kopfzeile mit Wahlmöglichkeiten über den Eingaben wiederholen<br>\n";	*/

	echo numInput('Display[0]','Bei mehr als',$Display[0],0,100,5,'','Teilnehmern: Kopfzeile mit Wahlmöglichkeiten über den Eingaben wiederholen (0: keine Wiederholung)<br>');

	startSelect('Display[1]','Anrede');
	echo txtOption( 0,'Du-Form',$Display[1]);
	echo txtOption( 1,'Sie-Form',$Display[1]);
	echo "</select> Wie sollen Teilnehmer angesprochen werden?<br>\n";

/*	startSelect('Display[2]','Extra-Spalte');
	echo txtOption( 0,'nein, keine Extraspalte anzeigen',$Display[2]);
	echo txtOption( 1,'ja, Zusatzinfo aus Rolle anzeigen',$Display[2]);
	echo "</select> Sollen bestimmte Teilnehmer gekennzeichnet werden?<br>\n";	*/
	echo txtInput('Display[2]','Extra-Spalte',$Display[2]);

	echo "</fieldset><fieldset><legend>Darstellung der Tabelle</legend>\n";

	startSelect('Cell[0]','Hintergrund');
	echo txtOption( 0,'Keine Farbe (Homepage-Standard)',$Cell[0]);
	echo txtOption( 1,'Optionsfarbe verwenden',$Cell[0]);
	echo txtOption( 2,'Akzentfarbe verwenden',$Cell[0]);
//	if ($Typ>4)	echo txtOption( 3,'Farbe der Auswahl verwenden',$Cell[0]);
	echo "</select> Tabellenzellen mit Einträgen einfärben<br>\n";

	startSelect('Cell[1]','Inhalt');
	echo txtOption( 0,'Standardfarbe der Homepage verwenden',$Cell[1]);
	echo txtOption( 1,'Optionsfarbe verwenden',$Cell[1]);
	echo txtOption( 2,'Akzentfarbe verwenden',$Cell[1]);
//	if ($Typ>4)	echo txtOption( 3,'Farbe der Auswahl verwenden',$Cell[1]);
	echo "</select> Zeichen/Symbole in Tabellenzellen<br>\n";

	echo "</fieldset><fieldset><legend>Legende</legend>\n";

	startSelect('ShowL[0]','Optionen');
	echo txtOption( 0,'keine Legende anzeigen',$ShowL[0]);
	echo txtOption( 1,'Legende unter der Tabelle anzeigen',$ShowL[0]);
	echo txtOption( 2,'Legende rechts neben der Tabelle anzeigen',$ShowL[0]);
	echo "</select> Optionen als Legende anzeigen (nur wenn es mehrere Optionen gibt)?<br>\n";

	if ($Type<4) {
		startSelect('ShowL[1]','Feiertage');
		echo txtOption( 0,'keine Legende anzeigen',$ShowL[1]);
		echo txtOption( 1,'Legende unter der Tabelle anzeigen',$ShowL[1]);
		echo txtOption( 2,'Legende rechts neben der Tabelle anzeigen',$ShowL[1]);
		echo "</select> Feiertage als Legende anzeigen (nur die im angezeigten Monat)?<br>\n";

		startSelect('ShowL[2]','Ruhetag');
		echo txtOption( 0,'keine Legende anzeigen',$ShowL[2]);
		echo txtOption( 1,'Legende unter der Tabelle anzeigen',$ShowL[2]);
		echo txtOption( 2,'Legende rechts neben der Tabelle anzeigen',$ShowL[2]);
		echo "</select> Ruhetag als Legende anzeigen (nur wenn zutreffend)?<br>\n";

		startSelect('ShowL[3]','Ferien');
		echo txtOption( 0,'keine Legende anzeigen',$ShowL[3]);
		echo txtOption( 1,'Legende unter der Tabelle anzeigen',$ShowL[3]);
		echo txtOption( 2,'Legende rechts neben der Tabelle anzeigen',$ShowL[3]);
		echo "</select> Betriebsferien als Legende anzeigen (nur die im angezeigten Monat)?<br>\n";
	} else {
		echo '<input type="hidden" name="ShowL[1]" value="0"><input type="hidden" name="ShowL[2]" value="0"><input type="hidden" name="ShowL[3]" value="0">';
	}
}
?>
</fieldset>
</div>

<div id="divConfig3" class="helper">
<fieldset><legend>Umfragedauer</legend>
<?php
	echo txtDateInput('Valide[0]','Umfragestart',$Valide[0],'Erster Tag');
	echo txtDateInput('Valide[1]','Umfrageende',$Valide[1],'Letzter Tag');
	echo '<small>Bei einem "ewigen Kalender" spielen Beginn und Ende natürlich keine Rolle.</small>';

	echo "</fieldset><fieldset><legend>Datenbereinigung</legend>\n";

	startSelect('Clean','Auto-Clean');
	echo txtOption( 0,'keine Daten löschen, ewig aufheben',$Clean);
	echo txtOption( 1,'Kalenderdaten aus Vormonaten automatisch löschen',$Clean);
	echo txtOption( 2,'Abgelaufene Umfragen automatisch löschen',$Clean);
	echo "</select> Bereinigung der Datenbestände/Umfragen (zurzeit inaktiv)<br>\n";

	echo "</fieldset><fieldset><legend>E-Mail-Benachrichtigungen</legend>\n";

	
?>
</div>

<div id="divConfig4" class="helper">
<fieldset><legend>Rechtevergabe</legend>
<p>Sie können die Berechtigungseinstellungen des WIBcms einbinden oder (falls erforderlich) zusätzliche Rollen definieren.</p>
<?php

$MayEditRoles = false;
//	$MayAddRole = true;
include 'personroles.php';

echo "</fieldset><fieldset><legend>Berechtigungen setzen</legend><small>\n";

startSelect('Rechte[0]','Stimmrecht');
echo txtOption(0,'keine Benutzergruppe');
foreach ($WIBcmsRole as $nr=>$Role) {
	if ($nr>0) echo txtOption($nr,$Role,$Rechte[0]);
}
echo '</select> <select id="Rechte[1]" name="Rechte[1]">';
echo txtOption(0,'keine Mitarbeiter-Rolle');
foreach ($Roles as $Role) {
	echo txtOption($Role,$Role,$Rechte[1]);
}
echo "</select> Wer ist aufgeführt und darf teilnehmen?<br>\n";

startSelect('Rechte[2]','Moderation');
echo txtOption(0,'keine Benutzergruppe');
foreach ($WIBcmsRole as $nr=>$Role) {
	if ($nr>0) echo txtOption($nr,$Role,$Rechte[2]);
}
echo '</select> <select id="Rechte[3]" name="Rechte[3]">';
echo txtOption(0,'keine Mitarbeiter-Rolle');
foreach ($Roles as $Role) {
	echo txtOption($Role,$Role,$Rechte[3]);
}
echo "</select> Wer darf Umfragen erstellen/bearbeiten?<br>\n";

startSelect('Rechte[4]','Übernahme');
echo txtOption(0,'keine Benutzergruppe');
foreach ($WIBcmsRole as $nr=>$Role) {
	if ($nr>0) echo txtOption($nr,$Role,$Rechte[4]);
}
echo '</select> <select id="Rechte[5]" name="Rechte[5]">';
echo txtOption(0,'keine Mitarbeiter-Rolle');
foreach ($Roles as $Role) {
	echo txtOption($Role,$Role,$Rechte[5]);
}
echo "</select> Wer darf Einträge anderer User bearbeiten?<br>\n";

startSelect('Rechte[6]','Einladung');
echo txtOption(0,'keine Benutzergruppe');
foreach ($WIBcmsRole as $nr=>$Role) {
	if ($nr>0) echo txtOption($nr,$Role,$Rechte[6]);
}
echo '</select> <select id="Rechte[7]" name="Rechte[7]">';
echo txtOption(0,'keine Mitarbeiter-Rolle');
foreach ($Roles as $Role) {
	echo txtOption($Role,$Role,$Rechte[7]);
}
echo "</select> Wer darf Benutzer einladen?<br>\n";

startSelect('Rechte[8]','Spalte 2');
echo txtOption(0,'keine Benutzergruppe');
foreach ($WIBcmsRole as $nr=>$Role) {
	if ($nr>0) echo txtOption($nr,$Role,$Rechte[8]);
}
echo '</select> <select id="Rechte[9]" name="Rechte[9]">';
echo txtOption(0,'keine Mitarbeiter-Rolle');
foreach ($Roles as $Role) {
	echo txtOption($Role,$Role,$Rechte[9]);
}
echo "</select> Wer wird in Spalte 2 gekennzeichnet?<br>\n";

?></small></table>
</fieldset>
</div>
<?php
//	Ende aller Konfigs -------------------------------------------
	echo "</fieldset>\n" . formsave('Plugin',$Plugin);
?>