<script>
function editcard(adrbook,file) {
	var url = 'plugins/SynoCal/editcard.php';
	var myCard = new XMLHttpRequest();
	var data = new FormData();
	data.append('adrbook', adrbook);
	data.append('vcard', file);
	myCard.addEventListener('load',function(event){
		if (myCard.readyState == 4) {
			strResponse = myCard.responseText;
			document.getElementById('cardeditor').innerHTML = strResponse;
			document.getElementById('cardeditor').style.display = 'block';
//			document.getElementById('cardeditor').style.visibility = 'visible';
			window.scroll(0,0);
		}
	});
	myCard.open("POST",url);
	myCard.send(data);
}
function closecard() {
	document.getElementById('cardeditor').style.display = 'none';
//	document.getElementById('cardeditor').style.visibility = 'hidden';
}
function gt(checked) {
	display = checked ? 'hidden':'visible';
	document.getElementById('DT0').style.visibility = display;
	document.getElementById('DT1').style.visibility = display;
}
</script>
<style>
div.halb	{display:inline-block; width:48%; vertical-align:top;}
.pointer	{cursor:pointer;}
.pointer:hover	{background:#ddd;}
img.vcf-preview	{max-height:150px;}
table.small	{font-size:0.9em;}
div#cardeditor {background:#ddd;}

input.tabzahl {width:40px; text-align:right;}
/* z-index:1003; position:absolute; display:none;
#cardeditor	{background:#f9f9f9; color:#003;
			 border:1px solid #333; border-radius:6px; box-shadow: 0px 0px 9px #666;
			 font-size:10pt; width:990px; min-height:480px; padding-bottom:4px; visibility:hidden;}
*/
</style>
<div id="cardeditor"></div><br>
<?php
$Plugin = "SynoCal";
$MyPlugin = "$MyPlugins/$Plugin/";

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = "data/plugins/$Plugin/";

// Get the data and configuration:
$idb = new SQLite3($MyPluginDataFolder.'DB.db');
include $MyPluginDataFolder.'config.php';


$ShowOverhead = false;
if (is_numeric($MyPageParam)) {
	$CalList = $MyPageParam;
} else {
	$CalList = 1;	// HARDCODED ---------- oder "'unbekannt'";
}

echo "<script>let eCardDisplayType=$eCardDisplayType;</script>\n";

include $MyPlugin.'switch.php';

$wegmit = $_POST['wegmit'] ?? '';

if ($wegmit == 'Speichern') {	// neu, ändern und löschen: OK!
	$SUMM = $_POST['SUMMARY'];
	$DESC = $_POST['DESCRIPTION'];
	$DESC = str_replace(array("\r\n", "\r", "\n"), "\\n", $DESC);
	$UID  = $_POST['UID'];

	$GT = isset($_POST['GT']);
	$DTST = $_POST['DTSTART'];
	$DTEND= $_POST['DTEND'];
	$DTSTIM = $_POST['DTSTARTTIME'];
	$DTETIM = $_POST['DTENDTIME'];

	$ACTION = $_POST['ACTION'];

	if ($GT) {
		$TZ = ";VALUE=DATE";
		$DTST = strtotime($DTST);
		$DTEND= strtotime($DTEND);
	} else {
		$TZ = ";TZID=Europe/Berlin";
		$DTST = strtotime($DTST.' '.$DTSTIM);
		$DTEND= strtotime($DTEND.' '.$DTETIM);
	}

	$TRAN = $_POST['TRANSP'];
	$LOC  = $_POST['LOCATION'];
	$SEQ  = $_POST['SEQ'] ?? 0;
	$TSNOW= gmdate("Ymd\THis\Z");

	if ($UID != 'neu') {
		$NEW=false;
		$SEQ++;	// increment
	} else {	// new event
		$UID = guidv4();
		$NEW=true;
		$SEQ=0;
	}

	$DEL = isset($_POST['DEL']);
/*
	// Reparatur:
	$DEL = true;
	$UID = 'neu';
*/
	$METHOD = $DEL ? 'DELETE' : 'PUT';

//	to DELETE an event ONLY the UID is needed
	
	$txt = "BEGIN:VCALENDAR\r\nPRODID:-//AK-P Intranet by WIBcms\r\nVERSION:2.0\r\nCALSCALE:GREGORIAN\r\n";

	$txt.= "BEGIN:$TYPE\r\n";
	if ($NEW)
		$txt.= "CREATED:$TSNOW\r\n";
	$txt.= "LAST-MODIFIED:$TSNOW\r\n";
	$txt.= "DTSTAMP:$TSNOW\r\n";
	$txt.= "UID:$UID\r\n";
	$txt.= "SUMMARY:$SUMM\r\n";
	$txt.= chunk_split("DESCRIPTION:$DESC", 72, "\n ")."\r\n";
	if ($SEQ>0)
		$txt.= "SEQUENCE:$SEQ\r\n";
	$txt.= "DTSTART$TZ:".gmdate("Ymd\THis\Z",$DTST)."\r\n";
	$txt.= "$EndType$TZ:".gmdate("Ymd\THis\Z",$DTEND)."\r\n";
	$txt.= "TRANSP:$TRAN\r\n";
	if ($LOC!="")
		$txt.= "LOCATION:$LOC\r\n";

	if ($ACTION != '0') {
		$DAY = $_POST['DAY'];
		$STD = $_POST['STD'];
		$MIN = $_POST['MIN'];
		$TRG = '-P'.(($DAY>0) ? $DAY.'D' : '') . (($STD+$MIN > 0) ? 'T' : '') . (($STD>0) ? $STD.'H' : '') . (($MIN>0) ? $MIN.'M' : '');
		$txt.= "BEGIN:VALARM\r\n";
		$txt.= "ACTION:$ACTION\r\n";
		$txt.= "TRIGGER;VALUE=DURATION:$TRG\r\n";
		$txt.= "DESCRIPTION:$SUMM\r\n";
		$txt.= "END:VALARM\r\n";
	}

	$txt.= "END:$TYPE\r\n";
	$txt.= "END:VCALENDAR\r\n";

//	echo nl2br($txt,0);

	if (true) {
//		https://sourceforge.net/p/davical/mailman/davical-general/thread/1278982299.3607.972.camel%40happy.home.mcmillan.net.nz/#msg25727929
		$URI = $url.$UID.".ics";
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//		curl_setopt($curl, CURLOPT_HEADER, false);	// s.u. PUT ???
		curl_setopt($curl, CURLOPT_HEADER, true);
		curl_setopt($curl, CURLOPT_USERNAME, $usr);
		curl_setopt($curl, CURLOPT_PASSWORD, $pwd);

		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $METHOD);	//	UPDATE ist ebenfalls PUT. ODER: curl_setopt($curl, CURLOPT_PUT, 1); >> 'DELETE'

		curl_setopt($curl, CURLOPT_URL, $URI);	// curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $txt);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Cache-Control: no-cache','Content-type: text/calendar'));

		$str = curl_exec($curl);

		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		if (($http_code == 204) or ($http_code == 201)) {	// 201: Neuer Termin, 204: Update
			echo "<p>Termin erfolgreich gespeichert. ($METHOD)</p>\n";
		} else {
			echo "ERROR $http_code:<br>$str<br>\n";	// 404: not found, 405: method not allowed
		}
	}
}

//	echo "Reading CalFile $url: Found " . count($cards) . " Events<br>\n";

$cards = getCalendar();
$Cat = array();
$Cls = array();

switch(count($cards)) {
	case 0: $e = 'Keine Einträge'; break;
	case 1: $e = '1 Eintrag'; break;
	default:$e = count($cards).' Einträge';
}

echo "<h3>$e vorhanden</h3>\n<table class=\"small\">\n";
echo '<thead><tr class="kopf"><td>Von</td><td>Bis</td><td>Titel</td><td>Beschreibung</td><td>Alarm</td></tr></thead>';

foreach ($cards as $nr=>$card) {
//	mehrzeilige Einträge vereinen:
	$card = str_replace($CL,'',$card);
	$card = str_replace($LF,'',$card);

//	echo "<h3>Event $nr</h3>\n<table>\n";

	$lines = explode(chr(10),trim($card));
	$DES[$nr] = $SUM[$nr] = '';
	$DTS[$nr] = $DTE[$nr] = $ALM[$nr] = 0;

	foreach ($lines as $line) {
	  if (trim($line) != "BEGIN:$TYPE") {
//		split line at first char of ':' but not within quotes!	// nur das erste Vorkommen berücksichtigen (da im Value ebenfalls : vorkommen können)
		$entry = preg_split('/[:](?=([^"]*"[^"]*")*[^"]*$)/', $line, 2);

//		caution: following lines just for eye candy, do not use them as regular iCal values!
		$key = trim($entry[0]);
		$val = str_replace("\\n","\n",$entry[1]);

//		if (strpos($key,"data:text/html,")!==false)
//			$key = htmlentities(urldecode($key));

		if (strpos($key,'DTS')!==false || strpos($key,$EndType)!==false || strpos($key,'CREATED')!==false || strpos($key,'MODIFIED')!==false || strpos($key,'LASTACK')!==false)
			$val = strtotime($val);
		else {
			if (strpos($key,'UID')!==false) {
				$PUID[$nr] = trim($val);
			} else {
				$val = stripslashes($val);
//				$val = nl2br(stripslashes($val),0);
			}
		}
//		collect the results to sort them later (prior to output):
//			echo "<tr><td>$key</td><td>$val</td></tr>\n";
		if (strpos($key,'DTSTART')!==false) {
			$DTS[$nr] = $val;
		}
		if (strpos($key,$EndType)!==false) {
			$DTE[$nr] = $val;
		}
		if (strpos($key,'SUMMARY')!==false) {
			$SUM[$nr] = $val;
		}
		if (strpos($key,'DESCRIPT')!==false) {
			$DES[$nr] = nl2br($val,0);
		}
		if ($key=='BEGIN' && trim($val)=="VALARM") {
			$ALM[$nr] = 1;
		}
		if ($key=='CATEGORIES') {
			$K = explode(',',trim($val));
			$Cat = array_merge($Cat, $K);
//			$Cat = array_unique($Cat);
		}
		if ($key=='CLASS') {
			$K = explode(',',trim($val));
			$Cls = array_merge($Cls, $K);
//			$Cls = array_unique($Cls);
		}
	  }
	}
}

array_multisort($DTS, $DTE,$SUM,$DES,$PUID,$ALM);
$Cat = array_unique($Cat);
sort($Cat);
$Cls = array_unique($Cls);
sort($Cls);

foreach ($DTS as $nr=>$DTStart) {
	$UID = $PUID[$nr];
	$Desc= $DES[$nr];
	$Summ= $SUM[$nr];
	$End = ($DTE[$nr]>0) ? date('d.m.Y H:i:s', $DTE[$nr]) : 'n.a.';
	$Strt= ($DTS[$nr]>0) ? date('d.m.Y H:i:s', $DTStart) : 'n.a.';
	$Alarm = $ALM[$nr];
	echo '<tr class="pointer" onclick="editcard('.$CalList.",'$UID')\"><td>$Strt</td><td>$End</td><td>$Summ</td><td>$Desc</td><td>$Alarm</td></tr>\n";
}
if ($WebStat) {
	echo '<tr class="pointer" onclick="editcard('.$CalList.",'neu')\"><td colspan=\"5\">Neuer Eintrag</td></tr>\n</table>\n";
} else {
	echo "</table>\n<p>Um Kalendereinträge zu erstellen oder zu ändern, müssen Sie angemeldet sein</p>\n";
}
$MyCats = implode("','",$Cat);
$MyClss = implode("','",$Cls);
$MyConf = "<?php\n\$MyCats = ['$MyCats'];\n\$MyClss = ['$MyClss'];\n?>";
file_put_contents($MyPlugin.'cats.php',$MyConf);
/*
echo "Kategorien:<br>\n";
	foreach($Cat as $Kategorie) {
	echo $Kategorie."<br>\n";
}
echo "Klassen:<br>\n";
foreach($Cls as $Klasse) {
	echo $Klasse."<br>\n";
}
*/

if ($ShowOverhead) {
//	core data seem to be correct:
	echo nl2br($Head,0)."<hr>\n";
	echo nl2br($Foot,0)."<hr>\n";
}
