<?php
//	$MyPlugins and $MyPlugData set in wibcmsconstants.php are the root folders of all plugins and plugin data
//	$MyPlugType and $MyPageParam set in wibcmspages.php

//	Folder in which the data for this plugin are stored:
$MyPluginDataFolder = "$MyPlugData/$MyPlugType/";

//	Configuration:
include $MyPluginDataFolder.'config.php';

//	Database:
$pDB = new SQLite3($MyPluginDataFolder.'DB.db');
//	$pDB = $db;

//	Parameter:
$Params = explode('-',$MyPageParam);
$MyPageParam = $Params[1];

//	Selection:
switch ($Params[0]) {
  case 'Forum1': // ########## Gästebuch ##########
	GuestBook(1,$pDB);
	break;
  case 'Forum2': // ########## Diskussionsforum ##########
	GuestBook(2,$pDB);
	break;
  case 'Forum3': // ########## Blog mit Kommentaren ##########
	GuestBook(3,$pDB);
	break;
  case 'Forum4': // ########## Ticket-System ##########
	break;
}

// ################################################## Gästebuch/Foren/Blogs komplett ########################################
function GuestBook($ForenID,$db) {
	global $mypage,$MyPageParam,$search, $u,$Server,$WebStat, $splitPage,$mylang;
	global $Forum1MaxSize,$Forum2MaxSize,$Forum3MaxSize;
	$MustWrite= false;	// Bei neuem Themenbereich/Blog muss man auch gleich den ersten Beitrag schreiben!
	$strEntry = ['','Eintrag','Diskussionsbeitrag','Kommentar'];

	$splittext= $splitPage[$mylang];
	$thispage = $_GET['page'] ?? '0';
	
	$myLinkPage = $mypage . (empty($search) ? '' : "&search=$search");

	if (isset($_GET['OK'])) {	// Freigabe etc. per E-Mail
		$time_id = $_GET['id'];
		$ForenID = $db->querySingle("SELECT ForenID FROM Forum WHERE Datum=$time_id");
		switch ($_GET['OK']) {	// Datum gewählt, damit die ID nicht (oder nur schwer) zu erraten ist
			case 1: $sql = "UPDATE Forum SET Stat=1 WHERE Datum=$time_id"; break;
			case 2: $sql = "UPDATE Forum SET Stat=0 WHERE Datum=$time_id"; break;
			case 0: $sql = "DELETE FROM Forum WHERE Datum=$time_id"; break;
		}
		$OK = $db->exec($sql);	// evtl. Fehler abfangen und anzeigen
	}
	elseif (isset($_POST['ToDo']) && isset($_POST['fid']) && $WebStat>0) {	// Neuen Themenbereich / Thema anlegen
		$ForenID = $_POST['forum'];
		$ID = $_POST['fid'];
		$Titel = $db->escapeString($_POST['Titel']);
		$Text = $db->escapeString($_POST['Text']);
		$Typ = $db->querySingle("SELECT Typ FROM Foren WHERE ID=$ForenID");
		if ($_POST['ToDo']=='Neues Thema anlegen') {
			$sql = "INSERT INTO Foren (Name,Typ,Parent,Comment,Mail,Owner)
			VALUES ('$Titel',$Typ,$ForenID,'$Text','".$_SESSION['UserMail']."','".$_SESSION['UserID']."')";	// Show=3 ist DEFAULT
			$MustWrite=true;	// neuer Themenbereich/ Blog -> man muss auch gleich den ersten Beitrag schreiben!
		} elseif ($_POST['ToDo']=='Aktualisieren') {
			$sql = "UPDATE Foren SET Name='$Titel', Comment='$Text' WHERE ID=$ID";
		}
		debug($sql);
		$OK = $db->exec($sql);	// evtl. Fehler abfangen und anzeigen
	}

	if (isset($_GET['forum']) && is_numeric($_GET['forum'])) {	// Forum ermitteln
		$ForenID = $_GET['forum'];
	} elseif ($MyPageParam>0) {
		$ForenID = $MyPageParam;
	}
	if (isset($_GET['fid']) && is_numeric($_GET['fid']) && isset($_GET['todo']) && $WebStat>0) {	// Blog / Bereich sperren etc.
		switch ($_GET['todo']) {
			case 'hide':  $Show = 0; break;
			case 'close': $Show = 1; break;
			case 'show':  $Show = 3; break;
		}
		$sql = "UPDATE Foren SET Show=$Show WHERE ID=".$_GET['fid'];
		$OK = $db->exec($sql);	// evtl. Fehler abfangen und anzeigen
	}
	if (isset($_GET['del']) && is_numeric($_GET['del']) && $WebStat>0) {
		// Kinder feststellen:
		$IDs = '';
		$sql = "SELECT ID FROM Foren WHERE Parent=".$_GET['del'];
		$res = $db->query($sql);
		while ($rec = $res->fetchArray()) {
			$IDs .= $rec[0].',';
		}
		$IDs = substr($IDs, 0, -1);	// entfernt letztes Komma

		// Enkel feststellen: (könnte es auch Urenkel geben???)
		if (!empty($IDs)) {
			$sql = "SELECT ID FROM Foren WHERE Parent IN ($IDs)";
			$res = $db->query($sql);
			while ($rec = $res->fetchArray()) {
				$IDs.=','.$rec[0];
			}
			$IDs .= ',';
		}
		// IDs komplettieren / abschließen:
		$IDs .= $_GET['del'];

		// und jetzt tapfer löschen:
		$sql = "DELETE FROM Foren WHERE ID IN ($IDs)";
		$ups = "<li>$sql</li>\n";
		$db->exec($sql);
		$sql = "DELETE FROM Forum WHERE ForenID IN ($IDs)";
		$ups.= "<li>$sql</li>\n";
		$db->exec($sql);
//		echo "DONE:<br><ul>$ups</ul>\n";
		echo "<p class=\"success\">Forum erfolgreich gelöscht</p>\n";
	}

	// feststellen, um welches Forum es hier eigentlich geht -> Eigenschaften...:
	$res = $db->querySingle("SELECT Name,Typ,Parent,Show,Mail,Subject,Owner,PubRules FROM Foren WHERE ID=$ForenID",true);
	$Name = $res['Name'];
	$Typ  = $res['Typ'];
	$Show = $res['Show'];	// 0:gesperrt, 1:closed mit Anzeige, 3:normal aktiv
	$Mail = $res['Mail'];
	$Subject=$res['Subject'];
	$Parent =$res['Parent'];
	$Owner  =$res['Owner'];
	$PubRules=$res['PubRules'];

	$MyName = $Name;
	$MyParent = $Parent;

	$HasParents=$Parent>0;
	$HasChilds = $db->querySingle("SELECT COUNT(ID) FROM Foren WHERE Parent=$ForenID AND Show>0");
	while ($Parent!=0) {	// Foren-"Breadcrumb" erzeugen
		$res = $db->querySingle("SELECT ID,Name,Typ,Parent,Show,Mail,Subject,Owner,PubRules FROM Foren WHERE ID=$Parent",true);
		$Parent = $res['Parent'];
		$Name = '<a href="'.$u.$myLinkPage.'&forum='.$res['ID'].'">'.$res['Name'] . "</a> > $Name";
		// falls in den Kinderforen keine Werte gespeichert waren:
		$Show = min($Show,$res['Show']);
		if (empty($Typ))      $Typ = $res['Typ'];
		if (empty($Mail))     $Mail = $res['Mail'];
		if (empty($Subject))  $Subject = $res['Subject'];
		if (empty($Owner))    $Owner = $res['Owner'];
		if (empty($PubRules)) $PubRules = $res['PubRules'];
	}
	if ($HasParents) {
		echo "<p>$Name</p>\n";
	}
	// jetzt daraus ableiten (ist noch nicht fertig!):
	// 0:gesperrt 1:Admin 2:Designer 3:Developer 4:Editor 8:Benutzer 12:Moderator 16:Gast
	$arrRoles= array(1,2,3,4,12);
	$MayWrite= ($Typ==1 || ($Typ==2 && $WebStat>0) || $Typ==3);	// Kommentare oder Beiträge schreiben
	if ($WebStat) {
		$IsOwner = $Owner==$_SESSION['UserID'] || $Mail==$_SESSION['UserMail'];
	} else {
		$IsOwner = false;
	}
	$MayEdit = in_array($WebStat,$arrRoles) || $IsOwner; // Einzelne Beiträge löschen etc., evtl. noch aufnehmen: oder ist Autor
	$MayAdd  = ($Typ==2 && $MayEdit) || ($Typ==3 && $IsOwner);	// Eigener Blog oder Thread
	// OBACHT $MayAdd nicht an Mail festmachen sondern an ID !!!!!!!!!!!!!!
	$PubRule = 1;		// 0:ohne Freigabe, 1:ohne Freigabe nur bei reg. Usern, 2:nur mit Freigabe -> konfigurierbar machen!?
	$txtEntry = $strEntry[$Typ];

	if (!isset($_GET['neu'])) {
		if ($HasChilds || ($MayAdd && isset($_GET['new']))) {	// Es gibt (Unter-)themen hierzu ODER ein Berechtigter muss/will ein Unterthemen erstellen:
			$sql ="SELECT ID,Name,Show,Comment,Mail FROM Foren WHERE Parent=$ForenID";
//			if (!$MayAdd && !($WebStat&1)) $sql .= " AND Show>0";
			$res = $db->query($sql);
			$Titel= '';
			$Text = '';
			$GetForm = false;
			echo "<div class=\"gbwrapper\">\n";
			$txt = "<a href=\"$u$mypage&forum=$ForenID"; //&fid=".$FID;
			while ($forum = $res->fetchArray()) {
//				$MayEdit = ($Typ==3 && isset($_SESSION['UserMail']) && $_SESSION['UserMail']==$forum['Mail']);
				if ($forum[2] || $MayEdit) {
					$FID = $forum[0];
					$forum[3] = $forum[3] ?? '';	// um NULL zu vermeiden
					$Anzahl = $db->querySingle("SELECT COUNT(ID) FROM Forum WHERE ForenID=$FID");
	//				$strAnz = "(" . ($Anzahl>0 ? $Anzahl : "keine") . ($Anzahl==1 ? 'Beitrag)':'Beiträge)');
					if ($search!='') {
						$forum[1] = highlight($forum[1],$search);
						$forum[3] = highlight($forum[3],$search);
					}
					echo '<div class="gbtitle"><a href="'.$u.$mypage.'&forum='.$FID.'">'. $forum[1] . ($Anzahl>0 ? " ($Anzahl ".($Anzahl==1 ? 'Beitrag':'Beiträge').")":"")."</a></div>\n";
					echo '<div class="gbentry"><a href="'.$u.$mypage.'&forum='.$FID.'">'. nl2br($forum[3]) ."</a>\n";
					echo '<div class="gbedit"><a href="'.$u.$mypage.'&forum='.$FID.'"> auswählen </a> ';
	//				if ($WebStat) echo $_SESSION['UserMail'].' / '.$Mail.' / '.$forum['Mail'] .' / '.$MayEdit;
					if ($MayAdd || $MayEdit) {
						$GetForm = true;
						$state = array('verborgen','geschlossen','','normal aktiv');
						echo "Dieses Forum ist ".$state[$forum[2]];
						$txt = "<a href=\"$u$mypage&forum=$ForenID&fid=".$FID;
						echo ' : '.$txt.'&todo=show"> öffnen </a> : '.$txt.'&todo=close"> schließen </a> : '.$txt.'&todo=hide"> verbergen </a> : '.$txt.'&del='.$FID.'"> löschen </a> : '.$txt.'&edit='.$FID.'"> bearbeiten </a>';
						if (isset($_GET['edit']) && $_GET['edit']==$FID) {
							$Titel= $forum[1];
							$Text = $forum[3];
						}
					}
					echo "</div></div>\n";
				}
			}

			if ($GetForm) {
				if ((isset($_GET['new']) && is_numeric($_GET['new'])) || (isset($_GET['edit']) && is_numeric($_GET['edit']))) {
					$fid = isset($_GET['edit']) ? $_GET['edit']:'0';
					echo '<form action="'.$u.$mypage.'" method="post" accept-charset="UTF-8"><fieldset>';
					echo txtInput("Titel","Titel",$Titel);
					echo TextArea("Text","Beschreibung",$Text);
					echo '<label><input type="hidden" name="fid" value="'.$fid.'">';
					echo '<input type="hidden" name="forum" value="'.$ForenID.'"></label>';
					echo '<input type="submit" name="ToDo" value="';
					echo (($Titel=='')?'Neues Thema anlegen':'Aktualisieren').'"></fieldset>';
				}
			}

			if ($MustWrite) {
				if ($MyParent>0) {
					echo "<p class=\"error\"><b><a href=\"$u$mypage&forum=$FID&neu=neu\">Sie sollten sogleich einen ersten $txtEntry dazu schreiben!</a></b></p>\n";
				} else {
					echo "<p class=\"error\"><b><a href=\"$u$mypage&forum=$FID&new=$FID\">Sie sollten sogleich ein erstes Unterthema erstellen!</a></b></p>\n";
				}
			} elseif ($MayAdd) {
				echo $txt.'&new='.$ForenID.'">'.($MyParent>0 ? 'Neues Thema':'Neuen Themenbereich'). ' anlegen</a>';
			} else {
				if ($Typ!=3) {
					echo "<p>Um ein".($MyParent>0 ? ' neues Thema':'en neuen Themenbereich'). ' anzulegen, müssen Sie sich zuerst <a href="'.$u."Login\">anmelden / registrieren</a>!</p>\n";
				} else {
					// echo "<p>Sie dürfen leider keinen neuen Blog einrichten.</p>\n";
				}
			}

			echo "</div>\n";
		} else {
			// Einträge anzeigen:
			// müssen wir mehrere Seiten anbieten, weil zuviele Einträge?
			$Limit = '';
			$cntEntries = $db->querySingle("SELECT COUNT(ID) FROM Forum WHERE ForenID=$ForenID");
			if ($Typ==1) $maxEntries = $Forum1MaxSize;
			elseif ($Typ==2) $maxEntries = $Forum2MaxSize;
			elseif ($Typ==3) $maxEntries = $Forum3MaxSize;
			if ($cntEntries>$maxEntries) {
				// mehrere Seiten!!
				echo "<div>";
				for($i=0;$i<($cntEntries/$maxEntries);$i++) {
					if ($thispage==$i) {
						echo '<span class="pageselect"> '.$splittext. ($i+1) .' </span>';
						$Limit = ' LIMIT '.$maxEntries. (($i==0)?'':' OFFSET '.$i*$maxEntries);
					} else {
						echo '<a class="pageselect" href="'.$u.$myLinkPage.'&forum='.$ForenID.'&page='.$i.'"> '.$splittext. ($i+1) .' </a>';
					}
				}
				echo "</div>\n";
			}

			$First = ($Typ==1 || $thispage>0)?'':' first';
			$Anzahl = 0;
			echo "<div class=\"gbwrapper\">\n";
			$sql = "SELECT Stat,Autor,Ort,Datum,Beitrag FROM Forum WHERE ForenID=$ForenID$Limit";
			$res = $db->query($sql);
			while ($rec = $res->fetchArray(SQLITE3_NUM)) {
				if ($rec[0]==1 || $MayEdit) { // Eintrag ist freigegeben ODER Pflege
					if ($search!='') {
						$rec[4] = highlight($rec[4],$search);
					}
					echo "<div class=\"gbtitle$First\">". $rec[1] . ((empty($rec[2])) ? '' : ' aus '. $rec[2]) .' schrieb am '. date("d.m.Y",$rec[3]) .":</div>\n";
					echo "<div class=\"gbentry$First\">". $rec[4];
					if ($MayEdit) {
						echo "\n<div class=\"gbedit$First\"><a href=\"".$u.$mypage.'&OK=0&id='.$rec[3].'">löschen</a> - ';
						echo ($rec[0]==1) ? $txtEntry.' ist freigegeben > <a href="'.$u.$mypage.'&OK=2&id='.$rec[3].'">sperren</a>' : '<a href="'.$u.$mypage.'&OK=1&id='.$rec[3]."\">$txtEntry freigeben</a>";
						// <a href="'.$u.$mypage.'&OK=2&id='.$rec[3].'">Bearbeiten</a> 
						 echo "</div>";
					}
					$First = '';
					$Anzahl++;
				 echo "</div>\n";
				}
			}
			if ($Anzahl==0) { // erster Beitrag im BLOGthema MUSS aber vom Eigentümer stammen!
				echo "<div class=\"gbtitle\">Kein freigegebener $txtEntry vorhanden...</div>\n";
				if ($MayWrite && $Show) {
					echo "<div class=\"gbentry\">Schreiben Sie doch den ersten $txtEntry!</div>\n";
				} else {
					echo "<div class=\"gbentry\">Sie dürfen oder können hier nichts schreiben... Tut uns leid!</div>\n";
				}
			}
			if ($Show) {
				if ($MayWrite) {
					echo "<p><a href=\"$u$mypage&amp;forum=$ForenID&amp;neu=neu\">Neuen $txtEntry erstellen</a></p>\n";
				} else {
					echo "<p>Um einen $txtEntry zu erstellen, müssen Sie sich zuerst <a href=\"".$u."Login\">anmelden / registrieren</a>!</p>\n";
				}
			} else {
				echo "<p>Dieses Thema ist geschlossen - es ist kein neuer $txtEntry möglich!</p>\n";
			}
			echo "</div>\n";
		}
	} else {	// isset($_GET['neu']) == 'neu' !!!
		// Neuen Gästebucheintrag erstellen:
		// $Typ ist bekannt
		$mailsent = false;
		if (empty($_SESSION)) {
			$FName = isset($_POST['FName'])? $db->escapeString($_POST['FName']):"";
			$FOrt  = isset($_POST['FOrt']) ? $db->escapeString($_POST['FOrt']) :"";
			$FMail = isset($_POST['FMail'])? $db->escapeString($_POST['FMail']):"";
			$FUser = 0;
		} else {
			$FName = $_SESSION['User'];
			$FOrt  = '';
			$FMail = $_SESSION['UserMail'];
			$FUser = $_SESSION['UserID'];
		}
		$Text = isset($_POST['Text'])? trim($_POST['Text']):"";
		$Trap = isset($_POST['Nickname'])?$_POST['Nickname']:"";
		$Text2= text2br('Text');
		if ($FName!='' && $FMail!='' && $Text!="" && $FName!=$FOrt && $Trap=="") {
			$time_id = time();
			switch ($Typ) {
				case 1: $wo = "im Gästebuch"; break;
				case 2: $wo = "im Diskussionsforum '$MyName'"; break;
				case 3: $wo = "im Blog '$MyName'"; break;
			}
			$Link = "$Server$u$mypage";
			$nachricht  = 'Name: ' . $FName . (($FOrt!='')?" (aus: $FOrt)":"") . "\r\n";
			$nachricht .= "hat soeben folgenden neuen $txtEntry $wo verfasst:\r\n\r\n";
			$nachricht .= $Text . "\r\n\r\nUnd was nun?\r\n";
			$nachricht .= "- Gleich freigeben mit ".$Link."&OK=1&id=$time_id oder\r\n";
			$nachricht .= "- erstmal rückfragen an ".$FMail." oder\r\n";
//			$nachricht .= "- bearbeiten mit ".$Link."&OK=2&id=$time_id oder\r\n";
			$nachricht .= "- löschen mit ".$Link."&OK=0&id=$time_id \r\n";
			if ($MayEdit) {
				$Stat = 1;
				$mailsent = true;	// Nun ja...
			} else {
				$mailsent = trymail($Subject,br2text($nachricht),$Mail);
				$Stat = 0;
			}
			// Eintrag speichern:
			$sql = "INSERT INTO Forum (ForenID,Stat,Datum,Autor,Ort,Mail,Beitrag,Anhang,User) VALUES ($ForenID,$Stat,'$time_id','$FName','$FOrt','$FMail','$Text2','',$FUser)";
			$db->exec($sql);
		}

		if ($mailsent) {
			echo "<p>Folgenden $txtEntry haben wir von Ihnen erhalten:</p>\n";
		} elseif (!$MayEdit) {
			echo "<p>Bitte geben Sie auf alle Fälle Name, Ort, E-Mail-Adresse und Ihren $txtEntry ein.</p>\n";
		}

		echo "<form action=\"$u$mypage&amp;forum=$ForenID&amp;neu=send\" method=\"post\" accept-charset=\"UTF-8\"><fieldset>\n";
		if (empty($_SESSION)) {
			echo fullInput("FName","Ihr Name:",$FName,$mailsent,1);
			echo fullInput("FOrt","Ihr Wohnort:",$FOrt,$mailsent,1);
			echo fullInput("FMail","Ihre E-Mail-Adresse:",$FMail,$mailsent,1);
		}
		echo TextArea ("Text","Ihr Textbeitrag:",$Text,$mailsent,1);

		if ($mailsent) {
			if ($MayEdit) {
				echo "<p>Danke für Ihren $txtEntry!</p>\n";
			} else {
				echo "<p>Wir werden Ihren $txtEntry nach erfolgter Prüfung gerne umgehend freischalten!</p>\n";
			}
		} else {
			echo '<label></label><input type="text" id="Nickname" name="Nickname" value=""><input type="submit" name="ToDo" value="Beitrag erstellen">';
		}
		echo "<p><a href=\"$u$mypage&amp;forum=$ForenID\">Zurück zur Übersicht</a></p>\n";
		echo "\n</fieldset></form>\n";
	}
}


/* If you provide a search function, you should also provide the highlighting of the found contents, like this:

// 1. compose the string to be echoed/printed:
$Text = '<strong>'.$Text.'</strong><i> ('.$Demotext.')</i>';

// 2. use the builtin highlight function:
if ($search!='') {
	$Text = highlight($Text,$search);
}
*/
?>