<?php
/* It's a good practice to define the name of the plugin.
You may use the name thereafter so the expressions will be the same in any plugin.
*/
$Plugin = 'Public';
$MyPlugin = "$MyPlugins/$Plugin/";	// This plugin folder

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = "../data/plugins/$Plugin/";	// CAVE: edit.php is called inside the core folder!
include $MyPluginDataFolder.'config.php';

// Database:
$pDB = new SQLite3($MyPluginDataFolder.'DB.db');
// $pDB = $db;

// listet die Foren auf (Gästebuch, Diskussionsforum, Blog):
function printForen($Typ) {
	global $db,$pDB;
	$sql = "SELECT ID,Name,Comment,Mail,Subject,Owner,PubRules,Show FROM Foren WHERE Parent<4 AND Typ=$Typ";
	$res = $pDB->query($sql);
	while ($rec = $res->fetchArray(1)) {
		$id = $rec['ID'];
		echo txtInput("Foren[$id][Name]","Bezeichnung",$rec['Name']);
		echo txtInput("Foren[$id][Comment]","Kommentar",$rec['Comment']);
		echo txtInput("Foren[$id][Mail]","Mailempfänger",$rec['Mail']);
		if ($Typ==3) {	// Blogs sind Usern zugeordnet
			startSelect("Foren[$id][Owner]","Eigentümer");
			$users = $db->query("SELECT ID,Name,Mail FROM Users WHERE RoleID>0 AND RoleID<16");
			while ($user = $users->fetchArray()) {
				echo txtOption($user['ID'],$user['Name'],$rec['Owner']);
			}
			echo "</select><br>\n";
		} else {
			echo '<input type="hidden" name="Foren['.$id.'][Owner]" value="0">';
		}
		echo '<input type="hidden" name="Foren['.$id.'][PubRules]" value="0">';
		echo txtInput("Foren[$id][Subject]","Betreff-Zeile",$rec['Subject']);
		startSelect("Foren[$id][Show]",'Status');
		echo txtOption(0,'nicht anzeigen (gesperrt)',$rec['Show']);
		echo txtOption(1,'Thema geschlossen',$rec['Show']);
		echo txtOption(3,'normal aktiv',$rec['Show']);
		echo "</select><br>\n";
//		echo "<p>Show: ".$rec['Show']." / Parent: ".$rec['Parent']."</p>\n";
/*		foreach($rec as $key => $val) {
			echo "$key : $val / ";
		} */
		echo "<br>\n";
	}
	if ($Typ>1) {
		$id = -$Typ;
		echo "<b>Neu:</b><br>";
		echo txtInput("Foren[$id][Name]","Bezeichnung");
		echo txtInput("Foren[$id][Comment]","Kommentar");
		echo txtInput("Foren[$id][Mail]","Mailempfänger");
		if ($Typ==3) {	// Blogs sind Usern zugeordnet
			startSelect("Foren[$id][Owner]","Eigentümer");
			$users = $db->query("SELECT ID,Name,Mail FROM Users WHERE RoleID>0 AND RoleID<16");
			while ($user = $users->fetchArray()) {
				echo txtOption($user['ID'],$user['Name']);
			}
			echo "</select><br>\n";
		} else {
			echo '<input type="hidden" name="Foren['.$id.'][Owner]" value="0">';
		}
		echo txtInput("Foren[$id][Subject]","Betreff-Zeile");
		echo '<input type="hidden" name="Foren['.$id.'][PubRules]" value="0">';
		echo '<input type="hidden" name="Foren['.$id.'][Show]" value="3">';
//		echo '<input type="hidden" name="Foren[".$id."][Parent]" value="">';
	}
}

/*
function formkopf($titel, $legend='', $right=1)
If $legend is not specified or an empty string, no fieldset is opened (and thus is not to be closed).
But of cause you may use fieldsets and legends of your own choice.
If $right is not true the user may not edit this plugin.
*/
formkopf('Hier konfigurieren Sie das Public-Plugin');

/* You may want to use several tabs to open specific, organized edit functions.
Therfore you may use up to 10 tabs named Config0 to Config9.
These names are corresponding to the same names in help.php, where different help texts may appear for each tab.
*/
echo '<div class="configmenu"><span id="Config0">Gästebuch</span><span id="Config1">Diskussionsforum</span><span id="Config2">Blog</span><span id="Config3">Personen/Rechte</span><span id="Config4">Darstellung</span></div>';

// Now begin with the first tab. It begins with the appropriate <div> tag with these id and class
// --------------------------------------------------------------------------------
echo "<div id=\"divConfig0\" class=\"helper\"><fieldset><legend>Gästebuch</legend>\n";
echo "<p>In einem Gästebuch darf JEDER Einträge vornehmen, die aber erst nach Freigabe veröffentlicht werden.<br>\n";
echo "Typischerweise gibt es auf einer Homepage nur 1 Gästebuch</p><hr size=\"1\">\n";
echo numInput('Forum1MaxSize','Anzahl pro Seite',$Forum1MaxSize,4,40,2,'tabzahl',"<br>\n");
printForen(1);
echo "</fieldset></div>\n";

// --------------------------------------------------------------------------------
echo "<div id=\"divConfig1\" class=\"helper\"><fieldset><legend>Diskussionsforum</legend>\n";
echo "<p>In einem Diskussionsforum darf ein REGISTRIERTER Benutzer (Gast) ein Thema starten und/oder kommentieren.<br>\n";
echo "Zur besseren Orientierung ist ein Forum in <b>Themenbereiche</b> und <b>Themen</b> untergliedert.</p><hr size=\"1\">\n";
echo numInput('Forum2MaxSize','Anzahl pro Seite',$Forum2MaxSize,4,40,2,'tabzahl',"<br>\n");
printForen(2);
echo "</fieldset></div>\n";
// --------------------------------------------------------------------------------
echo "<div id=\"divConfig2\" class=\"helper\"><fieldset><legend>Blog</legend>\n";
echo "<p>Hier darf ein MODERATOR einen Blog führen und ein Thema starten, JEDER darf kommentieren.<br>\n";
echo "Zur besseren Orientierung ist diese Funktion in <b>Eigentümer</b> und <b>Themen</b> untergliedert.</p><hr size=\"1\">\n";
echo numInput('Forum3MaxSize','Anzahl pro Seite',$Forum3MaxSize,4,40,2,'tabzahl',"<br>\n");
printForen(3);
echo "</fieldset></div>\n";
?>
<div id="divConfig3" class="helper">
<fieldset><legend>Rechtevergabe</legend>
<p>Berechtigungen werden in den einzelnen Blogs und Foren konfiguriert.</p>
<?php
//	include 'personroles.php';
?>
</fieldset>
</div>
<?php
echo "<div id=\"divConfig4\" class=\"helper\"><fieldset><legend>Darstellung</legend>\n";
echo '<span class="editlink" onclick="oeffne(' . "'incfile','../data/plugins/Public/style.css',1);\">(Stylesheet bearbeiten)</span>\n";
echo "<p>Hier gibt es sonst noch nichts zu konfigurieren</p>\n";
echo "</fieldset></div>\n";
/* This should be the last line in edit.php:
It closes the last fieldset and displays the area beneath with the two buttons to save the entries or to close the window.
Beware:
If you use tabs, the last tab must also be closed...
*/
echo "</div></fieldset>\n" . formsave('Plugin',$Plugin);
?>