<?php
/* wf_work.php
   Arbeitsseite für einen Workflow
   wird in Orga/page.php included, deshalb alle Konfigs bereits vorhanden...
*/

function TableHead($Typ) {
	global $DaysMon,$Scaling, $First,$Last;
	if ($Typ>0) {
		$strMM = ['Monat','Januar','Februar','März','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember'];
		$strmm = ['Mon','Jan','Feb','März','Apr','Mai','Juni','Juli','Aug','Sep','Okt','Nov','Dez'];

//		echo "<tr><th class=\"name\">Name</th>";
		for ($i=$First; $i<=$Last; $i++) {
			$width = $DaysMon[$i]*$Scaling;
			switch ($Typ) {
				case 1: echo "<th width=\"$width\"> $i </th>"; break;
				case 2: echo "<th width=\"$width\"> $strmm[$i] </th>"; break;
				case 3: echo "<th width=\"$width\"> $strMM[$i] </th>"; break;
			}
		}
		echo "</tr>\n";
	}
}
//	Dependencies: -> nur für wf_work.php (Workflow) -> Conflicts
$DetectConflicts = is_dir('data/plugins/Absence');

if ($DetectConflicts) {
	$adb = new SQLite3('data/plugins/Absence/DB.db');
	include 'data/plugins/Absence/config.php';

//	Abwesenheitsgründe:
	$sql = "SELECT * FROM AbsenceTypes ORDER BY Folge";
	$res = $adb->query($sql);
	while ($rs = $res->fetchArray()) {
		$AbsenceType[$rs['ID']] = $rs['Name'];
		$AbsenceGrafix[$rs['ID']] = $rs['Grafix'];
	}
}

$ShowAll = 0;

// Liste aller User (die MitarbeiterInnen sind):
$sql = "SELECT ID,Name,RealName FROM Users ORDER BY Name";
$res = $db->query($sql);
while ($rs = $res->fetchArray()) {
	$Name = empty($rs['RealName']) ? $rs['Name'] : $rs['RealName'];
	$Person[$rs['ID']] = $Name;
}

//	Einlesen aller Tätigkeiten:
// (statt Actor später mal Rolle verwenden! und über Rollenmatrix einen MA als Actor bestimmen.)
$sql = "SELECT ID,Name,ProcID,Actor FROM Activities";
$res = $odb->query($sql);
while ($rs = $res->fetchArray()) {
	$AIDs[] = $rs['ID'];
	$Action[$rs['ID']] = $rs['Name'];
	$ProcID[$rs['ID']] = $rs['ProcID'];
	$Actor[$rs['ID']]  = $rs['Actor'];
	if ($Actor[$rs['ID']]==0) {
		$get = $odb->querySingle('SELECT Parent,Owner FROM Orga WHERE ID='.$ProcID[$rs['ID']],1);
		if ($get['Owner'] == 0) {
			$Actor[$rs['ID']] = $odb->querySingle('SELECT Owner FROM Orga WHERE ID='.$get['Parent']);
		} else {
			$Actor[$rs['ID']] = $get['Owner'];
		}
	}
}

// ################################### Workflow einlesen und vorbereiten: ########################################

if ($WFID==0) {
	echo '<p class="neutral">Bitte wählen Sie zunächst einen Workflow aus'.($WebStat ? ' oder erstellen Sie einen neuen':'').":<br>\n";
	echo '<b>Vorauswahl</b>: &nbsp; nur abgeschlossene<input type="radio" name="Sel" value="1"'. ($Sel==1 ? ' checked':'') .' onclick="newload(1,'.$View.',0)"> &nbsp; '.
	'/ nur offene<input type="radio" name="Sel" value="2"'. ($Sel==2 ? ' checked':'') .' onclick="newload(2,'.$View.',0)"> &nbsp; '.
	'/ alle<input type="radio" name="Sel" value="3"'. ($Sel==3 ? ' checked':'') .' onclick="newload(3,'.$View.',0)"> Workflows vorauswählen '.
	($WebStat ? '/ <input type="radio" name="Sel" value="0"'. ($Sel==0 ? ' checked':'') .' onclick="newload(0,'.$View.',0)"> neu Anlegen':'').'<br><br>';
	if ($Sel==0) {
		echo '<form method="post">';
		echo txtInput('Name','Name des Workflows','','sollte eindeutig sein','required');
		if (is_file('data/includes/dbf_class.php')) {
//	neu anlegen: Name, Kunde aus Majesty...
			include 'data/includes/dbf_class.php';
			startSelect('ANGNR','Majesty-Angebot');
			echo txtOption(5000,'ohne Majesty-Vorgang');
//		Alle Angebote
			$Liste = new dbf_class('./DBFS/','ANGKO.DBF');	// ggf. beschränken auf offene Angebote
			$AnzList = $Liste->dbf_num_rec;
			for ($i=0; $i<$AnzList; $i++) {
				if ($Ang = $Liste->getRow($i)) {
//					echo txtOption($Ang[0], utf($Ang[5].' ('.$Ang[26].' v. '.$Ang[27].')'));
					echo txtOption($Ang[0], utf($Ang[5].' ('.$Ang[0].' v. '.Datum($Ang[2]).')'));
				}
			}
			echo "</select> kann man noch ändern, sollte eindeutig sein...<br>\n";
			startSelect('Kunde','Majesty-Kunde');
//		Alle Kunden
			$Liste = new dbf_class('./DBFS/','KDST.DBF');
			$AnzList = $Liste->dbf_num_rec;
			for ($i=0; $i<$AnzList; $i++) {
				if ($Kunde = $Liste->getRow($i)) {
					$Kunden[$Kunde[2]] = utf($Kunde[4]);
				}
			}
			asort($Kunden);
			foreach($Kunden as $Nr=>$Name) {
				echo txtOption($Nr.'#'.$Name,$Name);
			}
			echo "</select> <br>\n";
		} else {
			echo '<input type="hidden" name="ANGNR" value="5000"><input type="hidden" name="Kunde" value="0#">';
		}
//	Vorlage
		startSelect('WFT','Vorlage (Muster)');
		echo txtOption(0,'Aktuelle Prozesslandschaft');
		$res = $odb->query('SELECT ID,Name FROM WFTemplates');
		while ($rs = $res->fetchArray()) {
			echo txtOption($rs[0],$rs[1]);
		}
		echo "</select> <br>\n";
		echo '<label>Startdatum</label><input type="date" name="Start" id="Start"> Wann beginnt das Vorhaben?<br>';
		echo '<label></label><input type="submit" name="wegmit" value="anlegen"><br></form>';
	} else {
//		startSelect('WFID','Workflow');
		echo '<label></label><select name="WFID" onchange="newload(0,'.$View.',this.value)">';
		echo txtOption(0,'Bitte wählen:',0);
		$sql = "SELECT * FROM Workflows WHERE Status=0";	// hier ändern!
		$res = $odb->query($sql);
		while ($rs = $res->fetchArray()) {
			echo txtOption($rs['ID'],$rs['Name'],$WFID);
		}
		echo "</select> <br>\n";
	}
	echo "</p>\n";
} else {
//	Wir haben einen Workflow! Jetzt loslegen...:
//	Einlesen des Workflow-Headers inkl Start:
	$Desc = $odb->querySingle("SELECT * FROM Workflows WHERE ID=$WFID",1);
	$WFT  = $Desc['WFT'];	// welches Template wurde verwendet?
	if (!empty($WFT)) {
		$WFTName=$odb->querySingle("SELECT Name FROM WFTemplates WHERE ID=$WFT");
	} else {
		$WFTName='Prozesslandschaft';
	}
	$Start = $Desc['Start'];
	$StartWDay = getdate($Start)['wday'];	// Startdatum der 1. Activity MUST be a regular working day!

//	Ende ist quasi der (gedachte) Vorläufer
//	wegen korrekter Anzeige/Berechnung:
	if ($StartWDay==1) {
		$Ende = $Start - 3*$SecPerDay;
		$EndWDay = 5;
	} else {
		$Ende = $Start - $SecPerDay;
		$EndWDay = $StartWDay - 1;
	}

	$NextStart = $Start;
	$SaveEnd = $Ende;
	$LastDay = $Ende;
	$SaveEndWDay = $EndWDay;
	// war es das jetzt? OK?

//	Einlesen des Workflows:
	$sql = "SELECT * FROM Workflow WHERE WFID=$WFID";
	$res = $odb->query($sql);

	$PlanDauer = $odb->querySingle("SELECT SUM(Dauer) FROM Workflow WHERE WFID=$WFID AND Dauer>0");
	$Estimated = $PlanDauer + (int)($PlanDauer/5)*2;

//	anhand der Dauer Grenzen, Skalierung und Überschriftsart ausrechnen:
	$FirstDate = getdate($Start);
	$First = $FirstDate['mon'];
	$LastDate  = getdate($Start + $Estimated*$SecPerDay);	// was wenn über Jahresgrenze?
	if ($LastDate['year']>$FirstDate['year']) {
		$Last = 12;
	} else {
		$Last  = $LastDate['mon'];
	}
	$AnzMonate = $Last - $First + 1;
	$Scaling = (int)(12/$AnzMonate);
	$TabHead = ($Scaling>2) ? 3 : 2;

//	angzuzeigender Planzeitraum:
//	$heute = getdate();	// alternativ gleich auf Jahr des Vorhabens schalten:
//	$heute = $FirstDate;

	$Jahr = $_GET['Jahr'] ?? ($_POST['Jahr'] ?? $FirstDate['year']);
	$isSchaltjahr = (($Jahr%4)==0);	// von 2000 bis 2099 keine weitere Korrektur...
	if ($isSchaltjahr) {$DaysMon[2]=29;}

	$Ostern = easter_date($Jahr);	// für bewegliche Feiertage

	$OsternIsSZ = date('I',$Ostern)==1;
	$OsternIsZU = date('I',$Ostern+$SecPerDay)==1 && !$OsternIsSZ;
	$FastKorr = 3600*$OsternIsSZ;
	$NachKorr = 3600*(1-$OsternIsSZ);
	$MontKorr = 3600*$OsternIsZU;

	$Neujahr     = strtotime("$Jahr-01-01");
	$Dreikoenig	 = strtotime("$Jahr-01-06");
	$Maifeiertag = strtotime("$Jahr-05-01");
	$Karfreitag  = $Ostern - 2*$SecPerDay;
	$Ostermontag = $Ostern + 1*$SecPerDay - $MontKorr;
	$Himmelfahrt = $Ostern + 39*$SecPerDay- $NachKorr;
	$Pfingstmontag=$Ostern + 50*$SecPerDay- $NachKorr;
	$Fronleichnam= $Ostern + 60*$SecPerDay- $NachKorr;
	$Nationalftag= strtotime("$Jahr-10-03");
	$Weihnacht1  = strtotime("$Jahr-12-25");
	$Weihnacht2  = strtotime("$Jahr-12-26");
	$HeiligAbend = strtotime("$Jahr-12-24");	// halber Tag
	$Silvester   = strtotime("$Jahr-12-31");	// halber Tag
	$Rosenmontag = $Ostern - 48*$SecPerDay;		// halber Tag
	$MarHimmelft = strtotime("$Jahr-08-15");	// Saarland...
	$Reformation = strtotime("$Jahr-10-31");	// Sachsen...
	$Allerheiligen=strtotime("$Jahr-11-01");	// BW, Bayern...
	$Advent4	 = strtotime("last Sunday",$Weihnacht1);
	$Advent3	 = $Advent4 -  7*$SecPerDay;
	$Advent2	 = $Advent4 - 14*$SecPerDay;
	$Advent1	 = $Advent4 - 21*$SecPerDay;
	$BussUndBettag=$Advent4 - 32*$SecPerDay;

	$TabStart = strtotime("$Jahr-01-01");
	$TabEnde  = strtotime("$Jahr-12-31");

/* ----------------- Hier beginnt sie Anzeige --------------------- */
//	Auswahl des Workflows:

//	Anzeige des Vorspanns:
	$MyKunde = empty($Desc['Kunde']) ? '' : ' ('.$Desc['Kunde'].')';
	// echo '<h2>Terminplanung: <a class="jahr" href="'.$u.$mypage.'&Jahr='. ($Jahr-1) .'&ShowAll='.$ShowAll.'" title="1 Jahr zurück"> &lt; </a> '.date('d.m.Y',$TabStart)." bis ".date('d.m.Y',$TabEnde).' <a class="jahr" href="'.$u.$mypage.'&Jahr='. ($Jahr+1) .'&ShowAll='.$ShowAll.'" title="1 Jahr vor"> &gt; </a></h2><br>';
	echo '<h2>'.$Desc['Name'].$MyKunde.' &nbsp; <small>(<a href="'.$u.$mypage.'&WFID=0">oder einen anderen Workflow wählen</a>)</small></h2><br>';

//	Anzeigemodus auswählen:
	echo '<p><b>Anzeige</b>: &nbsp; Nur Tätigkeiten<input type="radio" name="View" value="0"'. ($View==0 ? ' checked':'') .' onclick="newload(0,0,'.$WFID.')"> &nbsp; / nur Prozesse<input type="radio" name="View" value="1"'. ($View==1 ? ' checked':'') .' onclick="newload(0,1,'.$WFID.')"> &nbsp; / beides<input type="radio" name="View" value="2"'. ($View==2 ? ' checked':'') .' onclick="newload(0,2,'.$WFID.')"> &nbsp; anzeigen.</p>';

//	Anzeige der Tabelle:
	echo '<table><tr class="Kopf"><th>Tätigkeit (Start am '.$strDD[$StartWDay].', '.date('d.m.Y',$Desc['Start']).')</th><th>Bearbeitung</th><th>Status</th>';	//"<th>Beginn</th><th>D</th><th>Ende</th>";
	TableHead($TabHead);

	$HasConflicts= false;
	$ConflictIDs = [];
	$Conflicts   = [];
	$MyProc = 0;

	while ($rs = $res->fetchArray()) {
	  if (in_array($rs['AID'],$AIDs)) {	// maybe this activity is deleted in the meantime!
		$Start = $NextStart;
		$StartWDay = getdate($Start)['wday'];

		if ($View) {
//		Prozesse anzeigen:
			$Proc = $odb->querySingle('SELECT ProcID FROM Activities WHERE ID='.$rs['AID']);
			$strProc = $odb->querySingle('SELECT ID,Parent,Name,Owner FROM Orga WHERE ID='.$Proc,1);
			if ($strProc['Parent']>5) {	// das ist ein Arbeitsbereich
				$Proc = $strProc['Parent'];
				$strProc = $odb->querySingle('SELECT Name,Owner FROM Orga WHERE ID='.$Proc,1);
			}
//			Jetzt haben wir den PROZESS:
			if ($Proc!=$MyProc) {
				if ($MyProc>0) {
//				Schlusszeile des letzten Prozesses:
					echo '<tr class="small" style="font-style:italic; background:var(--level-3); border-bottom:4px solid white;"><td align="right"> '.$ProcName.'&nbsp;</td><td>Prozessdauer</td><td colspan="'.($AnzMonate+1).'">'.date('d.m.Y ',$ProcStart).' - '.date('d.m.Y ',$Start).'</td></tr>';
				}
				echo '<tr class="small" style="background:var(--level-3);"><td>'.$strProc['Name'].'</td><td>'.$Person[$strProc['Owner']].'</td><td colspan="'.($AnzMonate+1).'"></td></tr>';
				$MyProc = $Proc;
				$ProcStart = $Start;
				$ProcName  = $strProc['Name'];
			}
		// Ende Prozesszeile
		}

		$Dauer = $rs['Dauer'];
		$DauerEff = $Dauer;

		if ($Dauer>0) {	// discard negative values for predecessors
//		Berechne effektives nächstes Startdatum (weil jetzt haben wir die geplante Dauer bis dahin)
			$NextStart = $Start + $Dauer*$SecPerDay;
//		Wochenendkorrektur:
			$NextWE = $StartWDay + $Dauer;
			if ($NextWE>5) {	// we are crossing at least one weekend
				$WEKorr = (int)(($NextWE-1)/5)*2;
				$NextStart += $WEKorr*$SecPerDay;
				$DauerEff += $WEKorr;
			}
//		Feiertagskorrektur - missing...

//		Berechne effektives Ende:
			$Ende = $Ende + $Dauer*$SecPerDay;
			$NextWE = $EndWDay + $Dauer;
			if ($NextWE>5) {
				$WEKorr = (int)(($NextWE-1)/5)*2;
				$Ende += $WEKorr*$SecPerDay;
			}
//		Auch hier: Feiertagskorrektur - missing...

			$EndWDay = getdate($Ende)['wday'];
			$SaveEnd = $Ende;
			$SaveEndWDay = $EndWDay;
		} else {
			$Ende = $Start;
			$EndWDay = $StartWDay;
			$LastDay = $Ende;	// merken: falls allerletzte Dauer 0 ist, wird sie ja "zurück-korrigiert"
		}

		$Worker = $Actor[$rs['AID']];	// maybe 999999 for multiple possible workers, so:
		$Person[999999] = "mehrere";	// and is never absent, when checking absence conflicts (see beneath) !!
		if ($View!=1) echo '<tr class="small"><td class="name" onclick="showact('.$WFID.','.$rs['ID'].','.$rs['AID'].')">'.$Action[$rs['AID']].'</td><td>'.$Person[$Worker].'</td><td>'.$rs['Status'].'</td>';
		$strStart = date('d.m.Y ',$Start).'('.$strdd[$StartWDay].')';
		$strEnde  = date('d.m.Y ',$Ende).'('.$strdd[$EndWDay].')';
//		if ($View!=1) echo '<td>'.date('d.m.Y ',$Start).$strdd[$StartWDay].'</td><td class="right">'.$Dauer.'</td><td>'.date('d.m.Y ',$Ende).$strdd[$EndWDay]."</td>";

//	if no conflicts:
		$img = "blau.gif";

		if ($DetectConflicts) {
//		now check absence conflicts:
//			$sql = "SELECT * FROM Absence WHERE PersonID=$Worker AND ((Ende>$Start AND Ende<$Ende) OR (Beginn>$Start AND Beginn<$Ende) OR (Beginn<$Start AND Ende>$Ende))";
			$sql = "SELECT * FROM Absence WHERE PersonID=$Worker AND ((Ende BETWEEN $Start AND $Ende) OR (Beginn BETWEEN $Start AND $Ende) OR (Beginn<$Start AND Ende>$Ende)) AND Status NOT IN (3,5)";
			$abs = $adb->query($sql);	// evtl. noch genauer auf Status eingehen, RefID=0 ...
			while ($cf = $abs->fetchArray()) {
				$img = ($cf['Status']==2) ? "alert2.gif" : "alert3.gif";
				$HasConflicts=true;
				if (!in_array($cf['ID'],$ConflictIDs)) {	// noch nicht erfasst:
					$ConflictIDs[] = $cf['ID'];
					$strMaybe = ($cf['Status']==2) ? '' : ' möglicherweise';
					$Conflicts[] = $Person[$Worker] . " ist vom " . date('d.m.Y',$cf['Beginn']) . " bis " . date('d.m.Y',$cf['Ende']). "$strMaybe abwesend (" . $AbsenceType[$cf['Grund']] . " / " . $cf['Text'] . " - Status: " . $strStatus[$cf['Status']] . ")<br>\n";
				}
			}
		}

//		normalize to daylight saving time:
		$GfxStart = strtotime(date('Y-m-d',$Start));
		$GfxEnde  = strtotime(date('Y-m-d',$Ende));
//		Note that date("I") returns 1 in summer and 0 in winter.

		for ($i=$First; $i<=$Last; $i++) {
			$MonStart = strtotime("$Jahr-$i-01");
			$MonEnde  = strtotime("$Jahr-$i-$DaysMon[$i]");
			$Zeiten = '';
			$SecsToEnd = 0;

//		findet in diesem Monat eine Tätigkeit statt?
//			if (($Ende>$MonStart AND $Ende<$MonEnde) OR ($Start>$MonStart AND $Start<$MonEnde) OR ($Start<$MonStart AND $Ende>$MonEnde)) {
			if (($GfxEnde>=$MonStart AND $GfxEnde<=$MonEnde) OR ($GfxStart>=$MonStart AND $GfxStart<=$MonEnde) OR ($GfxStart<$MonStart AND $GfxEnde>$MonEnde)) {
//			if (($Ende BETWEEN $MonStart AND $MonEnde) OR ($Start BETWEEN $MonStart AND $MonEnde) OR ($Start<$MonStart AND $Ende>$MonEnde)) {

				if ($Dauer<0) {	// negative values for predecessors
					$GfxStart = $MonStart;
					$img = "orange.gif";
				}

				$SecsToStart = max($SecsToEnd, $GfxStart-$MonStart);
				$DaysToStart = ($SecsToStart - $SecsToEnd)/$SecPerDay;
				$SecsToEnd   = min($MonEnde, $GfxEnde) - $MonStart + $SecPerDay;	// we add 1 to display at least 1 day...
				$NumberOfDays= ($SecsToEnd-$SecsToStart)/$SecPerDay;

				$Zeiten .= '<img class="zeit" src="plugins/Absence/symbols/'.$img.'" style="width:'.$NumberOfDays*$Scaling.'px; margin-left:'.$DaysToStart*$Scaling.'px;" title="'.$strStart."&#10;Dauer: $Dauer AT ($DauerEff KT)&#10;$strEnde".'">';
				if ($GfxEnde<=$MonEnde) {
					$GfxStart = $GfxEnde;
				}
			} else {
//				$Zeiten .= $GfxStart."/".$MonEnde;
//				$Zeiten .= $DaysToStart . '/' . $NumberOfDays;
			}
			if ($View!=1) echo "<td>$Zeiten</td>";
		}
		if ($View!=1) echo "</tr>\n";
		if (!($Dauer>0)) {
			$Ende = $SaveEnd;
			$EndWDay = $SaveEndWDay;
		}
	  }
	}
	if ($View) {
//	Jetzt noch letzte Prozesszeile:
		echo '<tr class="small" style="font-style:italic; background:var(--level-3);"><td align="right"> '.$ProcName.'&nbsp;</td><td>Prozessdauer</td><td colspan="'.
		($AnzMonate+1).'">'.date('d.m.Y ',$ProcStart).' - '.date('d.m.Y ',$Start).'</td></tr>';
	}
	echo "</table>\n";

//	Kommentare dazu:
	echo "<p><small>(Dieser Workflow basiert auf der Vorlage &quot;$WFTName&quot; und wurde angelegt am ".date('d.m.Y',$Desc['Created'])." von ".$Person[$Desc['Creator']].")</small></p>\n";

//	Kommentar Plandauer:
	echo '<p class="neutral">Plandauer: '.$PlanDauer.' Arbeitstage, Bruttodauer (inkl. Wochenenden): '. ($Ende-$Desc['Start'])/$SecPerDay . " Kalendertage vom ".date('d.m.Y',$Desc['Start'])." bis ".date('d.m.Y',$LastDay)." (OBACHT: Feiertage fehlen hier leider noch!)</p>\n";

//	Kommentar Terminkonflikt:
	if ($HasConflicts) {
		echo '<p class="error"><b>Es gibt Terminkonflikte:</b><br>';
		foreach ($Conflicts as $txt) {
			echo $txt;
		}
		echo "</p>\n";
	}
}
echo '<div id="details">Hier kommt dann die Bearbeitung der Aktivität hin.</div>';
?>