<?php
$MyPlugin = $MyPlugins . '/Orga/';

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = 'data/plugins/Orga/';

$odb = new SQLite3($MyPluginDataFolder.'DB.db');
include $MyPluginDataFolder.'config.php';

// Abwesenheitszeiten:
$Absence = 'data/plugins/Absence/';
$adb = new SQLite3($Absence.'DB.db');
include $Absence.'config.php';

// #######################################################################
// Einige Funktionen:
// Auswahl oder nur Anzeige des Qualifikationslevels
function QualLevel($ID,$L,$DO) {
	global $QualLevel,$MayQuali,$MA;
	if ($MayQuali || $DO) {
		$txt = '<select name="QL" onchange="setQL(this.value,'.$MA.','.$ID.')">';
		foreach ($QualLevel as $nr=>$QL) {
			$txt.= txtOption($nr,$QL,$L);
		}
		$txt.= '</select>';
		return $txt;
	} else {
		return $QualLevel[$L];
	}
}
// Anzeige einer Zeile der Aufgabenzuordnung:
function PrintProc($Procs, $ShowQuali, $ShowWhen, $ShowWho, $neg='') {
	global $Person, $MayQuali,$ProcOwnerMayQualiAct,$MA, $QualiCheck,$QualiAction,$QualiProc, $search;
	$UserID = $_SESSION['UserID'] ?? -1;	// 0 ungünstig, da Owner=0 verlangt werden könnte (bei $Procs,$Areas)!
	foreach($Procs as $Proc) {
		// Highlighting für die Suchergebnisse:
		$Name = $Proc[1];
		if ($search!='') {
			$Name = highlight($Name,$search);
		}
		echo "<tr><td>$Name</td>";
		$DO = (($UserID == $Proc[5]) AND (($ProcOwnerMayQualiAct==2) OR ($ProcOwnerMayQualiAct==1 AND $UserID!=$MA)));
		if ($ShowQuali || $DO) {
			echo '<td><small>Qualifikation: '.QualLevel($neg.$Proc[0],$Proc[2],$DO).'</small></td>';
			if ($ShowWhen || $DO) {
				if ($Proc[3]==0) {
					echo '<td><small>wurde noch nicht festgestellt</small></td>';
				} else {
					echo '<td><small>festgestellt am '.Date('d.m.Y',$Proc[4]);
					if ($ShowWho || $DO) echo ' von '.$Person[$Proc[3]];
					echo '</small></td>';
				}
			}
		}
		if ($QualiCheck && ($MayQuali || $DO)) {
			$MinQuali = ($neg=='-') ? $QualiAction[$Proc[0]] : $QualiProc[$Proc[0]];	// Vererbungslehre beachten!!!!
			if ($Proc[2] >= $MinQuali) {
				$bgc = 'lightgreen';
				$txt = 'OK';
			} else {
				$bgc = '#f88';
				$txt = 'nicht qualifiziert!';
			}
			echo '<td style="background-color:'.$bgc.'"><small>'.$txt.'</small></td>';
		}
		echo "</tr>\n";
	}
}

function OrgaTable($Parent=0, $Level=0) {
	global $odb,$MaxLevel, $search;
	$table = '';
	// eigtl. nicht benötigt:
//	$Anzahl  = $odb->querySingle("SELECT COUNT(ID) FROM Orga WHERE Parent=$Parent");
	// Jetzt die Organisationseinheiten:
	$sql = "SELECT * FROM Orga WHERE Parent=$Parent ORDER BY Folge";
	$res = $odb->query($sql);
//	$count = 0;	// count evtl. interessant bei grid-Layouts für Anzahl der Grids
	while ($rs = $res->fetchArray()) {
//		$count++;
		$ID = $rs['ID'];
		$NName = $rs['Name'];
		if ($search!='') {
			$NName = highlight($NName,$search);
		}
		$zeile = '<span onclick="getDetails('.$ID.','.$Level.')">'.$NName."</span>";
		// Rekursion: gibt es Unterorganisationen zu dieser Organisationseinheit?
		$text = ($Level<$MaxLevel) ? OrgaTable($ID, $Level+1) : '';
		// wegen hierarchischer Anzeige (Einrückung, Folder auf/zu):
		if ($text != '') {
			$LC = 'OrgaLevel-'.($Level+1);
			$table .= "<li class=\"isParent\">$zeile\n<ul class=\"$LC\">" . $text . "</ul>\n";
		} else {
			$table .= "<li class=\"noChild\">$zeile</li>\n";
		}
	}
	return $table;
}

function Matrix($Parent=0, $Level=0, $Name='', $Owner=0) {
	global $odb,$MaxLevel,$Person,$Anzahl,$Scope,$DelegRule, $search;
	$table = '';

	// Jetzt die Organisationseinheiten:
	$sql = "SELECT ID,Name,Owner FROM Orga WHERE Parent=$Parent ORDER BY Folge";
	$res = $odb->query($sql);

	while ($rs = $res->fetchArray()) {
		$ID = $rs['ID'];
		if ($Level==1) $Scope = $ID;	// wegen: Kernprozesse einfärben
		$sql = "SELECT * FROM Activities WHERE ProcID=$ID ORDER BY Folge";
		$rec = $odb->query($sql);
		$zeile = '';
		while ($rc = $rec->fetchArray()) {
			$Anzahl++;
			$zeile .= '<tr' . ($Scope==4 ? ' class="coreproc">' : '>');	// Kernprozesse einfärben
			// Highlighting für die Suchergebnisse:
			$NName = $rc['Name'];
			if ($search!='') {
				$NName = highlight($NName,$search);
			}
			if ($Level==2) {	// Prozess
				$p = strpos($rs['Name'],'[PK0');
				$Bezug = ($p!==false) ? substr($rs['Name'], $p+1 ,5) : '';
				$Actor = '';
				if ($DelegRule) {
					$Actor2 = ($rc['Actor']>0 && ($rc['Actor']!=$Owner || $rc['Actor']!=$rs['Owner'])) ? $Person[$rc['Actor']] : '';	// abweichende Person in der Tätigkeit
					$tdDeleg = "<td>$Actor2</td>";
				} else {
					$tdDeleg = '';
				}
				$zeile .= '<td>'.$NName.'</td><td>'.$rs['Name'].'</td><td>'.$Bezug.'</td><td></td><td>'.$Person[$rs['Owner']]."</td><td></td>$tdDeleg<td></td></tr>\n";
			} else {	// Aufgabenbereich
				$p = strpos($Name,'[PK0');
				$Bezug = ($p!==false) ? substr($Name, $p+1 ,5) : '';
				$Actor1 = ($rs['Owner']>0 && $rs['Owner']!=$Owner) ? $Person[$rs['Owner']] : '';	// abweichende Person im Aufgabenbereich
				if ($DelegRule) {
//					$Actor2 = ($rc['Actor']>0 && $rc['Actor']!=$Owner) ? $Person[$rc['Actor']] : '';	// abweichende Person in der Tätigkeit
					$Actor2 = ($rc['Actor']>0 && ($rc['Actor']!=$Owner || $rc['Actor']!=$rs['Owner'])) ? $Person[$rc['Actor']] : '';	// abweichende Person in der Tätigkeit
					$tdDeleg = "<td>$Actor2</td>";
				} else {
					$tdDeleg = '';
				}
				$zeile .= '<td>'.$NName."</td><td>$Name</td><td>$Bezug</td><td>".$rs['Name']."</td><td>".$Person[$Owner]."</td><td>$Actor1</td>$tdDeleg<td></td></tr>\n";
			}
		}
		// Rekursion: gibt es Unterorganisationen zu dieser Organisationseinheit?
		$text = ($Level<$MaxLevel) ? Matrix($ID, $Level+1, $rs['Name'], $rs['Owner']) : '';
		$table .= $zeile . $text;
	}
	return $table;
}

function Aufgaben($Parent=0, $Level=0, $Name='', $Owner=0) {
	global $odb,$MaxLevel,$Scope, $MA,$Procs,$Areas,$Actions, $TopQL,$TopWho,$TopWhen;

	// Jetzt die Organisationseinheiten:
	$sql = "SELECT ID,Name,Owner FROM Orga WHERE Parent=$Parent ORDER BY Folge";
	$res = $odb->query($sql);

	while ($rs = $res->fetchArray()) {
		$ID = $rs['ID'];
		if ($Level==1) $Scope = $ID;	// wegen: Kernprozesse einfärben if ($Scope==4)

		if ($Level==2) {	// Prozess
			if ($rs['Owner']==$MA) {
				$isTopOwner = true;
				$QLs = $odb->querySingle("SELECT Level,Changer,Changed FROM Skills WHERE (Person=$MA AND ProcID=$ID)",1);
				if (empty($QLs)) {
					$QL=0;
					$Who = $When = 0;
				} else {
					$QL   = $QLs['Level'];
					$Who  = $QLs['Changer'];
					$When = $QLs['Changed'];
				}
				$Procs[] = [$rs['ID'], $rs['Name'], $QL, $Who, $When, 0];
				$TopQL[$ID] = $QL;
				$TopWho[$ID]= $Who;
				$TopWhen[$ID]=$When;
			} else {
				$isTopOwner = false;
			}
		} elseif ($Level>2) {	// Aufgabenbereich
			if ($rs['Owner']==$MA || ($Owner==$MA && $rs['Owner']==0)) {
				$isTopOwner = true;
				$QLs = $odb->querySingle("SELECT Level,Changer,Changed FROM Skills WHERE (Person=$MA AND ProcID=$ID)",1);
				if (empty($QLs)) {
					$QL = $TopQL[$Parent] ?? 0;
					$Who= $TopWho[$Parent] ?? 0;
					$When=$TopWhen[$Parent] ?? 0;
				} else {
					$QL   = $QLs['Level'];
					$Who  = $QLs['Changer'];
					$When = $QLs['Changed'];
				}
				$Areas[] = [$rs['ID'], $rs['Name'], $QL, $Who, $When, 0];
				$TopQL[$ID] = $QL;
				$TopWho[$ID]= $Who;
				$TopWhen[$ID]=$When;
			} else {
				$isTopOwner = false;
			}
		}

		// Tätigkeiten zu diesem Prozess/Aufgabenbereich:
		$sql = "SELECT ID,Name,Actor FROM Activities WHERE ProcID=$ID ORDER BY Folge";
		$rec = $odb->query($sql);
		while ($rc = $rec->fetchArray()) {
			$IsActorOfMany = false;
			if ($rc['Actor']==999999) {
				$Actors = $odb->querySingle('SELECT Actors FROM ManyActors WHERE ActID='.$rc['ID']);
				if (in_array($MA, explode(',',$Actors))) $IsActorOfMany = true;
			}
			if ($rc['Actor']==$MA || ($isTopOwner && $rc['Actor']==0) || $IsActorOfMany) {
				$QLs = $odb->querySingle("SELECT Level,Changer,Changed FROM Skills WHERE (Person=$MA AND ActID=".$rc['ID'].")",1);
				if (empty($QLs)) {
					$QL = $TopQL[$ID] ?? 0;
					$Who= $TopWho[$ID] ?? 0;
					$When=$TopWhen[$ID] ?? 0;
				} else {
					$QL   = $QLs['Level'];
					$Who  = $QLs['Changer'];
					$When = $QLs['Changed'];
				}
				$Actions[] = [$rc['ID'], $rc['Name'], $QL, $Who, $When, $rs['Owner']];
			}
		}
		// Rekursion: gibt es Unterorganisationen zu dieser Organisationseinheit?
		$text = ($Level<$MaxLevel) ? Aufgaben($ID, $Level+1, $rs['Name'], $rs['Owner']) : '';
	}
	return true;
}

function Befugnis($Parent=0,$Level=0) {
	global $odb,$Person, $search;
	$sql = "SELECT ID,Name,Owner FROM Orga WHERE Parent=$Parent ORDER BY Folge";
	$res = $odb->query($sql);
	while ($rs = $res->fetchArray()) {
		$NName = $rs['Name'];
		if ($search!='') {
			$NName = highlight($NName,$search);
		}
		if ($Parent==2) {
			echo '<tr><td colspan="2"><h3>Verantwortung für die Prozesskategorie &quot;'.$NName."&quot;</h3></td></tr>\n";
			Befugnis($rs['ID'],$Level+1);
		} else {
			echo '<tr><td>'.$NName.'</td><td>'.$Person[$rs['Owner']]."</td></tr>\n";
		}
	}
}
function shortenName($Name) {
	$p = strpos($Name,' ');
	$SName = $Name[0].'.&nbsp;'.substr($Name,$p+1);
	return str_replace('-','&#8209;',$SName);
}

// #######################################################################
// Einstellungen einlesen:

$Chefs = $db->querySingle("SELECT Users FROM Roles WHERE Role='Chef'");
$ChefArray = explode (',',$Chefs);

$Staff = $db->querySingle("SELECT Users FROM Roles WHERE Role='Staff'");
$StaffArray = explode (',',$Staff);

$QMBs = $db->querySingle("SELECT Users FROM Roles WHERE Role='QMB'");
$QMBArray = explode (',',$QMBs);

// allgemeine Version, listet alle Berechtigungen (egal wie viele es gibt und wie sie heißen):
$Roles = $db->query('SELECT Role,Users FROM Roles');
while ($Users = $Roles->fetchArray()) {
	$strUsers[$Users['Role']] = $Users['Users'];
	$arrUsers[$Users['Role']] = explode(',',$Users['Users']);
}

/* Liste aller User, die MitarbeiterInnen sind:
$sql = 'SELECT ID,Name,RealName FROM Users WHERE ID IN ('.$strUsers['Staff'].') ORDER BY Name';
$res = $db->query($sql);
while ($rs = $res->fetchArray()) {
	$Name = empty($rs['RealName']) ? $rs['Name'] : $rs['RealName'];
	$Person[$rs['ID']] = $Name;
}
*/
// Liste aller User, auch die keine MitarbeiterInnen sind (sie könnten Ersteller älterer Unterlagen sein etc.):
$sql = "SELECT ID,Name,RealName FROM Users ORDER BY Name";
$res = $db->query($sql);
while ($rs = $res->fetchArray()) {
	$Name = empty($rs['RealName']) ? $rs['Name'] : shortenName($rs['RealName']);
	$Person[$rs['ID']] = $Name;
}

$MayAdmin = $WebStat && ($WebStat&1 || in_array($_SESSION['UserID'],$QMBArray));
$MayQuali = $WebStat && ($WebStat&1 || in_array($_SESSION['UserID'],$ChefArray));

// Vorgaben noch nicht in der config:
$StaffOnly = true;	// Zeige nur MA, die noch aktiv sind

// Konstante Bezeichner:
$strdd = ['So','Mo','Di','Mi','Do','Fr','Sa'];
$strDD = ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag'];
$DaysMon = [0,31,28,31,30,31,30,31,31,30,31,30,31];

$SecPerDay = 60*60*24;

// Aufrufparameter holen:
$test = $_GET['test'] ?? 0;	// Nur wegen Test...
$WFID = $_POST['WFID'] ?? ($_GET['WFID'] ?? 0);
$View = $_POST['NeuMA'] ?? ($_GET['NeuMA'] ?? 0);
$Sel  = $_POST['MA'] ?? ($_GET['MA'] ?? 2);
$view = $_GET['view'] ?? '';	// hier nicht benutzt!
$SO   = $_GET['SO'] ?? 1;

if ($WebStat) {
//	list($PostMaxSize,$FileMaxSize,$MAXFILESIZE,$MaxBytes) = ini_upload();
	echo insertTinyMCE();
	$HasEditor = true;
	$User = $_SESSION['User'];
	$UserID = $_SESSION['UserID'];
//	echo '<span class="pointer" onclick="protokoll(0,1,\''.$Modus.'\')"><img src="core/grafix/add.gif"> : Neues Protokoll erstellen</span><br>';

	$todo = $_POST['wegmit'] ?? '';

	if ($todo=='Speichern') {
		$ID = $_POST['id'] ?? '';
		$OK = false;
		if ($ID!='') {	// sonst wissen wir ja gar nicht, worum es geht...
			$Typ=$_POST['typ'];
			switch ($Typ) {
				case 0:	// von ProcEdit:
					$Item=$_POST['item'];
					switch ($Item) {
						case 'Owner':	$Val = $_POST[$Item]; break;
						default:	$Val = "'".$odb->escapeString($_POST[$Item])."'";
					}
					$sql = "UPDATE Orga SET $Item=$Val WHERE ID=$ID";
			//		echo $sql . "<br>\n";
					$OK = $odb->exec($sql);
					if ($OK) {
						$odb->exec("UPDATE Orga SET Changer=$UserID, Changed=".time()." WHERE ID=$ID");
						write_log("$User hat im Prozess $ID den Wert von $Item geändert");
					}
					$Level= $_POST['level'];
					echo "<script>\n document.addEventListener('DOMContentLoaded', function() {getDetails($ID,$Level)});\n</script>\n";
					break;
				case 1:	// von ActEdit:
					$Aufg = $odb->escapeString($_POST['Aufg']);
					$Proc = $_POST['Proc'];	// neuer Prozess
					$PID  = $_POST['PID'];	// alter Prozess
					$Actor = $_POST['Actor'] ?? 0;
					$QLevel= $_POST['QLevel'] ?? 0;
					$Dauer = $_POST['Dauer'] ?? 0;

					if (is_array($Actor)) {	// mehrere
						$Actors = implode(',',$Actor);
						$OK = $odb->querySingle("SELECT ID FROM ManyActors WHERE ActID=$ID");
						if (empty($OK)) {
							$sql = "INSERT INTO ManyActors (ActID,Actors) VALUES ($ID,'$Actors')";
						} else {
							$sql = "UPDATE ManyActors SET Actors='$Actors' WHERE ActID=$ID";
						}
						$OK = $odb->exec($sql);
						$Actor = 999999;
					}

					if ($ID==0) {
						// neue Tätigkeit
						$Folge = $odb->querySingle("SELECT MAX(Folge) FROM Activities WHERE ProcID=$Proc") + 1;
						$sql = "INSERT INTO Activities (ProcID,Folge,Name,Actor,QLevel,Period) VALUES ($Proc,$Folge,'$Aufg',$Actor,$QLevel,$Dauer)";
						$OK = $odb->exec($sql);
						if ($OK) {
							write_log("$User hat die Aufgabe $Aufg hinzugefügt");
						}
					} else {
						$sqlact = $DelegRule ? ", Actor=$Actor" : '';
						$qlevel = ($QualiProcs && $QualiActions) ? ", QLevel=$QLevel" : '';
						$sql = "UPDATE Activities SET Name='$Aufg'$sqlact$qlevel, Period=$Dauer WHERE ID=$ID";
						$OK = $odb->exec($sql);
						if ($OK) {
							write_log("$User hat in der Aufgabe $ID die Bezeichnung (und evtl. Delegation) geändert");
						}
					//	Delete:
						if (isset($_POST['del'])) {
							foreach ($_POST['del'] as $delID) {
								$Folge = $odb->querySingle("SELECT Folge FROM Activities WHERE ID=$delID");
								$sql = "UPDATE Activities SET Folge=Folge-1 WHERE ProcID=$PID AND Folge>$Folge";
//							echo $sql.'<br>';
								$OK = $odb->exec($sql);
//							Auch die Workflows korrigieren!!!
								$res = $odb->query("SELECT WFT,Folge FROM WFTemplate WHERE AID=$delID");
								while ($rec = $res->fetchArray()) {
									$OK = $odb->exec('UPDATE WFTemplate SET Folge=Folge-1 WHERE WFT='.$rec[0].' AND Folge>'.$rec[1]);
								}
								$res = $odb->query("SELECT WFID,Folge FROM Workflow WHERE AID=$delID");
								while ($rec = $res->fetchArray()) {
									$OK = $odb->exec('UPDATE Workflow SET Folge=Folge-1 WHERE WFID='.$rec[0].' AND Folge>'.$rec[1]);
								}
							}
							$dellist = implode(',',$_POST['del']);
							$sql = "DELETE FROM Activities WHERE ID IN ($dellist)";
							$OK = $odb->exec($sql);
							if ($OK) {
								write_log("$User hat in $PID die Aufgabe(n) $dellist gelöscht");
								$ups .= "<li>Aufgabe(n) $dellist gelöscht</li>";
							//	Sonst bleiben Dateileichen:
								$OK = $odb->exec("DELETE FROM Skills WHERE ActID IN ($dellist");
								$OK = $odb->exec("DELETE FROM ManyActors WHERE ActID IN ($dellist");
								$OK = $odb->exec("DELETE FROM WFTemplate WHERE ActID IN ($dellist");
								$OK = $odb->exec("DELETE FROM Workflow WHERE ActID IN ($dellist");
							}
						}
					//	verschieben
						if ($Proc!=$PID) {
							$Folge = $odb->querySingle("SELECT Folge FROM Activities WHERE ID=$ID");
							$sql = "UPDATE Activities SET Folge=Folge-1 WHERE ProcID=$PID AND Folge>$Folge";
							$OK = $odb->exec($sql);
							if ($OK) {
								$Folge = $odb->querySingle("SELECT MAX(Folge) FROM Activities WHERE ProcID=$Proc") + 1;
								$sql = "UPDATE Activities SET Folge=$Folge,ProcID=$Proc WHERE ID=$ID";
								$OK = $odb->exec($sql);
								if ($OK) {
									write_log("$User hat die Aufgabe $ID von $PID nach $Proc verschoben");
									$ups .= "<li>Aufgabe $ID verschoben</li>";
								}
							}
							//	Auch die Workflows korrigieren!!!
							// ist aber recht komplex...
						}
					}
//					echo "<script>\n document.addEventListener('DOMContentLoaded', function() {getDetails($Proc,$Level)});\n</script>\n"; // oder $PID? Level=?? evtl. auch gleich actedit öffnen?
					break;
			}
			if ($OK) {
				
			}
		} else {
			echo '<p class="error">Keine ID mitgeteilt - so kann ich nichts speichern...</p>';
		}
	} elseif ($todo=='anlegen') {	// von wf_work
		$Name = $_POST['Name'];
		$Kunde= explode('#',$_POST['Kunde']);
		$ANGNR= $_POST['ANGNR'];
		$WFT  = $_POST['WFT'];
		$Start= strtotime($_POST['Start']);
		// Startdatum der 1. Activity MUST be a regular working day!
		$SoZt= date('I',$Start);
		$Day = getdate($Start);
		if ($Day['wday']==0) $Start += $SecPerDay;
		if ($Day['wday']==6) $Start += 2*$SecPerDay;
		if (date('I',$Start) != $SoZt) {
			if ($SoZt==1)
				$Start -= 3600;
			else
				$Start += 3600;
		}

		$sql = "INSERT INTO Workflows (ANFNR,Name,KDNR,Kunde,WFT,Start,Creator,Created) VALUES ($ANGNR,'$Name',".$Kunde[0].",'".$Kunde[1]."',$WFT,$Start,".$_SESSION['UserID'].",".time().")";
		$OK = $odb->exec($sql);
		$WFID = $odb->lastInsertRowID();
		$Folge = 1;
		if ($WFT) {	// Template verwenden:
			$sql = "SELECT AID,WFTemplate.Folge,WFTemplate.Dauer,Actor,ProcID FROM WFTemplate,Activities WHERE WFT=$WFT AND AID=Activities.ID ORDER BY WFTemplate.Folge";
//			$sql = "SELECT AID,Folge,Dauer FROM WFTemplate WHERE WFT=$WFT ORDER BY Folge";
			$act = $odb->query($sql);
			while ($a = $act->fetchArray()) {
				$AID  = $a['AID'];
				$Dauer= $a['Dauer'];
				$Folge= $a['Folge'];
				$Akteur=$a['Actor'];
				if ($Akteur==0) {
					$Akteur = $odb->querySingle('SELECT Owner FROM Orga WHERE ID='.$a['ProcID']);
				}
				$sql = "INSERT INTO Workflow (WFID,AID,Folge,Dauer,Actor) VALUES ($WFID,$AID,$Folge,$Dauer,$Akteur)";
				$OK = $odb->exec($sql);
			}
		} else {	// Prozesslandschaft verwenden:
			$sql = "SELECT ID,Owner FROM Orga WHERE Parent=4 ORDER BY Folge";	// hardcoded 4 Kernprozesse!
			$res = $odb->query($sql);
			while ($proc = $res->fetchArray()) {
				// direkt zugeordnete Activities:
				$Aktor = $proc[1];
				$PActor = $Aktor;
				$sql = 'SELECT * FROM Activities WHERE ProcID='.$proc[0].' ORDER BY Folge';
				$act = $odb->query($sql);
				while ($a = $act->fetchArray()) {
					$AID = $a['ID'];
					$Dauer=$a['Period'];
					$Akteur = ($a['Actor']>0) ? $a['Actor'] : $PActor;
					$sql = "INSERT INTO Workflow (WFID,AID,Folge,Dauer,Actor) VALUES ($WFID,$AID,$Folge,$Dauer,$Akteur)";
					$OK = $odb->exec($sql);
					$Folge++;
				}
				$sql = 'SELECT ID,Owner FROM Orga WHERE Parent='.$proc[0].' ORDER BY Folge';
				$ber = $odb->query($sql);
				while ($b = $ber->fetchArray()) {
					$PActor = ($proc[1]>0) ? $proc[1] : $Aktor;
					$sql = 'SELECT * FROM Activities WHERE ProcID='.$b[0].' ORDER BY Folge';
					$act = $odb->query($sql);
					while ($a = $act->fetchArray()) {
						$AID = $a['ID'];
						$Dauer=$a['Period'];
						$Akteur = ($a['Actor']>0) ? $a['Actor'] : $PActor;
						$sql = "INSERT INTO Workflow (WFID,AID,Folge,Dauer,Actor) VALUES ($WFID,$AID,$Folge,$Dauer,$Akteur)";
						$OK = $odb->exec($sql);
						$Folge++;
					}
				}
			}
		}
	}
}
// #######################################################################

// echo "<p>Darstellung: <a href=\"$u$mypage&typ1\">Typ 1</a> <a href=\"$u$mypage&typ2\">Typ 2</a> <a href=\"$u$mypage&typ3\">Typ 3</a> <a href=\"$u$mypage&typ4\">Typ 4</a> <a href=\"$u$mypage&typ5\">Typ 5</a> ($MyPageParam)</p>\n";

switch ($MyPageParam) {

// Arbeitsworkflow:
  case 'wfwork':
	include "wf_work.php";
	break;

// Kennzahlen:
  case 'PKZ':
	$sql = "SELECT Name,PKZ FROM Orga WHERE PKZ NOT NULL AND PKZ>''";
	$res = $odb->query($sql);
	echo '<table><tr class="kopf"><th>Prozess</th><th>Kennzahlen</th><th>Ermittlung</th><th>Aktuell</th></tr>';
	while ($rs = $res->fetchArray()) {
		// Highlighting für die Suchergebnisse:
		$Name = $rs['Name']."</td>\n<td>".$rs['PKZ'];
		if ($search!='') {
			$Name = highlight($Name,$search);
		}
		echo "<tr><td>$Name</td><td></td><td></td></tr>\n";
	}
	echo "</table>\n";
	break;

// Aufgabenzuordnung / Qualifikation:
  case 'Aufgaben':
	$MA = $_GET['MA'] ?? 0;
	$NeuMA = $_GET['NeuMA'] ?? 0;
	$todo = $_GET['todo'] ?? '';

//	echo "MayQuali=$MayQuali, MayAdmin=$MayAdmin, MA=$MA<br>\n";
//	echo 'StaffArray='.implode(',',$StaffArray)."<br>\n";

	// Speichern:
	if ($todo=='setQL') {	// ($todo=='setQL' && $MayQuali)
		$QL = $_GET['ql'] ?? 0;
		$ID = $_GET['id'] ?? 0;
		$WhichID = $ID>0 ? 'ProcID' : 'ActID';
		$ID = abs($ID);
		$sql = "UPDATE Skills SET Level=$QL, Changer=".$_SESSION['UserID'].", Changed=".time()." WHERE (Person=$MA AND $WhichID=$ID)";
		$OK = $odb->exec($sql);
		if ($odb->changes()==0) {	// nothing happened...
			$sql = "INSERT INTO Skills (Person,$WhichID,Level,Changer,Changed) VALUES ($MA,$ID,$QL,".$_SESSION['UserID'].','.time().')';
			$OK = $odb->exec($sql);
		}
		if ($OK) {
			$User = $_SESSION['User'];
			write_log("$User hat die Qualifikation von ".$Person[$MA]." in $WhichID $ID auf Level $QL geändert");
		}
	}
	// Ggf. erforderliche Qualifikationen zum Vergleich ermitteln:
	if ($QualiCheck) {
		$res = $odb->query('SELECT ID,QLevel FROM Orga');
		while ($rs = $res->fetchArray()) {
			$QualiProc[$rs['ID']] = $rs['QLevel'];
		}
		$res = $odb->query('SELECT ID,ProcID,QLevel FROM Activities');
		while ($rs = $res->fetchArray()) {
			$QualiAction[$rs['ID']] = $QualiProc[$rs['ProcID']];	// Vererbung zuerst
			if ($QualiActions && ($rs['QLevel'] > $QualiProc[$rs['ProcID']]))
				$QualiAction[$rs['ID']] = $rs['QLevel'];	// ggf. höhere Quali erforderlich
		}
	}
	// Aufgaben einem anderen MA zuweisen:
	if ($NeuMA && $MayQuali) {
		$sql = "UPDATE Orga SET Owner=$NeuMA WHERE Owner=$MA";		// Prozesse/Aufgabenbereiche
		if ($odb->exec($sql)) {
			$txt = 'Prozesse von '.$Person[$MA].' an '.$Person[$NeuMA].' übertragen';
			write_log("$User hat alle $txt");
			$ups .= "<li>$txt</li>";
			echo '<p class="success">'.$txt."</p>\n";
		}
		$sql = "UPDATE Activities SET Actor=$NeuMA WHERE Actor=$MA";	// Aufgaben
		if ($odb->exec($sql)) {
			$txt = 'Aufgaben von '.$Person[$MA].' an '.$Person[$NeuMA].' übertragen';
			write_log("$User hat alle $txt");
			$ups .= "<li>$txt</li>";
		}
		$res = $odb->query('SELECT ID,Actors FROM ManyActors');		// "alle"
		while ($Actors = $res->fetchArray()) {
			$ManyActors= explode(',',$Actors[1]);
			$Actor = array_search($MA,$ManyActors);
			if ($Actor!==false) {
				$ManyActors[$Actor]=$NeuMA;
				$ManyActors = array_unique($ManyActors);
				$OK = $odb->exec("UPDATE ManyActors SET Actors='".implode(',',$ManyActors)."' WHERE ID=".$Actors[0]);
			}
		}
		if (is_file('data/plugins/Listen/DB.db')) {
			$ldb = new SQLite3('data/plugins/Listen/DB.db');		// Aktionsplan
			$res = $ldb->query('SELECT ID,Owner FROM Aktionsplan');
			while ($Actors = $res->fetchArray()) {
				$ManyActors= explode(',',$Actors[1]);
				$Actor = array_search($MA,$ManyActors);
				if ($Actor!==false) {
					$ManyActors[$Actor]=$NeuMA;
					$ManyActors = array_unique($ManyActors);
					$OK = $ldb->exec("UPDATE Aktionsplan SET Owner='".implode(',',$ManyActors)."' WHERE ID=".$Actors[0]);
				}
			}
		}
	}

	// MA wählen:
	startSelect('MA','MitarbeiterIn','onchange="newload(this.value,0,1,'. (int)$SO .')"');
	echo txtOption(0,'bitte wählen',$MA);
	foreach ($Person as $nr=>$Name) {
		if (in_array($nr,$StaffArray) || !$SO)
			echo txtOption($nr,$Name,$MA);
	}
	echo '</select> <input type="checkbox" name="SO" onclick="newload('.$MA.',0,1,'. (int)!$SO .')"'. ($SO ? ' checked' : '') ."> Nur aktiv Beschäftigte anzeigen<br>\n";
	if ($MayQuali && $MA) {	// falls berechtigt und MA gewählt: Aufgaben neu zuordnen
		startSelect('NeuMA','Neu zuordnen','onchange="v=this.value;if (v>0 && confirm(\'Sind Sie sicher?\'))newload('.$MA.',v,1,'. (int)$SO .');"');
		echo txtOption(0,'bitte wählen');
		foreach ($Person as $nr=>$Name) {
			if (in_array($nr,$StaffArray) && $nr!=$MA)
				echo txtOption($nr,$Name);
		}
		echo "</select> Alle Prozesse und Aufgaben einem anderen Mitarbeiter übertragen<br>\n";
	}
	// Jetzt Anzeige:
	if ($MA>0) {
		$Procs = [];
		$Areas = [];
		$Actions = [];
		$MaxLevel = 4;
		$TopQL = [];
		$PrintQuali = $QualiPersons && ($MayQuali || ($ShowQuali==9) || ($ShowQuali==1 && $WebStat) || ($ShowQuali==2 && $WebStat && $MA==$_SESSION['UserID']));
		$PrintWhen  = $PrintQuali  &&  ($MayQuali || ($ShowWhen==9)  || ($ShowWhen==1 && $WebStat)  || ($ShowWhen==2 && $WebStat && $MA==$_SESSION['UserID']));
		$cols = $PrintQuali ? ($PrintWhen ? ' colspan="3"' : ' colspan="2"') : '';
		$ProcHead = "<tr><td$cols><h3>".$Person[$MA];

		if (!in_array($MA,$StaffArray)) {
			echo '<br><p class="error">ACHTUNG: '.$Person[$MA]." ist nicht mehr in der Firma aktiv!</p>\n";
		}

		Aufgaben(1);	// Daten zusammentragen

		echo '<table class="blank">';

		if (count($Procs)) {
			echo $ProcHead. " verantwortet folgende Prozesse:</h3></td></tr>\n";
			PrintProc($Procs, $PrintQuali, $PrintWhen, $ShowWho);
		} else {
			echo $ProcHead. " verantwortet keine Prozesse</h3></td></tr>\n";
		}

		if (count($Areas)) {
			echo $ProcHead. " ist zuständig für folgende Aufgabenbereiche:</h3></td></tr>\n";
			PrintProc($Areas, $PrintQuali, $PrintWhen, $ShowWho);
		} else {
			echo $ProcHead. " ist für keinen Aufgabenbereich zuständig</h3></td></tr>\n";
		}

		if (count($Actions)) {
			echo $ProcHead. " übernimmt oder ist delegiert für folgende Tätigkeiten:</h3></td></tr>\n";
			PrintProc($Actions, $PrintQuali, $PrintWhen, $ShowWho, '-');
		} else {
			echo $ProcHead. " führt keine Tätigkeiten aus</h3></td></tr>\n";
		}
		echo "</table>\n";
	}
	break;

// Übersichtstabelle:
  case 'SurveyMA':
  //	Vorbereitung:
	$res = $odb->query('SELECT ID,ProcID,Name,QLevel FROM Activities');
	while ($rs = $res->fetchArray()) {
		$strAction[$rs[0]] = $rs[2];
	}
	$res = $odb->query('SELECT ID,Name,QLevel FROM Orga');
	while ($rs = $res->fetchArray()) {
		$strProcs[$rs[0]] = $rs[1];
	}
	$res = $db->query("SELECT Zeit,Titel,Button,People FROM Events WHERE Modus='1-0' ORDER BY Zeit");
	while ($rs = $res->fetchArray()) {
		$events[] = $rs;
	}
	$res = $db->query("SELECT Zeit,Titel,Button,People FROM Events WHERE Modus='1-1' ORDER BY Zeit");
	while ($rs = $res->fetchArray()) {
		$secure[] = $rs;
	}
	echo '<table class="small"><thead><tr class="kopf">';
	echo "<th>Name</th><th>Qualifikation</th><th>Besondere Befugnisse</th><th>Unterweisungen</th><th>Schulungen</th><th>Abwesenheit</th><th>Rollen</th><th>Sonstiges</th></tr></thead>\n";
	foreach ($Person as $nr=>$Name) {
		if (in_array($nr,$StaffArray) || !$SO) {
			echo "<tr><td>$Name</td>";
		// Qualifikation:
			$txt = $bef = '<ul>';
			$QLs = $odb->query("SELECT Level,Changer,Changed,ActID,ProcID FROM Skills WHERE Person=$nr");
			while ($QL = $QLs->fetchArray()) {
				if ($QL[0]==6) {
					$bef .= '<li>'.$strAction[$QL[3]].'</li>';
				}
				elseif ($QL[3]) {
					$txt .= '<li>'.$strAction[$QL[3]].' ('.$QualLevel[$QL[0]].')</li>';
				} elseif ($QL[4]) {
					$txt .= '<li><i>'.$strProcs[$QL[4]].' ('.$QualLevel[$QL[0]].')</i></li>';
				}
			}
			echo "<td>$txt</ul><a href=\"?Aufgaben&MA=$nr\">Qualifikationen bearbeiten</a></td>\n";	// OBACHT: Link ist hardcoded !!!!
		// Befugnisse:
			echo "<td>$bef</ul></td>";
		// Unterweisungen (Sicherheit):
			$txt = '<ul>';
			foreach ($secure as $schulung) {
				$tln = explode(';',$schulung[3]);
				if (in_array($nr,$tln)) {
					$txt .= '<li>'.date('d.m.y',$schulung[0]).': '.$schulung[1].'</li>';	// wirksamkeit?
				}
			}
			echo "<td>$txt</ul></td>\n";
		// Schulungen:
			$txt = '<ul>';
			foreach ($events as $schulung) {
				$tln = explode(';',$schulung[3]);
				if (in_array($nr,$tln)) {
					$txt .= '<li>'.date('d.m.y',$schulung[0]).': '.$schulung[1].'</li>';	// wirksamkeit?
				}
			}
			echo "<td>$txt</ul></td>\n";
		// Abwesenheit:
			$txt = '<ul>';
			$Time = time();
			$abs = $adb->query("SELECT * FROM Absence WHERE PersonID=$nr AND Ende>=$Time AND Status>0 AND Status<3 ORDER BY Beginn");
			while ($weg = $abs->fetchArray()) {
				$txt .= '<li>'.date('d.m.y',$weg['Beginn']).' - '.date('d.m.y',$weg['Ende']).':<br>'.$weg['Text'].'</li>';
			}
			echo "<td>$txt</ul></td>\n";
		// Rollen:
			$txt = '<ul>';
			foreach ($arrUsers as $key=>$val) {
				if (in_array($nr,$val)) {
					$txt .= "<li>$key</li>";
				}
			}
			echo "<td>$txt</ul></td>\n";
		// Sonstiges:
			echo "<td></td></tr>\n";
		}
	}
	echo "</table>\n";
	break;

// Aufgabenmatrix:
  case 'Matrix':
	$MaxLevel = 4;
	$Anzahl = 0;
	$tdDeleg = $DelegRule ? '<th>Delegiert<br><small>(Tätigkeit)</small></th>' : '';
	$Person[999999] = "mehrere";
	$table = Matrix(1);
	echo '<p>Insgesamt '.$Anzahl.' Tätigkeiten aufgeführt. <span class="coreproc">Kernprozesse sind farblich hervorgehoben.</span></p>';
	echo '<table><thead><tr class="kopf"><th style="width:400px; max-width:400px;">Tätigkeit</th><th>Prozess</th><th>Bezug</th><th>Aufgabenbereich</th><th>Prozesseigner</th><th>Zuständig<br><small>(Aufgabenbereich)</small></th>'.$tdDeleg."<th>Turnus/Dauer</th></tr></thead>\n";
	echo $table;
	echo "</table>\n";
	break;

// Befugnisse:
  case 'Befugnisse':
	$MaxLevel = 3;

	echo '<table class="blank">';
	Befugnis(2);

	echo '<tr><td colspan="2"><h3>Besondere Befugnisse für Aufgabenbereiche</h3></td></tr>';
//	$sql = "SELECT S.Person AS Person, O.Name AS Name FROM Skills AS S LEFT JOIN Orga AS O ON S.ProcID=O.ID WHERE S.ProcID>0 AND S.Level=6";	// GROUP BY S.Person ORDER BY O.Folge";
//	$res = $odb->query($sql);
//	$res = $odb->query('SELECT Skills.Person,Orga.Name FROM Skills,Orga WHERE Skills.ProcID>0 AND Skills.Level=6 AND Skills.ProcID=Orga.ID');
	$sql = 'SELECT Person,ProcID FROM Skills WHERE ProcID>0 AND Level=6';
	if ($StaffOnly)
		$sql .= " AND Person IN ($Staff)";
	$res = $odb->query($sql);
	$found = false;
	while ($rs = $res->fetchArray()) {
		$Name = $odb->querySingle('SELECT Name FROM Orga WHERE ID='.$rs[1]);
		echo '<tr><td>'. $Name .'</td><td>'.$Person[$rs[0]]."</td></tr>\n";
		$found = true;
	}
	if (!$found)
		echo '<tr><td colspan="2">Zurzeit nicht vorhanden</td></tr>';

	echo '<tr><td colspan="2"><h3>Besondere Befugnisse für spezielle Tätigkeiten</h3></td></tr>';
	$sql = 'SELECT S.Person AS Person, A.Name AS Name FROM Skills AS S LEFT JOIN Activities AS A ON S.ActID=A.ID WHERE S.ActID>0 AND S.Level=6';
	if ($StaffOnly)
		$sql .=" AND S.Person IN ($Staff)";	// GROUP BY S.Person ORDER BY A.Folge";
	$res = $odb->query($sql);
//	$res = $odb->query('SELECT Skills.Person,Activities.Name FROM Skills,Activities WHERE Skills.ActID>0 AND Skills.Level=6 AND Skills.ActID=Activities.ProcID');
//	$res = $odb->query('SELECT Person,ActID FROM Skills WHERE ActID>0 AND Level=6');
	$found = false;
	while ($rs = $res->fetchArray()) {
//		$Name = $odb->querySingle('SELECT Name FROM Activities WHERE ID='.$rs[1]);
		echo '<tr><td>'. $rs['Name'] .'</td><td>'.$Person[$rs[0]]."</td></tr>\n";
		$found = true;
	}
	if (!$found)
		echo '<tr><td colspan="2">Zurzeit nicht vorhanden</td></tr>';
	echo "</table>\n";
	break;

// Prozesslandschaft:
  default:
	echo '<link rel="stylesheet" media="all" href="'.$MyPlugin.$MyPageParam.".css\">\n";
	$MaxLevel = ($MyPageParam=='typ2' || $MyPageParam=='typ3') ? 3 : 4;
	$StartLevel = ($MyPageParam=='typ4' || $MyPageParam=='typ5') ? 1 : 0;
	echo '<ul class="tree OrgaLevel-'.$StartLevel.'">' . OrgaTable($StartLevel,$StartLevel) . "</ul>\n";
	$Changed = $odb->querySingle('SELECT MAX(Changed) FROM Orga');
	if ($Changed) {
		$Changer = $odb->querySingle("SELECT Changer FROM Orga WHERE Changed=$Changed");
		$strProcEdit = 'Letztmals geändert am '.date('d.m.Y',$Changed).' von '.$Person[$Changer];
	}
	echo "<p>$strProcEdit.</p>\n";

	echo '<div id="details"> Hier kommen dann Erläuterungen hin.</div>';
	echo '<form id="editproc" method="POST" action="?'.$mypage.'" class="overlay1"><fieldset id="procedit"></fieldset><label></label><input type="submit" name="wegmit" value="Speichern"><br><label></label><input type="button" onclick="closeme()" value="Fenster schließen"></form>';
}

if ($search!='') {
	$mypage .= "&search=$search";
}

echo "\n<style>\n:root {\n";
foreach($BGColor as $nr=>$color) {
	echo " --level-$nr: $color;\n";
}
foreach($FGColor as $nr=>$color) {
	echo " --color-$nr: $color;\n";
}
?>
 --line: black;
}

th, td		{border:1px solid black; padding:0px;}
.name		{padding:0 4px;}
td.name		{cursor:pointer;}
td.name:hover	{background-color:#ddd;}
table.blank td {border:none; border-bottom:2px solid #ddd; padding:0 10px 0 0;}

.small	{font-size:small;}
.coreproc	{background-color:#bdf;}
img.zeit	{height:17px; max-height:17px; cursor:pointer; border:0; padding:0px; margin:0px; margin-bottom:-4px;}

input[type="date"], button, textarea	{width:220px;}
select	{width:228px;}

p.help		{font-size:small;}
p.error		{padding:8px; border:2px solid red; color:red; background-color:#fee;}
p.success	{padding:8px; border:2px solid green; color:green; background-color:#efe;}
p.neutral	{padding:8px; border:2px solid blue; color:blue; background-color:#eef;}
p#History	{font-size:small;}

a.jahr	{border:1px solid #aaa; text-decoration:none; background-color:#ddd; display:inline-block; width:40px; text-align:center; border-radius:3px;}

.pointer:hover {background:#eee;}
.right	{text-align:right;}

/* ------------ für das Prozessorganigramm --------------*/
.tree	{float:left;}
.tree span:hover, .tree a:hover	{background-color:#ddd; color:black; cursor:pointer;}

.OrgaLevel-0 > li > span, .OrgaLevel-0 > li > a	{background:var(--level-0); color:var(--color-0);}
.OrgaLevel-1 > li > span, .OrgaLevel-1 > li > a	{background:var(--level-1); color:var(--color-1);}
.OrgaLevel-2 > li > span, .OrgaLevel-2 > li > a	{background:var(--level-2); color:var(--color-2);}
.OrgaLevel-3 > li > span, .OrgaLevel-3 > li > a	{background:var(--level-3); color:var(--color-3);}
.OrgaLevel-4 > li > span, .OrgaLevel-4 > li > a	{background:var(--level-4); color:var(--color-4);}

form#editproc	{position:fixed; z-index:1000; width:800px; min-height:500px; top:90px; right:400px; display:none; padding:4px; background:white;
				 border-radius:5px; box-shadow: 0 5px 15px rgba(0, 0, 0, 0.15);}
form#editproc table label {width:auto;}
div#details	{width:640px; border:1px solid #666; border-radius:5px; color:black; position:fixed; top:30px; right:20px; z-index:1000;
			 display:none; line-height:1em; box-shadow: 0 5px 15px rgba(0, 0, 0, 0.15); background:#eee;}
#details div.halb	{display:inline-block; width:49%; vertical-align:top; border:1px solid #058;}
#details h3	{background:#cdf; text-align:center; margin:0px; border-top:1px solid black; border-bottom:1px solid black; font-size:1em; font-weight:bold; color:black;}
#details h4	{background:#def; text-align:center; margin:0px; border-top:1px solid black; border-bottom:1px solid black; font-size:1em; font-weight:normal; color:black;}
#details p, #details ol	{margin:4px; font-size:.9em; font-weight:normal; line-height:1em;}

</style>
<script>
function newload(ma,v,wf,so) {
	window.location.href = '<?= $u.$mypage ?>&MA='+ma+'&NeuMA='+v+'&WFID='+wf+'&SO='+so;
}
function setQL(ql,ma,id) {
	window.location.href = '<?= $u.$mypage ?>&todo=setQL&ql='+ql+'&MA='+ma+'&id='+id;
}
function getDetails(id,level) {
	document.getElementById('editproc').style.display = 'none';
	Details = new XMLHttpRequest();
	var url = "plugins/Orga/Details.php?id="+id+"&uid=<?= ($_SESSION['UserID'] ?? 0) . '&ma=' . ($MayAdmin ? '1':'0') ?>";
//	url=url+"&sid="+Math.random();
	Details.addEventListener('load',function(event){
		if (Details.readyState == 4) {
			strResponse = Details.responseText;
			document.getElementById('details').innerHTML = strResponse;
			document.getElementById('details').style.display = 'inline-block';
		}
	});
	Details.open("GET",url);
	Details.send();
}
function editDetails(id,level,typ,item) {
	Details = new XMLHttpRequest();
//	item = item.trim();
	if (typ==0)
		var url = "plugins/Orga/procedit.php?id="+id+"&level="+level+"&item="+item;
	else
		var url = "plugins/Orga/actedit.php?PID="+id+"&level="+level+item;
//	alert (url);
	Details.addEventListener('load',function(event){
		if (Details.readyState == 4) {
			strResponse = Details.responseText;
			document.getElementById('procedit').innerHTML = strResponse;
			document.getElementById('editproc').style.display = 'inline-block';
			initEditor();
		}
	});
	Details.open("GET",url);
	Details.send();
}
function showact(wfid,id,aid) {
	Details = new XMLHttpRequest();
	var url = "plugins/Orga/wf_action.php?wfid="+wfid+"&id="+id+"&aid="+aid;
	Details.addEventListener('load',function(event){
		if (Details.readyState == 4) {
			strResponse = Details.responseText;
			document.getElementById('details').innerHTML = strResponse;
			document.getElementById('details').style.display = 'inline-block';
		}
	});
	Details.open("GET",url);
	Details.send();
}
function fillact(proc,name,actor,ql,per) {
	document.getElementById('Aufg').innerHTML = name;
	document.getElementById('Dauer').value = per;
	tt = document.getElementById('Proc');
	for (i=0; i<tt.length; i++) {
		if (tt.options[i].value == proc) {
			tt.selectedIndex = i;
		}
	}
	tt = document.getElementById('Actor');
	if (tt) {
		if (actor.includes('#')) {
			actors = actor.split('#');
			if (!tt.hasAttribute('multiple')) {
				tt.setAttribute('multiple','multiple');
				tt.name = 'Actor[]';
				document.getElementById('multi').innerHTML = '(umschalten > einzelne)<br><small>Mehrfachauswahl mit STRG + Klick!</small>';
			}
			for (i=0; i<tt.length; i++) {
				tt.options[i].selected = actors.includes(tt.options[i].value)
			}
		} else {
			if (tt.hasAttribute('multiple')) {
				tt.removeAttribute('multiple');
				tt.name = 'Actor';
				document.getElementById('multi').innerHTML = '(umschalten > mehrere)';
			}
			for (i=0; i<tt.length; i++) {
				if (tt.options[i].value == actor) {
					tt.selectedIndex = i;
				}
			}
		}
	}
	tt = document.getElementById('QLevel');
	if (tt) {
		for (i=0; i<tt.length; i++) {
			if (tt.options[i].value == ql) {
				tt.selectedIndex = i;
			}
		}
	}
}
function fillproc(id) {
	name = document.getElementById('Name'+id).innerHTML;
	document.getElementById('ProcName').value = name;
	par = document.getElementById('Par'+id).innerHTML;
	tt = document.getElementById('ProcSort');
	if (tt) {
		for (i=0; i<tt.length; i++) {
			if (tt.options[i].value == par) {
				tt.selectedIndex = i;
			}
		}
	}
}
function clearproc() {
	document.getElementById('ProcName').value = '';
	document.getElementById('ProcSort').selectedIndex = 0;
}
function closeme() {
	document.getElementById('editproc').style.display = 'none';
}
function closedet() {
	document.getElementById('details').style.display = 'none';
}
function multiple(f) {
	d = document.getElementById(f);
	m = document.getElementById('multi');
	if (d.hasAttribute('multiple')) {
		d.removeAttribute('multiple');
		d.name = f;
		m.innerHTML = '(umschalten > mehrere)';
	} else {
		d.setAttribute('multiple','multiple');
		d.name = f+'[]';
		m.innerHTML = '(umschalten > einzelne) <small>Mehrfachauswahl mit STRG + Klick!</small>';
	}
}
</script>