<?php
/* use this function at the start of your plugins edit.php:
function formkopf($titel, $legend='', $right=1)
If $legend is not specified, no fieldset is opened (and thus is not to be closed).
But of cause you may use fieldsets and legends of your own choice.
If $right is not true (1) the user may not edit this plugin.
*/
$Plugin = 'Orga';
$MyPlugin = $MyPlugins . "/$Plugin/";	// Dieser Plugin-Ordner

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = '../data/plugins/Orga/';

$odb = new SQLite3($MyPluginDataFolder.'DB.db');	// Plugin-Datenbank, gleich öffnen
include $MyPluginDataFolder.'config.php';			// Plugin-Konfigurationsdatei, gleich lesen: DelegRule, BGColor

// Dependencies:
$adb = new SQLite3('../data/plugins/Absence/DB.db');

function TabKopfSelect($Feld,$Label,$Value) {
	startSelect($Feld,$Label);
	echo txtOption (0,'keine Anzeige',$Value);
	echo txtOption (1,'Monat als Zahl',$Value);
	echo txtOption (2,'kurze Monatsnamen',$Value);
	echo txtOption (3,'lange Monatsnamen',$Value);
	echo "</select> <br>\n";
}

function OrgaTable($Parent=0, $Level=0) {
	global $odb;

	// Für die Sortierung benötigt:
	$clicksort="<span class=\"cursor\" onclick=\"oeffne('Plugin:Orga','$Parent&todo=sort&id=";
	$Anzahl  = $odb->querySingle("SELECT COUNT(ID) FROM Orga WHERE Parent=$Parent");

//	$PopUpNavi = false;
//	$popup = ($PopUpNavi) ? ' onclick="if (this.checked) this.checked=confirm(\'Sind Sie sicher? Sie können Einträge auch inaktiv stellen!\');"' : "";
	$popup = '';
	$td = '<td class="nowrap">'.substr('.............',0,$Level*2);

	// Jetzt die Organisationseinheiten:
	$sql = "SELECT ID,Name FROM Orga WHERE Parent=$Parent ORDER BY Folge";
	$res = $odb->query($sql);
	$count = 0;
	$table = '';
	while ($rs = $res->fetchArray()) {
		$count++;
		$ID = $rs['ID'];
		$zeile  = '<td><input type="radio" name="ProcID" onclick="fillproc('.$ID.')" id="Item'.$ID.'" value="'.$ID.'" title="Diesen Eintrag bearbeiten"></td>';
		$zeile .= '<td><input type="checkbox" title="Diesen Eintrag zum Löschen markieren" name="delProc[]" value="'.$ID.'"' . $popup . '"></td>';
		$zeile .= ClickToSort($clicksort,$Anzahl,$count,$ID) . $td . '<label style="width:200px" for="Item'.$ID.'" id="Name'.$ID.'">' . $rs['Name'].'</label>';
		$zeile .= '<div class="helper" id="Par'.$ID.'">'.$Parent."</div></td></tr>\n";

		// Rekursion: gibt es Unterorganisationen zu dieser Organisationseinheit?
		$snum = $ID;	// ID retten
		$text = OrgaTable($ID, $Level+1);
		// wegen hierarchischer Anzeige (Einrückung, Folder auf/zu): -> schließender Tag </tr> bereits in $zeile enthalten
		if ($text != "") {
			$table .= '<tr style="background:var(--level-'.$Level.'); color:var(--color-'.$Level.')">'.$zeile . "<tbody id=\"Sub$snum\">$text</tbody>";
		} else {
			$table .= '<tr style="background:var(--level-'.$Level.'); color:var(--color-'.$Level.')">'.$zeile;
		}
	}
	return $table;
}

function OrgaSelect($Parent=0, $Level=0) {
	global $odb,$MaxLevel,$OrgaBez;

	$table = '';
	$options = '';

	if ($Parent==0) {
		$options = '<optgroup label="Ist '.$OrgaBez[1].' in:">';
	}
	// Jetzt die zugeordneten Prozesse:
	$sql = "SELECT ID,Name FROM Orga WHERE Parent=$Parent ORDER BY Folge";
	$res = $odb->query($sql);
	while ($rs = $res->fetchArray()) {
		$ID = $rs['ID'];
		$options .= '<option value="'.$ID.'" style="background-color:var(--level-'.$Level.'); color:var(--color-'.$Level.')">'.$rs[1]."</option>\n";
		if ($Parent==0) $options .= "</optgroup>\n";
		// Rekursion: gibt es Unterprozesse zu diesem Prozess?
		$text = ($Level<3) ? OrgaSelect($ID, $Level+1) : '';
		// wegen hierarchischer Anzeige (Einrückung, Folder auf/zu):
		if ($text != '') {
			$table .= '<optgroup label="Ist in '.$OrgaBez[$Level].' \''.$rs[1].'\' '.$OrgaBez[$Level+2].' in:">'.$text."</optgroup>\n";
		}
	}

	if ($Level>0) {
		return $options.$table;
	} else {
		return $options.$table;	// war ohne options
	}
}

$todo = $_GET['todo'] ?? '';
if ($todo=="sort") {
	$ID = $_GET['id'];
	$to = $_GET['to'];
	$Pt = $_GET['page'];
//	echo "Parent=$Pt / ID=$ID / to=$to<br>\n";
	$Folge= $odb->querySingle("SELECT Folge FROM Orga WHERE ID=$ID");
	Sortiere($ID,$to,"Orga","Parent=$Pt",$Folge,$odb);
}

formkopf("Hier konfigurieren Sie das $Plugin-Plugin");
echo '<div class="configmenu"><span id="Config0">Organisationsstruktur</span><span id="Config1">Personen</span><span id="Config2">Qualifikation/Kompetenzen</span><span id="Config3">Delegation/Status</span><span id="Config4">Darstellung</span></div>';

// ----- Config 0 (Organisationsstruktur) ----------------------------------
echo '<div id="divConfig0" class="helper">'.
	"<fieldset><legend>Organisationsstruktur</legend>\n";
echo '<table><tr><th class="edit">!</th><th class="del">X</th><th colspan="2">Sort</th><th>Bezeichnung</th></tr>';
echo OrgaTable();
echo '<tr><td><input type="radio" name="ProcID" value="0" id="Item0" onclick="clearproc()"></td><td colspan="4"><label for="Item0">Neuer Eintrag</label></td></tr>';
echo "</table>\n</fieldset><fieldset><legend>Prozess bearbeiten</legend>\n";
echo txtInput('ProcName','Bezeichnung');
startSelect('ProcSort','Einordnung');
echo '<option>Bitte einsortieren:</option>';
$MaxLevel = 2;
echo OrgaSelect(0,0);
echo "</select> <br>\n";

// ----- Config 1 (Personen) ----------------------------------
echo '</div><div id="divConfig1" class="helper">'.
	"<fieldset><legend>MitarbeiterInnen</legend>\n";

include 'personroles.php';

// ----- Config 2 (Qualifikation/Kompetenzen) ----------------------------------
echo '</div><div id="divConfig2" class="helper">'.
	"<fieldset><legend>Qualifikation: generelle Erfassung</legend>\n";	//	<div class=\"halb\">
echo setSelCheck('QualiPersons','Soll die Qualifikation der MitarbeiterInnen erfasst werden?','MitarbeiterInnen',$QualiPersons);
echo setSelCheck('QualiProcs','Soll die benötigte Qualifikation für Prozesse/Aufgabenbereiche erfasst werden?','Aufgabenbereiche',$QualiProcs);
echo setSelCheck('QualiCheck','Soll bei der Aufgabenzuordnung die Qualifikation geprüft werden? (Geht nur, wenn beide vorigen Einstellungen aktiviert sind)','Prüfung',$QualiCheck);
echo setSelCheck('QualiActions','Darf die benötigte Qualifikation für einzelne Tätigkeiten vom Aufgabenbereich abweichen?','Tätigkeiten',$QualiActions);

echo "</fieldset><fieldset><legend>Qualifikations-Level</legend>\n";
foreach($QualLevel as $nr=>$Name) {
	echo txtInput("Level[$nr]","Level $nr",$Name);
}

echo "</fieldset><fieldset><legend>Berechtigungen</legend>\n";
startSelect('ProcOwnerMayEditAct','Prozesseigner');
echo txtOption(0,'darf keine',$ProcOwnerMayEditAct);
echo txtOption(1,'darf alle',$ProcOwnerMayEditAct);
echo "</select> Tätigkeiten in seinem Bereich bearbeiten<br>\n";
startSelect('ProcOwnerMayQualiAct','Prozesseigner');
echo txtOption(0,'darf keine',$ProcOwnerMayQualiAct);
echo txtOption(1,'darf alle außer eigene',$ProcOwnerMayQualiAct);
echo txtOption(2,'darf alle, auch eigene',$ProcOwnerMayQualiAct);
echo "</select> Qualifikationen bewerten (nur, falls Qualifikationen erfasst werden, s. o.)<br>\n";

echo "</fieldset><fieldset><legend>Anzeige in der Aufgabenzuordnung (falls die Qualifikation der MitarbeiterInnen überhaupt erfasst wird, s. o.)</legend>\n";
// echo '</div><div class="halb">';
startSelect('ShowQuali','Qualifikation');
echo txtOption(0,'keine Anzeige',$ShowQuali);
echo txtOption(1,'nur wenn angemeldet',$ShowQuali);
echo txtOption(2,'nur eigene',$ShowQuali);
echo txtOption(9,'immer',$ShowQuali);
echo "</select> <br>\n";
startSelect('ShowWhen','festgestellt am');
echo txtOption(0,'keine Anzeige',$ShowWhen);
echo txtOption(1,'nur wenn angemeldet',$ShowWhen);
echo txtOption(2,'nur eigene',$ShowWhen);
echo txtOption(9,'immer',$ShowWhen);
echo "</select> (nur, wenn die Qualifikation für den Benutzer auch angezeigt wird)<br>\n";
startSelect('ShowWho','festgestellt von');
echo txtOption(0,'keine Anzeige',$ShowWho);
echo txtOption(9,'immer',$ShowWho);
echo "</select>  (nur, wenn die Qualifikation für den Benutzer auch angezeigt wird)<br>Wer berechtigt ist, die Qualifikation festzustellen, bekommt jedoch immer alles angezeigt.\n";
// echo '</div>';

// ----- Config 3 (Delegation/Status) ----------------------------------
echo '</div><div id="divConfig3" class="helper">'.
	"<fieldset><legend>Delegationsregeln</legend>\n";
startSelect('DelegRule','Delegation');
echo txtOption (0,'keine Delegation',$DelegRule);
echo txtOption (1,'Jeder an jeden',$DelegRule);
echo "</select> <br>\n";
echo "</fieldset><fieldset><legend>Status</legend>\n";
foreach ($strWFStat as $ID=>$Name) {
	echo '<label for="strStat'.$ID.'">Status '.$ID.'</label><input type="text" name="strStat['.$ID.
	']" id="strStat'.$ID.'" value="'.$Name.'"> <input type="color" name="bgStat['.$ID.']" value="'.$bgWFStat[$ID].'"><br>';
}

// ----- Config 4 (Darstellung) ----------------------------------
echo '</div><div id="divConfig4" class="helper">'.
	"<fieldset><legend>Farbgebung und Bezeichnungen</legend>\n";
for ($i=0; $i<5; $i++) {
	echo '<label for="Color'.$i.'">Farbe Level '.$i.'</label><input type="color" id="Color'.$i.'" name="BGColor['.$i.']" value="'.$BGColor[$i].'"> / Schrift: <input type="color" name="FGColor['.$i.']" value="'.$FGColor[$i].'"> / Benennung: <input type="text" name="OrgaBez['.$i.']" value="'.$OrgaBez[$i].'"><br>';
}
echo "</fieldset></div>\n" . formsave('Plugin',$Plugin);
?>
