<?php
/**
 * Open Majesty DBTables and send emails to selected customers.
 *
 * @name      WIBcms Plugin News / page.php
 * @version   0.9
 * @license   GPL v3 (see enclosed license.txt or <http://www.gnu.org/licenses/>)
 * @copyright DO NOT remove @author or @license or @copyright.
 *            This program is free software: you can redistribute it and/or modify
 *            it under the terms of the GNU General Public License as published by
 *            the Free Software Foundation, either version 3 of the License,
 *            or (at your option) any later version.
 *
 *            This program is distributed in the hope that it will be useful,
 *            but WITHOUT ANY WARRANTY; without even the implied warranty of
 *            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *            GNU General Public License for more details.
 *
 *            You should have received a copy of the GNU General Public License
 *            along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @authors   nageniil - coded in notepad++
 */

function Gruss($Anrede,$Gender,$Name) {
	if ($Anrede==0) {
		$Gruss = '<p>Sehr geehrte';
		switch ($Gender) {
			case 0:
			case 1; $Gruss .= ' Damen und Herren'; break;
			case 2: $Gruss .= 'r Herr '.$Name; break;
			case 3: $Gruss .= ' Frau '.$Name; break;
			case 4: $Gruss .= 's Fräulein '.$Name; break;
		}
	} elseif($Anrede==1) {
		$Gruss = '<p>Guten Tag, ';
		switch ($Gender) {
			case 0:
			case 1; $Gruss .= 'sehr geehrte Damen und Herren'; break;
			case 2: $Gruss .= 'Herr '.$Name; break;
			case 3: $Gruss .= 'Frau '.$Name; break;
			case 4: $Gruss .= 'Fräulein '.$Name; break;
		}
	}
	$Gruss .= ",</p>";
	return $Gruss;
}

function Adresse($Name,$Mail) {
	if (empty($Name)) {
		$Adresse = $Mail;
	} else {
		$Adresse = $Name . " <$Mail>";
	}
	return $Adresse;
}

function verschicke($Vorname,$Nachname,$Gender,$Mail) {
	global $UseVN,$Anrede, $Subject,$Message,$Signatur,$Step,$Test,$doTest;

	$Name = (($UseVN) ? $Vorname.' ' : '') . $Nachname;
	$nachricht = Gruss($Anrede,$Gender,$Name) . $Message;
	if ($Step==6 && $Test) {
		// Nur Simulation:
		echo '<span style="background:#ee3">Simulation der E-Mail an '.$Mail.":</span><br>\n";
		echo $nachricht . nl2br($Signatur) . "<hr>\n";
	} elseif ($doMail) {	// ACHTUNG: GENERELLE FREIGABE - ECHTER BETRIEB!!!!!
		if (htmmail($Subject,$nachricht,$Mail)) {
		//	global $MailTo,$Sender,$Signatur;
			echo '<p class="success">Mail an '.$Mail.' wurde verschickt.</p>';
		} else {
			echo '<p class="error">Es gab Fehler beim Versand der Mail an '.$Mail.'</p>';
		}
	}
}

// ----------------------------------------------------------------------
$Plugin = 'News';
$MyPlugin = $MyPlugins . "/$Plugin/";	// Dieser Plugin-Ordner

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = "data/plugins/$Plugin/";

// Get the data and configuration:
$NL  = new SQLite3($MyPluginDataFolder.'DB.db'); // Plugin-Datenbank, gleich öffnen
include $MyPluginDataFolder.'config.php';		 // Plugin-Konfigurationsdatei

// ---------- Dependencies: ---------
include "data/includes/dbf_class.php";	// wegen Timer generell...
$dir = "./DBFS/";	// Pfad zu den DBF-Dateien
$showDelRecs=false;
$printmemo = false;

// User rights:
$NLAdmins = $db->querySingle("SELECT Users FROM Roles WHERE Role='News'");
$NLAdminArray = explode (',',$NLAdmins);
$MayAdmin = $WebStat && ($WebStat&1 || in_array($_SESSION['UserID'],$NLAdminArray));

if (!$MayAdmin) {
	// Nicht angemeldet oder nicht berechtigt:
	echo '<p class="neutral">Um Mailaktionen zu verwalten, müssen Sie angemeldet und dazu berechtigt sein. Hier die bisherigen Mailaktionen:</p>';
	$res = $NL->query('SELECT * FROM NL WHERE Datum NOT NULL');
	while ($rec = $res->fetchArray()) {
		$Anz = empty($rec['Verteiler']) ? 0 : substr_count($rec['Verteiler'], ',');
		$sent = ($rec['Datum']<0) ? 'Nur simuliert' : 'Verschickt';
		echo '<h4>Newsletter vom '.date('d.m.Y',abs($rec['Datum']))." (<small>$sent an $Anz Empfänger.</small>)</h4>\n";
		echo '<h5>'.$rec['Subject']."</h5>\n";
		echo $rec['Message'];
	}
} elseif($MyPageParam=='Adressen') {
	include 'mailinglist.php';
} else {
	// OK, los geht's:
	$Step = $_POST['NLStep'] ?? 1;
	$NLID = $_POST['NLID'] ?? 0;
	$todo = $_POST['NLtodo'] ?? '0';
	$Muster=$_POST['NLMuster'] ?? 0;
	$VListe=$_POST['VListe'] ?? 0;

// ---------- Test/Debug: ----------
	if ($debug) {
		foreach($_POST as $key=>$val) {
			if (is_array($val)) {
				foreach($val as $akey=>$aval) {
					if (is_array($aval)) {
						foreach($aval as $bkey=>$bval) {
							echo $key.'['.$akey .']['. $bkey ."] => " . $bval . "<br>\n";
						}
					} else {
						echo $key.'['.$akey . "] => " . $aval . "<br>\n";
					}
				}
			} else {
				echo $key . " => " . $val . "<br>\n";
			}
		}
	}

	if (($todo=='weiter') && ($Step<7)) {$Step += 1;}
	if (($todo=='zurück') && ($Step>1)) {$Step -= 1;}

	// Gibt es angefangene Newsletter?
	if ($Step==1) {
		$OK = $NL->querySingle("SELECT ID FROM NL WHERE Datum IS NULL");
		if ($OK) {
			$todo = 0;
			$NLID = $OK;
			$Step = 2;
			echo '<p class="neutral">Es gibt angefangene Newsletter:</p>';
		}
	}

	echo '<form id="Newsletter" method="POST">';
	switch ($Step) {
		case 1:
			echo "<h3>Schritt 1: Muster wählen</h3>\n";
			$res = $NL->query("SELECT ID,Datum,Subject FROM NL");
			echo '<select name="NLMuster"><option value="0">Ohne Vorlage neu erstellen</option>';
			while ($rec = $res->fetchArray()) {
				echo '<option value="'.$rec[0].'">'.date('d.m.Y',abs($rec[1])).': '.$rec[2]."</option>\n";
			}
			echo "</select><br>\n";
			echo "<p>Wenn Sie ein Muster auswählen, werden Betreffzeile, Inhalt und der Verteiler als Vorlage für die nächste Mail-Aktion übernommen.</p>\n";
			break;
		case 2:
			echo "<h3>Schritt 2: Newsletter bearbeiten</h3>\n";
			if ($Muster==0 && $NLID==0) {
				$Subject = "";
				$Message = "";
				$Verteiler="";
			} else {
				if ($NLID!=0) {
					$ID = $NLID;
				} else {
					$ID = $Muster;
				}
				$res = $NL->querySingle("SELECT Subject,Message,Liste,Verteiler FROM NL WHERE ID=$ID",1);
				$Subject = $res['Subject'];
				$Message = $res['Message'];
				$Verteiler=$res['Verteiler'];
				$VListe  = $res['Liste'];
			}
			echo '<label for="Subject">Betreffzeile</label><input type="text" id="Subject" name="Subject" value="'.$Subject.'"><br>';
			echo '<small>Die Grußformel/Anrede wird automatisch eingefügt, deshalb beginnt der folgende Text nach einem Komma, also in der Regel mit einem Kleinbuchstaben.</small><br>';
			echo '<label for="Message">Nachricht</label><textarea id="Message" name="Message" class="tinyMCE">'.$Message."</textarea><br>\n";
			echo '<input type="hidden" name="NLMuster" value="'.$Muster.'"><input type="hidden" name="Verteiler" value="'.$Verteiler.'">';
			echo insertTinyMCE();
			echo '<script>initEditor();</script>'."\n";
			$HasEditor = true;
			break;
		case 3:
			// Zuerst den letzten Schritt speichern:
			if ($todo=='weiter') {
				$Subject = $NL->escapeString($_POST['Subject']);
				$Message = $NL->escapeString($_POST['Message']);
				if ($NLID==0) {
					$Verteiler = $_POST['Verteiler'];
					$sql = "INSERT INTO NL (Subject,Message,Liste,Verteiler) VALUES ('$Subject','$Message',$VListe,'$Verteiler')";
					$OK = $NL->exec($sql);
					if ($OK)
						$NLID = $NL->lastInsertRowID();
				} else {
					$sql = "UPDATE NL SET Subject='$Subject', Message='$Message' WHERE ID=$NLID";
					$OK = $NL->exec($sql);
				}
			}
			echo "<h3>Schritt 3: Test-Mail verschicken</h3>\n";
			echo "<p>Nach Klick auf &quot;weiter&quot; wird eine Testmail verschickt, damit Sie das Erscheinungsbild kontrollieren können.</p>\n";
			echo "<p>Im Menüpunkt &quot;Einstellungen&quot; können Sie die erforderlichen Angaben zum Testmail-Empfänger konfigurieren.</p>\n";
			echo '<p><input type="checkbox" name="NoTest"> Versand der Test-Mail überspringen, z. B. weil bereits kontrolliert</p>';
			break;
		case 4:
			echo "<h3>Schritt 4: Erscheinungsbild kontrollieren</h3>\n";
			$NoTest = isset($_POST['NoTest']);
			if ($todo=='weiter' && !$NoTest) {
				// send testmail to configured testuser:
				$OK = $NL->querySingle("SELECT Subject,Message,Liste FROM NL WHERE ID=$NLID",1);
				$Subject = $OK['Subject'].' (Testmail)';
				$Message = $OK['Message'];
				$VListe  = $OK['Liste'];

			//	$ClearText = preg_replace( "/\n\s+/", "\n", rtrim(html_entity_decode(strip_tags($Message))) );

				$timer = new timerClass();
				$timer ->start();

				$OK = $NL->querySingle("SELECT * FROM Config WHERE ID=1",1);
				$Vorname = $OK['Vorname'];
				$Nachname= $OK['Nachname'];
				$Mail	 = $OK['Mail'];
				$Gender  = $OK['Gender'];
				$Anrede  = $OK['Anrede'];
				$UseVN	 = $OK['UseVN'];
				$Name = (($UseVN) ? $Vorname.' ' : '') . $Nachname;
				$nachricht = Gruss($Anrede,$Gender,$Name) . $Message;

				$Signatur = $OK['Signatur'];	// $Signatur ist vorgegeben
				$Sender	 = Adresse($OK['SendName'], $OK['SendMail']);
				$ReplyTo = Adresse($OK['ReplyName'],$OK['ReplyMail']);
				$ReturnTo= $ReplyTo;

				if (htmmail($Subject,$nachricht,$Mail)) {
				//	global $MailTo,$Sender,$Signatur;
					echo '<p class="success">Testmail wurde verschickt, bitte anschauen und ggf. korrigieren</p>';
				} else {
					echo '<p class="error">Es gab Fehler beim Versand der Testmail...</p>';
				}
				$endexct = $timer->end();
				echo "<p>(Benötigte Zeit für 1 Mail: $endexct)</p>\n";
			}
			echo "<p>Wenn Sie mit dem Aussehen zufrieden sind, können Sie in den nächsten Schritten den Mail-Verteiler festlegen.<br>";
			echo "Wenn nicht, gehen Sie zurück und bearbeiten die Mail noch einmal.</p>\n";
			echo"<p>Welches Adressbuch möchten Sie verwenden?</p>\n";
			startSelect("VListe","Verteilerliste");
			$AdrBooks = $NL->query('SELECT ID,Name FROM AdrBooks');
			while ($rec = $AdrBooks->fetchArray()) {
				echo txtOption($rec[0],$rec[1],$VListe);
			}
	//		echo txtOption(0,"die momentan in Majesty gespeicherten Kunden-Ansprechpartner",$VListe);	// ist oben bereits erledigt...
			echo txtOption(91,"das im Intranet gespeicherte Adressbuch",$VListe);
			echo txtOption(92,"ein manuell eingegebener Mail-Kontakt (geht aber noch nicht...)",$VListe);
			echo txtOption(99,"den in der letzten Mailaktion verwendete Verteiler",$VListe);
			echo "</select><br><br>\n";
			break;
		case 5:
			// Zuerst den letzten Schritt speichern:
			if ($todo=='weiter') {
				$OldVListe = $NL->querySingle("SELECT Liste FROM NL WHERE ID=$NLID");
				if ($OldVListe!=$VListe) {
					if ($VListe<92) {
						$sql = "UPDATE NL SET Liste=$VListe, Verteiler=NULL WHERE ID=$NLID";
						$OK = $NL->exec($sql);
					} elseif($VListe==99) {
						$OK  = $NL->querySingle('SELECT MAX(Datum) FROM NL');
						$sql = "SELECT Liste,Verteiler FROM NL WHERE Datum=$OK";
						$OK  = $NL->querySingle($sql,1);
						$VListe = $OK['Liste'];
						$VItems = $OK['Verteiler'];
						$sql = "UPDATE NL SET Liste=$VListe, Verteiler='$VItems' WHERE ID=$NLID";
						$OK = $NL->exec($sql);
					}
				}
			}

			// bestehender Empfänger-Verteiler:
			if ($NLID!=0) {
				$ID = $NLID;
			} else {
				$ID = $Muster;
			}
			$OK = $NL->querySingle("SELECT Verteiler FROM NL WHERE (Liste=$VListe AND ID=$ID)");
			if ($OK) {
				$Verteiler = explode(',',$OK);
			} else {
				$Verteiler = array();
			}
			$AnzPos = 0;

			// Verarbeitungsart feststellen:
			$OK = $NL->querySingle("SELECT Name,Typ,URL,User,Pass FROM AdrBooks WHERE ID=$VListe",1);
			$VName= $OK['Name'];
			$VTyp = $OK['Typ'];
			$VURL = $OK['URL'];
			$User = $OK['User'];
			$Pass = $OK['Pass'];

			echo "<h3>Schritt 5: Verteiler festlegen (Empfänger aus dem Adressbuch &quot;$VName&quot; auswählen)</h3>\n";
			echo '<script>function allcheck(val) {ar = document.getElementsByName("send[]"); ar.forEach(function(s,i,o){o[i].checked=val});}</script>';

			// Kopfzeile
			echo "<table>";
			echo '<tr class="kopf"><td><input type="checkbox" name="alle" onclick="allcheck(this.checked)"></td>';
			echo "<td>Firma</td><td>Name</td><td>E-Mail</td><td>VIP</td></tr>\n";

			if ($VTyp==0) {
			// Using Majesty ERP System (live):
				$files = explode('#',$VURL);
				$dbf = new dbf_class($dir,$files[1]);
				$numrec = $dbf->dbf_num_rec;
				for($i=0; $i<$numrec; $i++){
					if ($row = $dbf->getRow($i,$showDelRecs,$printmemo)) {
						$Firma[$row[2]] = out($row[4]) . " " . out($row[5]) . " (" . out($row[11]) . ")";
					}
				}
			// Jetzt Ansprechpartner auflisten:
				$dbf = new dbf_class($dir,$files[0]);
				$numrec = $dbf->dbf_num_rec;
				$field_num=$dbf->dbf_num_field;
			// Datenzeilen
				for($i=0; $i<$numrec; $i++){
					if ($row = $dbf->getRow($i,$showDelRecs,$printmemo)) {
						if ($row[10]) {
							echo '<tr><td><input type="checkbox" name="send[]" value="'.$AnzPos.'"'.(in_array($AnzPos,$Verteiler)?' checked':'').'></td>';
							echo '<td>'.$Firma[$row[0]].'</td>';
							echo '<td>'.out($row[3]).' '.out($row[2]).'</td>';
							echo '<td>'.out($row[10]).'</td>';
							echo '<td><input type="checkbox"' . (($row[32]=='T')?' checked':'') . "></td></tr>\n";
							$AnzPos++;
						}
					}
				}
			} elseif ($VTyp==1) {
				// Using Synology Addressbook (live / old, DSM<7)
			} elseif ($VTyp==2) {
				// Using Synology Contacts (live / new, DSM>=7)
				// include Contact Manager... mailinglist.php
			} elseif ($VListe==91) {
				$sql = "SELECT ID,Firma,Vorname,Nachname,Mail FROM Liste WHERE (aktiv=1 AND valid=1)";
				$res = $NL->query($sql);
				while ($row = $res->fetchArray()) {
					$AnzPos++;
					echo '<tr><td><input type="checkbox" name="send[]" value="'.$row[0].'"'.(in_array($row[0],$Verteiler)?' checked':'').'></td>';
					echo '<td>'.$row[1].'</td>';
					echo '<td>'.$row[2].' '.$row[3].'</td>';
					echo '<td>'.$row[4]."</td><td> </td></tr>\n";
				}
			}

			echo "</table>\n";
			echo $AnzPos . " Adressen gefunden!<br>";
			$Test = $NL->querySingle("SELECT Test FROM Config WHERE ID=1");
			echo '<p class="neutral">Im nächsten Schritt erfolgt ';
			switch ($Test) {
				case 0: echo 'der echte Versand an die ausgewählten Empfänger!'; break;
				case 1: echo 'ein Testdurchlauf (Simulation), der Newsletter wird noch nicht wirklich verschickt.'; break;
				case 2: echo 'nur eine Simulation. In der Konfiguration ist der Versand generell geblockt.'; break;
				default:echo 'irgendwas, keine Ahnung, ist nicht konfiguriert...!?';
			}
			echo "</p>\n";
			break;
		case 6:
			// Zuerst den letzten Schritt speichern (Verteiler):
			if ($todo=='weiter') {
				$Verteiler = $_POST['send'];
				$sql = "UPDATE NL SET Liste=$VListe, Verteiler='" . implode(',',$Verteiler) . "' WHERE ID=$NLID";
				$OK = $NL->exec($sql);
			}	// kein break...
		case 7:
			// bestehender Verteiler:
			$OK = $NL->querySingle("SELECT Subject,Message,Liste,Verteiler FROM NL WHERE ID=$NLID",1);
			if ($OK) {
				$Subject = $OK['Subject'];
				$Message = $OK['Message'];
				$VListe  = $OK['Liste'];
				$MailList= $OK['Verteiler'];
				$Verteiler=explode(',',$MailList);
			} else {
				$MailList  = '';
				$Verteiler = array();
			}
			$AnzPos = 0;
			$AnzMail= 0;
			if ($MailList=='') {
				echo '<p class="error">WARNUNG: Es sind keine Mail-Empfänger angegeben!</p>';
			} else {
				
			}
			// konfigurierte Vorgaben:
			$OK = $NL->querySingle("SELECT * FROM Config WHERE ID=1",1);
			$Anrede  = $OK['Anrede'];
			$UseVN	 = $OK['UseVN'];
			$Signatur= $OK['Signatur'];	// Bezeichnung '$Signatur' ist vorgegeben
			$HTML	 = $OK['HTML'];
			$Test	 = $OK['Test'];
			$doMail  = !($Test==2);
			$Sender	 = Adresse($OK['SendName'], $OK['SendMail']);
			$ReplyTo = Adresse($OK['ReplyName'],$OK['ReplyMail']);
			$ReturnTo= $ReplyTo;

			$timer = new timerClass();
			$timer ->start();

			// Verarbeitungsart feststellen:
			$OK = $NL->querySingle("SELECT Name,Typ,URL,User,Pass FROM AdrBooks WHERE ID=$VListe",1);
			$VName= $OK['Name'];
			$VTyp = $OK['Typ'];
			$VURL = $OK['URL'];
			$User = $OK['User'];
			$Pass = $OK['Pass'];

			if ($VTyp==0) {
			// Using Majesty ERP System (live):
				$files = explode('#',$VURL);
				$dbf = new dbf_class($dir,$files[0]);
				$numrec = $dbf->dbf_num_rec;
				for($i=0; $i<$numrec; $i++){
					if ($row = $dbf->getRow($i,$showDelRecs,$printmemo)) {
						if ($row[10]) {	// damit AnzPos genauso gezählt wird wie bei der Auswahl!
							if (in_array($AnzPos,$Verteiler)) {
								$AnzMail++;
								$Vorname = out($row[3]);
								$Nachname= out($row[2]);
								$Gender  = $row[5];
								$Mail	 = out($row[10]);
								$Name = (($UseVN) ? $Vorname.' ' : '') . $Nachname;
								$nachricht = Gruss($Anrede,$Gender,$Name) . $Message;
								if ($Step==6 && $Test) {
									// Nur Simulation:
									echo '<span style="background:#ee3">Simulation der E-Mail an '.$Mail.":</span><br>\n";
									echo $nachricht . nl2br($Signatur) . "<hr>\n";
								} elseif ($doMail) {	// Wirklich verschicken?
									if (htmmail($Subject,$nachricht,$Mail)) {
									//	global $MailTo,$Sender,$Signatur;
										echo '<p class="success">Mail an '.$Mail." wurde verschickt.</p>\n";
									} else {
										echo '<p class="error">Es gab Fehler beim Versand der Mail an '.$Mail."</p>\n";
									}
								}
							}
							$AnzPos++;
						}
					}
				}	
			} elseif ($VTyp==1) {
				// Using Synology Addressbook (live / old, DSM<7)
			} elseif ($VTyp==2) {
				// Using Synology Contacts (live / new, DSM>=7)
				// include Contact Manager... mailinglist.php
			} elseif ($VListe==91) {
				$sql = "SELECT ID,Vorname,Nachname,Gender,Mail FROM Liste WHERE ID IN ($MailList)";
				$res = $NL->query($sql);
				while ($row = $res->fetchArray()) {
					$AnzMail++;
					$Vorname = $row[1];
					$Nachname= $row[2];
					$Gender  = $row[3];
					$Mail	 = $row[4];
					$Name = (($UseVN) ? $Vorname.' ' : '') . $Nachname;
					$nachricht = Gruss($Anrede,$Gender,$Name) . $Message;
					if ($Step==6 && $Test) {
						// Nur Simulation:
						echo '<span style="background:#ee3">Simulation der E-Mail an '.$Mail.":</span><br>\n";
						echo $nachricht . nl2br($Signatur) . "<hr>\n";
					} elseif ($doMail) {	// Wirklich verschicken?
						if (htmmail($Subject,$nachricht,$Mail)) {
						//	global $MailTo,$Sender,$Signatur;
							echo '<p class="success">Mail an '.$Mail." wurde verschickt.</p>\n";
						} else {
							echo '<p class="error">Es gab Fehler beim Versand der Mail an '.$Mail."</p>\n";
						}
					}
				}
			} else {
				echo '<p class="error">Keine gültige Verteilerliste angegeben</p>';
			}

			$endexct = $timer->end();
			if ($Step==6 && $Test) {
				echo "<p>$AnzMail Mails simuliert in $endexct</p>\n";
				echo "<p>Bitte beachten Sie, dass der echte Mail-Versand wesentlich länger dauern kann!</p>\n";
				if ($doMail) {
					echo '<p class="neutral">Achtung: Im nächsten Schritt wird der Newsletter tatsächlich verschickt!</p>';
				} else {
					echo '<p class="neutral">In der Konfiguration ist eingestellt dass der Newsletter NIE verschickt, sondern NUR simuliert wird.<br>
					Wenn Sie jetzt trotzdem auf &quot;weiter&quot; klicken, wird der Newsletter zwar nicht verschickt, aber trotzdem als &quot;erledigt&quot; abgeschlossen.</p>';
				}
			} else {
				echo "<p>$AnzMail Mails verschickt in $endexct</p>\n";
				$sign = $doMail ? '' : '-';
				$OK = $NL->exec("UPDATE NL SET Datum='$sign".time()."' WHERE ID=$NLID");
				echo '<p class="success">Die E-Mail-Aktion ist hiermit erledigt.</p>';
				$Step = 0;
			}
			break;
		default:
			echo "<h3>FEHLER (Das kann in der Testphase schon mal vorkommen, bitte den Admin verständigen und kräftig schimpfen)</h3>\n";
	}
	echo '<input type="hidden" name="VListe" value="'.$VListe.'">
	<input type="hidden" name="NLStep" value="'.$Step.'"><input type="hidden" name="NLID" value="'.$NLID.'">';
	if ($Step)
		echo '<input type="submit" name="NLtodo" value="zurück"> <input type="submit" name="NLtodo" value="weiter"><br>';
	echo "</form>\n";
}
?>
