<script>
function editcard(adrbook,file) {
	var url = 'plugins/News/editcard.php';
	var myCard = new XMLHttpRequest();
	var data = new FormData();
	data.append('adrbook', adrbook);
	data.append('vcard', file);
	myCard.addEventListener('load',function(event){
		if (myCard.readyState == 4) {
			strResponse = myCard.responseText;
			document.getElementById('cardeditor').innerHTML = strResponse;
//			document.getElementById('cardeditor').style.display = 'inline-block';
			document.getElementById('cardeditor').style.visibility = 'visible';
			window.scroll(0,0);
		}
	});
	myCard.open("POST",url);
	myCard.send(data);
}
function closecard() {
//	document.getElementById('cardeditor').style.display = 'none';
	document.getElementById('cardeditor').style.visibility = 'hidden';
}
function switchnames() {
	vn = document.getElementById('N1');
	nn = document.getElementById('N0');
	vnam = vn.value;
	vn.value = nn.value;
	nn.value = vnam;
}
function opendet(nr) {
//	alert(lastnr+' -> '+nr);
	elm = document.getElementById('detail'+lastnr);
	if (elm) {
		elm.style.display = 'none';
	}
	document.getElementById('detail'+nr).style.display = 'inline-block';
	lastnr = nr;
}

lastnr = -1;
</script>
<style>
div.halb	{display:inline-block; width:48%; vertical-align:top;}
.pointer	{cursor:pointer;}
.pointer:hover	{background:#ddd;}
img.vcf-preview	{max-height:150px;}

/* z-index:1003; position:absolute; display:none;
#cardeditor	{background:#f9f9f9; color:#003;
			 border:1px solid #333; border-radius:6px; box-shadow: 0px 0px 9px #666;
			 font-size:10pt; width:990px; min-height:480px; padding-bottom:4px; visibility:hidden;}
*/
</style>
<div id="cardeditor"></div><br>
<?php
/**
 * @purpose   Managing mailing lists and addressbooks for AK-Produktionstechnik.
 *
 * @name      mailinglist.php
 * @version   0.2 rc
 * @license   GPL v3 (see enclosed license.txt or <http://www.gnu.org/licenses/>)
 * @copyright DO NOT remove @author or @license or @copyright.
 *            This program is free software: you can redistribute it and/or modify
 *            it under the terms of the GNU General Public License as published by
 *            the Free Software Foundation, either version 3 of the License,
 *            or (at your option) any later version.
 *
 *            This program is distributed in the hope that it will be useful,
 *            but WITHOUT ANY WARRANTY; without even the implied warranty of
 *            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *            GNU General Public License for more details.
 *
 *            You should have received a copy of the GNU General Public License
 *            along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @authors   nageniil - coded in notepad++
 *
 * available lists:
 * 1: live Majesty "KUNDANSP.DBF"
 * 2: normalized excel sheet
 * 3: manually added entries
 *
	TODO:
	Datumsformate (Eingabe, dort auch Anzeige)
	Doppelpunkt-Problem gelöst? (z.B. http:// oder in den NOTEs)
	Liste der Kategorien und select-Multi-Auswahl
	Timezone?
	Foto-Upload
	KEY-Handhabung etc.
	Link auf URL / mailto
	Sortierung / Suche
	Majesty Löschen / Speichern / Neu!
	Einträge auf vCard löschen
 */

function CreateEmptyCard() {	// nicht benötigt, nur zur Übersicht drin gelassen...
	$arr = [
		'BEGIN'=>'VCARD',
		'VERSION'=>'3.0',	//	Subject to change one day...
		'PRODID'=>'-//WIBcms//NONSGML Version1.0//DE',
		'UID'=>guidv4(),
		'CATEGORIES'=>'',
		'ADR'=>'',			// ADR; TYPE=WORK | TYPE=HOME ... 
		'EMAIL'=>'',		// ;TYPE=PREF;TYPE=HOME
		'TEL'=>'',			// ;TYPE=WORK:07545-93284-82
		'FN'=>'',			// full name = Anzeigename "Vorname Nachname"
		'N'=>'',			// Name "Nachname;Vorname;zus. Vornamen;Präfix (Titel);Suffix (Zusatz)"
		'NICKNAME'=>'',		// Spitzname
		'BDAY'=>'',
		'TZ'=>'',
		'ORG'=>'',
		'TITLE'=>'',
		'ROLE'=>'',
		'REV'=>'',			// :20210417T091522Z gmdate("Y-m-d\TH:i:s\Z");
		'PHOTO'=>'',		// base64 etc.
		'LOGO'=>'',			// base64 etc.
		'SOUND'=>'',		//
		'KEY'=>'',			//
		'NOTE'=>'',
		'END'=>'VCARD'];
	// X-THUNDERBIRD-ETAGS etc. weglassen!
	// LABEL / SORT-STRING
	return $arr;
}

function imgtob64($file) {
	if (is_file($file)) {
		$pnt = strrpos($file,'.');
		$ext = substr($file,$pnt+1);
		$bin = file_get_contents($file);
		$b64 = base64_encode($bin);
//		$src = "data:image/$ext;base64,$b64";
		return $b64;
	} else {
		return false;
	}
}
function createpicture($Typ,$image) {
	// Bildgröße skalieren

	$txt = "$Typ;TYPE=JPEG;ENCODING=b:\n " . wordwrap(imgtob64($image), 72, "\n ", true) . "\n";
// V4.0		$txt.= "$Typ:data:image/jpeg;base64,\n " . wordwrap(imgtob64($image), 72, "\n ", true) . "\n";
	unlink($image);
	return $txt;
}

$vcf=array();
$dat=array();
$eml=array();
$Fnm=array();
$Vnm=array();
$Nnm=array();
$org=array();
$cat=array();
$not=array();
$idx=array();
$Kat=array();

// reads folder with vcf-files and puts contents into arrays, returns the number of files (=addresses)
function cardlist($AdrBook) {
	global $vcf,$dat,$eml,$Fnm,$Vnm,$Nnm,$org,$cat,$not, $idx,$Kat,$clf;

	$strBook= sprintf('collection_%03d',$AdrBook);
	$clf    = "data/includes/$strBook/";
	$clf    = "data/plugins/News/$strBook/";
	if (!file_exists($clf))
		mkdir($clf);

	$excludes = array(".","..","@eaDir","Thumbs.db");
	$cardlist = array_diff(scandir($clf),$excludes);
	$nr = 0;
	foreach ($cardlist as $vcfile) {
		$str = trim(file_get_contents($clf.$vcfile));
		$del = chr(10);	// \r \n: nein nur am Ende
		$lines= explode($del,$str);
		$mail = '';
		$FN   = '';
		$VN   = '';
		$NN   = '';
		$ORG  = '';
		$CAT  = '';
		$date = 0;
		$hasNote=0;
		$hasLabel=0;
		$hasSort=0;
		foreach($lines as $line) {
			$entry = explode (':',$line);
//			echo trim($line) . "|<br>\n";
//			echo $entry[0] . " => " . $entry[1] . "<br>";
//			print_r($entry);
//			if ($entry[1] != 'VCARD') {
				if ($entry[0] == 'FN') { $FN = $entry[1]; }
				if (stripos($entry[0],'EMAIL')!==false) {
					if ($mail=='' or stripos($entry[0],'PREF'))
						$mail = strtolower($entry[1]);
				}
				if ($entry[0] == 'N') {
					$names= explode(';',$entry[1]);
					$VN = $names[1];
					$NN = $names[0];
				}
				if ($entry[0] == 'ORG') { $ORG = $entry[1]; }
				if ($entry[0] == 'CATEGORIES') {
					$CAT = trim($entry[1]);
					$K = explode(',',$CAT);
					$Kat = array_merge($Kat, $K);
					$Kat = array_unique($Kat);
				}
				if ($entry[0] == 'NOTE') { $hasNote=1; }
				if (stripos($entry[0],'LABEL')!==false) { $hasLabel=1; }
				if ($entry[0] == 'SORT-STRING') { $hasSort=1; }
				if ($entry[0] == 'REV') { $date = date('Y-M-d H:i:s', strtotime($entry[1])); }	// Synology-Liste Datumsformat (ohne Sekunden = geschickt!)
//			}
		}
		$vcf[$nr] = $vcfile;
		$dat[$nr] = $date;
		$eml[$nr] = $mail;
		$Fnm[$nr] = $FN;
		$Vnm[$nr] = $VN;
		$Nnm[$nr] = $NN;
		$org[$nr] = $ORG;
		$cat[$nr] = $CAT;
		$not[$nr] = $hasNote.$hasLabel.$hasSort;
		$idx[$vcfile] = $nr;
		$nr++;
	}
	sort($Kat);
	return $nr;
}

$CardStorage = 1;	// 0: (noch) nirgends - 1: als .vcf-Dateien in Verzeichnis - 2: in Newsletter.db
$ListStorage = 1;	// 0: (noch) nirgends - 1: als .vcf-Dateien in Verzeichnis - 2: in Newsletter.db


$todo   = $_POST['wegmit'] ?? '';
$Action = $_POST['Action'] ?? '';
$AdrBook= $_POST['AdrBook'] ?? '';
$Typ = 0;

if ($todo=='ausführen') {
	$Typ = $NL->querySingle("SELECT Typ FROM AdrBooks WHERE ID=$AdrBook");
	$todo = $Action;
	if ($Typ==0 and $todo=='Synch') { $todo = 'Import Majesty'; }
}

$HandleDelRecs = $_POST['HandleDelRecs'] ?? 0;
$Sortierung = $_POST['Sortierung'] ?? 0;
if (isset($_POST['desc']))
	$Sortierung += 20;
$Kategorie = $_POST['Kategorie'] ?? 999;

$HandleExt2Int = $_POST['HandleExt2Int'] ?? 0;
$HandleInt2Ext = $_POST['HandleInt2Ext'] ?? 0;


$strBook= sprintf('collection_%03d',$AdrBook);                            
$clf    = "data/includes/$strBook/";
$clf    = "data/plugins/News/$strBook/";

if ($todo=='Löschen') {
	$VCFile=$_POST['VCFile'];
	if (unlink($clf.$VCFile))	// im Intranet löschen
		echo "<p>Eintrag $VCFile im Intranet gelöscht!</p>\n";

	//	Verbindung zur Applikation aufnehmen und ebenfalls löschen:
	$sql = "SELECT Typ,URL,User,Pass FROM AdrBooks WHERE ID=$AdrBook";
	$res = $NL->querySingle($sql,1);
	$typ = $res['Typ'];
	$url = $res['URL'];
	$usr = $res['User'];
	$pwd = $res['Pass'];

	if ($typ==1 or $typ==2) {	// Syno
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url.$VCFile);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_HEADER, false);	// s.u. PUT ???
//		curl_setopt($curl, CURLOPT_HEADER, true);	// s.u. PUT ???
		curl_setopt($curl, CURLOPT_USERNAME, $usr);
		curl_setopt($curl, CURLOPT_PASSWORD, $pwd);
		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'DELETE');	// HTTP method like (OPTIONS, GET, HEAD, POST, PUT, DELETE, TRACE, COPY, MOVE)
		$str = curl_exec($curl);
		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		if ($http_code == 204) {	// 201: Neue Karte, 204: Update/Delete
			echo "<p>Kontakt erfolgreich gelöscht.</p>\n";
		} else {
			echo "ERROR $http_code:<br>$str<br>\n";
		}
	} else {
		echo "<p>Löschen in der Anwendung (Majesty) noch nicht implementiert.</p>\n";
	}

	$todo = 'Liste';	// weiter mit der Intranet Listenanzeige
}

if ($todo=='Speichern') {
	$SaveSort = true;
	$SaveLabels = true;

	$UID = $_POST['UID'];
	$FN  = $_POST['FN'];
	$ORG = $_POST['ORG'];
	$NICK= $_POST['NICKNAME'];
	$BDAY= $_POST['BDAY'];
	$TITLE=$_POST['TITLE'];
	$ROLE= $_POST['ROLE'];
	$CAT = $_POST['CATEGORIES'];
	$SORT= $_POST['SORT-STRING']  ?? '';
	$VN  = $_POST['N1'];
	$NN  = $_POST['N0'];
	$N2  = $_POST['N2'];
	$N3  = $_POST['N3'];
	$N4  = $_POST['N4'];
	$TZ  = $_POST['TZ']	?? '';
	$NOTE= $_POST['NOTE'];
	$VCFile=$_POST['VCFile'];

//	Array-Werte:
	$MAIL= $_POST['EMAIL'] ?? array();
	$TEL = $_POST['TEL']   ?? array();
	$ADR = $_POST['ADR']   ?? array();
	$URL = $_POST['URL']   ?? array();
	$LABEL=$_POST['LABEL'] ?? array();
	$PREF= $_POST['PREF']  ?? array();
	$WORK= $_POST['WORK']  ?? array();
	$USE = $_POST['Usage'] ?? array();

	$FotoV=$_POST['PHOTOVAL'] ?? array();
	$FotoK=$_POST['PHOTOKEY'] ?? array();
	$FotoN=$_FILES['PHOTONEW'];
	$LogoV=$_POST['LOGOVAL']  ?? array();
	$LogoK=$_POST['LOGOKEY']  ?? array();
	$LogoN=$_FILES['LOGONEW'];
	$KeyV= $_POST['KEYVAL']   ?? array();
	$KeyK= $_POST['KEYKEY']   ?? array();
	$SndV= $_POST['SOUNDVAL'] ?? array();
	$SndK= $_POST['SOUNDKEY'] ?? array();

// TODO: PHOTONEW / LOGONEW ( SOUNDNEW / KEYNEW )

//	benötigte Werte für Attribute:
	$Usage = [0=>'',1=>';TYPE=FAX', 2=>';TYPE=CELL',3=>';TYPE=PAGER',4=>';TYPE=MAIN',9=>';TYPE=OTHER'];
	$WorkH = [0=>'',1=>';TYPE=WORK',2=>';TYPE=HOME'];
	$Prefs = [0=>'',1=>';TYPE=PREF'];
	$Date  = time();

//	vCard-Text erzeugen:
	$txt = "BEGIN:VCARD\n";
	$txt.= "VERSION:3.0\n";
	$txt.= "PRODID:-//WIBcms//NONSGML Version1.0//DE\n";
	$txt.= "UID:$UID\n";
	$txt.= "FN:$FN\n";
	$txt.= "N:$NN;$VN;$N2;$N3;$N4\n";

	foreach($MAIL as $nr=>$val) {
		if (!empty($val))
			$txt.= 'EMAIL' . $WorkH[$WORK[$nr]] . $Prefs[isset($PREF[$nr])] . ":$val\n";
	}
	foreach($TEL as $nr=>$val) {
		if (!empty($val))
			$txt.= 'TEL' . $WorkH[$WORK[$nr]] . $Usage[$USE[$nr]] . (isset($PREF[$nr]) ? ';TYPE=PREF' : '') . ":$val\n";
	}
	foreach($ADR as $nr=>$val) {
		if (!empty(implode($val)))
			$txt.= 'ADR' . $WorkH[$WORK[$nr]] . (isset($PREF[$nr]) ? ';TYPE=PREF' : '') . ":;;$val[2];$val[3];$val[4];$val[5];$val[6]\n";
	}
	foreach($URL as $nr=>$val) {
		if (!empty($val))
			$txt.= 'URL' . $WorkH[$WORK[$nr]] . (isset($PREF[$nr]) ? ';TYPE=PREF' : '') . ":$val\n";
	}
	if ($SaveLabels) {
		foreach($LABEL as $nr=>$val) {
			if (!empty($val))
				$txt.= 'LABEL' . $WorkH[$WORK[$nr]] . (isset($PREF[$nr]) ? ';TYPE=PREF' : '') . ":$val\n";
		}
	}

	if (!empty($NICK))
		$txt.= "NICKNAME:$NICK\n";
	if (!empty($BDAY))
		$txt.= "BDAY:$BDAY\n";
	if (!empty($ORG))
		$txt.= "ORG:$ORG\n";
	if (!empty($TITLE))
		$txt.= "TITLE:$TITLE\n";
	if (!empty($ROLE))
		$txt.= "ROLE:$ROLE\n";
	if (!empty($NOTE))
		$txt.= "NOTE:$NOTE\n";
	if (!empty($CAT))
		$txt.= "CATEGORIES:$CAT\n";
	if (!empty($TZ))
		$txt.= "TZ:$TZ\n";
	if (!empty($SORT) && $SaveSort)
		$txt.= "SORT-STRING:$SORT\n";

	foreach ($FotoV as $nr=>$val) {
		$txt.= $FotoK[$nr] . ":\n " . wordwrap($val, 72, "\n ", true) . "\n";
	}
	if ($FotoN['size']>0 and stripos($LogoN['type'],'image')===0) {
		$txt.= createpicture('PHOTO',$FotoN['tmp_name']);
	}

	foreach ($LogoV as $nr=>$val) {
		$txt.= $LogoK[$nr] . ":\n " . wordwrap($val, 72, "\n ", true) . "\n";
	}
	if ($LogoN['size']>0 and stripos($LogoN['type'],'image')===0) {
		$txt.= createpicture('LOGO',$LogoN['tmp_name']);
	}

	foreach ($KeyV as $nr=>$val) {
		$txt.= $KeyK[$nr] . ":\n " . wordwrap($val, 72, "\n ", true) . "\n";
	}
	foreach ($SndV as $nr=>$val) {
		$txt.= $SndK[$nr] . ":\n " . wordwrap($val, 72, "\n ", true) . "\n";
	}

	$txt.= "REV:".gmdate("Ymd\THis\Z",$Date)."\n";	// oder nur date("Ymd\THis\Z",$Date) ???
	$txt.= "END:VCARD\n";

//	Insert/Update card into Directory:
	$fc = fopen($clf.$VCFile,'w');
	fwrite($fc, $txt);
	fclose($fc);

	//	Verbindung zur Anwendung aufnehmen und neue Karte "putten":
	$sql = "SELECT Typ,URL,User,Pass FROM AdrBooks WHERE ID=$AdrBook";
	$res = $NL->querySingle($sql,1);
	$typ = $res['Typ'];
	$url = $res['URL'];
	$usr = $res['User'];
	$pwd = $res['Pass'];

	if ($typ==1 or $typ==2) {	// Syno
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
//		curl_setopt($curl, CURLOPT_HEADER, false);	// s.u. PUT ???
		curl_setopt($curl, CURLOPT_HEADER, true);
		curl_setopt($curl, CURLOPT_USERNAME, $usr);
		curl_setopt($curl, CURLOPT_PASSWORD, $pwd);

		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PUT');
	//	Für PUT: UPDATE ist ebenfalls PUT

		curl_setopt($curl, CURLOPT_URL, $url.$VCFile);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $txt);	// Text der VCF-Karte
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-type: text/vcard'));	// $content_type='text/vcard';

		$str = curl_exec($curl);
		$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		curl_close($curl);

		if (($http_code == 204) or ($http_code == 201)) {	// 201: Neue Karte, 204: Update
			echo "<p>Kontakt erfolgreich gespeichert.</p>\n";
		} else {
			echo "ERROR $http_code:<br>$str<br>\n";
		}
	} else {
		echo "<p>Update in der Anwendung (Majesty) noch nicht implementiert.</p>\n";
	}

	$todo = "Liste";
	// evtl. open VCF: editcard($AdrBook,$VCFile)
}

$server = array();
$update = array();

switch ($todo) {
  case 'Import Majesty':	// $Typ==0 && $todo=='Synch'
	set_time_limit(60);	// sonst evtl. timeout
	$timer = new timerClass();
	$timer ->start();

//	Mal schauen, was wir bereits im Intranet haben:
	$AnzCards = cardlist($AdrBook);
	$islist = $AnzCards>0;

//	Vorab Firmen einlesen (anhand Kunden-/Lieferanten-Nummern):
//	und die Landeskennzeichnungen:
//	$Land = ['D'=>'Deutschland','CH'=>'Schweiz','A'=>'Österreich','DK'=>'Dänemark','SK'=>'Slowakei','F'=>'Frankreich'];
	$Laender = new dbf_class($dir,"LANDTAB.DBF");
	$numrec = $Laender->dbf_num_rec;
	for($i=0; $i<$numrec; $i++){
		if ($row = $Laender->getRow($i,$showDelRecs,0)) {
			$Land[$row[0]] = utf($row[2]);
		}
	}

	if ($AdrBook==1) {
		$FirmenDB = 'KDST.DBF';
		$Kontakte = 'KUNDANSP.DBF';
		$AenDat = 177;
	} elseif ($AdrBook==2) {
		$FirmenDB = 'LIEFST.DBF';
		$Kontakte = 'LIEFANSP.DBF';
		$AenDat = 130;
	}

	$firmen = new dbf_class($dir,$FirmenDB);
	$numrec = $firmen->dbf_num_rec;
	for($i=0; $i<$numrec; $i++){
		if ($row = $firmen->getRow($i,$showDelRecs,$printmemo)) {
			$Firma[$row[2]]= utf($row[4]) . ' ' . utf($row[5]) . ' ' . utf($row[6]) . ' (' . utf($row[11]) . ')';
			$ADR[$row[2]] = [utf($row[7]), $Land[utf($row[9])], utf($row[10]), utf($row[11])];	// Str,LandKZ,PLZ,Ort
			$TEL[$row[2]] = [utf($row[13]),utf($row[14]),utf($row[15])];	// Tel,TX(Mobil),Fax
			$URL[$row[2]] = [utf($row[16]),utf($row[17])];	// Mail,Website
			$GRU[$row[2]] = utf($row[19]);	// Kundengruppe (Kennung)
			$Aend[$row[2]]= Timestamp($row[$AenDat]);
		}
	}
// Evtl. noch Kennzeichnungen einlesen...

//	Majesty-Liste einlesen:
	$dbf = new dbf_class($dir,$Kontakte);
	$num_rec = $dbf->dbf_num_rec;
    $field_num=$dbf->dbf_num_field;
	$modDate = date('d.m.Y',$dbf->dbf_modDate);

	$AnzPos = 0;
	$AnzDel = 0;
	$AnzNeu = 0;
	$AnzKill= 0;
	$AnzExist=0;

	$must_update_self   = false;
	$must_update_server = false;

//	Jetzt die Majesty-Liste durchgehen:
	for($i=0; $i<$num_rec; $i++){
		if ($row = $dbf->getRow($i,$showDelRecs,$printmemo)) {
			if ($row[10]) {	// hat Mailadresse
				$AnzPos++;
				$Valid = 1;
				$Aktiv = 1;
				$EMail = trim(strtolower(utf($row[10])));

				if ($ListStorage==1) {	// File-Version
					$nr = array_search($EMail, $eml);
					// OBACHT: es kann in Majesty mehrere Einträge geben mit gleicher Mailadresse -> weitere Kriterien berücksichtigen!!!!
					$exists = ($nr !== false);
				} elseif ($ListStorage==2) {	// DB-Version
					$nr = $NL->querySingle("SELECT ID FROM Liste WHERE Mail LIKE '$EMail'");
					$exists = ($nr !== false);
				}
				$DoSynch = true;
				if ($dbf->isDeleted) {
					$AnzDel++;
					switch ($HandleDelRecs) {
						case 0:	//	löschen, nicht aufnehmen
							$DoSynch = false;
							if ($ListStorage==1) {	// File-Version
								//	Zeile weglassen / löschen
								// .vcf weglassen / entfernen
							} elseif ($ListStorage==2) {	// DB-Version
								if ($exists) {
									$OK = $NL->exec("DELETE FROM Liste WHERE ID=$nr");
									$AnzKill++;
								}
							}
							break;
						case 1: $Valid = 0; break;	// nur markieren als ungültig
						case 2: $Aktiv = 0; break;	// nur markieren als inaktiv
					}
				}
				if ($DoSynch) {
					$date = Timestamp($row[46]);	// Format??
					$Kunde = $Firma[$row[0]];
//					$Kunde = $row[0];
					$Adr   = $ADR[$row[0]];
					$Tel   = $TEL[$row[0]];
					$Url   = $URL[$row[0]];
					$Gru   = $GRU[$row[0]];
					$NName = utf($row[2]);
					$VName = utf($row[3]);
					$Gender= $row[5];

					if ($islist && $exists) {
						// list exists and card exists, so compare and mark to update
						$AnzExist++;
						$card = $vcf[$nr];
						$mydate = strtotime($dat[$nr]);	// REV-Kartendatum yyyymmddThhmmssZ $dat[$exists]
						if ($mydate < $date) {
							// gespeicherte vCard muss aktualisiert werden:
							$update[$card] = true;
							$must_update_self = true;
			//				echo "<span onclick=\"editcard($AdrBook,'$card')\">(I:".date('d.m.Y H:i:s',$mydate).'/Sneu:'.date('d.m.Y H:i:s',$date).") </span>";
			// Update database
							$sql = "UPDATE Liste SET Quelle=1,Datum=$date,valid=$Valid,aktiv=$Aktiv,Firma='$Kunde',Vorname='$VName',Nachname='$NName',Gender=$Gender,Mail='$EMail' WHERE ID=$exists";
						} elseif ($mydate > $date) {
							// vCard hier ist bereits aktueller, markiere zum Aktualisieren auf dem CardDaV-Server
							$server[$card] = true;
							$must_update_server = true;
			//				echo "<span onclick=\"editcard($AdrBook,'$card')\">(Ineu:".date('d.m.Y H:i:s',$mydate).'/S:'.date('d.m.Y H:i:s',$date).") </span>";
			//				??? Update in Majesty... Aber wie?
						}
					} else {
						// new card in Majesty
						$AnzNeu++;
						do {
							$UID = guidv4();
						} while (file_exists($clf.$UID.'.vcf'));

						$MyDate = $date;	//	(Majestydatum) oder $Aend[$row[0]] (Firmendatum)
						$card = $UID.'.vcf';

						$txt = "BEGIN:VCARD\n";
						$txt.= "VERSION:3.0\n";
						$txt.= "PRODID:-//WIBcms//NONSGML Version1.0//DE\n";
						$txt.= "UID:$UID\n";
						$txt.= "FN:$VName $NName\n";	// Reihenfolge, mit/ohne Firma
						$txt.= "N:$NName;$VName;;;\n";
						$txt.= "ORG:$Kunde\n";
						$txt.= "ADR;TYPE=WORK:;;$Adr[0];$Adr[3];;$Adr[2];$Adr[1]\n";
						$txt.= "EMAIL;TYPE=WORK;TYPE=PREF:$EMail\n";
						if (!empty($Url[0]))
							$txt.= "EMAIL;TYPE=WORK:$Url[0]\n";
						if (!empty($Url[1]))
							$txt.= "URL;TYPE=WORK:$Url[1]\n";
						if (!empty($Tel[0]))
							$txt.= "TEL;TYPE=WORK:$Tel[0]\n";
						if (!empty($Tel[1]))
							$txt.= "TEL;TYPE=WORK;TYPE=CELL:$Tel[1]\n";
						if (!empty($Tel[2]))
							$txt.= "TEL;TYPE=WORK;TYPE=FAX:$Tel[2]\n";
						$txt.= "REV:".gmdate("Ymd\THis\Z",$MyDate)."\n";	// oder nur date(...) ???
						$txt.= "END:VCARD\n";

						// Insert card in Directory
						$fc = fopen($clf.$card,'w');
						fwrite($fc, $txt);
						fclose($fc);

						// Insert into database:
						$sql = "INSERT INTO Liste (Quelle,Datum,valid,aktiv,Firma,Vorname,Nachname,Gender,Mail) VALUES (1,$date,$Valid,$Aktiv,'$Kunde','$VName','$NName',$Gender,'$EMail')";
					}
//					$OK = $NL->exec($sql);
				}
			}
		}
	}

	echo "<p>$AnzPos Datensätze mit Mail-Adressen in Majesty gefunden, davon $AnzDel gelöschte Einträge.<br>";
	echo "$AnzNeu neue Datensätze importiert, $AnzExist Datensätze bereits vorhanden und $AnzKill entfernt.</p>\n";

//	Jetzt anzeigen den Erfolg...
	if ($must_update_server) {
		echo count($server) . " Einträge im Intranet sind neuer und können in Majesty aktualisiert werden.<br>";
		
	}
	if ($must_update_self) {
		echo count($update) . " Einträge in Majesty sind neuer und können im Intranet aktualisiert werden.<br>";
		
	}

	$endexct = $timer->end();
	echo "<small>(Majesty-Import abgeschlossen nach: $endexct)</small><br>\n";
	break;

case 'Synch':
	$timer = new timerClass();
	$timer->start();

	$must_update_self   = false;
	$must_update_server = false;
	$new = 0;
	$AnzNeu = 0;

//	Mal schauen, was wir bereits im Intranet haben:
	$AnzCards = cardlist($AdrBook);
	$islist = $AnzCards>0;

//	Verbindung zur Syno aufnehmen und Collection abrufen:
	$sql = "SELECT URL,User,Pass FROM AdrBooks WHERE ID=$AdrBook";
	$res = $NL->querySingle($sql,1);
	$url = $res['URL'];
	$usr = $res['User'];
	$pwd = $res['Pass'];

//	echo "Synching with $url<br>\n";

    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HEADER, false);	// s.u. PUT ???
	curl_setopt($curl, CURLOPT_USERNAME, $usr);
	curl_setopt($curl, CURLOPT_PASSWORD, $pwd);
    $str = curl_exec($curl);

	$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
	if ($http_code == 204) {	// 201: Neue Karte, 204: Update/Delete
		echo "<p>Kontakt erfolgreich.</p>\n";
	} else {
		echo "ERROR $http_code:<br>$str<br>\n";
	}


  if ($Typ==1) {	// alter Synology CardDAV-Server

	$str1 = explode('<div class="directory-listing">', $str);

//	extract vcf filenames: (sample: fd334543-e392-4f23-95fc-a79423457f57.vcf)
	$pattern = "/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}.vcf</";
	$OK = preg_match_all($pattern, $str1[1],$vcffile);
//	extract modification date of vCard:
	$pattern = "/[0-9]{4}-[a-zA-Z]{3}-[0-9]{2} [0-9]{2}:[0-9]{2}/";
	$OK = preg_match_all($pattern, $str1[1],$vcfdate);
/*
	echo "<pre>";
	var_dump($vcfdate);
	var_dump($vcffile);
	echo "</pre>";
*/

//	normalize and save / compare collection overview:
	foreach($vcffile[0] as $key=>$val) {
		$vcfile = substr($val, 0, -1);	// letztes Zeichen (<) abschneiden, damit der Dateiname xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx.vcf übrig bleibt
		$cards[$key] = $vcfile;
		$date = strtotime($vcfdate[0][$key]);	// ist Speicherdatum, NICHT Kartendatum! Format "YYYY-Mon-dd HH:ii"

		curl_setopt($curl, CURLOPT_URL, $url.$vcfile);	// fetch vCard from Server
		$card = trim(curl_exec($curl));

		$rpos = strpos($card,'REV:');
		if ($rpos > 0) { // REV-Kartendatum extrahieren für Vergleich
			$nlpos = strpos($card,chr(10),$rpos);
			$date = strtotime(substr($card,$rpos+4, $nlpos-$rpos-5));	// $date ist jetzt REV-Kartendatum
		} else {
			$tmp = explode('END:',$card);
			$card = $tmp[0] . "REV:" . gmdate("Ymd\THis\Z",$date) . "\nEND:VCARD\n";
		}
		$strDate = date("d.m.Y H:i:s",$date);

		if ($islist && isset($idx[$vcfile])) {
			// list exists and vcfile exists, so compare and mark to update
			$nr = $idx[$vcfile];
			$mydate = strtotime($dat[$nr]);	// bereits gespeichertes REV-Kartendatum yyyymmddThhmmssZ
			$strMyDate = date("d.m.Y H:i:s",$mydate);

			if ($mydate < $date) {
				// gespeicherte vCard muss aktualisiert werden:
				$update[$vcfile] = true;
				$must_update_self = true;
				if (file_put_contents($clf.$vcfile, trim($card))!==false)
					echo "Kontakt $vcfile ($Fnm[$nr]/$strMyDate) erfolgreich im Intranet auf $strDate aktualisiert.<br>\n";
//				echo "<span onclick=\"editcard($AdrBook,'$vcfile')\">(I:".date('d.m.Y H:i:s',$mydate).'/Sneu:'.date('d.m.Y H:i:s',$date).") </span>";
			} elseif ($mydate > $date) {
				// vCard hier ist bereits aktueller, markiere zum Aktualisieren auf dem CardDaV-Server
				$server[$vcfile] = true;
				$must_update_server = true;
				
//				echo "<span onclick=\"editcard($AdrBook,'$vcfile')\">(Ineu:".date('d.m.Y H:i:s',$mydate).'/S:'.date('d.m.Y H:i:s',$date).") </span>";
			}
		} else {
			// new vcfile on server. REV-Datum bereits eingefügt, falls erforderlich
			file_put_contents($clf.$vcfile, $card);
			$AnzNeu++;
		}
	}

  } elseif ($Typ==2) {	// Synology Contacts: one huge .vcf-file containing all contacts

	echo 'Synching Contacts:<br>';
	$cards = explode('END:VCARD', $str);
	foreach ($cards as $card) {
		$Len = strlen($card);
		if (strlen($card) > 9) {	// Wert 9 ist willkürlich, ist auch nur wegen dem letzten Eintrag
		//	extract UID
			$pattern = "/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/";
			preg_match($pattern, $card, $matches, PREG_OFFSET_CAPTURE);
//			var_dump($matches);
			$UID = $matches[0][0];
			$ptr = $matches[0][1];
			$uidpos = strrpos($card,'UID:',$ptr-$Len);
			$card = substr_replace($card,'',$uidpos+4,$ptr-$uidpos-4);
			$vcfile = "$UID.vcf";
		//	Aktualität feststellen
			$date = time();

			$rpos= strpos($card,'REV:');
			if ($rpos > 0) { // REV-Kartendatum extrahieren für Vergleich
				$nlpos = strpos($card,chr(10),$rpos);
				$date = strtotime(substr($card, $rpos+4, $nlpos-$rpos-5));	// $date ist jetzt REV-Kartendatum
			} else {
				$card .= "REV:" . gmdate("Ymd\THis\Z",$date) . "\n";
				$server[$vcfile] = true;	// weil Datum fehlt -> aktualisieren!
				$must_update_server = true;
			}
			$card .= "END:VCARD\n";
			$strDate = date("d.m.Y H:i:s",$date);

//	siehe oben....   !
			if ($islist && isset($idx[$vcfile])) {
			// list exists and vcfile exists, so compare and mark to update
				$nr = $idx[$vcfile];
				$mydate = strtotime($dat[$nr]);	// bereits gespeichertes REV-Kartendatum yyyymmddThhmmssZ
				$strMyDate = date("d.m.Y H:i:s",$mydate);
				if ($mydate < $date) {
					// gespeicherte vCard muss aktualisiert werden:
					$update[$vcfile] = true;
					$must_update_self = true;
					if (file_put_contents($clf.$vcfile, trim($card))!==false)
						echo "Kontakt $vcfile ($Fnm[$nr]/$strMyDate) erfolgreich im Intranet auf $strDate aktualisiert.<br>\n";
	//				echo "<span onclick=\"editcard($AdrBook,'$vcfile')\">(I:".date('d.m.Y H:i:s',$mydate).'/Sneu:'.date('d.m.Y H:i:s',$date).") </span>";
				} elseif ($mydate > $date) {
					// vCard hier ist bereits aktueller, markiere zum Aktualisieren auf dem CardDaV-Server
					$server[$vcfile] = true;
					$must_update_server = true;
					echo "Kontakt $vcfile ($Fnm[$nr]/$strMyDate) muss auf dem Server aktualisiert werden.<br>\n";
	//				echo "<span onclick=\"editcard($AdrBook,'$vcfile')\">(Ineu:".date('d.m.Y H:i:s',$mydate).'/S:'.date('d.m.Y H:i:s',$date).") </span>";
				}
			} else {
				// new vcfile on server. REV-Datum bereits eingefügt, falls erforderlich
				file_put_contents($clf.$vcfile, trim($card));
				$AnzNeu++;
			}
		}
	}
  }

//	Jetzt anzeigen den Erfolg...
	if ($must_update_server) {
		echo count($server) . " Einträge im Intranet sind neuer und können auf dem Server aktualisiert werden.<br>";
		curl_setopt($curl, CURLOPT_HEADER, true);
		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PUT');	// UPDATE ist ebenfalls PUT
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-type: text/vcard'));
		foreach($server as $vcfile=>$bool) {
			$txt = file_get_contents($clf.$vcfile);
			curl_setopt($curl, CURLOPT_POSTFIELDS, $txt);	// Text der VCF-Karte
			curl_setopt($curl, CURLOPT_URL, $url.$vcfile);
			$str = curl_exec($curl);
			$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			if (($http_code == 204) or ($http_code == 201)) {	// 201: Neue Karte, 204: Update
				echo "Kontakt $vcfile erfolgreich aktualisiert.<br>\n";
			} else {
				echo "Kontakt $vcfile NICHT aktualisiert wegen ERROR $http_code:<br>$str<br>\n";
			}
		}
	}
	if ($must_update_self) {
		echo count($update) . " Einträge auf dem Server sind neuer und wurden im Intranet aktualisiert.<br>";
	}
	if ($AnzNeu) {
		echo $AnzNeu . " neue Einträge auf dem Server gefunden und im Intranet aufgenommen.<br>";
	}
	echo "Gefunden: ".count($cards). " Einträge auf dem Server / $AnzCards im Intranet<br>\n";
	curl_close($curl);
	$endexct = $timer->end();
	echo "<small>(Synch abgeschlossen nach $endexct)</small><br>\n";
	break;

case 'Liste':
	$timer = new timerClass();
	$timer->start();

	$AnzCards = cardlist($AdrBook);

	if ($AnzCards) {
		echo '<table><thead><tr class="kopf"><td>Vorname</td><td>Nachname</td><td>Anzeigename</td><td><small>Firma</small></td><td>E-Mail</td><td>NLS</td></tr></thead>';;
		switch ($Sortierung) {
			case  0: array_multisort($Nnm, SORT_ASC,  $Vnm,$eml,$Fnm,$org,$cat,$dat,$not,$vcf); break;
			case  1: array_multisort($Vnm, SORT_ASC,  $Nnm,$eml,$Fnm,$org,$cat,$dat,$not,$vcf); break;
			case  2: array_multisort($org, SORT_ASC,  $eml,$Fnm,$Vnm,$Nnm,$cat,$dat,$not,$vcf); break;
			case  3: array_multisort($eml, SORT_ASC,  $Nnm,$Fnm,$Vnm,$org,$cat,$dat,$not,$vcf); break;
			case 20: array_multisort($Nnm, SORT_DESC, $Vnm,$eml,$Fnm,$org,$cat,$dat,$not,$vcf); break;	// SORT_NATURAL | SORT_FLAG_CASE
			case 21: array_multisort($Vnm, SORT_DESC, $Nnm,$eml,$Fnm,$org,$cat,$dat,$not,$vcf); break;
			case 22: array_multisort($org, SORT_DESC, $eml,$Fnm,$Vnm,$Nnm,$cat,$dat,$not,$vcf); break;
			case 23: array_multisort($eml, SORT_DESC, $Nnm,$Fnm,$Vnm,$org,$cat,$dat,$not,$vcf); break;
		}

		foreach($vcf as $nr=>$val) {
			$K = explode(',',$cat[$nr]);
			if ($Kategorie==999 or in_array($Kat[$Kategorie],$K))
				echo "<tr class=\"pointer\" onclick=\"editcard($AdrBook,'$val')\"><td>$Vnm[$nr]</td><td>$Nnm[$nr]</td><td>$Fnm[$nr]</td><td><small>$org[$nr]</small></td><td>$eml[$nr]</td><td>$not[$nr]</td></tr>\n";	// <td><small>$cat[$nr]</small></td><td><small>$dat[$nr]</small></td>
		}
		echo "<tr class=\"pointer\" onclick=\"editcard($AdrBook,'neu')\"><td colspan=\"6\">Neuen Eintrag erstellen</td></tr>\n";
		echo "</table><br>";
	} else {
		echo "<p>Keine Kontakte im Intranet gespeichert. Bitte importieren!</p>\n";
	}
	echo "Gefunden: $AnzCards Einträge im Intranet-Adressbuch $AdrBook<br>\n";

	$endexct = $timer->end();
	echo "<small>(Liste eingelesen nach $endexct)</small><br>\n";
	break;
case 'Show':
	echo '<p>Noch nicht implementiert...</p>';
	break;
}

// ---------- Hier fängt die Auswahl an: ----------
echo '<form id="Mailinglist" method="POST">';

// ---------- Status-Übersicht: ----------
/*
$Anz1 = $NL->querySingle("SELECT COUNT(ID) FROM Liste WHERE Quelle=1");
$Anz2 = $NL->querySingle("SELECT COUNT(ID) FROM Liste WHERE Quelle=2");
$Anz3 = $NL->querySingle("SELECT COUNT(ID) FROM Liste WHERE Quelle=3");
$New1 = $NL->querySingle("SELECT MAX(Datum) FROM Liste WHERE Quelle=1");
$New2 = $NL->querySingle("SELECT MAX(Datum) FROM Liste WHERE Quelle=2");
$New3 = $NL->querySingle("SELECT MAX(Datum) FROM Liste WHERE Quelle=3");
$Dat1 = empty($New1) ? 'n.a.' : date('d.m.Y',$New1);
$Dat2 = empty($New2) ? 'n.a.' : date('d.m.Y',$New2);
$Dat3 = empty($New3) ? 'n.a.' : date('d.m.Y',$New3);

echo '<table><tr class="kopf"><td>Quelle</td><td>Datum</td><td>Einträge</td><td>Synchronisieren</td><td>Anzeigen</td></tr>';
echo "<tr><td>Majesty</td><td>$Dat1</td><td>$Anz1</td><td>".'<input type="submit" name="wegmit" value="Import Majesty"></td><td><input type="submit" name="wegmit" value="Liste Majesty"></td></tr>';
echo "<tr><td>Team-Adressen</td><td>$Dat2</td><td>$Anz2</td><td>".'<input type="submit" name="wegmit" value="Synch Team-Adressen"></td><td><input type="submit" name="wegmit" value="Liste Team-Adressen"></td></tr>';
echo "<tr><td>Jürgens Adressen</td><td>$Dat3</td><td>$Anz3</td><td>".'<input type="submit" name="wegmit" value="Synch Jürgens Adressen"></td><td><input type="submit" name="wegmit" value="Liste Jürgens Adressen"></td></tr>';
echo "<tr><td>Anitas Adressen</td><td>$Dat3</td><td>$Anz3</td><td>".'<input type="submit" name="wegmit" value="Synch Anitas Adressen"></td><td><input type="submit" name="wegmit" value="Liste Anitas Adressen"></td></tr>';
// echo "<tr><td>Excel</td><td>$Dat2</td><td>$Anz2</td><td>".'<input type="submit" name="wegmit" value="Import Excel"></td><td></td></tr>';
// echo "<tr><td>Manuell</td><td>$Dat3</td><td>$Anz3</td><td>".'<input type="submit" name="wegmit" value="Eingabe"></td><td></td></tr>';
echo "</table><br>\n";
*/
echo "<fieldset><legend>Externes Adressbuch auswählen</legend>\n";
startSelect('AdrBook','Adressbuch / Aktion');
$res = $NL->query("SELECT ID,Name FROM AdrBooks");
while($rec = $res->fetchArray()) {
	echo txtOption($rec[0],$rec[1],$AdrBook);
}
echo '</select> <select name="Action">';
echo txtOption('Liste','Liste (importiert im Intranet)',$Action);
echo txtOption('Synch','Synch',$Action);
echo txtOption('Show','Anzeige (live)',$Action);
echo '</select> <input type="submit" name="wegmit" value="ausführen"><br>';
echo "</fieldset><fieldset><legend>Anzeigeoptionen für die Liste</legend>\n";
startSelect('Sortierung','Sortierung');
echo txtOption(0,'nach Nachname',$Sortierung);
echo txtOption(1,'nach Vorname',$Sortierung);
echo txtOption(2,'nach Firma',$Sortierung);
echo txtOption(3,'nach Mailadresse',$Sortierung);
echo '</select> <input type="checkbox" name="desc"> (absteigend)<br>';

startSelect('Kategorie','Kategorie');
echo txtOption(999,'ohne Kategorie',$Kategorie);
foreach ($Kat as $key=>$val) {
	echo txtOption($key,$val,$Kategorie);
}
echo "</select><br>\n";
echo "</fieldset><fieldset><legend>Import-/Synchronisierungsoptionen</legend>\n";
startSelect('HandleDelRecs','Gelöschte Majesty-Einträge');
echo txtOption(0,'nicht in Importliste aufnehmen und löschen, falls vorhanden',$HandleDelRecs);
echo txtOption(1,'in Importliste aufnehmen und als nicht gültig markieren',$HandleDelRecs);
echo txtOption(2,'in Importliste aufnehmen und als nicht aktiv markieren',$HandleDelRecs);
echo "</select> Wie soll ich inzwischen gelöschte Majesty-Datensätze behandeln?<br>\n";
startSelect('HandleExt2Int','Intranet <- Extern');
echo txtOption(0,'keinerlei Synchronisierung (nur Hinweis)',$HandleExt2Int);
echo txtOption(1,'nur neu erstellte Kontakte importieren',$HandleExt2Int);
echo txtOption(2,'alle (auch aktualisierte) Kontakte importieren',$HandleExt2Int);
echo txtOption(3,'extern gelöschte Kontakte auch im Intranet löschen',$HandleExt2Int);
echo "</select> Import: Synchronisierung vom externem Adressbuch Richtung Intranet<br>\n";
startSelect('HandleInt2Ext','Intranet -> Extern');
echo txtOption(0,'keinerlei Synchronisierung (nur Hinweis)',$HandleInt2Ext);
echo txtOption(1,'nur neu erstellte Kontakte exportieren',$HandleInt2Ext);
echo txtOption(2,'alle (auch aktualisierte) Kontakte exportieren',$HandleInt2Ext);
echo txtOption(3,'intern gelöschte Kontakte auch extern löschen',$HandleInt2Ext);
echo "</select> Export: Synchronisierung vom Intranet Richtung externem Adressbuch<br>\n";
echo '<input type="hidden" name="LastSubmit" value="'.$todo.'">';
?>
</fieldset></form>