<?php
/**
 * @purpose   Managing mailing lists for AK-Produktionstechnik.
 *
 * @name      mailinglist.php
 * @version   0.1 rc
 * @license   GPL v3 (see enclosed license.txt or <http://www.gnu.org/licenses/>)
 * @copyright DO NOT remove @author or @license or @copyright.
 *            This program is free software: you can redistribute it and/or modify
 *            it under the terms of the GNU General Public License as published by
 *            the Free Software Foundation, either version 3 of the License,
 *            or (at your option) any later version.
 *
 *            This program is distributed in the hope that it will be useful,
 *            but WITHOUT ANY WARRANTY; without even the implied warranty of
 *            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *            GNU General Public License for more details.
 *
 *            You should have received a copy of the GNU General Public License
 *            along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @authors   nageniil - coded in notepad++
 *
 */
// STEP 0 ("Konstante" Vorgaben für das WIcms holen)
$WIBcmsFilePrefix = "../../";
require "../../core/wibcmsconstants.php";

// STEP 1 (Funktionen):
require "../../core/wibcmsfunctions.php";

// --------------------- Some functions: ------------------------
function b64tojpg($b64,$file='vcf_photo.jpg') {
//	https://base64.guru/converter/encode/image
	$bin = base64_decode($b64);
	$img = imageCreateFromString($bin);
	if ($img) {
		imagejpeg($img, $file);
		return true;
	} else {
		return false;
	}
}
function imgtob64($file) {
	if (is_file($file)) {
		$pnt = strrpos($file,'.');
		$ext = substr($file,$pnt+1);
		$bin = file_get_contents($file);
		$b64 = base64_encode($bin);
		$src = "data:image/$ext;base64,$b64";
		return $src;
	} else {
		return false;
	}
}

function printgrafik($img,$j,$nr=0) {
	global $cardVersion,$CSPHeader;
/*
3.0: LOGO/PHOTO;TYPE=JPEG:http://example.org/photo.jpg	(or =PNG)
3.0: LOGO/PHOTO;TYPE=JPEG;ENCODING=b:[base64-data]		(or =PNG)
4.0: LOGO/PHOTO;MEDIATYPE=image/jpeg:http://example.org/photo.jpg (or image/png)
4.0: LOGO/PHOTO:data:image/jpeg;base64,[base64-data]	(or image/png)
*/
	if (count($img)) {
		foreach($img as $key=>$val) {
//			echo "Key=$key<br>";
			echo '<input type="hidden" name="'.$j.'VAL['.$nr.']" value="'.$val.'">';
			echo '<input type="hidden" name="'.$j.'KEY['.$nr.']" value="'.$key.'">';
			if (($cardVersion<4 and stripos($key,'ENCODING')===false) or ($cardVersion>3 and stripos($key,'MEDIATYPE')!==false)) {
			// Link auf Image:
				if (!$CSPHeader) {
					// wenn ohne ContentSecurityHeader können wir ein base64-codiertes Data-Image einbinden
					echo '<img class="vcf-preview" title="verlinktes Bild als Base64 eingebettet" src="'.imgtob64($val).'"> ';
				} else {
					echo '<img class="vcf-preview" title="verlinktes Bild als externe Datei" src="'.$val.'"> ';
				}
			} else {
			// base64-codiertes Data-Image:
				if ($cardVersion>3) {
					$pnt = strpos($val,',');
					$val = substr($val,$pnt+1);	// data:image/jpeg;base64, abschneiden
				}
				if ($CSPHeader) {
					// weil: base64-codiert geht wohl nicht bei ContentSecurityHeader
					if (b64tojpg($val,"vcf_$j.jpg")) {
						echo '<img class="vcf-preview" title="Base64-Bild als Datei" src="data/includes/vcf_'.$j.'.jpg?'.time().'"> ';
					}
				} else {
					echo '<img class="vcf-preview" title="Base64-Bild eingebettet" src="data:image/jpeg;base64,'.$val.'"> '; // jpeg/png scheint egal zu sein
				}
			}
		}

	} else {
		echo '<img class="vcf-preview" title="Neues Bild" src="data/includes/'.$j.'.jpg"> ';
	}
	echo '<input id="'.$j.'NEW" name="'.$j.'NEW" type="file"><br>';
}

function contact($prop,$key,$val,$nr,$echo=true) {
	// https://www.iana.org/assignments/vcard-elements/vcard-elements.xhtml
	$lbl = ['EMAIL'=>'E-Mail-Adresse','TEL'=>'Rufnummer','ADR'=>'Adresse','URL'=>'Homepage'];
	$txt = '';
	$WorkHome = 0 + (stripos($key,'work') > 0) + 2*(stripos($key,'home') > 0);
	$ispref = stripos($key,'pref') > 0;
	if ($echo) {
		$valo = trim(str_replace(array("\n",";","\\n")," ",$val));
		echo '<label><span class="pointer" onclick="opendet('.$nr.')">'.$lbl[$prop].'<small> -> Details</small></span></label><input type="text" disabled value="'.$valo."\"><br>\n";
	} else {
		echo ' &nbsp; <span class="pointer" onclick="opendet('.$nr.')">'.$lbl[$prop].'</span>';
	}
	if ($prop=='ADR') {
		$adr = explode(';',$val);
//		$txt.= txtInput("ADR[$nr][0]",'Postfach',$adr[0]);
//		$txt.= txtInput("ADR[$nr][1]",'zus. Angaben',$adr[1]);
		$txt.= txtInput("ADR[$nr][2]",'Straße Nr',$adr[2]);
		$txt.= txtInput("ADR[$nr][5]",'PLZ',$adr[5]);
		$txt.= txtInput("ADR[$nr][3]",'Ort',$adr[3]);
		$txt.= txtInput("ADR[$nr][4]",'Region',$adr[4]);
		$txt.= txtInput("ADR[$nr][6]",'Land',$adr[6]);
	} else {
		$txt.= txtInput($prop."[$nr]",'<b>'.$lbl[$prop].'</b>',$val);
	}
	$txt.= setCheckButton("PREF[$nr]",'','bevorzugt',$ispref);
	$txt.= txtSelect("WORK[$nr]",'Nutzung');
	$txt.= txtOption(0,'(keine Angabe)',$WorkHome);
	$txt.= txtOption(1,'geschäftlich',$WorkHome);
	$txt.= txtOption(2,'privat',$WorkHome);
	$txt.= "</select><br>\n";
	if ($prop=='TEL') {
		$isfax = stripos($key,'fax') > 0;
		$iscell= stripos($key,'cell') > 0;
		$ispag = stripos($key,'pager') > 0;
		$ismain= stripos($key,'main') > 0;	// Festnetz
//		$isvoic= stripos($key,'voice') > 0;
//		$istext= stripos($key,'text') > 0;
//		$isvid = stripos($key,'video') > 0;
//		$istxtp= stripos($key,'textphone') > 0;
		$isothr= stripos($key,'other') > 0;
		$Usage = 0 + $isfax +2*$iscell + 3*$ispag + 4*$ismain +9*$isothr;
		$txt.= txtSelect("Usage[$nr]",'Verwendung');
		$txt.= txtOption(0,'(keine Angabe)',$Usage);
		$txt.= txtOption(1,'Telefax',$Usage);
		$txt.= txtOption(2,'Mobiltelefon',$Usage);
		$txt.= txtOption(3,'Pager',$Usage);
		$txt.= txtOption(4,'Festnetz',$Usage);
		$txt.= txtOption(9,'Sonstige',$Usage);
		$txt.= "</select><br>\n";
	}
	return $txt;
}
// -------------------------------------------------------------

$Label = ['FN'=>'Anzeigename', 'N'=>'Name', 'CATEGORIES'=>'Kategorien', 'ORG'=>'Organisation', 'NICKNAME'=>'Spitzname', 'BDAY'=>'Geburtstag', 'TITLE'=>'Stellenbezeichnung', 'ROLE'=>'Rolle/Position', 'NOTE'=>'Notizen', 'UID'=>'', 'REV'=>'', 'VERSION'=>'', 'PRODID'=>'', 'SORT-STRING'=>'Sortierung', 'LABEL'=>'Etikett'];	// 'PHOTO'=>'Foto','LOGO'=>'Logo' extra draußen gelassen damit die Einträge am Ende berücksichtigt werden!

echo '<form enctype="multipart/form-data" id="EditCard" method="POST">';
echo "<script>lastnr = -1;</script>\n";

$AdrBook= $_POST['adrbook'];
$MyFile = urldecode($_POST['vcard']);

$strBook= sprintf('collection_%03d',$AdrBook);
$clf    = "../../data/includes/$strBook/";

echo "<h2>Visitenkarte $MyFile:</h2>\n";

if (($MyFile == "neu") or file_exists($clf.$MyFile)) {
	if ($MyFile == "neu") {
		do {
			$UID = guidv4();
		} while (file_exists($clf.$UID.'.vcf'));
		$MyFile= $UID.'.vcf';
		$vcard[] = "BEGIN:VCARD";
		$vcard[] = "VERSION:3.0";
		$vcard[] = "PRODID:-//WIBcms//NONSGML Version1.0//DE";
		$vcard[] = "UID:$UID";
		$vcard[] = "REV:".gmdate("Ymd\THis\Z");	// oder nur date(...) ???
		$vcard[] = "END:VCARD";
	} else {
		$vcard = file($clf.$MyFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
	}

//	https://de.wikipedia.org/wiki/VCard
//	CALADRURI CALURI CLIENTPIDMAP FBURL GEO KIND MEMBER RELATED SOURCE URL[]
//	IMPP:skyp:xyz / xmpp:(Jabber) / qq:(Tencent QQ) / gtalk:(Google Talk)
//	ITEM1.X-ABDATE:20210930 / ITEM1.X-ABLABEL:Besprechung / X-WAB-GENDER / X-THUNDERBIRD-...
/*
3.0: KEY;TYPE=PGP:http://example.org/key.pgp
3.0: KEY;TYPE=PGP;ENCODING=B:[base64-data]
4.0: KEY;MEDIATYPE=application/pgp-keys:http://example.org/key.pgp
4.0: KEY:data:application/pgp-keys;base64\,[base64-data]

3.0: SOUND;TYPE=OGG:http://example.org/sound.ogg
3.0: SOUND;TYPE=OGG;ENCODING=b:[base64-data]
4.0: SOUND;MEDIATYPE=audio/ogg:http://example.org/sound.ogg
4.0: SOUND:data:audio/ogg;base64\,[base64-data]
*/
	foreach($vcard as $nr=>$line) {
	// extract all the data within the vCard
		$entry = explode (':',stripslashes($line),2);	// BEWARE: some data may contain the ':' (http://...) -> so limit to 2
		$key = trim($entry[0]);
		if ((empty($entry[1]) && strpos($line,':')===false) or ($line[0]==' ')) {
			// Zeile ohne ':' oder mit ' ' am Anfang bedeutet Fortsetzung der letzten Zeile!
			switch ($lasttype) {
				case  0: $mail[$lastkey].= $key; break;
				case  1: $adr[$lastkey] .= $key; break;
				case  2: $tel[$lastkey] .= $key; break;
				case  3: $foto[$lastkey].= $key; break;
				case  4: $logo[$lastkey].= $key; break;
				case  5: $snd[$lastkey] .= $key; break;
				case  6: $pkey[$lastkey].= $key; break;
				case  7: $url[$lastkey] .= $key; break;
				case  8: $lbl[$lastkey] .= $key; break;
				case  9: $note[$lastkey].= $key; break;
				case 10: $card[$lastkey].= $key; break;
			}
		} else {
			$val = trim($entry[1]);
			if       (strpos($key,'EMAIL')!==false) {
				$mail[$key] = $val;
				$lasttype = 0;
			} elseif (strpos($key,'ADR') !== false) {
				$adr[$key] = $val;
				$lasttype = 1;
			} elseif (strpos($key,'TEL') !== false) {
				$tel[$key] = $val;
				$lasttype = 2;
			} elseif (strpos($key,'PHOTO')!==false) {
				$foto[$key] = $val;
				$lasttype = 3;
			} elseif (strpos($key,'LOGO') !==false) {
				$logo[$key] = $val;
				$lasttype = 4;
			} elseif (strpos($key,'SOUND')!==false) {
				$snd[$key] = $val;
				$lasttype = 5;
			} elseif (strpos($key,'KEY') !== false) {
				$pkey[$key] = $val;
				$lasttype = 6;
			} elseif (strpos($key,'URL') !== false) {
				$url[$key] = $val;
				$lasttype = 7;
			} elseif (strpos($key,'LABEL') !== false) {
				$lbl[$key] = $val;
				$lasttype = 8;
			} elseif (strpos($key,'NOTE') !== false) {
				$note[$key] = $val;
				$lasttype = 9;
			} elseif($val!='VCARD') {
				$card[$key] = $val;
				$lasttype = 10;
			}
			$lastkey = $key;
		}
	}

	echo "<fieldset><legend>Visitenkarte</legend>\n";
	$j = 'FN';
	echo txtInput($j, $Label[$j], $card[$j]);
	$j = 'CATEGORIES';
	echo txtInput($j, $Label[$j], $card[$j]);
	$j = 'SORT-STRING';
	echo txtInput($j, $Label[$j], $card[$j]);
	echo "<label>Zuletzt aktualisiert</label>". date('d.m.Y H:i:s', strtotime($card['REV'])) . " &nbsp; <small>(Version: ".$card['VERSION'].", erzeugt von ".$card['PRODID']." am: ". $card['REV'] .")</small><br>\n";
	$cardVersion = $card['VERSION'];
	// v2.1, v3.0:	TZ:+0100
	// v4.0:		TZ:Europe/Berlin
	echo "</fieldset>\n";

	echo "<fieldset><legend>Persönliche Informationen</legend>\n";
	echo '<div class="halb">';
	$vals = explode(';',$card['N']);
	echo txtInput('N1','Vorname <img class="pointer" src="core/grafix/pfupdown.gif" title="Vor- und Nachname tauschen" onclick="switchnames();">',$vals[1]);
	echo txtInput('N2','zus. Vornamen',$vals[2]);
	echo txtInput('N0','Nachname',$vals[0]);
	echo txtInput('N3','Präfix (Titel)',$vals[3]);
	echo txtInput('N4','Suffix (Zusatz)',$vals[4]);
	$j = 'NICKNAME';
	echo txtInput($j, $Label[$j], $card[$j]);
	// BDAY:1964-08-12 oder (2.1) BDAY:19640812
	$j = 'BDAY';
	if (is_numeric($card[$j])) {$card[$j] = substr($card[$j],0,4).'-'.substr($card[$j],4,2).'-'.substr($card[$j],6,2);}
//	echo txtInput($j, $Label[$j], $card[$j]);
	echo '<label for="'.$j.'">'.$Label[$j].'</label><input type="date" id="'.$j.'" name="'.$j.'" value="'.$card[$j].'"><br>';
	// v4.0: ANNIVERSARY:2014-08-12 GENDER:F LANG:de-DE
	echo '</div><div class="halb">';
	$j = 'PHOTO';
	printgrafik($foto,$j);
	echo "</div></fieldset>\n";

	echo "<fieldset><legend>Berufliche Informationen</legend>\n";
	echo '<div class="halb">';
	$j = 'ORG';
	echo txtInput($j, $Label[$j], $card[$j]);
	$j = 'TITLE';
	echo txtInput($j, $Label[$j], $card[$j]);
	$j = 'ROLE';
	echo txtInput($j, $Label[$j], $card[$j]);
	echo '</div><div class="halb">';
	$j = 'LOGO';
	printgrafik($logo,$j);
	echo "</div></fieldset>\n";

	echo "<fieldset><legend>Kontaktangaben</legend>\n";
	echo '<div class="halb">';
	$nr = 0;
	foreach($mail as $key=>$val) {
		$detail[$nr] = contact('EMAIL',$key,$val,$nr);
		$nr++;
	}
	foreach($tel as $key=>$val) {
		$detail[$nr] = contact('TEL',$key,$val,$nr);
		$nr++;
	}
	foreach($adr as $key=>$val) {
		$detail[$nr] = contact('ADR',$key,$val,$nr);
		$nr++;
	}
	foreach($url as $key=>$val) {
		$detail[$nr] = contact('URL',$key,$val,$nr);
		$nr++;
	}
	echo '<label>NEU:</label><small>';
	$detail[$nr] = contact('EMAIL','','',$nr,0); $nr++;
	$detail[$nr] = contact('TEL' , '','',$nr,0); $nr++;
	$detail[$nr] = contact('ADR' , '','',$nr,0); $nr++;
	$detail[$nr] = contact('URL' , '','',$nr,0); $nr++;
	echo '</small></div><div class="halb">';
	// die gesammelten Detailangaben:
	foreach($detail as $i=>$txt) {
		echo '<div style="display:none" id="detail'.$i.'">'.$txt."</div>\n";
	}
	echo "</div></fieldset>\n";

	echo "<fieldset><legend>Sonstiges</legend>\n";
	echo '<div class="halb">';
	$j = 'NOTE';
	echo TextArea($j, $Label[$j], $note[$j]);

	foreach($lbl as $key=>$val) {
		if (!empty($val)) {
			echo '</div><div class="halb">';
			echo TextArea("LABEL[$nr]", $Label['LABEL'], $val);
			// siehe function contact() -> evtl. als eigene function:
			echo setCheckButton("PREF[$nr]",'','bevorzugt',$ispref);
			echo txtSelect("WORK[$nr]",'Nutzung');
			echo txtOption(0,'(keine Angabe)',$WorkHome);
			echo txtOption(1,'geschäftlich',$WorkHome);
			echo txtOption(2,'privat',$WorkHome);
			echo "</select><br>\n";
			$nr++;
		}
	}
//	und jetzt der ganze Rest:
	$arr = array_diff_key($card, $Label);
	foreach($arr as $key=>$val) {
		echo txtInput($key,$key,$val);
	}
	echo '<input type="hidden" name="UID" value="'.$card['UID'].'">';
	echo '<input type="hidden" name="VCFile" value="'.$MyFile.'">';
	echo '<input type="hidden" name="AdrBook" value="'.$AdrBook.'">';
	// Derzeit keine Bearbeitung, aber damit die Daten nicht verloren gehen:
	foreach ($pkey as $key=>$val) {
		echo '<input type="hidden" name="KEYKEY['.$nr.']" value="'.$key.'">';
		echo '<input type="hidden" name="KEYVAL['.$nr.']" value="'.$val.'">';
		$nr++;
	}
	foreach ($snd as $key=>$val) {
		echo '<input type="hidden" name="SOUNDKEY['.$nr.']" value="'.$key.'">';
		echo '<input type="hidden" name="SOUNDVAL['.$nr.']" value="'.$val.'">';
		$nr++;
	}
	echo "</div></fieldset>\n";

	$CanSave = true;
} else {
	echo '<p class="error">Kann vCard '.$clf.$MyFile.' nicht finden.</p>';
	$CanSave = false;
}

echo "<fieldset>\n";
if ($CanSave) {
?>
<label></label><input type="submit" name="wegmit" value="Löschen"><br>
<label></label><input type="submit" name="wegmit" value="Speichern"><br>
<?php } ?>
<label></label><input type="button" value="Fenster schließen" onclick="closecard();"><br>
</fieldset></form>