<?php
$Plugin = 'Listen';
$MyPlugin = "$MyPlugins/$Plugin/";	// Dieser Plugin-Ordner

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = "$MyPlugData/$Plugin/";

// Get the data and configuration:
$ldb = new SQLite3($MyPluginDataFolder.'DB.db');	// Plugin-Datenbank, gleich öffnen
include $MyPluginDataFolder.'config.php';			// Plugin-Konfigurationsdatei, gleich lesen -> nur wegen $Items (und CalList...)

$strAuswahl = '<p>Sie müssen erst eine Liste auswählen.</p>';

// ---------------------------------------------------------
function textStat($R0,$R1) {
	global $strStat;
	$s = $R0.$R1;
	switch ($s) {
		case 99: $x = 'Neuer Eintrag'; break;
		case 98: $x = 'Textänderungen'; break;
		default: $x = $strStat[$R0].' -> '.$strStat[$R1];
	}
	return $x;
}
function AllowedChangers($R0,$R1) {
	global $WIBcmsRole,$Roles;
	$s = $R0.$R1;
	$x = textStat($R0,$R1);
	echo "<tr><td>$x</td><td>";
	if ($s=='99') {
		echo '<input type="hidden" id="C99"></td><td><input type="hidden" id="O99';
	} else {
		echo "Ersteller ".'<input type="checkbox" id="C'.$s.'" name="C'.$s.'"></td><td>Verantwortliche(r) <input type="checkbox" id="O'.$s.'" name="O'.$s;
	}
	echo '"></td><td><select id="U'.$s.'" name="U'.$s.'">';
	echo txtOption(0,'keine Benutzergruppe');
	foreach ($WIBcmsRole as $nr=>$Role) { if ($nr>0) echo txtOption($nr,$Role); }
	echo '</select></td><td><select id="R'.$s.'" name="R'.$s.'">';
	echo txtOption(0,'keine Mitarbeiter-Rolle');
	foreach ($Roles as $Role) { echo txtOption($Role,$Role); }
	echo "</select></td></tr>\n";
}
function Recipients($R0,$R1) {
	$s = $R0.$R1;
	$x = textStat($R0,$R1);
	echo "<tr><td>$x</td><td>Ersteller ".'<input type="checkbox" id="E'.$s.'" name="E'.$s.'"></td><td>Verantwortliche(r) <input type="checkbox" id="V'.$s.'" name="V'.$s;
	echo '"></td><td>Auditor(en) <input type="checkbox" id="A'.$s.'" name="A'."$s\"></td></tr>\n";
}

// ---------------------------------------------------------

formkopf("Hier konfigurieren Sie das $Plugin-Plugin");
echo '<div class="configmenu"><span id="Config0">Listen</span><span id="Config1">Personen/Rechte</span><span id="Config2">Darstellung</span><span id="Config3">Listenspalten</span><span id="Config4">Benachrichtigungen</span></div>';

/*	Auswahl der Liste in jedem Tab:
echo "<fieldset>\n";
$sql = 'SELECT ID,Name FROM Lists';
$List = $ldb->query($sql);
startSelect('Liste','Auswahlliste','onchange="idx=this.options[this.selectedIndex];if (idx.value>=0) oeffne(\'Plugin:Listen\',idx.value,0)"');
echo txtOption(-1,'Bitte auswählen');
while ($Lib = $List->fetchArray()) {
	echo txtOption($Lib[0],$Lib[1],$parm);
}
echo txtOption(0,'Neue Auswahlliste',$parm);
echo "</select><br></fieldset>\n";
*/

// ----- Alle Listen: ----------------------------------

// für die Listenauswahl:
$s = txtOption(0,'Bitte Liste wählen');
$fs = $cs = '';
$Listen = '';

$res = $ldb->query('SELECT * FROM Lists');
while ($rs = $res->fetchArray()) {
	$nr = $rs[0];
	$Listen.= '<label for="Name['.$nr.']">Liste '.$nr.'</label><input type="text" id="Name['.$nr.']" name="Name['.$nr.']" value="'.$rs[1].'" required><br>'."\n";

//	wir sammeln sogleich alle Daten für die Listenauswahl:
	$s .= txtOption($nr,$rs[1]);
	echo '<div class="helper" id="sS'.$nr.'">'.$rs[2].'</div>';
	echo '<div class="helper" id="bg'.$nr.'">'.$rs[3].'</div>';
	echo '<div class="helper" id="TF'.$nr.'">'.$rs[4].'</div>';
	echo '<div class="helper" id="sb'.$nr.'">'.abs($rs[5]).'</div>';
	echo '<div class="helper" id="ad'.$nr.'">'.($rs[5]>0 ? 1:-1).'</div>';
	echo '<div class="helper" id="iC'.$nr.'">'.$rs[9].'-'.$rs[6].'</div>';
	echo '<div class="helper" id="CT'.$nr.'">'.$rs[7].'</div>';
	echo '<div class="helper" id="FA'.$nr.'">'.$rs[10].'</div>';
	$sql = "SELECT Type,Field,Name FROM Desc WHERE ListID=$nr";
	$rec = $ldb->query($sql);
	while ($rr = $rec->fetchArray()) {
		$Type = $rr[0];
		$i = $rr[1];
		echo '<div class="helper" id="'.$Type.$i.$nr.'">'.$rr[2].'</div>';
		$fs .= "fv('$Type$i',n);";
		$cs .= "cv('$Type$i');";
	}
	$rec = explode(';',$rs[8]); // Rights
	foreach ($rec as $rr) {
		$i = explode(':',$rr);
		$j = explode(',',$i[1]);
		$x = 'C'.$i[0]; echo '<div class="helper" id="'.$x.$nr.'">'.$j[0].'</div>'; $fs.="fc('$x',n);"; $cs.="cc('$x');";
		$x = 'O'.$i[0]; echo '<div class="helper" id="'.$x.$nr.'">'.$j[1].'</div>'; $fs.="fc('$x',n);"; $cs.="cc('$x');";
		$x = 'U'.$i[0]; echo '<div class="helper" id="'.$x.$nr.'">'.$j[2].'</div>'; $fs.="fs('$x',n);"; $cs.="cs('$x');";
		$x = 'R'.$i[0]; echo '<div class="helper" id="'.$x.$nr.'">'.$j[3].'</div>'; $fs.="fs('$x',n);"; $cs.="cs('$x');";
	}
	if ($rs[11]!='') {
		$rec = explode(';',$rs[11]); // Notes
		foreach ($rec as $rr) {
			$i = explode(':',$rr);
			$j = explode(',',$i[1]);
			$x = 'E'.$i[0]; echo '<div class="helper" id="'.$x.$nr.'">'.$j[0].'</div>'; $fs.="fc('$x',n);"; $cs.="cc('$x');";
			$x = 'V'.$i[0]; echo '<div class="helper" id="'.$x.$nr.'">'.$j[1].'</div>'; $fs.="fc('$x',n);"; $cs.="cc('$x');";
			$x = 'A'.$i[0]; echo '<div class="helper" id="'.$x.$nr.'">'.$j[2].'</div>'; $fs.="fc('$x',n);"; $cs.="cc('$x');";
		}
	}
}


echo "<fieldset>\n";
// Liste wählen:
$x = "n=this.value; if(n==0){cv('sS');cv('bg');cv('TF');cs('sb');cs('ad');cs('FA');cs('iC');cv('CT');$cs} else{fv('sS',n);fv('bg',n);fv('TF',n);fs('sb',n);fs('ad',n);fs('FA',n);fs('iC',n);fv('CT',n);$fs}";
echo '<label>Liste</label><select name="Liste" onchange="'.$x.'">';
echo $s;
echo "</select><br></fieldset>\n";

// ----- Config 0 (Listen) ----------------------------------
echo '<div id="divConfig0" class="helper">'."<fieldset><legend>Listen</legend>\n";
echo $Listen;
echo '<label for="NewList">Neue Liste</label><input type="text" id="NewList" name="NewList" value=""><br>'."\n";

echo "</fieldset></div>\n";

// ----- Config 1 (Personen) ----------------------------------
echo '<div id="divConfig1" class="helper"><fieldset><legend>Rollen von MitarbeiterInnen</legend>'."\n";
if ($parm<0) {
	echo $strAuswahl;
} else {
//	experimental:
	$ShowRoles = 'all';
	$MyPluginRole = 'TDL';
	$MayEditRoles = false;	// except - of course - the plugin role
	$MayAddRole = true;		// or depending on if a new role already exists

	include 'personroles.php';

	echo "</fieldset><fieldset><legend>Rechte setzen</legend>\n";
	echo '<table style="border:none">';
	AllowedChangers(9,9);
	AllowedChangers(9,8);
	AllowedChangers(0,1);
	AllowedChangers(1,2);
	AllowedChangers(2,3);
	echo "</table>\n";
}
echo "</fieldset></div>\n";

// ----- Config 2 (Darstellung) ----------------------------------
echo '<div id="divConfig2" class="helper">';
echo "<fieldset><legend>Prioritäten</legend>\n";
echo "<small>0:niedrig, 1:mittel, 2:hoch / jeweils Kurzbezeichnung (für die Tabellenanzeige) und Erläuterung<br></small><br>\n";
for($i=0; $i<3; $i++) {
	echo '<label for="EP">Priorität '.$i.'</label><input type="text" name="SP'.$i.'" id="SP'.$i.'"><input type="text" name="EP'.$i.'" id="EP'.$i.'"><br>';
}
echo "</fieldset><fieldset><legend>Status</legend>\n";
echo txtInput('sS','Status Name');
echo txtInput('bg','Status Farbe');

echo "</fieldset><fieldset><legend>Filter beim erstmaligen Aufruf der Seite</legend>\n";
startSelect('FA','Anzeige');
echo txtOption(0,'Alle Maßnahmen ohne Filter');
echo txtOption(1,'Nur nicht abgeschlossene Maßnahmen');
echo txtOption(2,'Nur abgeschlossene Maßnahmen');
echo "</select> <br>\n";
echo "</fieldset></div>\n";

// ----- Config 3 (Benennung) ----------------------------------
echo '<div id="divConfig3" class="helper">';
echo "<fieldset><legend>Benennung der Listen-Spalten</legend>\n";
// erst mal Daten sammeln:
foreach($Items as $nr=>$Item) {
	echo txtInput('H'.$nr,"($nr) $Item");
}
echo "</fieldset><fieldset><legend>Listenanzeige auf der Seite</legend>\n";
echo txtInput('TF','Felder/Folge');
startSelect('sb','Sortierung');
echo txtOption(99,'Bitte wählen');
foreach($Items as $nr=>$Item) {
	echo txtOption($nr,$Item);
}
echo '</select> <select id="ad" name="ad"><option value="1">aufsteigend</option><option value="-1">absteigend</option></select><br>';
echo "</fieldset></div>\n";

// ----- Config 4 (Benachrichtigungen) ----------------------------------
echo '<div id="divConfig4" class="helper"><fieldset>';
echo "<legend>Kalendereinträge (nur bei installiertem iCal- oder SynoCal-Plugin)</legend>\n";
$iCalYes = is_dir("$MyPlugins/iCal");
$SynoYes = is_dir("$MyPlugins/SynoCal");
if ($iCalYes || $SynoYes) {
	startSelect('iC','Kalender');
	echo txtOption('0-0','keinen Kalender verwenden');
	if ($iCalYes) {
		$cdb = new SQLite3('../data/plugins/iCal/DB.db');
		$res = $cdb->query('SELECT ID,Name FROM Calendars');
		while ($rs = $res->fetchArray()) {
			echo txtOption('iCal-'.$rs[0],'iCal: '.$rs[1]);
		}
	}
	if ($SynoYes) {
		$cdb = new SQLite3('../data/plugins/SynoCal/DB.db');
		$res = $cdb->query('SELECT ID,Name FROM Calendars');
		while ($rs = $res->fetchArray()) {
			echo txtOption('Syno-'.$rs[0],'SynoCal: '.$rs[1]);
		}
	}
	echo "</select> In welchen Kalender soll ein neuer Eintrag aufgenommen werden?<br>\n";
	echo txtInput('CT','Zeitsteuerungen');
} else {
	echo "<p>Das iCal- oder SynoCal-Plugin ist nicht installiert</p>\n";
	echo '<input type="hidden" id="iC" name="iC" value="0-0"><input type="hidden" id="CT" name="CT" value="">';
}

echo "</fieldset><fieldset><legend>E-Mails</legend>\n";
echo '<table style="border:none">';
Recipients(9,9);
Recipients(9,8);
Recipients(0,1);
Recipients(1,2);
Recipients(2,3);
echo "</table></fieldset></div>\n" . formsave('Plugin',$Plugin);
?>