<?php
/* It's a good practice to define the name of the plugin.
You may use the name thereafter so the expressions will be the same in any plugin.
*/
$Plugin = 'Demo';
$MyPlugin = "$MyPlugins/$Plugin/";	// This plugin folder

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = "../data/plugins/$Plugin/";	// CAVE: edit.php is called inside the core folder!
$DemoConfigFile = $MyPluginDataFolder.'config.php';

/* Use this function at the start of your plugins edit.php:
function formkopf($titel, $legend='', $right=1)
If $legend is not specified or an empty string, no fieldset is opened (and thus is not to be closed).
But of cause you may use fieldsets and legends of your own choice.
If $right is not true the user may not edit this plugin.
*/
formkopf('Hier konfigurieren Sie das Demo-Plugin');

/* You may want to use several tabs to open specific, organized edit functions.
Therfore you may use up to 10 tabs named Config0 to Config9.
These names are corresponding to the same names in help.php, where different help texts may appear for each tab.
If you do not need any tabs, you may discard the whole next line beginning with <div> and ending with </div>.
*/
echo '<div class="configmenu"><span id="Config0">Konfiguration</span><span id="Config1">Personen/Rechte</span><span id="Config2">Darstellung</span><span id="Config3">Listenspalten</span><span id="Config4">Benachrichtigungen</span></div>';

// Now begin with the first tab. It begins with the appropriate <div> tag with these id and class
echo '<div id="divConfig0" class="helper">';
echo "<fieldset><legend>Demo-Konfiguration</legend>\n";

if (is_file($DemoConfigFile)) {
	$Demotitel = file_get_contents($DemoConfigFile);
} else {
	$Demotitel = '';
}

$DemoDB = new SQLite3($MyPluginDataFolder.'DB.db');
$sql = "CREATE TABLE IF NOT EXISTS 'Demo' ('ID' INTEGER PRIMARY KEY AUTOINCREMENT, 'Text' TEXT)";
$OK  = $DemoDB->exec($sql);
$sql = "SELECT Text FROM Demo WHERE ID=1";
$Demotext = $DemoDB->querySingle($sql);
if (empty($Demotext)) {
	$OK = $DemoDB->exec("INSERT INTO Demo ('Text') VALUES ('Text')");
}

?>
<p>Fügen Sie einfach geeigneten HTML- oder PHP-Code in der 'edit.php' hinzu, um zum Beispiel Formularfelder zu erzeugen für Werte, 
die Sie anschließend in der 'save.php'-Datei verarbeiten und in einer Datei oder Datenbank im entsprechenden data/plugins-Verzeichnis speichern können.</p>
</fieldset><fieldset><legend>Nur zum Test</legend>
<label for="Demotitel">Bildunterschrift</label>
<input type="text" name="Demotitel" id="Demotitel" value="<?= $Demotitel ?>"> Geben Sie dem Bild eine Unterschrift<br>
<label for="Demotext">Demotext</label>
<input type="text" name="Demotext" id="Demotext" value="<?= $Demotext ?>"> Geben Sie dem Bild eine zusätzliche Beschreibung<br>
</div>
<div id="divConfig1" class="helper">
<fieldset><legend>Rechtevergabe</legend>
<p>Sie können die Berechtigungseinstellungen des WIBcms einbinden und (falls erforderlich) zusätzliche Rollen definieren.<br>
Dieser Tab wurde nur zur Veranschaulichung aufgenommen, es werden keine Änderungen gespeichert.</p>
<?php
include 'personroles.php';
?>
</fieldset>
</div>
<div id="divConfig2" class="helper">
<fieldset><legend>Nur zur Demo</legend>
<p>Diese Seite wurde nur zu Demonstrationszwecken aufgenommen,<br>um die Funktionsweise der Tabs zu zeigen.</p>
</fieldset>
</div>
<div id="divConfig3" class="helper">
<fieldset><legend>Nur zur Demo</legend>
<p>Diese Seite wurde nur zu Demonstrationszwecken aufgenommen,<br>um die Funktionsweise der Tabs zu zeigen.</p>
</fieldset>
</div>
<div id="divConfig4" class="helper">
<fieldset><legend>Nur zur Demo</legend>
<p>Diese Seite wurde nur zu Demonstrationszwecken aufgenommen,<br>um die Funktionsweise der Tabs zu zeigen.</p>
</fieldset>
</div>
<?php
/* This should be the last line in edit.php:
It closes the last fieldset and displays the area beneath with the two buttons to save the entries or to close the window.
Beware:
If you use tabs, the last tab must also be closed...
*/
echo "</div></fieldset>\n" . formsave('Plugin',$Plugin);
?>