<?php
$MyPlugin = $MyPlugins . "/Absence/";

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = $MyPlugData . '/Absence/';

// Get the data and configuration:
$adb = new SQLite3($MyPluginDataFolder.'DB.db');
include $MyPluginDataFolder.'config.php';

// Dependencies:
$odb = new SQLite3("$MyPlugData/Orga/DB.db");
include "$MyPlugData/Orga/config.php";

// #######################################################################
// Einige Funktionen:
function DatumSelect($for,$label,$comment,$js='') {
	echo "<label for=\"$for\">$label</label><input type=\"date\" id=\"$for\" name=\"$for\" $js> $comment<br>\n";
}

function TableHead($Typ) {
	global $DaysMon,$Scaling;
	if ($Typ>0) {
		$strMon = ['Monat','Januar','Februar','März','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember'];
		$shortM = ['Mon','Jan','Feb','März','Apr','Mai','Juni','Juli','Aug','Sep','Okt','Nov','Dez'];

		echo '<thead><tr class="kopf"><th class="name">Name</th>';
		for ($i=1; $i<13; $i++) {
			$width = $DaysMon[$i]*$Scaling;
			switch ($Typ) {
				case 1: echo "<th width=\"$width\"> $i </th>"; break;
				case 2: echo "<th width=\"$width\"> $shortM[$i] </th>"; break;
				case 3: echo "<th width=\"$width\"> $strMon[$i] </th>"; break;
			}
		}
		echo "</tr></thead>\n";
	}
}

function shortenName($Name) {
	$p = strpos($Name,' ');
	$SName = $Name[0].'.&nbsp;'.substr($Name,$p+1);
	return str_replace('-','&#8209;',$SName);
}

// Konstante Bezeichner:
// $strdd = ['Mo','Di','Mi','Do','Fr','Sa','So'];
// $strDD = ['Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag','Sonntag'];

$SecPerDay = 60*60*24;

$UserID = $WebStat ? $_SESSION['UserID'] : 0;

// #######################################################################
// Einstellungen einlesen:

// Abwesenheitsgründe:
$sql = "SELECT * FROM AbsenceTypes ORDER BY Folge";
$res = $adb->query($sql);
while ($rs = $res->fetchArray()) {
	$AbsenceType[$rs['ID']] = $rs['Name'];
	$AbsenceGrafix[$rs['ID']] = $rs['Grafix'];
}
$AbsenceType[99] = 'anwesend';
$AbsenceGrafix[99] = 'green.gif';

// allgemeine Version, listet alle Berechtigungen (egal wie viele es gibt und wie sie heißen):
$Roles = $db->query('SELECT Role,Users FROM Roles');
while ($Users = $Roles->fetchArray()) {
	$strUsers[$Users['Role']] = $Users['Users'];
	$arrUsers[$Users['Role']] = explode(',',$Users['Users']);
}

// Liste aller User, die MitarbeiterInnen sind:
$sql = 'SELECT ID,Name,RealName FROM Users WHERE ID IN ('.$strUsers['Staff'].') ORDER BY Name';
$res = $db->query($sql);
while ($rs = $res->fetchArray()) {
	$Name = empty($rs['RealName']) ? $rs['Name'] : $rs['RealName'];
	$Person[$rs['ID']] = $Name;
}

// Liste aller User, für die ich Prozesseigner bin:
$MySubalterns = [];
$sql = "SELECT ID,Actor FROM Activities WHERE ProcID IN (SELECT ID FROM Orga WHERE Owner=$UserID)";
$res = $odb->query($sql);
while ($rs = $res->fetchArray()) {
	if ($rs[1]==999999) {	// Many Actors
		$Subs = $odb->querySingle('SELECT Actors FROM ManyActors WHERE ActID='.$rs[0]);
		$arrSub = explode(',',$Subs);
		$MySubalterns = array_merge($MySubalterns,$arrSub);
	} else {
		$MySubalterns[] = $rs[1];
	}
}
//clean up double entries:
$MySubalterns = array_unique($MySubalterns);

$MayAdmin = $WebStat && ($WebStat&1 || in_array($UserID,$arrUsers['Chef']));

// #######################################################################

// Aufrufparameter holen:
$heute = getdate();
$Jahr = $_GET['Jahr'] ?? ($_POST['Jahr'] ?? $heute['year']);
$ShowAll = $_GET['ShowAll'] ?? ($_POST['ShowAll'] ?? 0);
$todo = $_POST['todo'] ?? '';

// Ggf. Speichern:
if ($todo=='Änderung verwerfen' && $WebStat) {
	$NID = $_POST['NID'];
	$PersID = $_POST['Person'];
	$sql = "DELETE FROM Absence WHERE ID=$NID";	// echt löschen
//	oder: 	$sql = "UPDATE Absence SET Status=6 WHERE ID=$NID";	// Ablehnung merken
	$OK  = $adb->exec($sql);
	if ($OK) {
		echo '<p class="success">Änderungswunsch wurde wie gewünscht verworfen!</p>';
		$Mailto = $db->querySingle("SELECT Mail FROM Users WHERE ID=$PersID");
		trymail('Ihr Änderungswunsch im Anwesenheitsplan','Ihr Änderungswunsch wurde zurückgenommen/verworfen!',$Mailto);
	} else {
		echo '<p class="error">Änderungswunsch konnte nicht verworfen werden!</p>';
	}
} elseif ($todo=='Änderung übernehmen' && $WebStat) {
	$NID = $_POST['NID'];
	$ID  = $_POST['ID'];
	$PersID = $_POST['Person'];
	$Status = $adb->querySingle("SELECT Status FROM Absence WHERE ID=$ID");
	$sql = "UPDATE Absence SET RefID=0,Status=$Status WHERE ID=$NID";	// Änderung ist gültig, da keine Referenz mehr
	$OK  = $adb->exec($sql);
	if ($OK) {
		$sql = "DELETE FROM Absence WHERE ID=$ID";	// alten Eintrag löschen
		$OK  = $adb->exec($sql);
	}
	if ($OK) {
		echo '<p class="success">Änderungswunsch wurde wie gewünscht übernommen!</p>';
		$Mailto = $db->querySingle("SELECT Mail FROM Users WHERE ID=$PersID");
		trymail('Ihr Änderungswunsch im Anwesenheitsplan','Ihr Änderungswunsch wurde wie gewünscht übernommen!',$Mailto);
	} else {
		echo '<p class="error">Änderungswunsch konnte nicht übernommen werden!</p>';
	}
} elseif ($todo=='Speichern' && $WebStat) {
	$PersID = $_POST['Person'] ?? 0;
	$Beginn = $_POST['Beginn'];
	$Ende   = $_POST['Ende'];
	$Grund  = $_POST['Grund'];
	$Text   = $_POST['Text'];
	$Status = $_POST['Status'] ?? 0;
	$OldStat= $_POST['OldStat'] ?? 0;
	$ID  = $_POST['ID'];
	$NID = $_POST['NID'] ?? 0;	// wenn es ein NID gibt, liegt bereits ein Änderungswunsch vor

	if ($PersID>0 and $Beginn!='' and $Ende!='' and $Grund>0) {
		$TS_Beginn = strtotime($Beginn);
		$TS_Ende   = strtotime($Ende);
		$dateBeginn= date('d.m.Y',$TS_Beginn);
		$dateEnde  = date('d.m.Y',$TS_Ende);
		$now = time();
		$MyAddress = dirname($_SERVER['HTTP_REFERER']).'/'.$u.$mypage;

		if ($TS_Beginn > $TS_Ende) {
		//	Datum plausibel?
			echo "<p class=\"error\">Das Endedatum ($dateEnde) liegt vor dem Beginndatum ($dateBeginn) - das kann ja wohl nicht stimmen!</p>";
		} else {
			if ($Status>3) {
			// Änderung gewünscht -> Kopie anlegen! => aber nur beim ersten Mal!
				if ($NID==0) {
					$sql = "INSERT INTO Absence (PersonID,Beginn,Ende,Grund,Status,Text,RefID,Creator,Created) VALUES ($PersID, $TS_Beginn, $TS_Ende, $Grund, $Status, '$Text', $ID, $UserID, $now)";
					$Message = "Für folgende Abwesenheit wurde soeben eine Änderung gewünscht:\r\n\r\n";
				} else {
					$sql = "UPDATE Absence SET PersonID=$PersID, Beginn=$TS_Beginn, Ende=$TS_Ende, Grund=$Grund, Status=$Status, Text='$Text', Changer=$UserID, Changed=$now WHERE ID=$NID";
					$Message = "Folgender Änderungswunsch im Anwesenheitsplan wurde erneut geändert:\r\n\r\n";
				}
				$OK = $adb->exec($sql);
				if ($OK) {
					echo '<p class="success">Änderungswunsch zur Abwesenheitszeit wurde gespeichert!</p>';
					$sql = "SELECT * FROM Absence WHERE ID=$ID";	// die bisherigen Angaben
					$res = $adb->query($sql);
					$Old = $res->fetchArray();
					$Message .= "Person: ".$Person[$PersID]."\r\n".
					"Beginn: ".date('d.m.Y',$TS_Beginn)." (bisher: ".date('d.m.Y',$Old['Beginn']).")\r\n".
					"Ende  : ".date('d.m.Y',$TS_Ende)." (bisher: ".date('d.m.Y',$Old['Ende']).")\r\n".
					"Grund : ".$AbsenceType[$Grund]." (bisher: ".$AbsenceType[$Old['Grund']].")\r\n".
					"Kommentar: $Text"."\r\n (bisher: ".$Old['Text'].")\r\n".
					"Status: ".$strStatus[$Status]." (bisher: ".$strStatus[$Old['Status']].")\r\n\r\n".
					"Bearbeitung im Intranet: $MyAddress \r\n";
					trymail('Änderungswunsch Abwesenheitszeit',$Message);
				} else {
					echo '<p class="error">Änderungswunsch wurde NICHT gespeichert!</p>';
				}
			} else {
			//	Überlappung?
				$sql = "SELECT Grund FROM Absence WHERE PersonID=$PersID AND ID NOT IN ($ID,$NID) AND ((Beginn Between $TS_Beginn AND $TS_Ende) OR(Ende Between $TS_Beginn AND $TS_Ende))";
				$Collision = $adb->querySingle($sql);

				if (empty($Collision)) {
					if ($ID == 0) {
					//	Neuer Eintrag:
						$sql = "INSERT INTO Absence (PersonID,Beginn,Ende,Grund,Status,Text,Creator,Created) VALUES ($PersID, $TS_Beginn, $TS_Ende, $Grund, $Status, '$Text', $UserID, $now)";
						$Message = "Folgende Abwesenheitszeit wurde soeben im Intranet eingetragen:\r\n\r\n";
					} else {
					//	Bestehenden Eintrag direkt aktualisieren:
						$sql = "UPDATE Absence SET PersonID=$PersID, Beginn=$TS_Beginn, Ende=$TS_Ende, Grund=$Grund, Status=$Status, Text='$Text', Changer=$UserID, Changed=$now WHERE ID=$ID";
						$Message = "Folgende Abwesenheit wurde soeben im Intranet geändert:\r\n\r\n";
					}
					$OK = $adb->exec($sql);
					if ($OK) {
						echo '<p class="success">Angaben zur Abwesenheitszeit wurden gespeichert!</p>';
						$Message .= "Person: ".$Person[$PersID]."\r\n".
						"Beginn: ".date('d.m.Y',$TS_Beginn)."\r\n".
						"Ende  : ".date('d.m.Y',$TS_Ende)."\r\n".
						"Grund : ".$AbsenceType[$Grund]."\r\n".
						"Kommentar: $Text\r\n".
						"Status: ".$strStatus[$Status]."\r\n\r\n".
						"Bearbeitung im Intranet: $MyAddress \r\n";
						trymail('Neue/geänderte Abwesenheitszeit',$Message);
						if ($Status>1) {	// bestätigt/abgelehnt
							$Mailto = $db->querySingle("SELECT Mail FROM Users WHERE ID=$PersID");
							trymail("Ihre geplante Abwesenheit wurde bearbeitet",$Message,$Mailto);
						}
					} else {
						echo '<p class="error">Abwesenheit wurde NICHT gespeichert!</p>';
					}
				} else {
					echo "<p class=\"error\">Im gewählten Zeitraum ($dateBeginn - $dateEnde) ist für $Person[$PersID] bereits eine Abwesenheit ($AbsenceType[$Collision]) eingetragen!</p>";
				}
			}
		}
	} else {
		echo '<p class="error">Sie haben nicht alle Eingabefelder ausgefüllt!</p>';
/*			echo "Person: ".$Person[$PersID]."<br>\n";
			echo "Beginn: ".date('d.m.Y',$TS_Beginn)." ($Beginn) <br>\n";
			echo "Ende&nbsp; : ".date('d.m.Y',$TS_Ende)." ($Ende)<br>\n";
			echo "Grund: ".$AbsenceType[$Grund]."<br>\n";
			echo "Status alt: ".$strStatus[$OldStat]."<br>\n";
			echo "Status neu: ".$strStatus[$Status]."<br>\n";	*/
	}
} else {
	if ($WebStat) {
		echo '<p class="neutral">Hier können Sie An- und Abwesenheitszeiten erfassen und bearbeiten.</p>';
	} else {
		echo '<p class="neutral">Um An- und Abwesenheitszeiten erfassen und bearbeiten zu können, müssen Sie angemeldet sein.</p>';
	}
}

// #######################################################################

// Planzeitraum:
$DaysMon = [0,31,28,31,30,31,30,31,31,30,31,30,31];
$isSchaltjahr = (($Jahr%4)==0);
if ($isSchaltjahr) {$DaysMon[2]=29;}

$TabStart = strtotime("$Jahr-01-01");
$TabEnde  = strtotime("$Jahr-12-31");

// ANZEIGE:
echo '<h2>Anwesenheiten - Planzeitraum: <a class="jahr" href="'.$u.$mypage.'&Jahr='. ($Jahr-1) .'&ShowAll='.$ShowAll.'" title="1 Jahr zurück"> &lt; </a> '.date('d.m.Y',$TabStart)." bis ".date('d.m.Y',$TabEnde).' <a class="jahr" href="?'.$mypage.'&Jahr='. ($Jahr+1) .'&ShowAll='.$ShowAll.'" title="1 Jahr vor"> &gt; </a></h2>';

// Kopfzeile:
echo '<br><table class="timetable">'."\n";
TableHead($TabHead);

// Alle Zeiten oder nur bestätigte:
$ShowType = $ShowAll ? '' : 'AND Status IN (0,1,2)';

// Je Person eine Zeitleiste über 12 Monate:
foreach($Person as $ID=>$Name) {
	$DO = in_array($ID,$MySubalterns) AND ($ProcOwnerMayQualiAct>0);
	$MayChange = $MayAdmin || ($UserID==$ID) || $DO;
	$IsTage = in_array($ID,$arrUsers['Tage']);
	$presence = $IsTage ? '"tage"' : '"voll"';
	$ocname = $MayChange ? ' edit" onclick="detedit(0,'.$ID.')"' : '"';
	echo "<tr class=$presence><th class=\"name$ocname>$Name</th>";
	for ($i=1; $i<13; $i++) {
		$MonStart = strtotime("$Jahr-$i-01");
		$MonEnde  = strtotime("$Jahr-$i-$DaysMon[$i]");
		$Zeiten = '';
//		$sql = "SELECT * FROM Absence WHERE PersonID=$ID AND ((Ende BETWEEN $MonStart AND $MonEnde) OR (Beginn BETWEEN $MonStart AND $MonEnde) OR (Beginn<$MonStart AND Ende>$MonEnde)) $ShowType ORDER BY Beginn";
		$sql = "SELECT * FROM Absence WHERE PersonID=$ID AND ((Ende>=$MonStart AND Ende<$MonEnde) OR (Beginn>=$MonStart AND Beginn<$MonEnde) OR (Beginn<$MonStart AND Ende>=$MonEnde)) $ShowType ORDER BY Beginn";
		$res = $adb->query($sql);
		$SecsToEnd = 0;
		while ($zeit = $res->fetchArray()) {
			$SecsToStart = max($SecsToEnd, $zeit['Beginn']-$MonStart);
			$DaysToStart = ($SecsToStart - $SecsToEnd)/$SecPerDay;
			$SecsToEnd   = min($MonEnde, $zeit['Ende']) - $MonStart + $SecPerDay;
			$DaysToEnd   = 1+$SecsToEnd/$SecPerDay;
			$NumberOfDays= ($SecsToEnd-$SecsToStart)/$SecPerDay;

//		schauen, ob Änderungswunsch vorliegt:
			$Request = $adb->querySingle("SELECT ID,Beginn,Ende,Grund,Text FROM Absence WHERE RefID=".$zeit['ID'],1);
			$strRequest = empty($Request) ? '' : ', aber Änderung gewünscht!';

			$onClick = $MayChange ? ' onclick="detedit('.$zeit['ID'].','.$ID.')">' : '>';

			$Zeiten .= '<img class="zeit" src="'.$MyPlugin.'symbols/'.$AbsenceGrafix[$zeit['Grund']].'" style="width:'.$NumberOfDays*$Scaling.'px; margin-left:'.$DaysToStart*$Scaling.'px;" title="'.$AbsenceType[$zeit['Grund']].' vom '.date('d.m.Y',$zeit['Beginn']) . ' - ' . date('d.m.Y',$zeit['Ende']).' ('.$strStatus[$zeit['Status']].$strRequest.')"'.$onClick;
//			$Zeiten .= $DaysToStart . '/' . $DaysToEnd;
		}
		echo "<td class=\"small\">$Zeiten</td>";
	}
	echo "</tr>\n";
}

// Fußzeile:
TableHead($TabFoot);
echo "</table>";

// Hilfetext:
if ($ShowAll) {
	echo '<p class="help"><br>Hier werden sämtliche, auch unbestätigte Abwesenheitszeiten angezeigt. Sie können die Anzeige einschränken auf die effektiven Abwesenheiten. Klick: <a href="'.$u.$mypage.'&Jahr='.$Jahr.'&ShowAll=0">Anzeige einschränken</a>';
} else {
	echo '<p class="help"><br>Hier werden nur beantragte oder bestätigte Abwesenheitszeiten angezeigt. Sie können aber auch zusätzlich nicht bestätigte Zeiten anzeigen lassen. Klick: <a href="'.$u.$mypage.'&Jahr='.$Jahr.'&ShowAll=1">Alles anzeigen</a>';
}
echo '<br>Details zu den Abwesenheitsgründen erfahren Sie, wenn Sie die Maus über die eingetragene geplante Abwesenheit bewegen.</p>';
if ($WebStat) {
// Eingabeformular für die Abwesenheitszeiten:
	echo '<form id="time" method="POST" accept-charset="utf-8">'."\n";
	echo '<fieldset id="editform" style="position:relative;"><legend id="legend">Neue An-/Abwesenheitszeit erfassen</legend>';
?>
	Sie können eine <b>neue Abwesenheit planen</b>, wenn Sie den Namen in der ersten Spalte anklicken.<br>
	Sie können eine <b>geplante Abwesenheit bearbeiten</b>, wenn Sie auf die eingetragene Abwesenheit klicken.<br>
	Mitglieder der GL dürfen alle Angaben erfassen und ändern, Mitarbeiter nur eigene Abwesenheiten <?= $ProcOwnerMayQualiAct ? '(oder die ihrer Prozessausführenden) ':'' ?>beantragen oder korrigieren.</p>
<?php
	echo '</fieldset><input type="hidden" name="ShowAll" value="'.$ShowAll.'"><input type="hidden" name="Jahr" value="'.$Jahr.'">'."</form>\n";
}
echo "<fieldset><legend>Legende</legend>\n<table><tr>";
$i=0;
foreach($AbsenceType as $ID=>$Name) {
	if ($i==$Legende) {
		$i=0;
		echo "</tr>\n<tr>";
	}
	echo '<td> <img class="zeit" style="width:9px" src="'.$MyPlugin.'symbols/'."$AbsenceGrafix[$ID]\"> $Name &nbsp; </td>\n";
	$i++;
}
while ($i<$Legende) {$i++; echo '<td></td>';}
echo "</tr></table>\n</fieldset>\n";

$MySideText='';	// damit Infobox verschwindet (Breite benötigt!) s. u.: Breite für form, table, Position von Request...

if ($TabWidth || $FormWidth) {
	echo "<style>\n". ($TabWidth ? "	table.timetable {width:$TabWidth px;}\n" : '') . ($FormWidth ? "	form#time {width:$FormWidth px;}\n" : '') . "</style>\n";
}
?>

<script>
function datetest(id,value) {
	d = document.getElementById(id);
	if (d.value == '') {
		d.value = value;
	}
}
function detedit(item1,item2) {
	Details = new XMLHttpRequest();
	url = 'plugins/Absence/detedit.php?item1='+item1+'&item2='+item2;
	Details.addEventListener('load',function(event){
		if (Details.readyState == 4) {
			strResponse = Details.responseText;
			document.getElementById('editform').innerHTML = strResponse;
			document.getElementById('editform').style.display = 'block';
		}
	});
	Details.open('GET',url);
	Details.send();
}
</script>