<?php
/* use this function at the start of your plugins edit.php:
function formkopf($titel, $legend='', $right=1)
If $legend is not specified, no fieldset is opened (and thus is not to be closed).
But of cause you may use fieldsets and legends of your own choice.
If $right is not true (1) the user may not edit this plugin.
*/
$Plugin = 'Absence';
$MyPlugin = "$MyPlugins/$Plugin/";	// Dieser Plugin-Ordner

// Folder in which the data for this plugin are stored:
$MyPluginDataFolder = "$MyPlugData/$Plugin/";

// Get the data and configuration:
$adb = new SQLite3($MyPluginDataFolder.'DB.db');	// Plugin-Datenbank, gleich öffnen
include $MyPluginDataFolder.'config.php';			// Plugin-Konfigurationsdatei, gleich lesen

function TabKopfSelect($Feld,$Label,$Value) {
	startSelect($Feld,$Label);
	echo txtOption (0,'keine Anzeige',$Value);
	echo txtOption (1,'Monat als Zahl',$Value);
	echo txtOption (2,'kurze Monatsnamen',$Value);
	echo txtOption (3,'lange Monatsnamen',$Value);
	echo "</select> <br>\n";
}

$todo = $_GET['todo'] ?? '';
if ($todo=="sort") {
	$ID = $_GET['id'];
	$to = $_GET['to'];
//	echo "ID=$ID / to=$to<br>\n";
	$Folge= $adb->querySingle("SELECT Folge FROM AbsenceTypes WHERE ID=$ID");
	Sortiere($ID,$to,"AbsenceTypes","ID>0",$Folge,$adb);
}

formkopf("Hier konfigurieren Sie das $Plugin-Plugin");
echo '<div class="configmenu"><span id="Config0">Bezeichnungen</span><span id="Config1">Personen/Rechte</span><span id="Config2">Darstellung</span></div>';

// ----- Config 0 (Bezeichnungen) ----------------------------------
echo '<div id="divConfig0" class="helper">'.
	"<fieldset><legend>Abwesenheitsgründe</legend>\n";

echo '<div style="float:right; width:40%">';
$dir = array_diff(scandir($MyPlugin."/symbols/"),['.','..','@eaDir']);
foreach ($dir as $file) {
	echo '<img class="zeit" style="width:9px" src="'.substr($MyPlugin,3)."symbols/$file\"> $file<br>\n";
}
echo "</div>\n";

// für die Sortierfunktion:
$clicksort="<span class=\"cursor\" onclick=\"oeffne('Plugin:Absence','0&todo=sort&id=";
$Anzahl  = $adb->querySingle("SELECT COUNT(ID) FROM AbsenceTypes");

// Abwesenheitsgründe in Tabelle anzeigen:
echo "<table>\n";
echo "<tr><th colspan=\"2\">Folge</th><th>Anzahl</th><th>Bezeichnung</th><th>Grafik</td></tr>\n";
$sql = "SELECT AT.ID AS ID, AT.Name AS Name, AT.Grafix AS Grafix, COUNT(A.Grund) AS Anzahl FROM AbsenceTypes AS AT LEFT JOIN Absence AS A ON AT.ID=A.Grund GROUP BY AT.ID ORDER BY AT.Folge";
$res = $adb->query($sql);
$count = 0;
while ($rs = $res->fetchArray()) {
	$count++;
	$ID = $rs['ID'];
	echo "<tr>".ClickToSort($clicksort,$Anzahl,$count,$ID).'<td>'.$rs['Anzahl'].'</td><td><input name="Grund['.$ID.']" value="'.$rs['Name'].
		'"></td><td><img class="zeit" style="width:9px" src="'.substr($MyPlugin,3)."symbols/".$rs['Grafix'].'"> <input name="Grafix['.$ID.']" value="'.$rs['Grafix'].'">'."</td></tr>\n";
}
echo '<tr><td colspan="3">Neuer Grund</td><td><input name="Grund[0]" value=""></td><td><img class="zeit" style="width:9px" src="'.substr($MyPlugin,3).'symbols/blank.gif"> <input name="Grafix[0]" value=""></td></tr>';
echo "</table>\n";

echo "</fieldset><fieldset><legend>Status</legend>\n";
// Liste der Status:
echo "<table>\n";
echo "<tr><th>Nr.</th><th>Zustand</th><th>ändern</th><th>Änderung erlaubt für MA</th></tr>\n";
foreach ($strStatus as $ID=>$Name) {
	$allowed = ($ID<1) ? '0,1' : '4,5';
	echo "<tr><td>$ID</td><td><input name=\"strStatus[$ID]\" value=\"$Name\"></td>".
		 '<td><input name="strChange['.$ID.']" value="'.$strChange[$ID]."\"></td><td>$allowed</td></tr>\n";
}
echo "</table>\n";
echo "</fieldset></div>\n";

// ----- Config 1 (Personen) ----------------------------------
echo '<div id="divConfig1" class="helper">'.
	"<fieldset><legend>MitarbeiterInnen</legend>\n";

include 'personroles.php';

echo "</fieldset><fieldset><legend>Benachrichtigungen bei der Anwesenheitsplanung</legend>\n";
echo "<p>Nachricht erfolgt an MA, wenn:</p>\n<ul><li>Änderungswunsch übernommen oder verworfen wurde</li><li>Abwesenheitszeit bestätigt oder abgelehnt wurde</li></ul>\n";
echo "<p>Nachricht erfolgt an Chef, wenn:</p>\n<ul><li>Abwesenheitszeit zur Bestätigung vorliegt</li><li>selbst relevante Änderungen vorgenommen wurden</li></ul>\n";
echo "</fieldset></div>\n";

// ----- Config 2 (Darstellung) ----------------------------------
echo '<div id="divConfig2" class="helper">'.
	"<fieldset><legend>Übersichtstabelle</legend>\n";
TabKopfSelect('TabHead','Tabellenkopf',$TabHead);
TabKopfSelect('TabFoot','Tabellenfuß',$TabFoot);
echo '<label for="Scaling">Skalierung</label><input type="number" id="Scaling" name="Scaling" value="'.$Scaling.'" min="1" max="5" step="1"> Pixel/Tag<br>';
echo '<label for="Legende">Legende</label><input type="number" id="Legende" name="Legende" value="'.$Legende.'" min="1" max="5" step="1"> Spalten<br>';
echo '<label for="TabWidth">Tabellenbreite</label><input type="number" id="TabWidth" name="TabWidth" value="'.$TabWidth.'" min="800" max="1900" step="10"> Breite erzwingen<br>';
echo '<label for="FormWidth">Eingabebreite</label><input type="number" id="FormWidth" name="FormWidth" value="'.$FormWidth.'" min="800" max="1900" step="10"> Breite des Formulars erzwingen<br>';
echo "</fieldset><fieldset><legend>Symbole</legend>\n";
echo txtInput('newGrafic','Neues Symbol','',' Bezeichnung (ohne .gif)');
echo '<label for="Color">Farbe</label><input type="color" id="Color" name="Color"> <br>';

echo "</fieldset></div>\n" . formsave('Plugin',$Plugin);
?>