# ================================
# GifCreator
# ================================

GifCreator is a PHP class to create animated GIF from multiple images

### For what ?

This class helps you to create an animated GIF image: choose multiple images and their duration and that's it !

### Usage

**1 - Creation:**

```php
// Create an array containing file paths, resource var (initialized with imagecreatefromXXX), 
// image URLs or even binary code from image files.
// All sorted in order to appear.

$frames = array(
    imagecreatefrompng("/../images/pic1.png"), // Resource var
    "/../images/pic2.png", // Image file path
    file_get_contents("/../images/pic3.jpg"), // Binary source code
    'http://thisisafakedomain.com/images/pic4.jpg', // URL
);

// Create an array containing the duration (in 1/100 seconds) of each frames (according to $frames array)

$durations = array(40, 80, 40, 20);

// Choose the number of loops of your animated gif before it stops.
// Set 0 (zero) to get an infinite loop.

$loops = 5;

// Initialize and create the GIF !

$gc = new GifCreator();

$gc->create($frames, $durations, $loops);

// you may also get the result instantly:
$gifBinary = $gc->create($frames, $durations, $loops);
```

**2 - Get the result:**

You can get the animated GIF binary intantly by calling the create function (see above) or by distinct function:

```php
$gifBinary = $gc->getGif();
```

Then you can show it in the navigator:

```php
header('Content-type: image/gif');
header('Content-Disposition: filename="butterfly.gif"');
echo $gifBinary;
exit;
```

Or save it in a folder as a GIF:

```php
file_put_contents('/myfolder/animated_picture.gif', $gifBinary);
```

### Behavior

- The transparency is based on the first given frame. It will be saved only if you give multiple frames with same transparent background.
- The dimensions of the generated GIF are based on the first frame. If you need to resize your frames to get the same dimension, you can use 
this class: https://github.com/Sybio/ImageWorkshop

### About

The class reuses some part of code of "GIFEncoder.class.php" by László Zsidi (thanks to him).