<?php
// ####################### STEP 4: die Seite vorbereiten: ###################################
if ($IniSetSec && !isset($_SESSION)) {
	ini_set('session.cookie_httponly', 1);
	ini_set('session.cookie_secure', 1);
}
// Falls der Server sonst evtl. meckert:
date_default_timezone_set($MyTimeZone);
ini_set('date.timezone',$MyTimeZone);

// ####################### STEP 4.1: vorab einige Funktionen: ###############################
// #### Gibt den Text für die Sidebar/Infoboxen aus:
function sidetext($nr) {
	global $ticker,$UseSideTime,$ShowBoxTitle,$BoxHeadLine, $showEditSymbols,$May;
	$text = '';
	if (isset($ticker[$nr])) {
		if (!$UseSideTime || !$ticker[$nr][3] || ($ticker[$nr][4]<time() && $ticker[$nr][5]>time())) {
			$BoxHeadLine = $ticker[$nr][0];
			$text = "\n	<div class=\"BoxItem\" style=\"position:relative\">\n	".txtBoxTitle();
			$text.= '	'.$ticker[$nr][1]."\n";
			if ($showEditSymbols && $May['EditInfos'])
				$text .= '	<img class="editpagelink" src="core/grafix/text.gif" title="Diese Infobox bearbeiten" onclick="oeffne('."'infobox',$nr,0)\">\n";
			$text.= "</div>\n";
		}
	}
	return $text;
}
// #### Text für die Sidebar bei Login-Seiten:
function sidelogin() {
	global $WebStat,$u, $ShowBoxTitle,$BoxHeadLine,$PermaCookie;
	$BoxHeadLine = 'Login';
	$text = txtBoxTitle();
	$link = '<a href="'.$u.'Login&ToDo';
	if ($WebStat>0) {
		$User = $_SESSION['User'];
		$text.= "<p>Sie sind angemeldet als:<br>$User (".$_SESSION['webstatus'].")</p>\n";
		$text.= '<p>Sie können:</p>';
		if (isset($_SESSION['Saved'])) {
			$text.= "<ul><li>$link=Ummelden&User=$User\">sich ummelden</a></li></ul>\n";
		} else {
			$text.= "<ul><li>$link=edit\">Ihre Anmeldedaten ändern</a></li><li>$link=Abmelden&User=$User\">sich abmelden</a></li></ul>\n";
		}
	} else {
		$text.= '<form name="login" method="post" action="?Login"><input type="hidden" name="ToDo" id="ToDo" value="Anmelden">';
		$text.= "<p>Als registrierter Benutzer melden Sie sich bitte hier mit Ihrem Benutzernamen und Passwort an.<br><br>Wenn Sie sich registrieren möchten, klicken Sie bitte auf $link=Register\">Registrieren</a>.</p>\n";
		$text.= '<label for="User">Benutzername ODER E-Mail-Adresse</label><input type="text" id="User" name="User" required="required"><br>';
		$text.= '<label for="Pass">Passwort</label><input type="password" id="Pass" name="Pass"><br>';
		//  <small class="pointer" onmousedown="document.getElementById'."('Pass').type='text';".'" onmouseup="document.getElementById'."('Pass').type='password';\">Passwort anzeigen</small>
		$text.= '<a href="#" onclick="login.submit()">Anmelden</a> || <a href="#" onclick="document.getElementById(\'ToDo\').value=\'Passwort zusenden\';login.submit();">Passwort vergessen</a><br>';
		if ($PermaCookie) {
			$text.= '<input type="checkbox" name="forever" value="1"><label for="forever">dauerhaft angemeldet bleiben</label>'."\n";
			$text.= '<input type="hidden" name="CookieDauer" value="'.$PermaCookie."\">\n";
			$text.="<p>Wenn das Kästchen NICHT angekreuzt ist, müssen Sie sich bei jedem Besuch unserer Seite erneut anmelden, um Ihre gespeicherten Merklisten abrufen zu können.</p>\n";
		}
		echo "</form>\n";
	}
	return $text;
}

// holt Angaben zur angeforderten Seite:
function ThisPage($mypage) {
	global $db, $MyStartPage, $found;	// als globale Variablen, damit man sie verändern kann
	$found = false;

	$sql = "SELECT * FROM Pages WHERE RefID=0 AND URL='$mypage'";
	$row = $db->querySingle($sql,true);
	if (!empty($row)) {
		$found = true;
	} else {
		// angeforderte Seite gibt es nicht:
		if ($mypage!='Login') {
			$sql = "SELECT * FROM Pages WHERE URL='missing'";
			$row = $db->querySingle($sql,true);
			if (!empty($row)) {
				$row = $result->fetchArray(SQLITE3_NUM);
				$found = true;
			}
		}
		if (!$found) {
			$sql = "SELECT * FROM Pages WHERE RefID=0 AND URL='$MyStartPage'";
			$row = $db->querySingle($sql,true);
			$found = !empty($row);
		}
	}
	$row['HasChild'] = false;
	if ($found) {
	// we found a page, but is it locked by parents?
		$Parent = $row['Parent'];
		$isLocked = $row['Login'];
		while ($Parent>0 && !$isLocked) {
			$res = $db->querySingle("SELECT Login,Parent FROM Pages WHERE ID=$Parent",1);
			$isLocked = $res['Login'];
			$Parent = $res['Parent'];
		}
		$row['Login'] = $isLocked;
		// are there any children?
		$row['HasChild'] = !empty($db->querySingle('SELECT ID FROM Pages WHERE Show>0 AND Show<4 AND Parent='.$row['ID']));
	}
	return $row;
}

// gibt Cookie-Hinweis aus:
function printAcceptCookie() {
	global $MayUseCookie,$FirstUse,$OneShot,$CookieAcceptType,$u, $mylang,$mypage,$db,$PolicyPage;
/*
	$CookieAcceptType:	(0/1/2/3) -> mit/ohne Zusatztext etc...
	$OneShot:			(true: einmalig / false: jede Seite)
	$FirstUse:			(true: ist erstmaliger Hinweis / false: ist wiederholter Hinweis)
	$MayUseCookie:		(0/1: bisherige Einwilligung)
*/
	// Sprachversionen:
	$LinkToPolicy = $PolicyPage;
	if ($mylang) {
		$ID = $db->querySingle("SELECT ID FROM Pages WHERE RefID=0 AND URL='$PolicyPage'");
		$LinkToPolicy = $db->querySingle("SELECT URL FROM Pages WHERE RefID=0 AND Lang=$mylang AND Ist=$ID");
	}

	$CookNo = ['Cookies ablehnen','Refuse cookies','Refuser les cookies','Rechazar cookies','Rifiuta i cookie','Cookies weigeren','Recusar cookies'];
	$CookYes= ['Cookies wieder erlauben','Allow cookies again','Autoriser à nouveau les cookies','Permitir cookies de nuevo',
			   'Consenti nuovamente i cookie','Cookies opnieuw toestaan','Permitir novamente os cookies'];
	$CookDE = ['Datenschutzerklärung','privacy policy','déclaration de confidentialité','política de privacidad','informativa sulla privacy','privacybeleid','política de privacidade'];

	$LinkNo = '<a href="'.$u.$mypage.'&cookies=no">'.$CookNo[$mylang].'</a>';
	$LinkYes= '<a href="'.$u.$mypage.'&cookies=yes">'.$CookYes[$mylang].'</a>';
	$LinkDE = '<a href="'.$u.$LinkToPolicy.'">'.$CookDE[$mylang].'</a>';

	switch ($mylang) {
		case 0:	// de
			$Expl1 = 'Diese Website verwendet Cookies. Wenn Sie die Website weiterhin benutzen, stimmen Sie dem Einsatz von Cookies auf unserer Website zu.
					Weitere Informationen finden Sie in unserer';
			$Expl2 = 'Sie können der Verwendung von Cookies auch widersprechen, wenn Sie hier Ihre Einwilligung verweigern';
			$DidNo ='Sie haben der Verwendung von Cookies auf dieser Website widersprochen. Sie können der Verwendung von Cookies jedoch jederzeit gerne zustimmen';
			$DidYes='Sie haben der Verwendung von Cookies auf dieser Website zugestimmt. Sie können der Verwendung von Cookies jedoch jederzeit widersprechen';
			break;
		case 1:	// en
			$Expl1 = 'This website uses cookies. By continuing to use the website, you consent to the use of cookies on our website. You can find more information in our';
			$Expl2 = 'You can also object to the use of cookies by refusing your consent here';
			$DidNo ='You have objected to the use of cookies on this website. However, you are welcome to consent to the use of cookies at any time';
			$DidYes='You have consented to the use of cookies on this website. However, you can object to the use of cookies at any time';
			break;
		case 2:	// fr
			$Expl1 = 'Ce site utilise des cookies. Si vous continuez à utiliser le site, vous acceptez l\'utilisation de cookies sur notre site.
					Pour plus d\'informations, veuillez consulter notre';
			$Expl2 = 'Vous pouvez également vous opposer à l\'utilisation de cookies en refusant votre consentement ici ';
			$DidNo ='Vous avez refusé l\'utilisation de cookies sur ce site web. Vous pouvez toutefois accepter l\'utilisation de cookies à tout moment ';
			$DidYes='Vous avez accepté l\'utilisation de cookies sur ce site web. Vous pouvez toutefois vous opposer à tout moment à l\'utilisation de cookies ';
			break;
		case 3:	// es
			$Expl1 = 'Este sitio web utiliza cookies. Si continúa navegando, consideramos que acepta su uso. Puede encontrar más información en nuestra';
			$Expl2 = 'También puede oponerse al uso de cookies denegando su consentimiento aquí';
			$DidNo ='Se ha opuesto al uso de cookies en este sitio web. No obstante, puede volver a autorizar el uso de cookies en cualquier momento';
			$DidYes='Ha consentido el uso de cookies en este sitio web. Sin embargo, puede oponerse al uso de cookies en cualquier momento';
			break;
		case 4:	// it
			$Expl1 = 'Questo sito web utilizza i cookie. Continuando a utilizzare il sito web, acconsentite all\'uso dei cookie sul nostro sito.
					Per ulteriori informazioni, consultare la nostra';
			$Expl2 = 'Potete anche opporvi all\'uso dei cookie negando il vostro consenso qui';
			$DidNo ='Avete rifiutato l\'uso dei cookie su questo sito web. Tuttavia, potete acconsentire all\'uso dei cookie in qualsiasi momento';
			$DidYes='Avete acconsentito all\'uso dei cookie su questo sito web. Tuttavia, potete opporvi all\'uso dei cookie in qualsiasi momento';
			break;
		case 5:	// nl
			$Expl1 = 'Deze website maakt gebruik van cookies. Door de website te blijven gebruiken, geeft u toestemming voor het gebruik van cookies op onze website.
					Meer informatie vindt u in ons';
			$Expl2 = 'U kunt ook bezwaar maken tegen het gebruik van cookies door hier uw toestemming te weigeren';
			$DidNo ='U heeft bezwaar gemaakt tegen het gebruik van cookies op deze website. U kunt echter te allen tijde weer toestemming geven voor het gebruik van cookies';
			$DidYes='Je hebt toestemming gegeven voor het gebruik van cookies op deze website. U kunt echter te allen tijde bezwaar maken tegen het gebruik van cookies';
			break;
		case 6:	// pt
			$Expl1 = 'Este sítio Web utiliza cookies. Ao continuar a utilizar o sítio Web, está a consentir a utilização de cookies no nosso sítio Web.
					Pode encontrar mais informações na nossa';
			$Expl2 = 'Também se pode opor à utilização de cookies recusando o seu consentimento aqui';
			$DidNo ='Opôs-se à utilização de cookies neste sítio Web. No entanto, pode voltar a dar o seu consentimento à utilização de cookies em qualquer altura';
			$DidYes='Deu o seu consentimento para a utilização de cookies neste sítio Web. No entanto, pode opor-se à utilização de cookies em qualquer altura';
			break;
	}

	echo '<div id="cookies">';
	if ($FirstUse or $CookieAcceptType&1) {
		echo "$Expl1 $LinkDE.<br>";
	}
	if ($FirstUse) {
		echo "$Expl2: $LinkNo";
	} elseif ($MayUseCookie == 0) {
		echo "$DidNo: $LinkYes";
	} elseif ($MayUseCookie == 1 && !$OneShot) {
		echo "$DidYes: $LinkNo";
	}
	echo "</div>\n";
}

// holt Array mit Buttons für Hinweise (Kalender):
function getButtons() {
	global $db;
	$i = 0;
	$res = $db->query("SELECT * FROM Buttons");
	while ($rs = $res->fetchArray()) {
		$buttons[$i++] = $rs;
	}
	if ($i) {
		return $buttons;
	} else {
		return false;
	}
}
// ####################### STEP 4.2: Jetzt die konkrete Seite: ##############################

$HasSecondNavi = $db->querySingle("SELECT COUNT(ID) FROM Pages WHERE Lang=$mylang AND Show=2");

// ----------------------------------- Formatierung / Layout / Tags: -------------------------------------
$HeadClass = $PrintHeader  ? '' : ' class="noprint"';
$FootClass = $PrintFooter  ? '' : ' class="noprint"';

$HasGridLayout = $BodySize==2 || $BodySize==3;

$ho = $bo = $no = $co = $fo = '';
$hi = $bi = $ni = $ci = $fi = '';
$he = $be = $ne = $ce = $fe = '';
$hw = $bw = $nw = $cw = $fw = '';
$ndiv = "\n</div>";
if ($BodySize==1) {	// Die Seite hat verschiedene Zentrierungen:
	if ($HeadSize ==1) {$he = $ndiv; $hi = "\n<div class=\"inner header\">";}
	if ($BreadSize==1) {$be = $ndiv; $bi = "\n<div class=\"inner bread\">"; }
	if ($NaviSize ==1) {$ne = $ndiv; $ni = "\n<div class=\"inner nav\">";   }
	if ($MainSize ==1) {$ce = $ndiv; $ci = "\n<div class=\"inner wrap\">";  }
	if ($FootSize ==1) {$fe = $ndiv; $fi = "\n<div class=\"inner footer\">";}

	if ($HeadSize ==2) {$hw = $ndiv; $ho = "\n<div class=\"outer header\">";}
	if ($BreadSize==2) {$bw = $ndiv; $bo = "\n<div class=\"outer bread\">"; }
	if ($NaviSize ==2) {$nw = $ndiv; $no = "\n<div class=\"outer nav\">";   }
	if ($MainSize ==2) {$cw = $ndiv; $co = "\n<div class=\"outer wrap\">";  }
	if ($FootSize ==2) {$fw = $ndiv; $fo = "\n<div class=\"outer footer\">";}
}
if ($BodySize==7) {	// Die Seite hat einheitliche Zentrierung:
	$hw = $ndiv; $ho = "\n<div class=\"outer header\">";
	$bw = $ndiv; $bo = "\n<div class=\"outer bread\">";
	$nw = $ndiv; $no = "\n<div class=\"outer nav\">";
	$cw = $ndiv; $co = "\n<div class=\"outer wrap\">";
	$fw = $ndiv; $fo = "\n<div class=\"outer footer\">";
}

$headtag_open  = "\n<!-- Header -->$ho\n<header$HeadClass>$hi\n";
$headtag_close = "$he\n</header>$hw\n<!-- End of Header -->\n";

$breadtag_open = "\n<!-- Locator -->$bo\n<div class=\"locator noprint\">$bi\n";
$breadtag_close= "$be\n</div>$bw\n<!-- End of Locator -->\n";

$navitag_open  = "\n<!-- Navigation -->$no\n<nav class=\"noprint\">$ni\n";

if ($HasGridLayout) {	// Grid braucht keine wrapper
	$navitag_level = "<br>\n";
	$navitag_close = "$ne\n</nav>$nw\n<!-- End of Navigation -->\n";
	$wraptag_open  = "\n<!-- Contentwrapper -->\n";
	$wraptag_close = "\n<!-- End of Contentwrapper -->\n";
} else {
	$navitag_level = "<br>\n";
	$navitag_close = "$ne\n</nav>$nw\n<!-- End of Navigation -->\n";
	$wraptag_open  = "\n<!-- Contentwrapper -->$co\n<div class=\"wrapper\">$ci\n";
	$wraptag_close = "$ce\n</div>$cw\n<!-- End of Contentwrapper -->\n";
}

$foottag_open  = "\n<!-- Footer -->$fo\n<footer$FootClass>$fi\n";
$foottag_close = "$fe\n</footer>$fw\n<!-- End of Footer -->\n";

$DivBody = false;	// Seitenwrapper für schmale Seiten
$bodytag_close = "\n</body>\n</html>";
if ($BodySize==9 || $BodySize==3) {		// Die gesamte Seite ist zentriert:
	$DivBody = true;	// Seitenwrapper dafür: und wenn bereits die gesamte Seite zentriert ist, muss man die übrigen Bereiche nicht mehr zentrieren.
	$bodytag_close = $ndiv.$bodytag_close;
}

if ($Hamburger) {
	$hamburg = '
	<input type="checkbox" id="hamburg">
	<label for="hamburg" class="hamburg">
		<span class="line"></span><span class="line"></span><span class="line"></span>
	</label>';
} else {
	$hamburg = '';
}
/*
 0: Kein Hamburger-Menü einbinden
 1: Hamburger-Menü links einbinden, Dropdown
 5: Hamburger-Menü links einbinden, > Slide in >
 9: Hamburger-Menü links integriert in Navizeile
 2: Hamburger-Menü rechts einbinden, Dropdown
 6: Hamburger-Menü rechts einbinden, < Slide in <
10: Hamburger-Menü rechts integriert in Navizeile
*/
if ($Hamburger&3 || $HasSecondNavi) {
	//	hier muss der Hamburger eingeschoben werden (oder zusätzliches div wegen 2. Navigation)
	if ($Hamburger&1) {	// links
		$navitag_open = "<div class=\"naviwrapper\">".$hamburg.$navitag_open;
		$navitag_close .= $ndiv;
	} else {	// rechts
		$navitag_open = "<div class=\"naviwrapper\">".$navitag_open;
		$navitag_close .= $hamburg.$ndiv;
	}
}

// Feststellen, welche Hauptseiten es gibt und Nummer der jetzt anzuzeigenden Seite ermitteln:
// $mypage haben wir bereits geholt (wibcms.php), default: $MyStartPage='Startpage'...
$pages = 0;
$mypagenum    = 0;
$PageParent   = '';
$found = false;
$naviMainText = '';
$naviSubText1 = '';
$sitemap      = '';
$MyParentInfo = '';

// Jetzt die Inhalte der angeforderten Seite heraussuchen und die Navigation erzeugen:
// bei geschützten Seiten ggf. umleiten auf Login-Seite
$row = ThisPage($mypage);			// ermittelt NUR die Seitendaten als Array...
$MustLogin = $row['Login'];			// geschützt?
$MyHeadLine= $row['Kopf'];			// Überschrift evtl. DOCH anzeigen
if ($MustLogin && $WebStat==0) {	// die angeforderte Seite ist geschützt und der User nicht angemeldet?
	$closedpage = $mypage;			// wo wollte ich hin (ist aber geschützt...)
	$row = ThisPage('Login');		// Umleitung auf Login-Seite
} else {
	$closedpage = '';
	$MustLogin = false;
}
$mypagenum  = $row['ID'];
$mypage     = $row['URL'];		// korrigierte Seite
$MyPageTitle= $row['Title'];	// HTML <title>
$MyBreadCrumb=$row['Link'];		// Seitenname in der Navigation
$MyPageInfos= $row['Info'];		// Infobox Seitenleiste
$MyHeadLine = $row['Kopf'];		// Überschrift
$MyPageType = $row['Type'];		// Seitentyp
$MyPagePicts= $row['Image'];	// Schmuck-Bildleiste
$MyPageBack = $row['Back'];		// Hintergrund
$MyPageParam= $row['Parameter'];// Parameter für Seitentyp
$Content    = $row['Content'];	// Inhalt / Content
//	$MustLogin = ($row['Login'] || $MustLogin);		// geschützt? (Die Login-Seite selbst ist NICHT geschützt - logisch...)
$myParent   = $row['Parent'];	// Parent der Seite
$MayContent = $row['AddC'] & 1;	// zusätzlicher Fließtext-Content erlaubt?
$PageComment= (int)($row['AddC']/2) || in_array($AllowComments,[5,6,7,8]);	// Kommentarfunktion für diese Seite oder generell
$MyNaviIcon = $row['Icon'];		// Icon für die Navigation
$MayShow    = $row['Show'];		// überhaupt vorgesehen zur Anzeige?
$MyPageStat = $row['Status'];	// Status bei Freigaberegelung
$MyPageDesc = $row['Desc'];		// Description
$MyPageKeys = $row['Keys'];		// Keywords
$MyPageDate = $row['Changed'];	// Letztes Änderungsdatum
$MyPageInit = $row['Created'];	// Erstes Erstelldatum
$MyTitlePict= $row['Picture'];	// Titelbild
$PageHasChild=$row['HasChild'];	// Zu dieser Seite gibt es Unterseiten

//	Specify plugin type if needed:
if (strpos($MyPageType,'Plugin')!==false) {
	$MyPlugType = substr($MyPageType,7);
	$MyPageType = 'Plugin';
}

//	Specify up-to-dateness:
if (empty($MyPageDate)) {
	$MyPageDate=$MyPageInit;
}
$MySiteDate = $db->querySingle('SELECT MAX(Changed) FROM Pages WHERE Status=1');
$MySiteInit = $db->querySingle('SELECT MAX(Created) FROM Pages WHERE Status=1');
if (empty($MySiteDate)) {
	$MySiteDate=$MySiteInit;
}

//	Specify description / keywords:
if (empty($MyPageDesc)) {
	$MyPageDesc = $metaDescPrefix;
}
if (empty($MyPageKeys)) {
	$MyPageKeys = $metaKeywords;
}

$ancestors[] = $myParent;
$temp = $myParent;
while ($temp!=0) {
	$temp = $db->querySingle("SELECT Parent FROM Pages WHERE ID=$temp");
	$ancestors[] = $temp;
}

$ShowAllBranches = ($NaviStyle&4);	// Im Dropdown-Menü ALLES aktivieren (den Rest erledigt CSS)
if ($HasSecondNavi) {
	$DropDownMenu = "<div class=\"nav1\"><ul>\n".MapSite(0,1)."</ul></div>\n<div class=\"nav2\"><ul>\n".MapSite(0,2)."</ul></div>\n";	// getrennte Ebenen hier fraglich...?
} else {
	$DropDownMenu = '<ul>'.MapSite(0,1).'</ul>';	// Navigation holen mit getrennten Ebenen strNavi[Ebene] UND DropDown
}

// Jetzt evtl. die Zeile für die BreadCrumb-Navigation starten / formatieren:
// Obacht: $Breadcrumb (int)/ $MyBreadCrumb (string) !!!
if ($Breadcrumb) {
	$MyStartName = deprefix($db->querySingle("SELECT Link FROM Pages WHERE URL LIKE '$MyStartPage'"));
	if ($mypage==$MyStartPage) {
		$MyBreadCrumb = $MyStartName;
	} else {
		$MyBreadCrumb = "<a href=\"./$u$MyStartPage\">$MyStartName</a>$CrumbSign" . $BreadCrumb . deprefix($MyBreadCrumb);
	}
	$MyBreadCrumb = $breadtag_open . "<span>$MyHereYouAre</span> $MyBreadCrumb " . $breadtag_close;
}

// #### Die Suchfunktion: ####
$search = '';
if (isset($_GET['search'])) {
	$search = htmlspecialchars_decode($_GET['search']);
	$Content = highlight($Content,$search);
}
if (isset($_POST['suche'])) {
	$search = $_POST['suche'];
}

// #### Die Inhalte für die Sidebar erzeugen: #################################################
$SideClass = $PrintSidebar ? '' : ' noprint';

$MySideText = '';
if ($UseSidebar) {
	$ticker  = getTicker();	// holt ALLE Infobox-Texte
	$myInfos = $MyPageInfos;

	$ForceBox = $UseDefaultBox & 3;
	if ($myInfos=='' && $ForceBox) {
		if ($ForceBox=='2' && $myParent != 0) {
			$myInfos = $db->querySingle("SELECT Info FROM Pages WHERE ID=$myParent");
		} elseif ($ForceBox=='3') {
			$myInfos = $db->querySingle("SELECT Info FROM Pages WHERE RefID=0 AND URL='$MyStartPage'");
		}
	}

	if (strtolower($myInfos)=='alle') {
		// Erzeuge Sidebar-Texte nur aus Zeitvorgaben:
		foreach($ticker as $index => $rec) {
			$MySideText.= sidetext($index);
		}
	} elseif ($myInfos != '') {
		// Erzeuge Sidebar-Texte gemäß pages-Vorgabe:
		$mysidebar = explode(',',$myInfos);
		foreach($mysidebar as $index) {
			$index = strtolower(trim($index));
			if ($index=='login') {
				$MySideText .= sidelogin();
			} elseif ($index=='search') {
				$MySideText .= suchform($mypage);
			} elseif ($index=='next') {
				$res = $db->querySingle('SELECT ID,Titel,Text,Zeit FROM Events WHERE Modus=0 AND Zeit>'.time().' ORDER BY Zeit',1);	// nächster Termin
				if (!empty($res)) {
/*					Anzeige noch optimieren: (siehe Kalender1)
					- Titelzeile erzwingen (falls sonst unterdrückt)
					- Von-Bis bzw. ganztägig	*/
					$BoxHeadLine = date('j.n.Y, H:i: ',$res['Zeit']).$res['Titel'];
					$MySideText .= "\n	<div class=\"BoxItem\" style=\"position:relative\">\n	".txtBoxTitle();
					$MySideText .= '	'.$res['Text']."\n";
					if ($showEditSymbols && $May['EditInfos'] && $May['EditCal1']) {
						$nr = $res['ID'];
						$MySideText .= '	<img class="editpagelink" src="core/grafix/text.gif" title="Diesen Termin bearbeiten" onclick="oeffne('."'kalender',$nr,0)\">\n";
					}
					$MySideText .= "</div>\n";
				}
			} elseif ($index=='navilevel2') {
				if (isset($ulliMap[1])) {
					$MySideText .= "<nav class=\"L2\"><ul>\n".$ulliMap[1]."</ul>\n</nav>\n";
				}
			} elseif ($index=='navilevel3') {
				if (isset($ulliMap[2])) {
					$MySideText .= "<nav class=\"L3\"><ul>\n".$ulliMap[2]."</ul>\n</nav>\n";
				}
			} else {
				$MySideText .= sidetext($index);
			}
		}
	}

	if ($MySideText=='' && $ForceBox) {	// Default-Infobox
		$MySideText = sidetext($StandardBox);
	}
	if ($search != '') {
		$MySideText = highlight($MySideText,$search);
	}
	if ($MySideText != '') {
		$MySideText = "<aside class=\"sidebar$SideClass\">$MySideText</aside>\n";
	} else {
		// immer noch leer : $UseDefaultBox beachten (0,4,5) Content leer/ verbreitern / Spalte
	}
	if ($BoxOnPage) {
		$MySideText = withLightbox($MySideText,$BoxOnPage);
	}
}
// #### Imagebilder für die Bilderleiste holen: #############################################
$MyImageBar = '';
if ($UsePicts && $MyPagePicts !='') {
	if ($UsePicts&2) {
		$sql = $db->querySingle("SELECT Box,Folder FROM Gallery WHERE ID=$MyPagePicts",1);
		$box = $sql['Box'] ? '</a>':'';
		$Folder = $MyMedia.$sql['Folder'].'/';
		$Thumbs = $Folder.'Thumbs/';
		$sql = "SELECT Img FROM Galerie WHERE GalleryID = $MyPagePicts";
		$res = $db->query($sql);
		while ($rs = $res->fetchArray()) {
			if ($box)
				$MyImageBar.= '<a href="'.$Folder.$rs[0].'" class="lightbox-img">';
			$MyImageBar.= '<img class="imagebar" src="'. $Thumbs.$rs[0] ."\">$box\n";
		}
	}
	if ($MyImageBar!='') {
		$MyImageBar = "<aside class=\"imagebar$SideClass\">$MyImageBar";
		if ($showEditSymbols && $May['EditPicts'])
			$MyImageBar.= '	<img class="editpagelink" src="core/grafix/pict.gif" title="Diese Bildleiste bearbeiten" onclick="oeffne('."'KissPicsFile',$MyPagePicts,0)\">\n";
		$MyImageBar.= "</aside>\n";
	}
}

// #### Buttons für die Hinweise holen:	-> aufrufen NUR wenn gebraucht!!!	###################
if ($UseButtons) {
	$buttons = getButtons();
}

// #### Aktionsseite vorhanden? ######################
$ActionLink = '';
if ($WebStat&1) {
	$WHERE = '';			// is Admin/Developer, may view all pages
} elseif ($WebStat) {
	$WHERE = 'Login<99 AND';// is logged in, may view all pages except those for Admins/Developers only
} else {
	$WHERE = 'Login<3 AND';	// not logged in, may view only free pages
}
$sql = "SELECT URL,Link FROM Pages WHERE ($WHERE Show=8 AND Lang=$mylang AND RefID=0)";
$FlashPage = $db->querySingle($sql,1);
if (!empty($FlashPage)) {
	$ActionLink = '<div id="flashpage"'.($PrintFlash ? '' : ' class="noprint"').'><a href="'.$u.$FlashPage['URL'].'">'.$FlashPage['Link']."</a></div>\n";
}

// ####### Sollen Cookie-Hinweise angezeigt werden? Wenn ja, wo? ##################################
//	Default:
$MayUseCookie = 0;		// Cookie-Verwendung (nutzerspezifisch) erlaubt?
$ShowCookieAccept = 0;	// Cookie-Hinweis anzeigen?

if ($AcceptCookie>0) {	//	DSGVO-Cookie-Hinweis einblenden laut Konfiguration in $MyFeatures:
//	HINWEIS: Cookies werden im WIBcms bislang NUR bei erfolgreicher Anmeldung gesetzt, deshalb erübrigt sich dieser DSGVO-Hinweis normalerweie!
/*	$FirstUse:			(true: erstmaliger Hinweis / false: wiederholter Hinweis)
	$MayUseCookie:		(0/1: bisherige Einwilligung)
*/
	$HOST = $_SERVER['SERVER_NAME'];

//	Cookie-Behandlung
	if (isset($_GET['cookies'])) {
	//	Cookie neu setzen:
		if ($_GET['cookies'] == 'no') {
			$MayUseCookie = 0;
			setcookie('__Secure-AcceptCookies','0',0,'/',$HOST,1,1);
		} elseif ($_GET['cookies'] == 'yes') {
			$MayUseCookie = 1;
			setcookie('__Secure-AcceptCookies','1',0,'/',$HOST,1,1);
		}
		$FirstUse = false;
	} else {
	//	Cookie holen oder anfordern:
		if (isset($_COOKIE['__Secure-AcceptCookies'])) {
			$MayUseCookie = $_COOKIE['__Secure-AcceptCookies'];
			$FirstUse = false;
		} else {
			$MayUseCookie = 1;
			setcookie('__Secure-AcceptCookies','1',0,'/',$HOST,1,1);
			$FirstUse = true;
		}
	}

//	Anzeigeoptionen:
	$CookieAcceptType = $AcceptCookie & 3;	// (0/1/2/3) -> mit/ohne Zusatztext etc...
	$ShowCookieAccept = ($AcceptCookie >> 2) & 3;	// (1/2) am oberen/unteren Bildrand
	$OneShot = ($AcceptCookie < 128);	// (true: einmalig / false: jede Seite)
}

// ####################### STEP 4.3: Jetzt geht die Ausgabe endlich richtig los! ############################
// Zuerst noch Security-Header setzen:
if ($CSPHeader) {
	header('X-Frame-Options: DENY');
	if ($CSPHeader==3) {
		header('X-XSS-Protection "1; mode=block"'); // -> .htaccess: AddCharset UTF-8 .js (weiße Seite...) / <meta charset="utf-8">?
		header('X-Content-Type-Options "nosniff"'); // -> MIME-Types müssen stimmen text/javascript / text/css
	}
	$CSP = "default-src 'self'; base-uri 'self'; frame-ancestors 'none'; object-src 'self'; form-action 'self'";
	if ($MyPageType=='Route') {	// für Google-Routenplaner
		$CSP .= " maps.google.de; frame-src maps.google.de www.google.com";
	}
	if ($WebStat || $CSPHeader==1) {
		$CSP .= "; script-src 'self' 'unsafe-inline' 'unsafe-eval'; style-src 'self' 'unsafe-inline'";
	} else {
		$CSP .= "; script-src 'self'; style-src 'self'";
	}
	header("Content-Security-Policy: $CSP");
//	header("X-Content-Security-Policy: $CSP");
//	header("X-WebKit-CSP: $CSP");
	header("Feature-Policy: vibrate 'self'");
	header("Referrer-Policy: no-referrer-when-downgrade");	// besser wäre: same-origin, das verhindert aber Validator (kein Referer...)

/*	https://wiki.selfhtml.org/wiki/Sicherheit/Content_Security_Policy

============================================================================================================================
	im head noch ggf. aufnehmen / ändern:
	"viewport" content="... user-scalable=no"
*/
}
if ($error404) {
	header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found');
	$MyPageTitle = e404();
	$PageComment = 0;
} elseif ($metaRobots!='') {
	header("X-Robots-Tag: $metaRobots");
}

?><!doctype html>
<html lang="<?= $MyLanguages[$mylang] ?>">
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1, minimal-ui">
<title><?= $MyPageTitle ?></title>
<meta name="generator" content="WIBcms (https://wibcms.de/)">
<link rel="stylesheet" media="all" href="data/basic.css<?= $reloadStyles ?>">
<script>const WibLang = <?= $WibLang ?>, MyLang = <?= $mylang ?>;</script>
<style>
<?php

$Mobil1Dim = "$Mobil1Width$Mobil1Unit";
$Mobil2Dim = "$Mobil2Width$Mobil2Unit";
$strCSS = '';

if ($Hamburger) {
	// still to be configured:
	$HamCheck = 'max-height:1200px';	// einfach ein hoher Wert, damit alles angezeigt wird

	$HamBordRad = $HamMenuRad ? 'border-radius:'. $HamSpace/2 .'px' : '';
	$LineBordRad= ($HamLineRad && $HamHeight>2) ? 'border-radius:'. 2 .'px' : '';

	$HamDim = (4*$HamSpace + 3*$HamHeight).'px';
	$LLen = (2*$HamSpace + 3*$HamHeight).'px';
	$LLeft= $HamSpace.'px';
	$LHgt = $HamHeight.'px';
	$HamDiff = $HamHeight + $HamSpace;
	$HamTrans = $HamDiff.'px';
	$Ham1 = $HamSpace.'px';
	$Ham2 = ($HamSpace+$HamDiff).'px';
	$Ham3 = ($HamSpace+2*$HamDiff).'px';
	// .hamburg:hover .line {background: #ff6;}

	$strCSS .= "	input#hamburg {display:none}
	label.hamburg {display:inline-block; position:relative; width:$HamDim; height:$HamDim; background:$HamBGCol; $HamBordRad}
	.line {position:absolute; display:block; left:$LLeft; height:$LHgt; width:$LLen; background:$HamColor; transition:0.1s; transform-origin:center; $LineBordRad}
	.line:nth-child(1) {top: $Ham1}
	.line:nth-child(2) {top:$Ham2}
	.line:nth-child(3) {top:$Ham3}
	#hamburg:checked + .hamburg .line:nth-child(1){transform:translateY($HamTrans) rotate(45deg)}
	#hamburg:checked + .hamburg .line:nth-child(2){opacity:0}
	#hamburg:checked + .hamburg .line:nth-child(3){transform:translateY(-$HamTrans) rotate(-45deg)}
	nav {max-height:0px; overflow:hidden; transition:1s}
	#hamburg:checked + .hamburg + div nav,
	#hamburg:checked + .hamburg + nav { $HamCheck }

	@media screen and (min-width:$Mobil1Dim) {
		label.hamburg {display:none}
		nav	{ $HamCheck; overflow:visible;}
	}\n";
}

if ($HasGridLayout) {	// Grid Layout
	$bs = ($BodySize==3) ? " max-width:$BodyWidth$BodyUnit; justify-content:center;" : '';
	$gap= ($BodyGridGap) ? " gap:$BodyGridGap$BodyGridGapUnit;" : '';
	$bDiv=($BodySize==3) ? 'div.body' : 'body';
	$strCSS .= "	$bDiv		{display:grid;$gap margin:$BodyMargin$BodyMarginUnit auto; padding:$BodyPadOU$BodyPadOUnit $BodyPadLR$BodyPadIUnit;$bs}\n";
//	elements over the whole width:
	$grid_col = [];
	if ($HeadSize ==0) {$grid_col[] = 'header';}
	if ($BreadSize==0) {$grid_col[] = 'div.locator, div.bread';}
	if ($NaviSize ==0) {$grid_col[] = 'div.naviwrapper';}
	if ($MainSize ==0 && $SidebarStyle==0) {$grid_col[] = 'div.content';}
	if ($CommStyle==0 && $PageComment) {$grid_col[] = 'div.CommWrap';}
	if ($FootSize ==0) {$grid_col[] = 'footer';}
	if (!empty($grid_col)) {
		$strCSS .= "\t" . implode(",\n\t",$grid_col) . "	{grid-column: 1 / -1;}\n";
	}
//	do we need templates to adjust width/height?:
	if ($SidebarStyle || $HasFooter>1 || $NaviStyle==2) {
		$strCSS .= "@media (min-width:$Mobil1Dim) {\n\t$bDiv {";
		if ($SidebarStyle || $NaviStyle==2) {
			$strCSS .= 'grid-template-columns: ' . ($NaviStyle==2 ? "$NaviWidth$NaviWidthUnit " : '');
			if ($SidebarStyle==0) $strCSS .= "$ContWidth$ContWidthUnit;";
			if ($SidebarStyle==1) $strCSS .= "$SideWidth$SideWidthUnit $ContWidth$ContWidthUnit;";
			if ($SidebarStyle==2) $strCSS .= "$ContWidth$ContWidthUnit $SideWidth$SideWidthUnit;";
		}
		if ($HasFooter>1) {	// Footer ist sticky -> also alle rows außer content/main auf auto und Höhe auf 100%
			$strCSS .= "\n\t min-height:100vh; grid-template-rows: ";
//			if ($AddSkipLink) $strCSS .= 'auto ';
			if ($HasHeader) $strCSS .= 'auto ';
			if ($Breadcrumb>0 && $Breadcrumb<5) $strCSS .= 'auto ';
			if (in_array($NaviStyle,[0,2,5])) $strCSS .= 'auto ';
			if ($CommStyle==0 && $PageComment) $strCSS .= 'auto ';
			$strCSS .= '1fr ';
			if ($Breadcrumb>4) $strCSS .= 'auto ';
			$strCSS .= 'auto;';
		}
		$strCSS .= "}\n}\n";
	}
} else {
	$strCSS .= "	div.sidebarleft	  {float:left;}\n	div.sidebarright  {float:right;}\n";
	$strCSS .= "	div.sidebar		  {display:inline-block; width:$SideWidth$SideWidthUnit;}\n";
	$strCSS .= "	footer			  {clear:both;}\n";
	$strCSS .= "	main, div.content {display:inline-block; max-width:$ContWidth$ContWidthUnit;}\n";
	switch ($BodySize) {
		case 7: $strCSS .= "	div.outer		  {max-width:$BodyWidth$BodyUnit; margin:$BodyMargin$BodyMarginUnit auto; padding:$BodyPadOU$BodyPadOUnit $BodyPadLR$BodyPadIUnit;}\n"; break;
		case 9: $strCSS .= "	div.body		  {max-width:$BodyWidth$BodyUnit; margin:$BodyMargin$BodyMarginUnit auto; padding:$BodyPadOU$BodyPadOUnit $BodyPadLR$BodyPadIUnit;}\n"; break;
		case 1: $strCSS .= "	div.outer,\n"; 
				$strCSS .= "	div.inner		  {max-width:$BodyWidth$BodyUnit; margin:$BodyMargin$BodyMarginUnit auto; padding:$BodyPadOU$BodyPadOUnit $BodyPadLR$BodyPadIUnit;}\n"; break;
	}
}

if ($StickyNavi) $strCSS .= "	div.naviwrapper   {position:sticky; top:0px; z-index:4}\n";
if ($HasFooter==3) $strCSS .= "	footer, .footer	  {position:fixed; bottom:0;}\n";
if ($AddSkipLink) {
	$strCSS .= "	a.skip-link	{position:absolute !important; clip:rect(1px, 1px, 1px, 1px) !important;
			padding:0 !important; border:0 !important; height:1px !important; width:1px !important; overflow:hidden !important;}\n";
}
$strCSS .= "	@media screen { .printlegal {display:none;} }\n";



echo $strCSS;
?>
</style>
<link rel="stylesheet" media="all" href="data/style.css<?= $reloadStyles ?>">
<?php
//	Weitere Styles einbinden? (kundenspezifischer plugin-style)
if ($MyPageType=='Plugin' && is_file("$MyPlugData/$MyPlugType/style.css")) {
		echo '<link rel="stylesheet" media="all" href="data/plugins/'."$MyPlugType/style.css\">\n";
}
/*	if ($metaPublisher!='')
	echo "<meta name=\"publisher\" content=\"$metaPublisher\">\n";	 laut validator nicht erlaubt... */

// canonical tag:	-> languages ??? !!!
$URL = !empty($CanonicalDomain) ? $CanonicalDomain : $Server;
if ($isDefault && !$CanonicalDefault) {
	$URLcan = $URL.'/';
} else {
	$URLcan = "$URL/$u$mypage";
}

if ($OpenGraph) {
//	OpenGraph Tags für Facebook / Twitter: (https://ogp.me/)
	echo "<meta property=\"og:title\" content=\"$MyPageTitle\">\n";	// max. 95 Zeichen, besser 50 (wegen Zeilenumbruch)
	echo "<meta property=\"og:type\" content=\"website\">\n";
	echo "<meta property=\"og:url\" content=\"$URLcan\">\n";
	if ($OpenImage) {
		$img = explode('-',$OpenImage);
		$res = $db->querySingle('SELECT Folder FROM Gallery WHERE ID='.$img[0]);
		echo '<meta property="og:image" content="'.$URL.'/media/'.$res.'/'.$img[1]."\">\n";	// ideal: 1200 x 630 Pixel mit einem 1,91:1 Format
	}
	echo "<meta property=\"og:description\" content=\"$MyPageDesc\">\n";	// max. 297 Zeichen
}
if ($MyPageKeys!='')
	echo "<meta name=\"keywords\" content=\"$MyPageKeys\">\n";
if ($MyPageDesc!='')
	echo "<meta name=\"description\" content=\"$MyPageDesc\">\n";
if ($metaAuthor!='')
	echo "<meta name=\"author\" content=\"$metaAuthor\">\n";
if ($HasFavicon)
//	echo "<link rel=\"shortcut icon\" href=\"/favicon.ico\">\n";	überflüssig, da im root-Verzeichnis
if ($HasAppleIcon)
	echo '<link rel="apple-touch-icon" sizes="180x180" href="/'.$MyFavicons.'apple-touch-icon.png">'."\n";
if ($HasFavi32)
	echo '<link rel="icon" type="image/png" sizes="32x32" href="/'.$MyFavicons.'favicon-32x32.png">'."\n";
if ($HasFavi16)
	echo '<link rel="icon" type="image/png" sizes="16x16" href="/'.$MyFavicons.'favicon-16x16.png">'."\n";
if ($HasFavicons)
	echo '<link rel="manifest" href="/'.$MyFavicons.'site.webmanifest">'."\n";
//	echo '<meta name="theme-color" content="'.$SVGColor.'">'."\n";
if ($HasSafariSVG)
	echo '<link rel="mask-icon" href="'.$MyFavicons.'safari-pinned-tab.svg" color="'.$SVGColor.'">'."\n";
if ($MyExtraMetas!='')
	echo "$MyExtraMetas\n";
if ($metaRobots!='')
		echo "<meta name=\"robots\" content=\"$metaRobots\">\n";

echo '<link rel="canonical" href="'.$URLcan."\">\n";

// ########## evtl. benötigte Skripte laden: ###########
if ($WebStat || (($MustLogin || $WantLogin) && $LoginStyle<2)) {
	$reloadVersion = getWIBcmsVersion();
	echo '<link rel="stylesheet" media="all" href="core/admin.css?v='. $reloadVersion ."\">\n";	// wegen Login per overlay-formbox...
//	if ($AdminStyle==1)   echo '<link rel="stylesheet" href="core/admin-dark.css?v='. $reloadVersion ."\">\n"; -------  .mceIcon
	if ($AdminStyle==1)
		echo "<style>#admin_menu, #formbox, #mini_menu, #helpbox, #admin_menu img, #formbox img, #mini_menu img, #helpbox img, .mceToolbar, .mceToolbar .mceIcon {filter: invert(1);}</style>\n";
	if (isset($AdminExtraStyle) && $AdminExtraStyle)
		echo '<link rel="stylesheet" media="all" href="data/admin.css'. $reloadStyles ."\">\n";
//	$MyComeBack = $_POST['ComeBack'] ?? '';
	$MyComeBack = $_SESSION['back'] ?? ''; $_SESSION['back'] = '';
	if ($MyComeBack != '') {	// wibcmsedit erneut öffnen
//		$conf = $_POST['ConfigNr'] ?? 0;
		$todo = $_SESSION['todo'] ?? 0; $_SESSION['todo'] = 0;
		$conf = $_SESSION['conf'] ?? 0; $_SESSION['conf'] = 0;
		$onload = "oeffne('$MyComeBack','$todo',$conf);";
		$DivOnLoad = "$MyComeBack,$todo,$conf";	// für wibcmsfoot
	}
}
if ($WebStat || $MyPagePicts!='' || in_array($MyPageType,array('Galerie2','Fotoalben','KissAlbum','KissGallery','KissMemory')) || ($MyPageType=='Form' && $MyPageParam>4)) {
	// Lightbox aktivieren:
	$HasGallery = true;
}
if ($WebStat || $MyPageType=='Form' || $MyPageType=='Forms') {	// $$ $MyPageParam...
	$HasDate = true;
}
if ($MyPageBack!='' && $UseBacks) {
	echo '<style>body {background-image:url(media/'. $MyPageBack . ");}</style>\n";
}
/*
	$quer = ($DruckAnsicht==2) ? 'landscape' : 'portrait';
	echo '<style>@page {size:' . $quer . "} </style>\n";
*/
	if ($onload!='') $onload = ' onload="'.$onload.'"';
	echo "</head>\n\n<body$onload>\n";

if ($MaxiButton) {	// geht nicht!
	$strMaxiButton = ['Vergrößern','Maximize'];
	$strMiniButton = ['Verkleinern','Minimize'];
	echo '<button id="maxibutton">'.$strMaxiButton[$mylang]. " ⛶</button>\n";
	echo "<style>\nbutton#maxibutton {position:absolute; top:0; right:0;}\n</style>\n";
	?>
	<script>
	let MaxiButton = document.getElementById('maxibutton');
	MaxiButton.addEventListener('click', toggler);

	function toggler() {
		if (window.matchMedia('(display-mode: fullscreen)').matches) {
			exitFullscreen();
		} else {
			enterFullscreen(document.getElementsByTagName('body')[0]);
		}
	}

	function enterFullscreen(element) {
	  if(element.requestFullscreen) {
		element.requestFullscreen();
	  } else if(element.webkitRequestFullscreen) {
		element.webkitRequestFullscreen();
	  }
	  MaxiButton.textContent = '<?= $strMiniButton[$mylang] ?> X';
	}

	function exitFullscreen() {
	  if(document.exitFullscreen) {
		document.exitFullscreen();
	  } else if(document.webkitExitFullscreen) {
		document.webkitExitFullscreen();
	  }
	  MaxiButton.textContent = '<?= $strMaxiButton[$mylang] ?> ⛶';
	}
	</script>
	<?php
}
if ($ShowCookieAccept==1) {
	//	Cookie-Hinweis oben einblenden, falls nötig:
	printAcceptCookie();
}
if ($DivBody) echo "<div class=\"body\">\n";
?>