<?php
// ####################### STEP 1: vorab einige Funktionen: ###################################

	use PHPMailer\PHPMailer\PHPMailer;
	use PHPMailer\PHPMailer\SMTP;
	use PHPMailer\PHPMailer\Exception;

// entfernt Präfix von Linknamen bei mehrsprachigen Versionen:
function deprefix($LinkName) {
	global $MultiLang,$MyLanguages;
	if ($MultiLang) {
		$trylang = substr($LinkName,0,2);
		if (in_array($trylang,$MyLanguages)) {	// Prefix ('de' etc.) ist gültig!
			$LinkName = substr($LinkName,3);		// der Rest nach 'de:', delimiter-Zeichen egal, aber genau 1 Zeichen
		}
	}
	return $LinkName;
}
function ZielSeite($ToLang,$mylang) {
	global $db,$MyStartPage,$mypagenum;
	if ($ToLang==0) {	// Verweis fremd auf deutsch
		$sql = "SELECT URL FROM Pages WHERE ID=(SELECT Ist FROM Pages WHERE ID=$mypagenum)";
	} elseif ($mylang==0) {	// Verweis deutsch auf Fremd
		$sql = "SELECT URL FROM Pages WHERE Lang=$ToLang AND Ist=$mypagenum";
	} else {	// Verweis fremd auf fremd
		$sql = "SELECT URL FROM Pages WHERE Lang=$ToLang AND Ist=(SELECT Ist FROM Pages WHERE ID=$mypagenum)";
	}
//	echo $sql."<br>\n";
	$ZielSeite = $db->querySingle($sql);
	if (empty($ZielSeite)) {
		$ZielSeite = $MyStartPage;
/*		$ID = $db->querySingle("SELECT ID FROM Pages WHERE RefID=0 AND URL='$MyStartPage'");
		$sql = "SELECT URL FROM Pages WHERE Lang=$ToLang AND Ist=$ID";
//		$ZielSeite = $db->querySingle("SELECT URL FROM Pages WHERE ID=(SELECT ID FROM Pages WHERE RefID=0 AND Lang=$ToLang AND Ist=$ID)");
		$ZielSeite = $db->querySingle($sql);
		echo "$sql = S: $MyStartPage, Z: $ZielSeite<br>\n";	*/
	}
	return $ZielSeite;
}

// listet rekursiv alle Seiten für eine Sitemap/Navigation:
function MapSite($Parent='0',$Show='1', $isNavi=1,$icon=1, $Level=0, $num='', $Locked=0,$Titel=0) {
	global $db,$ShowStartPage,$ShowLinkOnly,$MyStartPage,$MultiLang,$UsePageTime, $u, $HasPrint,
			$mypage,$myParent,$ancestors, $mylang,$mypagenum, $NaviIcons, $strNavi,$uliNavi,$ulliMap;
	// $MyPageTitle,$headtitle,$MustLogin,$Content, $MyPageType,$MyPageParam,$MayContent,$MyPagePicts,$MyPageBack,$MyNaviIcon,$MyPageInfos
	// $NaviStyle = 0;	-> Merkposten: da kann man evtl. was verbessern...
	// $icon = $UseIconNavi; kann aber durch Aufruf verhindert werden
	global $WebStat,$showEditSymbols,$May;	// wegen Login und edit-Symbole anzeigen oder nicht
	global $Breadcrumb,$BreadCrumb,$CrumbSign,$ShowAllBranches,$IncludeSubMenu;	// $ExpandForum2,$ExpandForum3;
	global $AutoNumbers, $StartNumber, $EndNumber, $MapInsert, $strMapInsert;	// Kapitelnummerierung und zusätzliche Elemente in der Footer-Navigation

//	$strClass = ' class="L'.($Level+1).'"';
	$sitemap = '';
	$In = substr('            ',0,2+$Level*2);
	$strLink = ' <div class="editpagelink noprint"><img src="core/grafix/add.gif" title="Seite hinzufügen" onclick="oeffne(';

	if ($WebStat&1) {
		$WHERE = '';			// is Admin/Developer, may view all pages
	} elseif ($WebStat) {
		$WHERE = 'Login<99 AND';// is logged in, may view all pages except those for Admins/Developers only
	} else {
		$WHERE = 'Login<3 AND';	// not logged in, may view only free pages
	}
	if ($UsePageTime && !($May['UseMenu'])) {
		$WHERE .= ' (Auto=0 OR (Von<'.time().' AND Bis>'.time().')) AND';	// Zeitsteuerung
	}
	$query = "SELECT ID,URL,Link,Title,Kopf,Type,Icon,Parameter,Ist,Folge,Login,Picture,Auto,Von,Bis FROM Pages WHERE ($WHERE Parent=$Parent AND Show=$Show AND Lang=$mylang AND RefID=0) ORDER BY Folge";
	$result = @($db->query($query));
	if ($result) {
		$HasSelectedPage = $ThisIsMe = false;
		$Counter = 0;

		while ($row = $result->fetchArray()) {
			if ($MapInsert && $Counter%$MapInsert==0) {
				if ($Counter>0)
					$sitemap .= "</ul></div>\n";
				$sitemap .= "$strMapInsert<ul>\n";
			}
			$LinkName = ($MultiLang>0) ? deprefix($row['Link']) : $row['Link'];
			$MenuItem = '';
			$ID = $row['ID'];
			$isLocked = max($Locked,$row['Login']);	// hier noch unterscheiden, ob nicht doch angezeigt werden darf...
			$timeOut  = $UsePageTime && $row['Auto'] && ($row['Von']>time() || $row['Bis']<time());
			$strClass = ' class="L'.($Level+1) . (in_array($ID,$ancestors) ? ' isSelected' : '') . ($isLocked>2 ? ' isLocked' : ($isLocked>0 ? ' partLocked' : '')) . ($timeOut ? ' timeout' : '') . ($Titel ? ' hastitlepict' : '') . '"';

//		--	Kapitelnummerierung:
			$Number = '';
			if ($AutoNumbers) {
				if ($Level==0 && $row['Folge'] >= $StartNumber && $row['Folge'] <= $EndNumber) {
					$Number = ($row['Folge'] - $StartNumber - 1 + $AutoNumbers).'';
				} elseif ($num!='') {
					$Number = $num . '.' . $row['Folge'];	// bei Unterkapiteln einen Punkt in der Nummerierung hinzufügen
				}
			}
//		--	Nächste anklickbare Seite in der Navigation
			if ($row['URL']!=$mypage) {
				if ($ShowStartPage || $row['URL']!=$MyStartPage) {
					if ($Breadcrumb && in_array($ID,$ancestors) && $myParent!=0 && $row['URL']!=$MyStartPage) {
//						$BreadCrumb .= '<a href="' . $u . $row['URL'] . '">' . $LinkName . "</a>$CrumbSign" . (($MultiLang>0) ? deprefix($BreadCrumb) : $BreadCrumb);
						$BreadCrumb .= '<a href="./'. $u . $row['URL'] . '">' . ($AutoNumbers ? "$Number ":"") . $LinkName . "</a>$CrumbSign";
					}
					$IsLabel=false;
					$HasPicture=false;
					switch ($row['Type']) {
						case 'LinkPrint': $IsLink=true; $MenuItem = "<a$strClass ".'id="pageprint" name="Printer" title="'.$LinkName.'">'; $HasPrint=true; break;
						case 'LinkHome' : $IsLink=true; $MenuItem = "<a$strClass href=\"./$u" . $MyStartPage . '" title="'.$LinkName.'">'; break;
						case 'LinkLang' : $IsLink=true;
							if ($MultiLang>0) {
								$MyLangPage = ZielSeite($row['Parameter'],$mylang);
								$MenuItem = "<a$strClass href=\"./$u" . $MyLangPage . '" title="'.$LinkName.'">';	// $ShowLinkOnly=false -> NIE in Sitemap anzeigen
							}
							break;
						case 'LinkSearchVersuch': $IsLink=true; $IsLabel=true;
							$MenuItem = '<input name="search" id="search"><label for="search" class="search"><a name="search">';
							break;
						default: $IsLink=false;
/*							if (in_array($ID,$ancestors))
								$PClass = ' class="L'.($Level+1).' isSelected"';
//							$MenuItem = "<a$PClass href=\"./$u" . $row['URL'] . '">';	*/
							$MenuItem = "<a$strClass href=\"./$u" . $row['URL'] . '">';
							if ($Titel && $row['Picture']) {	// zusätzlich Titelbild anzeigen
								$MenuItem .= '<img src="media/'.$row['Picture'].'" title="'.$LinkName.'" alt="Symbolbild für Menüpunkt '.$LinkName.'"><span>';
								$HasPicture=true;
							}
							break;
					}
					$LinkEnd = ($IsLabel ? '</label>' : '') . ($HasPicture ? '</span>' : '') . '</a>';
					if ($MenuItem!='' && (!$IsLink || $ShowLinkOnly)) {
						if (!$icon || $row['Icon']=='0' || $row['Icon']=='') {
							// ohne Icons:
							$MenuItem .= ($AutoNumbers ? "$Number ":'') . $LinkName . $LinkEnd;
						} else {
							// mit Icons:
							if ($row['Icon'][0]=='+') {	// auch Titel anzeigen
								$strIcon = substr($row['Icon'],1-strlen($row['Icon']),strlen($row['Icon'])-1);
								$MenuItem .= '<img src="'. $NaviIcons . $strIcon .'" alt="Symbol für Menüpunkt '.$LinkName.'"> '.$LinkName.$LinkEnd;
							} else {
								$MenuItem .= '<img src="'. $NaviIcons . $row['Icon'] .'" title="'.$LinkName.'" alt="Symbol für Menüpunkt '.$LinkName."\">$LinkEnd";
							}
						}
					} else {
						$MenuItem = '';
					}
				}
			} else {	// diese Seite soll angezeigt werden!
				if ($ShowStartPage || $row['URL']!=$MyStartPage) {
					if (!$icon || $row['Icon']=='0' || $row['Icon']=='') {
						$MenuItem = "<span$strClass>" . ($AutoNumbers ? "$Number ":'') . $LinkName . '</span>';
					} else {
						if ($row['Icon'][0]=='+') {	// auch Titel anzeigen
							$strIcon = substr($row['Icon'],1-strlen($row['Icon']),strlen($row['Icon'])-1);
							$MenuItem = "<span$strClass><img src=\"". $NaviIcons . $strIcon .'" alt="Symbol für Menüpunkt '.$LinkName.'"> ' . $LinkName . '</span>';
						} else {
							$MenuItem = "<span$strClass><img src=\"". $NaviIcons . $row['Icon'] .'" alt="Symbol für Menüpunkt '.$LinkName. '"></span>';
						}
					}
				}
			}

			$addLink = ($showEditSymbols && $May['AddPages']) ?	($In.$strLink."'addpage',$ID,0)\"></div>\n$In") : '';
			$addNavi = $isNavi && ($Level==0 || $Parent==$mypagenum || in_array($Parent,$ancestors));	// Obacht bei Sitemap -> Mehrfachaufruf!!!

			// jetzt rekursiv Unterseiten suchen:
//	alt:	if ($ShowAllBranches || ($IncludeSubMenu && ($ID==$mypagenum || $ID==$myParent))) {
//			if ($ShowAllBranches || $ID==$mypagenum || $ID==$myParent) {
			if ($ShowAllBranches || $ID==$mypagenum || in_array($ID,$ancestors)) {	// Unterseiten suchen?
				$text = MapSite($ID, $Show,$isNavi,$icon, $Level+1, $Number, $isLocked,$Titel);	// Rekursion!
			} else {
				$text = '';
			}
//			Prepare MenuList:
			if ($addNavi && !isset($strNavi[$Level])) {
				$strNavi[$Level] = '';
				$uliNavi[$Level] = '';
			}
//			Examine recursion:
			if ($text != '') {	// Die Rekursion hat festgestellt, dass dieser Punkt noch mehr enthält...
				$PClass = 'isParent';
				$HasSelectedPage = (strpos($text,'<span') !== false);
				$ThisIsMe = ($ID == $mypagenum);
				if ($HasSelectedPage)
					$PClass .= ' isSelected';
				if ($ThisIsMe)
					$PClass .= ' thatsMe';
				if ($Titel)
					$PClass .= ' hastitlepict';
				$sitemap .= $In.'<li class="'.$PClass.'">'.$MenuItem."\n$In<ul>\n$text$In</ul>\n".$addLink;
				if ($addNavi) $strNavi[$Level].= $MenuItem."\n".$addLink;
				if ($addNavi) $uliNavi[$Level].= "$In<li class=\"$PClass\">$MenuItem\n$In$addLink</li>\n";
			} else {
				$PClass = $Titel ? ' class="hastitlepict"' : '';
				if ($MenuItem != '')
					$sitemap .= "$In<li$PClass>$MenuItem";
				if ($addNavi) $strNavi[$Level].= $MenuItem."\n";
				if ($addNavi) $uliNavi[$Level].= "$In<li>$MenuItem</li>\n";
			}

			if ($MenuItem != '' && ($ShowStartPage || $row['URL'] != $MyStartPage)) {
				$sitemap .= "</li>\n";
			}
			if ($Show==1 && ($Parent==$mypagenum || $HasSelectedPage || in_array($Parent,$ancestors))) {	// $Parent==$myParent || 
				$ulliMap[$Level] = $sitemap;
			}
			$Counter++;
		}
	} else {
		$sitemap =  '<li><p class="error">Error reading Sitemap!<br>'.$query.'</p></li>';
	}
	return $sitemap;
}

function getAutoNumberByID($ID) {
	global $db,$AutoNumbers,$StartNumber,$EndNumber;
	$temp = (int)$ID;
	while ($temp!=0) {
		$val = $db->querySingle("SELECT Parent,Folge FROM Pages WHERE ID=$temp",1);
		$ancestors[] = $val['Folge'];
		$temp = (int)$val['Parent'];
	}
	$ancestors = array_reverse($ancestors);
	if ($ancestors[0] >= $StartNumber && $ancestors[0] <= $EndNumber) {
		$ancestors[0] = $ancestors[0] - $StartNumber - 1 + $AutoNumbers;
		$Number = implode('.',$ancestors);
	} else {
		$Number = '';
	}
	return $Number;
}

// ---------- form html Button close: ----------
function formclose($edit,$submit='Anwenden',$save=true) {	// zwingend schließen
	return formbuttons($submit,$edit,0,$save,0);
}
function formsave($edit,$parameter='0',$save=true) {	// je nach Einstellung
	global $EditStay;
	return formbuttons('Anwenden',$edit,$parameter,$save,$EditStay);
}
function formreopen($edit,$parameter='0',$save=true) {	// zwingend wieder aufsuchen
	return formbuttons('Anwenden',$edit,$parameter,$save,1);
}
function formbuttons($submit,$edit,$parameter,$save,$reopen) {
	global $WebStat;
	$t = '<fieldset id="formbuttons"><label><input type="hidden" id="edit" name="edit" value="'.$edit.'"><input type="hidden" id="todo" name="todo" value="'.$parameter.'">';
	$t.= '<input type="hidden" name="ConfigNr" id="ConfigNr" value="0"></label><input name="ToDo" id="ToDo" value="';
	if ($save) {
		if ($edit=='login') {
			$t.= $submit.'" type="submit">';	// wird auch anders ausgewertet per wibcms->wibcmslogin
		} else {
			$t.= $submit.'" type="submit" onclick="return update(this.value);">';
		}
	} else {
		$t.= 'Dummy" type="hidden">';
	}
//	$EditStay:
	if ($reopen==1) {
//		$EditStay=1 > stets speichern und Editor erneut aufrufen
		$t.= '<input type="hidden" id="ComeBack" name="ComeBack" value="'.$edit.'">';
	} elseif ($reopen&2 && $save) {
//		bleiben / verlassen durch Checkbox wählbar, Vorauswahl: 2->leer / 3->checked
		$t.= ' <input type="checkbox" id="ComeBack" name="ComeBack" value="'.$edit.'"'.(($reopen==3)?' checked':'').'> (und Bearbeitung hier fortsetzen)';
	} else {
//		$EditStay=0 > stets speichern und Editor verlassen
//		$EditStay=4 > bleiben / verlassen durch 2. Button wählbar (derzeit nicht realisiert)
		$t.= '<input type="hidden" id="ComeBack" name="ComeBack" value="">';
	}
	$t.= '<br><label>'. (($edit!='login')?'<img id="helpgfx" class="helpbox" alt="Hilfesymbol" src="core/grafix/user_help.gif" onclick="togglehelp()" title="Online-Hilfe">':''). '<img id="waiting" class="waiting" src="core/grafix/waiting.gif" alt="drehender Kreis" title="Bitte etwas Geduld..."> ';
	if($WebStat & 1) {
		$t.= '<img src="core/grafix/htm.gif" class="helpbox" alt="Textsymbol" title="HTML-Quelltext des Edit-Overlays" onclick="showSrc(1)">';
	}
	$t.= '</label><input type="button" id="edit_close" value="Fenster schließen" onclick="close_edit()">'."\n</fieldset></form>\n";
	return $t;
}

function insertTinyMCE() {
	global $UseTinyMCE, $mylang;
	$txt = '';
	if ($UseTinyMCE == 3) {
		$txt = "	<script src=\"modules/tinymce/jscripts/tiny_mce/tiny_mce.js\"></script>\n";
//		$txt.= "	<script src=\"core/tinyinit2.js\"></script>\n";
		$txt.= "	<script src=\"core/tinyinit.php?ver=3&Lang=$mylang\"></script>\n";
	} elseif ($UseTinyMCE == 7) {
		$txt = "	<script src=\"modules/tinymce7/tinymce.min.js\"></script>\n";
//		$txt.= "	<script src=\"core/tinyinit.js\"></script>\n";
		$txt.= "	<script src=\"core/tinyinit.php?ver=7&Lang=$mylang\"></script>\n";
	}
	return $txt;
}
// ###################### WIBcms- und SQLite3-Funktionen #######################
// --------------- noch klären, ob hier benötigt oder in wibcmsedit / wibcmssave
function getWIBcmsVersion() {	// used in wibcmsedit (2) + wibcmsupdate (1)
	global $CVFile;
	$Versions = file($CVFile);
	$Version = trim($Versions[0]);
	return $Version;
}
function readVersions($Datei) {	// nur wibcmsedit (2)
	$Versions = array();
	if ($VersionFile = @fopen($Datei, 'r')) {
		while (!feof($VersionFile)) {
			$Zeile = fgets($VersionFile);
			if (strlen($Zeile)>2)
				$Versions[] = trim($Zeile);
		}
		fclose($VersionFile);
	}
	return $Versions;
}
function clearWishes() {	// nur wibcmsstatus (1)
	global $db;
	$sql = "SELECT DISTINCT User FROM Wishes WHERE User NOT LIKE 'User%'";
	$res = $db->query($sql);
	while ($rec = $res->fetchArray()) {
		if (!file_exists(session_save_path().'/sess_'.$rec[0])) {
			$sql = "DELETE FROM Wishes WHERE User LIKE '".$rec[0]."'";
//			echo 'deleted '.$rec[0]."<br>\n";
			$db->exec($sql);
		} else {
//			echo 'kept '.$rec[0]."<br>\n";
		}
	}
}
// ---------------------- SQLite3 Tabelle anlegen: -----------------------------
function wibcmsdb_create_table($tabelle,$sql,$verbose=0,$showtable=0) {	// used only in wibcmssave
	global $db,$ups,$User,$verbose;
	$ups .= "<li>Trying to create table &quot;$tabelle&quot;:<br>$sql</li>\n";
	$ok = $db->exec("CREATE TABLE IF NOT EXISTS $tabelle $sql");
	if (!$ok) {
		$ups .= "<li>Kann Tabelle $tabelle nicht anlegen.</li>\n";
	} else {
		$ups .= "<li>Tabelle $tabelle angelegt oder existiert bereits:<br>\n";
		write_log("$User hat die Tabelle $tabelle angelegt");
	}
	$query = "SELECT COUNT(ID) FROM $tabelle";
	$result = $db->querysingle($query);
	if ($result==0) {
		if ($verbose)
			$ups .= "bisher keine Einträge.</li>\n";
		return 1;
	} else {
		if ($verbose)
			$ups .= "mit $result Einträgen.</li>\n";
		return 0;
	}
}
// ###################### Ende SQLite3-Funktionen ##############################

// ###################### WIBcms-interne Funktionen #######################
// Fügt eine Meldungszeile ($m) mit Zeitstempel an die Logdatei an:
function write_log($m,$Level=9) {
	global $ups,$MyLogFile,$UseLog,$MyTimeZone;
	if ($UseLog>=$Level || 1==1) {
		if ($logfile = @fopen($MyLogFile, "a")) {
			$MyDate = new DateTime('now',new DateTimeZone($MyTimeZone));
			fwrite($logfile, $MyDate->format("Y-m-d H:i:s") . ": " . $m . "\n");	//  [$UseLog:$Level]
			fclose($logfile);
		} else {
			$ups .= "<li>Fehler: kann $MyLogFile nicht beschreiben!</li>";
		}
	}
}
// Gibt Debug-Meldung aus:
function debug($note,$type=1) {
	global $Debug,$ups;
	if ($Debug >= $type) {
		$ups .="<li>$note</li>\n";
	}
}
// Nicht erlaubt ausgeben:
function NotAllowed() {
	echo "<h1 class=\"error\">Sie haben hier keine Berechtigung!</h1>\n";
}
// ermittelt den Webstatus aus dem angemeldeten Zustand:
function getWebStat() {
	global $db,$May, $WIBcmsRole,$ShowHelp;

//	Besucher mit einem Session-Cookie:
	if (isset($_COOKIE[session_name()])) { // nach Abmelden ist Cookie noch gesetzt mit Ablaufdauer -42000!!!
		if(session_status() === PHP_SESSION_NONE) {	// erster Aufruf im Skript-Verlauf
			$OldSessID = $_COOKIE[session_name()];
			session_start();
			$ActSessID = session_id();
			if ($OldSessID != $ActSessID) {
				write_log('Cookie erkannt, aber Session muss neu erstellt werden.');
				$OldSessHash = sha1($OldSessID);
				$sql = "SELECT ID,Name,Mail,RoleID,Help,RealName,VName,NName,MPos,Mini,Expires FROM Users WHERE Session='$OldSessHash'";
				$res = $db->querySingle($sql, true);
				if (!empty($res) && $res['Expires']>time()) {
					$WebStat = $res['RoleID'];
					$MyID	 = $res['ID'];
					$User = getUserName($res['Name'],$res['RealName'],$res['VName'],$res['NName']);
					$_SESSION['webstatus']= $WIBcmsRole[$WebStat];
					$_SESSION['WebStat']  = $WebStat;
					$_SESSION['User']     = $User;
					$_SESSION['UserMail'] = $res['Mail'];
					$_SESSION['UserID']   = $MyID;
					$_SESSION['Help']     = isset($res['Help']) ? $res['Help'] : $ShowHelp;
					$_SESSION['May']	  = getMay($WebStat);
					$_SESSION['MPos']	  = ($res['MPos']=='') ? null : explode(',',$res['MPos']);
					$_SESSION['MiniMenu'] = $res['Mini'];
//				Neue Session, also Werte aktualisieren:
					$SessionHash = sha1($ActSessID);
					$db->exec("UPDATE Users SET Session='$SessionHash' WHERE ID=$MyID");
					setcookie(session_name(),$ActSessID,$res['Expires']);
				}
			}
		}
	}
//	Ist eine Session aktiv und gültig?
	$WebStat = $_SESSION['WebStat'] ?? 0;	// korrespondiert mit wibcmsconstants:Line 36 / $WIBcmsRole UND wibcmsfoot:50 / Anmelden
	$May = $_SESSION['May'] ?? getMay($WebStat);

	return $WebStat;
}
// Berechtigungsmatrix für Rolle bereitstellen:
function getMay($Role) {
	global $db;
	$May = ['UseMenu'=>0,'Debug'=>0,'UseFormBox'=>0];
	$res = $db->query("SELECT Var,R$Role FROM Rights");
	while ($rs = $res->fetchArray()) {
		$May[$rs[0]] = $rs[1];
	}
	return $May;
}
// Einzelner Benutzername:
function Username($ID) {
	global $db;
	$User = $db->querySingle("SELECT Name,RealName,VName,NName FROM Users WHERE ID=$ID",1);
	return getUserName($User['Name'],$User['RealName'],$User['VName'],$User['NName']);
}
// Username formatieren:
function getUserName($Name,$RealName,$VName,$NName,$Style=NULL) {
	global $UserStyle;
	if (empty($Style))
		$Style = $UserStyle;
	$NeedVN = !($Style==0 || $Style==5);
	if ($NeedVN && (empty($VName) || empty($NName)))
		$Style=5;
	if ($Style==5 && empty($RealName))
		$Style = 0;
	switch ($Style) {
		case 0: $User = $Name; break;
		case 1: $User = $VName.' '.$NName; break;
		case 2: $User = $VName; break;
		case 3: $User = $NName.', '.$VName; break;
		case 4: $User = $NName; break;
		case 5: $User = $RealName; break;
//	future expansion:
		case 6: $User = $VName.' '.substr($NName,0,1); break;
		case 7: $User = $NName.', '.substr($VName,0,1); break;
	}
	return $User;
}
// merge two configuration files into one file:
function mergefiles($Infile1,$Infile2,$Outfile) {
	$count = 0;
	if (is_file($Infile1) && is_file($Infile2)) {
		$Datei = fopen($Outfile,'wb');
		// copy 1st file to target, omit trailing closure
		$Input = fopen($Infile1,'r');
		while (!feof($Input)) {
			$Zeile = fgets($Input);
			if (trim($Zeile)!='?>') {
				fwrite($Datei,$Zeile);
				$count++;
			}
		}
		fclose($Input);
		// add 2nd file to target, omit leading opener
		$Input = fopen($Infile2,'r');
		while (!feof($Input)) {
			$Zeile = fgets($Input);
			if (trim($Zeile)!='<?php') {
				fwrite($Datei,$Zeile);
				$count++;
			}
		}
		fclose($Input);
		fclose($Datei);
	}
	return $count;
}
// add value to a configuration file:
function addCfgEntry($line,$value,$Outfile) {
	global $MyLayouts,$MyThemes;
	$result = addEntry($line,$value,$Outfile);
	if ($Outfile==$MyLayouts && is_dir($MyThemes)) {	// wir sollten auch die anderen Themes aktualisieren:
		$themes = getAlbum($MyThemes);
		foreach($themes as $theme) {
			addEntry($line,$value,"$MyThemes/$theme/layout.conf");
		}
	}
	return $result;
}
function addEntry($line,$value,$Outfile) {
	$result = false;
	if (is_file($Outfile)) {
		$Datei = fopen($Outfile.'_tmp','wb');
		$Input = fopen($Outfile,'r');
		while (!feof($Input)) {
			$Zeile = fgets($Input);
			if (trim($Zeile)!='?>') {
				fwrite($Datei,$Zeile);
			}
			if (strpos($Zeile,$line)!==false) {
				$result = true;	// Eintrag bereits bekannt!
			}
		}
		if (!$result) {
			fwrite($Datei,"$line = $value;\n");
			$result = true;
		}
		fwrite($Datei,'?>');
		fclose($Input);
		fclose($Datei);
		rename($Outfile.'_tmp', $Outfile);
	}
	debug($Outfile. ($result ? '':' nicht') .' aktualisiert');
	return $result;
}
// delete value from a configuration file:
function delCfgEntry($line,$Outfile) {
	$result = false;
	if (is_file($Outfile)) {
		$Datei = fopen($Outfile.'_tmp','wb');
		$Input = fopen($Outfile,'r');
		$line .= ' ';
		while (!feof($Input)) {
			$Zeile = fgets($Input);
			if (strpos($Zeile,$line)===false) {
				fwrite($Datei,$Zeile);
			}
		}
		$result = true;
		fclose($Input);
		fclose($Datei);
		rename($Outfile.'_tmp', $Outfile);
	}
	return $result;
}
// move value to another config file:
function moveCfgEntry($line,$Infile,$Outfile) {
	$var = substr($line,1);
	$result = isset($$var);
	if ($result)
		$result = addEntry($line,$$var,$Outfile);
	if ($result)
		$result = delCfgEntry($line,$Infile);
	return $result;
}
// add a column to the WIBcms database:
function addColumn($table,$column,$type) {
	global $db;
	$sql = "ALTER TABLE $table ADD COLUMN $column $type";
	return $db->exec($sql);
}

// Gibt Klartext-Fehlermeldung zurück statt Nummern (beim Upload):
function UploadErrorText($errnumber) {
	$e = "Upload-Hinweis (Nr. $errnumber):<br>";
	switch ($errnumber) {
	case 1: $e .= 'Die hochgeladene Datei ist größer als erlaubt (upload_max_filesize in php.ini)'; break; // UPLOAD_ERR_INI_SIZE
	case 2: $e .= 'Die hochgeladene Datei ist größer als erlaubt (MAX_FILE_SIZE im HTML-Formular)'; break; // UPLOAD_ERR_FORM_SIZE
	case 3: $e .= 'Die Datei wurde nur teilweise hochgeladen'; break;		// UPLOAD_ERR_PARTIAL
	case 4: $e .= 'Es wurde keine Datei hochgeladen'; break;				// UPLOAD_ERR_NO_FILE
	case 6: $e .= 'Es ist kein temporäres Verzeichnis vorhanden'; break;	// UPLOAD_ERR_NO_TMP_DIR
	case 7: $e .= 'Fehler beim Schreiben auf die Festplatte'; break;		// UPLOAD_ERR_CANT_WRITE
	case 8: $e .= 'Datei-Upload wurde durch extension gestoppt'; break;		// UPLOAD_ERR_EXTENSION
	default:$e .= 'Unbekannter Upload-Fehler...';
	}
	return $e;
}

function guidv4() {
    // Generate 16 bytes (128 bits) of random data for use as an UUID/GUID
	// Usage: $myuuid = guidv4(); echo $myuuid;

	$data = (PHP_MAJOR_VERSION < 7) ? openssl_random_pseudo_bytes(16) : random_bytes(16);
    assert(strlen($data) == 16);

    $data[6] = chr(ord($data[6]) & 0x0f | 0x40);	// Set version to 0100
    $data[8] = chr(ord($data[8]) & 0x3f | 0x80);	// Set bits 6-7 to 10

    // Output the 36 character UUID.
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

function encrypt($plaintext, $data='WIB/cms#smc\BIW') {
    $method = 'AES-256-CBC';
    $key = hash('sha256', $data, true);
    $iv = openssl_random_pseudo_bytes(16);

    $ciphertext = openssl_encrypt($plaintext, $method, $key, OPENSSL_RAW_DATA, $iv);
    $hash = hash_hmac('sha256', $ciphertext . $iv, $key, true);

    return base64_encode($iv . $hash . $ciphertext);
}

function decrypt($encryptedText, $data='WIB/cms#smc\BIW') {
    $encryptedText = base64_decode($encryptedText);

    $method = 'AES-256-CBC';
    $iv = substr($encryptedText, 0, 16);
    $hash = substr($encryptedText, 16, 32);
    $ciphertext = substr($encryptedText, 48);
    $key = hash('sha256', $data, true);

    if (!hash_equals(hash_hmac('sha256', $ciphertext . $iv, $key, true), $hash)) return null;

    return openssl_decrypt($ciphertext, $method, $key, OPENSSL_RAW_DATA, $iv);
}

// fügt einen Ordner zu einer ZIP-Datei hinzu:
function addZipFolder($zip,$pfad,$exclude=NULL) {
	global $excludeit;
	if (is_dir($pfad)) {
		if (!empty($exclude)) {
	//		$excludes = array_merge($excludeit,$exclude);
			foreach($exclude as $rec)
				$excludeit[]=$rec;
		}
		$filelist = array_diff(scandir($pfad),$excludeit);
		$zip->addEmptyDir($pfad);

		foreach($filelist as $rec) {
			$datei = $pfad.$rec;
			if (is_dir($datei))
				addZipFolder($zip, "$datei/");
			else
				$zip->addFile($datei,$datei);
		}
	}
}
// Update-Datei extrahieren:
function extrahiere($Datei,$Pfad='./') {
	// jetzt entzippen:
	$zip = new ZipArchive;
	$ret = $zip->open($Pfad.$Datei, ZipArchive::CHECKCONS);
	if ($ret !== true) {
		$text = " fehlgeschlagen, Code: $ret";
	} else {
		if (!$zip->extractTo($Pfad)) {
			$text = ' Zip-Extraktion fehlgeschlagen';
		} else {
			$text = ' erfolgreich!';
		}
	}
	// zip-Datei löschen!
	$zip->close();
	unlink($Pfad.$Datei);
	return $text;
}
// Rekursive Funktion zum Backup ALLER Dateien:
function FolderBackup($Folder,$ZipFolder,$type) {
	global $excludeit, $ZipList, $ups;

	$Name = substr(str_replace(['../','/'],['','_'],$Folder),0,-1);
	$txt = $ZipFolder.$Name.'.zip';
//	$ups .= "<li>$txt</li>\n";
	$zip = new ZipArchive;
	$ret = $zip->open($txt, ZipArchive::CREATE);
	if ($ret !== TRUE) {
		$ups.= "<li>FolderBackup bei $ZipFolder fehlgeschlagen, Code: $ret</li>\n";
		write_log("FolderBackup bei $ZipFolder fehlgeschlagen, Code: $ret");
	} else {
		$ZipList .= $Name."\n";	// hier werden auch "leere Ordner, ohne Files" aufgeführt!
		$zip->addEmptyDir($Folder);
		$filelist = array_diff(scandir($Folder),$excludeit);
		if (count($filelist)) {
//			$zip->addEmptyDir($Folder);
			foreach($filelist as $rec) {
				$datei = $Folder.$rec;
				if (is_file($datei)) {
					$zip->addFile($datei);
				} else {
					FolderBackup("$datei/",$ZipFolder,$type);
				}
			}
		}
		$zip->close();
	}
	return $ZipList;
}
// Erzeugt eine Backupdatei (data, plug, media, alben oder full, oder...)
function BackItUp($type='data',$folder='') {
	global $excludeit, $AlbenFolder,$MyPlugins,$ups, $WIBcmsFilePrefix,$MyBackUps;
	$any = ($type=='full' || $type=='site');
	$zip = new ZipArchive;
	if ($folder != '') {
		$txt = $MyBackUps.$folder.$type.'.zip';
	} else {
		$txt = $MyBackUps.'B'. date('Y-m-d_His_') .$type.'.zip';
	}
	$ret = $zip->open($txt, ZipArchive::CREATE);
	if ($ret !== TRUE) {
		$ups.= "<li>Backup fehlgeschlagen, Code: $ret</li>\n";
		write_log("Backup fehlgeschlagen, Code: $ret");
	} else {
		if ($type=='data' || $type=='prep' || $any)
			addZipFolder($zip,$WIBcmsFilePrefix.'data/');
		if (($type=='plug' || $type=='plugins' || $any) && is_dir($MyPlugins))
			addZipFolder($zip,$WIBcmsFilePrefix.'plugins/');
		if (($type=='alben' || $any) && is_dir($AlbenFolder))
			addZipFolder($zip,$AlbenFolder);
		if ($type=='media' || $any)
			addZipFolder($zip,$WIBcmsFilePrefix.'media/',['Originals']);
		if ($type=='site' || $type=='core' || $type=='prep')
			addZipFolder($zip,$WIBcmsFilePrefix.'core/');
		if ($type=='site' || $type=='modules')
			addZipFolder($zip,$WIBcmsFilePrefix.'modules/');
		if ($type=='site' || $type=='downloads')
			addZipFolder($zip,$WIBcmsFilePrefix.'downloads/');
		if ($type=='site' || $type=='fonts')
			addZipFolder($zip,$WIBcmsFilePrefix.'fonts/');
		if ($type=='site' || $type=='favicons')
			addZipFolder($zip,$WIBcmsFilePrefix.'favicons/');
		if ($type=='site') {
		// files in document root:
			$docroot = strlen($WIBcmsFilePrefix)>1 ? $WIBcmsFilePrefix : './';
			$filelist = array_diff(scandir($docroot),$excludeit);
			foreach($filelist as $rec) {
				$datei = $docroot.$rec;
				if (is_file($datei))
					$zip->addFile($datei,$datei);
			}
		}
		$zip->close();
		$ups.= "<li>Backup angelegt: $type<br>$txt</li>\n";
		write_log("Backup angelegt: $txt");
	}
}

// Eine ganze Backup-Prozedur nach dem Anmelden oder manuell, inkl. automatischem Löschen von Backups/Logeinträgen
function doBackUp($type=2) {
	global $excludeit,$ups,$WIBcmsFilePrefix, $AutoDelBackUps,$Keep1BackUp,$AutoDelLogs, $db,$MyLogFile,$MyBackUps,$MyPlugins,$MyModules,$MyFeatures,$MyDatabase, $ZipList;
	$folder='';
	$zips = ['','data_copy','data','alben','media','plug','site_copy','full','site',9];

//	Ordner-Backups:
	if ($type==1 || $type==6 || $type==21 || $type==26) {

		$User = $_SESSION['User'];
		$anonym = false;
		if ($type>20) {
			$anonym = true;
			$type -= 20;
		}
		$folder = ($anonym ? 'A' : 'B').date('Y-m-d_His_').$zips[$type];
		$ZipFolder = $MyBackUps.$folder.'/';
		if (mkdir($ZipFolder,0755)) {
			$ZipList = $ZipPlug = $ZipMods = '';
			$ups .= "<li>Backup-Folder $folder angelegt</li>";
			write_log("$User hat den Backup-Folder $folder angelegt");
//		dieses 3 Ordner sind unkritisch und werden separat komplett gezippt:
//			anonymisieren?
			if ($anonym) {
			  copy($MyFeatures,'temp.conf');	// Sicherung der Live-Version
				delCfgEntry('$MailHost',$MyFeatures);
				delCfgEntry('$MailUser',$MyFeatures);
				delCfgEntry('$MailPass',$MyFeatures);
				delCfgEntry('$CanonicalDomain',$MyFeatures);
				addEntry('$MailHost',"'mail.beispiel.de'",$MyFeatures,true);
				addEntry('$MailUser',"'user@beispiel.de'",$MyFeatures,true);
				addEntry('$MailPass',"'LFHNvvtihVg8+XH/WNlt41x74MvVuRunBMbMZ3+zbU+kJZxqd7xswCaW1mWf3t9kYyX3Hh2f0QgLh/tZDnJ2RA2/Ftf+8sixj4DzucEgbxw='",$MyFeatures,true);
				addEntry('$CanonicalDomain',"''",$MyFeatures,true);
			  copy($MyConfigs,'config.bak');
				delCfgEntry('$MailTo',$MyConfigs);
				delCfgEntry('$Sender',$MyConfigs);
				addEntry('$MailTo',"'info.beispiel.de'",$MyConfigs,true);
				addEntry('$Sender',"'post@beispiel.de'",$MyConfigs,true);
			  copy($MyDatabase,'temp.db');	// Sicherung der Live-Version
				$AdminID = $db->querySingle('SELECT ID FROM Users WHERE RoleID=1');	// es MUSS ja einen Admin geben...
				$db->exec("UPDATE Users SET Pass='$2y$10$7x0IY//yOFQ9W5wPJkUlyuXO1oTAgEuUAeaY.KImR56Dy5Y/Alc6S', VName=Name,NName=Name,RealName=Name, Session='',Expires='',Since='',PWChange='', Mail= Name || '@example.de'");
				$db->exec("UPDATE Users SET Name='Admin2' WHERE Name='Admin'");
				$db->exec("UPDATE Users SET Name='Admin',Pass='$2y$10$7x0IY//yOFQ9W5wPJkUlyuXO1oTAgEuUAeaY.KImR56Dy5Y/Alc6S' WHERE ID=$AdminID");
				$db->exec('VACUUM');
			}
			BackItUp('data',"$folder/");
			if ($anonym) {	// Live-Version wiederherstellen:
				rename('temp.conf',$MyFeatures);
				rename('config.bak',$MyConfigs);
				rename('temp.db',$MyDatabase);
			}
			BackItUp('fonts',"$folder/");	$ZipList .= "fonts\n";
			BackItUp('favicons',"$folder/");$ZipList .= "favicons\n";
			if ($type==6) {
				BackItUp('core',"$folder/");	$ZipList .= "core\n";
				BackItUp('modules',"$folder/");	$ZipList .= "modules\n";
				BackItUp('plugins',"$folder/");	$ZipList .= "plugins\n";
			}
			$excludes = array_merge($excludeit,['data','fonts','favicons','core','modules','plugins','_Updates','BackUp']);
//		jetzt alles übrige erfassen:
			$docroot = strlen($WIBcmsFilePrefix)>1 ? $WIBcmsFilePrefix : './';
			$filelist = array_diff(scandir($docroot),$excludes);
			foreach($filelist as $rec) {
				$datei = $docroot.$rec;
				if (is_dir($datei)) {
//					$ups .= "<li>Scanning $datei</li>\n";
					FolderBackup("$datei/",$ZipFolder,$type);	// rekursiv in einzelne Ordner-Zips
				}
			}

			$MyPlugs = getAlbum($MyPlugins);
			$exclude = [];
			foreach ($MyPlugs as $plug) {
//		Check if really needed and valid (WIBcms Development only)
				if (is_file("$MyPlugins/$plug/Version.inf")) {
					if ($ZipPlug != '')
						$ZipPlug .= "\n";
					$ZipPlug .= $plug;
				} else {
					$exclude[] = $plug;
				}
			}
			$txt = $ZipFolder.'plugins-used.zip';
			$ZipList .= "plugins-used\n";
			$zip = new ZipArchive;
			$ret = $zip->open($txt, ZipArchive::CREATE);
			addZipFolder($zip,$WIBcmsFilePrefix.'plugins/',$exclude);
			$zip->close();
			file_put_contents($ZipFolder.'ZipPlug.txt',$ZipPlug);

			$MyPlugs = getAlbum($MyModules);
			$exclude = [];
			foreach ($MyPlugs as $plug) {
//		Check if really needed and valid (WIBcms Development only)
				if (is_file("$MyModules/$plug/Version.inf")) {
					if ($ZipMods != '')
						$ZipMods .= "\n";
					$ZipMods .= $plug;
				} else {
					$exclude[] = $plug;
				}
			}
			$txt = $ZipFolder.'modules-used.zip';
			$ZipList .= "modules-used\n";
			$zip = new ZipArchive;
			$ret = $zip->open($txt, ZipArchive::CREATE);
			addZipFolder($zip,$WIBcmsFilePrefix.'modules/',$exclude);
			$zip->close();
			file_put_contents($ZipFolder.'ZipMods.txt',$ZipMods);

			$ZipList .= 'data';	// erst hier, dann können wir gut das /n weglassen...
			file_put_contents($ZipFolder.'ZipList.txt',$ZipList);

		} else {
			$ups .= "<li>Backup-Folder $folder konnte nicht angelegt werden</li>";
			write_log("$User konnte Backup-Folder $folder nicht anlegen");
		}
//	Einzeln wiederherstellbare Backups:
	} elseif ($type==9) {
		BackItUp('data');
		BackItUp('alben');
		BackItUp('media');
		BackItUp('plug');
	} else {
		BackItUp($zips[$type]);
	}

//	Anschließend Garbage Collection:
	if ($AutoDelBackUps) {
		$MyBackType = ['data'=>0,'alben'=>0,'media'=>0,'plug'=>0,'full'=>0,'site'=>0];
		if ($Keep1BackUp>16) {
			$KeepOld = true;
			$KeepCnt = $Keep1BackUp & 16;
		} else {
			$KeepOld = false;
			$KeepCnt = $Keep1BackUp;
		}
		$dellist = [];
		$delcount = 0;
		$deltime = time()-($AutoDelBackUps*30*24*60*60);	// Sekunden in der Vergangenheit
//		$ups .= "DelTime is $deltime :<br>";

		$files = array_diff(scandir($MyBackUps,1),$excludeit);
		foreach($files as $rec) {
			if (is_file($MyBackUps.$rec)) {
				$type = substr($rec,19,-4);
				$zeit = strtotime(substr($rec,1,10).' '.substr($rec,12,2).':'.substr($rec,14,2).':'.substr($rec,16,2));
				if ($KeepCnt>0 && $MyBackType[$type]<$KeepCnt) {
					if (!$KeepOld || $zeit < $deltime) {
						$MyBackType[$type]++;
					}
//				$ups .= "found last $type at $zeit <br>";
				} elseif ($zeit < $deltime) {
					$dellist[] = $rec;
					$delcount++;
				}
			}
		}

		if (!empty($dellist)) {		// Löschkandidaten gefunden!
			Del_Backups($dellist);
			$ups .= "<li>$delcount alte Backup-Dateien gelöscht</li>";
			write_log("$delcount Backupdateien älter als $AutoDelBackUps Monat(e) wurden automatisch gelöscht");
		}
	}
	if ($AutoDelLogs) {
		$deltime = time()-($AutoDelLogs*30*24*60*60);	// Sekunden in der Vergangenheit
		$delcount = 0;
		$logfile = fopen($MyLogFile,'r');
		$tmpfile = fopen($MyLogFile.'_tmp','wb');
		while (!feof($logfile)) {
			$rec = fgets($logfile); // \n ist in Dateizeile enthalten
			if (strlen($rec)>2) {	// Leerzeilen unterdrücken (besteht nur aus \n)
				$zeit = strtotime(substr($rec,0,19));
				if ($zeit < $deltime) {
					$delcount++;
				} else {
					fwrite($tmpfile, $rec);
				}
			}
		}
		fclose($logfile);
		fclose($tmpfile);
		rename($MyLogFile.'_tmp', $MyLogFile);

		if ($delcount>0) {
			write_log("$delcount Logeinträge älter als $AutoDelLogs Monat(e) wurden automatisch gelöscht");
			$ups .= "<li>$delcount alte Logeinträge gelöscht</li>";
		}
	}
}
// ###################### Login- und Register-Funktionen #######################
// Testet beim Registrieren (neuer Benutzer), ob Nutzer bereits existiert:
function CheckRegisterData($Benutzer,$UserMail,$PassWort,$exclude='0') {
	global $db;
	$isOK = false;
	if ($Benutzer=='') {
		echo "<p class=\"error\">Bitte geben Sie einen Benutzernamen ein. Danke.</p>\n";
	} elseif ($UserMail=='') {
		echo "<p class=\"error\">Bitte geben Sie eine E-Mail-Adresse ein. Danke.</p>\n";
	} elseif ($PassWort=='') {
		echo "<p class=\"error\">Bitte geben Sie ein Passwort ein. Danke.</p>\n";
	} else {
		$sql = "SELECT RoleID FROM Users WHERE Name LIKE '$Benutzer' AND NOT ID=$exclude";
		$rec = $db->querySingle($sql);
		if ($rec !== NULL) {	// found another User:
			echo "<p class=\"error\">Der Benutzername $Benutzer ist hier bereits registriert!<br>Bitte wählen Sie einen anderen Namen". (($exclude=='0')?" - oder sind Sie evtl. bereits registriert?":".") . "</p>\n";
		} else {
			$sql = "SELECT RoleID FROM Users WHERE Mail LIKE '$UserMail' AND NOT ID=$exclude";
			$rec = $db->querySingle($sql);
			if ($rec !== NULL) {	// found another Mail:
				echo "<p class=\"error\">Die E-Mail-Adresse $UserMail ist hier bereits registriert!<br>Bitte wählen Sie eine andere Adresse". (($exclude=='0')?" - oder sind Sie evtl. bereits registriert?":".") . "</p>\n";
			} else {
				$isOK = true;
			}
		}
	}
	return ($isOK && PassFits($PassWort,true));
}
// Hinweis zu Passwort-Bedingung
function strPassRequirement($print=false) {
	global $PassLength,$PassRule;
	$str = '';
	if ($PassLength>0) {
		$str .= "Das Passwort muss mindestens $PassLength Zeichen lang sein.<br>";
	}
	switch ($PassRule) {
		case  3: $str .= 'Das Passwort muss beliebige Buchstaben UND Ziffern enthalten.<br>'; break;
		case  7: $str .= 'Das Passwort muss beliebige Buchstaben UND Ziffern UND Sonderzeichen enthalten.<br>'; break;
		case 35: $str .= 'Das Passwort muss Klein- UND Großbuchstaben UND Ziffern enthalten.<br>'; break;
		case 39: $str .= 'Das Passwort muss Klein- UND Großbuchstaben UND Ziffern UND Sonderzeichen enthalten.<br>'; break;
	}
	if ($print) {
		if ($str) {
			echo "<p class=\"passnote\">Bitte beachten:<br>$str</p>\n";
		}
	} else {
		return $str;
	}
}
// Prüfen der Passwort-Bedingung
function PassFits($Pass,$print=false) {
	global $PassLength,$PassRule;
	$str = '';
	$OK = true;

	$Chars = preg_match("#[a-zA-Z]+#", $Pass);
	$UpperCase = preg_match('@[A-Z]@', $Pass);
	$LowerCase = preg_match('@[a-z]@', $Pass);
	$Number    = preg_match('@[0-9]@', $Pass);
	$SpecChars = preg_match('@[^\w]@', $Pass);
	
	if ($PassLength>0 && strlen($Pass) < $PassLength) {
		$str .= "Das Passwort muss mindestens $PassLength Zeichen lang sein.<br>";
	}
	switch ($PassRule) {
		case  3: if (!$Chars || !$Number) {$str .= 'Das Passwort muss beliebige Buchstaben UND Ziffern enthalten.<br>';} break;
		case  7: if (!$Chars || !$Number || !$SpecChars) {$str .= 'Das Passwort muss beliebige Buchstaben UND Ziffern UND Sonderzeichen enthalten.<br>';} break;
		case 35: if (!$UpperCase || !$LowerCase || !$Number) {$str .= 'Das Passwort muss Klein- UND Großbuchstaben UND Ziffern enthalten.<br>';} break;
		case 39: if (!$UpperCase || !$LowerCase || !$Number || !$SpecChars) {$str .= 'Das Passwort muss Klein- UND Großbuchstaben UND Ziffern UND Sonderzeichen enthalten.<br>';} break;
	}
	if ($str) {
		$OK = false;
		if ($print) {
			echo "<p class=\"passnote error\">Bitte beachten:<br>$str</p>\n";
		}
	}
	return $OK;
}

// ###################### Vorgefertigte Textbausteine #######################
// #### Tabelle mit den Logeinträgen:
function TableOfLogEntries() {
?>
	<table class="datenschutztabelle">
	<tr><td>IP-Adresse des aufrufenden Internet-Anschlusses:</td><td><?= $_SERVER['REMOTE_ADDR'] ?></td></tr>
	<tr><td>Zeitpunkt der Anforderung:</td><td><?= date('d/M/Y:H:i:s',$_SERVER['REQUEST_TIME']) ?> +0100</td></tr>
	<tr><td>Verwendete Anfragemethode:</td><td><?= $_SERVER['REQUEST_METHOD'] ?></td></tr>
	<tr><td>Name der angeforderten Datei:</td><td><?= $_SERVER['PHP_SELF'] ?></td></tr>
	<tr><td>Übertragungsprotokoll:</td><td><?= $_SERVER['SERVER_PROTOCOL'] ?></td></tr>
	<tr><td><a href="https://de.wikipedia.org/wiki/HTTP-Statuscode" target="_blank">HTTP-Statuscode</a> der Antwort:</td><td>200</td></tr>
	<tr><td>Übertragene Datenmenge:</td><td>8780 (Byte)</td></tr>
	<tr><td>Aufrufende Seite:</td><td><?= $_SERVER['HTTP_REFERER'] ?></td></tr>
	<tr><td>Das für den Zugriff auf die Datei verwendete Programm und Betriebssystem:</td><td><?= $_SERVER['HTTP_USER_AGENT'] ?></td></tr>
	</table>
<?php
}
// #### Liste mit den Cookies:
function ListOfCookies() {
	echo "<p><code>\n";
	foreach($_COOKIE as $key => $value) {	// Geben wir hier zuviele Informationen preis?
		echo "	$key => $value<br>\n";
	}
	echo "</code></p>\n";
}

// ###################### Content-Funktionen #######################
// #### Im Text Ausdrücke markieren:
function highlight($Text,$suche) {
	$htmlsuche = htmlentities($suche);
	$Text = preg_replace_callback("/((<[^>]*)|$suche)/i",
			function($match){$r='<span class="hilite">'.$match[1].'</span>';if (isset($match[2]) && $match[1]==$match[2]) $r=$match[1]; return $r;}, $Text);
	if ($htmlsuche != $suche) {
		$Text = preg_replace_callback("/((<[^>]*)|$htmlsuche)/i",
			function($match){$r='<span class="hilite">'.$match[1].'</span>';if (isset($match[2]) && $match[1]==$match[2]) $r=$match[1]; return $r;}, $Text);
	}
	return $Text;
}

// #### holt die Texte als zweidimensionales Array für die Sidebar/Infoboxen:
function getTicker($Typ=0,$Sort=0) {
	global $db,$MultiLang,$mylang;
	switch ($Sort) {
		case 1:  $ORD = ' ORDER BY Von DESC';  break;
		case 2:  $ORD = ' ORDER BY Von ASC';   break;
		case 3:  $ORD = ' ORDER BY Titel ASC'; break;
		default: $ORD = '';
	}
	$res = $db->query("SELECT ID,Titel,Text,Auto,Von,Bis FROM Infos WHERE (Typ=$Typ AND Lang=$mylang)$ORD");
	$ticker = array();
	while ($rec = $res->fetchArray()) {
		if ($MultiLang>0) {$rec[1] = deprefix($rec[1]);}
		$ticker[$rec[0]] = [$rec[1],$rec[2],'x',$rec[3],$rec[4],$rec[5]];
	}
	return $ticker;
}

// Überschrift einer Infobox anzeigen
function txtBoxTitle($anyway=false, $Name='', $PH='') {
	global $ShowBoxTitle,$BoxHeadLine;
	return TitleText($ShowBoxTitle,$BoxHeadLine,$anyway,$Name,$PH);
}
// Überschrift der Seite anzeigen
function printPageTitle($anyway=false, $Name='', $PH='') {
	global $ShowPageTitle,$MyHeadLine;
	echo TitleText($ShowPageTitle,$MyHeadLine,$anyway,$Name,$PH);
}
// Überschrift anzeigen
function TitleText($ShowTitle,$HeadLine,$anyway,$Name='', $PH='') {
	global $search, $AutoNumbers,$mypagenum;
	$Text = '';
	if ($ShowTitle>0 || $anyway) {
		$style = array('p','h1','h2','h3','h4','h5','h6','p');
		$hx = $style[$ShowTitle];
		if ($Name!='') {
			$Text = "<input type=\"text\" id=\"$Name\" name=\"$Name\" class=\"$hx\" placeholder=\"$PH\" value=\"$HeadLine\"><br>\n";
		} elseif ($HeadLine!='') {
			$Number = '';
			if ($search!='')
				$HeadLine = highlight($HeadLine,$search);
			if ($AutoNumbers)
				$Number = getAutoNumberByID($mypagenum).' ';
			$Text = "<$hx>$Number$HeadLine</$hx>\n";
		}
	}
	return $Text;
}
// ------------------------------------------- Formularelemente: -----------------------------------------
// checkbox erzeugen:
function setCheckButton($name,$labelTitle,$labelTxt,$value) {
	$txt = '<label for="'.$name.'" title="'.$labelTitle.'">'.$labelTxt.'</label><input type="checkbox" id="'.$name.'" name="'.$name.'"'.(($value)?' checked="checked"':'').'> &nbsp; '.$labelTitle."<br>\n";
	return $txt;
}
function txtCheckbox($name,$value,$idx='',$dis=0) {
	$strDis = $dis ? ' disabled':'';
	$txt = '<input type="checkbox" name="'.$name.'['.$idx.']" '. ($value ? ' checked="checked"' : '') .$strDis.'>';
	return $txt;
}
function txtReadOnlyBox($name,$value,$idx='',$dis=0) {
	if ($dis) {
		$txt = '<input type="checkbox" '. ($value ? ' checked="checked"' : '') .' disabled>';
		if ($value)
			$txt .='<input type="hidden" name="'.$name.'['.$idx.']" value="'.$value.'">';
		return $txt;
	} else {
		return txtCheckbox($name,$value,$idx,$dis);
	}
}
function setTextCheck($name,$wert,$value,$titel='') {
	if ($titel=='') $titel="Beschreibung $wert";
	echo '<input type="checkbox" name="'.$name.'[]" title="'.$titel.'" value="'.$wert.'"' . ((strpos($value,$wert)===false)?'':' checked="checked"') .'>';
}
// Pseudo Checkbox aus 2 Radiobuttons
function setSelCheck($name,$labelTitle,$labelTxt,$value) {
	$txt = "<label title=\"$labelTitle\">$labelTxt</label>".txtSelCheck($name,$value)."&nbsp; $labelTitle<br>\n";
	return $txt;
}
function txtSelCheck($name,$value) {
	$txt = '<span class="toggle">';
	$txt.= '<input type="radio" name="'.$name.'" id="'.$name.'0" value="0" title="nein" '.(($value)?'':' checked="checked"').'><label for="'.$name.'0" class="s0">J</label>';
	$txt.= '<input type="radio" name="'.$name.'" id="'.$name.'1" value="1" title="ja" '.(($value)?' checked="checked"':'').'><label for="'.$name.'1" class="s1">N</label></span>';
	return $txt;
}
// select:
function txtSelect($name,$text='',$js='') {
	$txt = "<label for=\"$name\">$text</label><select id=\"$name\" name=\"$name\" $js>\n";
	return $txt;
}
// select anzeigen:
function startSelect($name,$text='',$js='') {
	echo txtSelect($name,$text,$js);
}
function MultiSelect($name,$text='',$js='') {
	echo "<label for=\"$name\">$text</label><select id=\"$name\" name=\"$name"."[]\" multiple $js>\n";
}
// option erzeugen:
function txtOption($value,$text,$wert=-999,$pre='',$style='') {	// default $wert=-999, damit man die Funktion universell aufrufen kann...
	$txt = "<option value=\"$pre$value\"" . (($wert==$value)?' selected="selected"':'') . (($style!="")?' style="'.$style.'"':'') . ">$text</option>\n";
	return $txt;
}
function txtMulti($value,$text,$arr,$pre='',$style='') {
	$txt = "<option value=\"$pre$value\"" . ((in_array($value,$arr))?' selected="selected"':'') . (($style!="")?' style="'.$style.'"':'') . ">$text</option>\n";
	return $txt;
}
function numInput($name,$text,$wert,$min,$max,$step,$class='',$comment='') {
	$txt = '';
	if ($text!='') {
		$txt = "<label for=\"$name\">$text</label>";
	}
	if ($class!='') {
		$class = " class=\"$class\"";
	}
	$txt .= "<input type=\"number\"$class name=\"$name\" id=\"$name\" value=\"$wert\" min=\"$min\" max=\"$max\" step=\"$step\"> $comment\n";
	return $txt;
}
// ein Text-Input-Feld mit label und Zusatztext
function txtInput($name, $text, $wert='', $comment='', $js='') {
	$txt = "<label for=\"$name\">$text</label><input type=\"text\" id=\"$name\" name=\"$name\" value=\"$wert\" $js> ";
	if ($comment!='') $txt .= $comment;
	$txt .= "<br>\n";
	return $txt;
}
// color-Input-Feld
function colInput($name, $text, $wert='', $comment='', $js='') {
	$txt = "<label for=\"$name\">$text</label><input type=\"color\" id=\"$name\" name=\"$name\" value=\"$wert\" $js> ";
	if ($comment!='') $txt .= $comment;
	return $txt;
}
function fullInput($name, $text, $wert='',$disabled=0,$required=0,$comment='') {
	$strDis = $disabled ? ' disabled':'';
	$strReq = $required ? ' required':'';
	$txt = "<label for=\"$name\">$text</label><input type=\"text\" id=\"$name\" name=\"$name\"$strDis$strReq value=\"$wert\"> ";
	if ($comment!='') $txt .= $comment;
	$txt .= "<br>\n";
	return $txt;
}
function txtPass($name, $text, $wert='', $comment='', $js='') {
	$txt = "<label for=\"$name\">$text</label><input type=\"password\" id=\"$name\" name=\"$name\" value=\"$wert\" $js> ";
	if ($comment!='') $txt .= $comment;
	$txt .= "<br>\n";
	return $txt;
}
function txtDateInput($name, $text, $wert='', $comment='', $js='') {
	$txt = "<label for=\"$name\">$text</label><input type=\"date\" id=\"$name\" name=\"$name\" value=\"$wert\" $js> ";
	if ($comment!='') $txt .= $comment;
	$txt .= "<br>\n";
	return $txt;
}
function TextArea($name,$text,$wert='',$disabled=0,$required=0,$comment='',$rows=0) {
	$strDis = $disabled ? ' disabled':'';
	$strReq = $required ? ' required':'';
	$strRow = $rows ? ' rows="'.$rows.'"' : '';
	$txt = "<label for=\"$name\">$text</label><textarea id=\"$name\" name=\"$name\"$strDis$strReq$strRow>$wert</textarea>";
	if ($comment!='') $txt .= $comment;
	$txt .= "<br>\n";
	return $txt;
}

// ---------------------- Textseite zweispaltig ausgeben: ------------------------------
// ------ geht nur, wenn Spaltentrenner vorhanden sind ($divS...) - ABIC-Brennertechnik
function Spaltenprint($content,$hr=0) {
	global $WebStat,$MyPageParam, $AnzahlSpalten,$divSpalte, $divSParent,$divSpalte1,$divSpalte2,$divSpalte3,$divSpalte4, $EditInserts,$InsertLinks;
	$AnzSpalten= 2;

//	$splittext = preg_split('/<[^>]*[^\/]>/i' , $content, -1, PREG_SPLIT_NO_EMPTY);
	$splittext = preg_split('/<h6>Spaltenwechsel<\/h6>/i' , $content, -1, PREG_SPLIT_NO_EMPTY);
//	$splittext = preg_split('/<h6>[^*]<\/h6>/i' , $content, -1, PREG_SPLIT_NO_EMPTY);
//	print_r($splittext);
	$thiscount = count($splittext);	// Wieviele Abschnitte wird es geben?
	$count = 0;
	foreach($splittext as $text) {
		if ($count==0) {
			echo $divSParent;
			if ($MyPageParam!=3 || $thiscount>1) echo $divSpalte1;
		} else {
			echo $divSpalte2;
		}
		echo $text."</div>\n";
		$count++;
		$thiscount--;
		if ($count>1) {
			$count=0;
			if ($MyPageParam!=3 || $thiscount>0) echo "</div>\n";
			if ($thiscount>0 && $hr) {
				echo "<hr>\n";
			}
		}
	}
	if ($count>0 && $MyPageParam!=3)
		echo "</div>\n";
}

// Gibt dreispaltige Seite aus:
function print3($spaltentext,$i=0) {
	foreach($spaltentext as $num => $txt) {
		if (strstr($txt,'</h1>') && !strstr($txt,'<h1>'))
			$spaltentext[$num] = '<h1>'.$txt;
	}
	echo '<div class="leftside">' .$spaltentext[$i].  "</div>\n";
	echo '<div class="centre">'	  .$spaltentext[++$i]."</div>\n";
	echo '<div class="rightside">'.$spaltentext[++$i]."</div>\n";
}

// gibt den Content in gewünschter Anzahl Spalten aus, Content-Wrapper muss vorher/nachher gesetzt werden (ist hier nicht mit drin!)
// TODO: Option zick-zack, wenn mehr spaltentext als Spalten / 
function printContent($content) {
	
}
function printSpalten($spaltentext,$i=0) {
	global $AnzahlSpalten,$divSpalte;
	// kann es sein, dass wir zuwenig spaltentext haben (oder zuviel)?
	$CountSpalten = count($spaltentext);
	if ($CountSpalten>$AnzahlSpalten)
		echo $divSpalte[0]."\n";
	echo $divSpalte1."\n".$spaltentext[$i]."</div>\n";
	// Rest folgt noch...
}
// zerlegt einen Content in Abschnitte (Spalten):
function TextSplitter($text,$delim1='<h6>',$delim2='</h6>') {
	global $TextSplitType;	// 0:h1 / 1:h6

	if ($TextSplitType==0) {
		$split = explode('<h1>',$text);
		foreach($split as $num => $txt) {
			if (strstr($txt,'</h1>') && !strstr($txt,'<h1>'))
				$split[$num] = "<h1>$txt";
		}
	} else {
		$splittext = explode($delim1,$text);
		$split = array();
		foreach($splittext as $num=>$text) {
			$temptext = explode($delim2,$text);
			if (!empty($temptext[1]))
				$split[$num] = $temptext[1];
			else	//if (!empty($temptext[0]))	// oder überhaupt???
				$split[$num] = $temptext[0];
		}
	}
	return $split;
}
//	ergänzt Bilder mit einer Lightbox-Funktion:
function withLightbox($Content,$BoxOnPage) {
	global $db,$MyMedia,$HasGallery;
	$images = explode('<img ',$Content);
	if (count($images)>0) {	// links auf img gefunden:
		// Ist das ein KissGallery-Bild?
		// Welche KissGallery-Ordner gibt es?
		$folders = $db->query("SELECT DISTINCT Folder FROM Gallery");
		while($fold = $folders->fetchArray()) {
			$KGFolders[] = $MyMedia.$fold[0];
		}
//		$KGFolders = array_unique($KGFolders);	// bringt leider nichts...
		foreach ($images as $idx=>$imgTag) {
			if ($idx>0 && ($BoxOnPage<7 || strpos($imgTag,'class="lightbox"')!==false)) {	// Bild behandeln? ($idx=0 ist VOR dem ersten Bild)
				// src und title oder alt feststellen - besser mit preg_match?:
				$srcpos0 = strpos($imgTag,'src=') + 4;
				$delimit = $imgTag[$srcpos0];
				$srcpos1 = strpos($imgTag,$delimit,$srcpos0 + 3) - 1;
				$src = substr($imgTag,$srcpos0 + 1,$srcpos1-$srcpos0);
				$FindIt = true;
//				$images[0] .= ' <span class="hilite">'.$src.'</span>';	//	nur zum Test... -> OK!
				foreach ($KGFolders as $folder) {
					if ($FindIt && substr($src,0,strlen($folder)) == $folder) {
//						yes, it's a KissImage
//					$images[0] .= ' <span class="hilite">'.$src.'</span>';	//	nur zum Test... -> OK!
//						add lightbox with title tag:
//						title oder alt feststellen - besser mit preg_match?:
						$titpos0 = strpos($imgTag,'title=');
						if ($titpos0!==false) {
							$delimit = $imgTag[$titpos0 + 6];
							$titpos1 = strpos($imgTag,$delimit,$titpos0 + 7) - 7;
							$tit = ' title="' . substr($imgTag,$titpos0 + 7,$titpos1-$titpos0) . '"';
						} else {
							$titpos0 = strpos($imgTag,'alt=');
							if ($titpos0!==false) {
								$delimit = $imgTag[$titpos0 + 4];
								$titpos1 = strpos($imgTag,$delimit,$titpos0 + 5) - 1;
								$tit = ' title="' . substr($imgTag,$titpos0 + 5,$titpos1-$titpos0) . '"';
							} else {
								$tit = '';
							}
						}
						$imgTagEnd = strpos($imgTag,'>')+1;
						$src = str_replace('/Thumbs','',$src);
						$images[$idx-1] .= '<a href="'.$src.'" id="image'.$idx.'" class="lightbox-gr"'.$tit.'>';	// Link auf Lightbox dem <img...> voranstellen
						$images[$idx] = substr($imgTag,0,$imgTagEnd).'</a>'.substr($imgTag,$imgTagEnd);	// </a> hinter dem <img...> ergänzen
						$HasGallery = true;
						$FindIt = false;
					}
				}
			}
		}
		$Content = implode('<img ',$images);
	}
	return $Content;
}

//	['de'=>'deutsch','en'=>'englisch','fr'=>'französisch','es'=>'spanisch','it'=>'italienisch','nl'=>'holländisch','pt'=>'portugiesisch'];
// zeigt Name eines Wochentags an:
function wochentag($datum) {
	global $WibLang;
	switch ($WibLang) {
		case 0: $t = ['Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag']; break;
		case 1: $t = ['Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday']; break;
		case 2: $t = ['Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi']; break;
		case 3: $t = ['Domingo','Lunes','Martes','Miércoles','Jueves','Viernes','Sábado']; break;
		case 4: $t = ['Domenica','Lunedì','Martedì','Mercoledì','Giovedì','Venerdì','Sabato']; break;
		case 5: $t = ['Zondag','Maandag','Dinsdag','Woensdag','Donderdag','Vrijdag','Zaterdag']; break;
		case 6: $t = ['domingo','segunda-feira','terça-feira','quarta-feira','quinta-feira','sexta-feira', 'sábado']; break;
	}
	return $t[date('w',$datum)];
}
// erzeugt Array mit Monatsnamen:
function monat() {
	global $WibLang;
	switch ($WibLang) {
		case 0: $t = ['','Januar','Februar','März','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember']; break;
		case 1: $t = ['','January','February','March','April','May','June','July','August','September','October','November','December']; break;
		case 2: $t = ['','janvier','février','mars','avril','mai','juin','juillet','août','septembre','octobre','novembre','décembre']; break;
		case 3: $t = ['','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre']; break;
		case 4: $t = ['','Gennaio','Febbraio','Marzo','Aprile','Maggio','Giugno','Luglio','Agosto','Settembre','Ottobre','Novembre','Dicembre']; break;
		case 5: $t = ['','Januari','Februari','Maart','April','Mei','Juni','Juli','Augustus','September','Oktober','November','December']; break;
		case 6: $t = ['','Janeiro','Fevereiro','Março','Abril','Maio','Junho','Julho','Agosto','Setembro','Outubro','Novembro','Dezembro']; break;
	}
	return $t;
}
// file not found:
function e404() {
	global $WibLang;
	$e404 = ['Fehler 404 - Seite nicht gefunden',
			'Error 404 - Page not found',
			'Erreur 404 - Page introuvable',
			'Error 404 - Página no encontrada',
			'Errore 404 - Pagina non trovata',
			'Fout 404 - Pagina niet gevonden',
			'Erro 404 - Página não encontrada'];
	return $e404[$WibLang];
}

// Kommentare anzeigen:
function getComments($Page,$Reply=0,$Level=0) {
	global $db,$WibLang;
	$comm = '';
	$res = $db->query("SELECT * FROM Comments WHERE (Page=$Page AND Status=1 AND Reply=$Reply)");
	while ($rs = $res->fetchArray()) {
		$txt = $rs['Comment'];
		$rep = $rs['ID'];
		$strRep = $Reply ? 'antwortete' : 'schrieb';
		$comm .= '<p class="CommLevel'.$Level.'"><b>'. $rs['Name'] . "</b> <small>$strRep am". date(' d.m.Y ',$rs['Datum']).'um'.date(' H:i ',$rs['Datum'])."Uhr:</small><br>\n";
		$comm .= $rs['Comment'] . "<br>\n";
		$comm .= '<small><span class="replyto cursor" id="reply_'.$rep.'">Antworten</span></small></p><div class="helper CommLevel'.$Level+1 .'" id="repform_'.$rep."\"></div>\n";
		$comm .= getComments($Page,$rep,$Level+1);
	}
	return $comm;
}

// listet rekursiv alle Seiten für eine Sitemap auf:
function MapSites($Parent=0, $Show=1) {
	global $ShowAllBranches,$ShowStartPage,$Breadcrumb;

//	Save values:
	$SSP = $ShowStartPage;
	$SAB = $ShowAllBranches;
	$Bc  = $Breadcrumb;

//	Set necessary values for sitemap:
	$ShowStartPage = 1;
	$Breadcrumb = false;
	$ShowAllBranches = true;
	$sitemap = '';

//	Regular Navigation:
	$sitemap .= MapSite(0,1,0,0);

//	Second navigation
	$sitemap .= MapSite(0,2,0,0);

//	Footer navigation:
	$sitemap .= MapSite(0,3,0,0);

//	Reset values:
	$ShowStartPage = $SSP;
	$ShowAllBranches = $SAB;
	$Breadcrumb = $Bc;

	return $sitemap;
}

// konvertiert textarea-Eingaben in strings mit <br>
function text2br($post) {
	global $db;
	if (isset($_POST[$post])) {
		$text = trim($_POST[$post]);
		$text = $db->escapeString(str_replace(array("\r\n", "\r", "\n"), '<br>', $text));
	} else
		$text = '';
	return $text;
}
// konvertiert strings mit <br> oder <br /> in Textarea-Format (mit \n)
function br2text($text) {
	$text = str_replace(array('<br>','<br />'),"\n",$text);
	return $text;
}

// Backups löschen:
function Del_Backups($dellist=[]) {
	global $MyBackUps,$ups;
	foreach($dellist as $datei) {
		$Entry = $MyBackUps.$datei;
		if (is_file($Entry)) {
			if (unlink($Entry)) {
				$ups.="<li>$Entry gelöscht</li>";
			} else {
				$ups.="<li>$Entry NICHT gelöscht</li>";
			}
		} else {
			delTree($Entry);
		}
	}
}
// Bild(er) / Datei(en) aus Galerie / Ordner löschen:
function Del_Image($Ordner,$Thumbs='',$Originals='',$Dellist='') {
	global $ups;
	// Dateien löschen?
	if ($Dellist!='') {
		$dellist = explode(',',$Dellist);
	} elseif (isset($_POST['del'])) {
		$dellist = $_POST['del'];
	} else {
		$dellist = '';
	}
	if (is_array($dellist)) {
		foreach($dellist as $datei) {
			if (unlink($Ordner.$datei)) {
				$ups.="<li>$Ordner$datei gelöscht</li>";
			} else {
				$ups.="<li>$Ordner$datei NICHT gelöscht</li>";
			}
			if ($Thumbs) @unlink($Thumbs.$datei);
			if ($Originals) @unlink($Originals.$datei);
		}
	}
}

// Speichert ein 2-dimensionales Array in eine csv-Datei mit Default-Zeichen # als Trenner:
function saveCSV($datei,$array,$trenner='#') {
	global $ups;
	$success = false;
	if ($configfile = @fopen($datei, "wb")) {
		foreach ($array as $rec) {
			fwrite($configfile, implode($trenner,$rec)."\n");
		}
		fclose($configfile);
		$success = true;
	} else {
		$ups.="<li>Kann Datei $datei nicht speichern!</li>";
		write_log("Kann Datei $datei nicht speichern!");
	}
	return $success;
}

// verschickt eine E-Mail:
function trymail($betreff,$nachricht,$mailaddress='',$CC='',$BCC='',$Reply='') {
	return SendMail($mailaddress, $betreff, $nachricht, 0,$CC,$BCC,$Reply);
}
function htmmail($betreff,$nachricht,$mailaddress='',$CC='',$BCC='',$Reply='',$AltBody='') {
	return SendMail($mailaddress, $betreff, $nachricht, 1,$CC,$BCC,$Reply,$AltBody);
}

function SendMail($mailaddress, $betreff, $nachricht, $isHTML, $CC='', $BCC='', $Reply='',$AltBody='') {
	global $MyCore, $MailTo,$Sender,$Signatur,$SenderName;
	global $MailHost,$MailPort,$MailUser,$MailPass,$MailSect;

	$MyModules = $MyCore.'mailer';	// PHPMailer in core/mailer/

	if ($mailaddress=='') $mailaddress = $MailTo;

//	utf8_encode($betreff), utf8_encode($nachricht) -> NÖ: das codieren von Quatschzeichen bringt nur noch mehr Quatschzeichen...

	if ($Signatur!='') {
		if ($isHTML) {
			$Signatur = nl2br($Signatur,0);
			$nachricht .= "<p>$Signatur</p>";
		} else {
			$nachricht .= "\r\n$Signatur\r\n";
		}
	}

	if (!is_dir("$MyModules/src")) {
//		Mail with internal php mail function
		if (strpos($Sender,'<')===false and $SenderName!='')
			$Sender = "$SenderName <$Sender>";
		if ($isHTML) {
			$header = "From: $Sender\n"		// Nötige HEADER-Angaben
			."MIME-Version: 1.0\r\nContent-Type: text/html; charset=UTF-8\r\n";
			$betreff = "=?UTF-8?B?".base64_encode($betreff)."?=";
			$nachricht = "<html><head><title>$betreff</title></head><body>" . $nachricht . "</body></html>";
		} else {
			$header = "From: $Sender\n"		// Nötige HEADER-Angaben
			."Content-Type: text/plain; charset=\"utf8\"\n"
			."Content-Transfer-Encoding: 8bit\n"
			."X-Mailer: WIBcms PHP ".phpversion();
		}
		write_log("E-Mail mit php-mail, weil $MyModules/src nicht existiert.");
		if (mail($mailaddress, $betreff, $nachricht, $header)) {
			write_log('E-Mail mit php-mail erfolgreich veschickt');
			return true;
		} else {
			write_log('Fehler beim E-Mail-Versand mit php-mail');
			return false;
		}
	} else {
//		Mail with PHPMailer
		include_once "$MyModules/src/Exception.php";
		include_once "$MyModules/src/PHPMailer.php";
		include_once "$MyModules/src/SMTP.php";

		$mail = new PHPMailer(true);
//		$mail->setLanguage('de', "$MyModules/PHPMailer/language/");
		try {
//		Server settings
//			$mail->SMTPDebug = SMTP::DEBUG_SERVER;		//Enable verbose debug output
			$mail->isSMTP();
			$mail->SMTPAuth   = true;
			$mail->CharSet	  = 'utf-8';
			$mail->Host       = $MailHost;
			$mail->Username   = $MailUser;
			$mail->Password   = decrypt($MailPass);
			$mail->SMTPSecure = "PHPMailer::$MailSect";
			$mail->Port       = $MailPort;
			$mail->setFrom($Sender, $SenderName);
//			write_log("Mail via $MailHost:$MailPort with $MailSect and $MailUser");

//		Recipients
			if (is_array($mailaddress)) {
				foreach ($mailaddress as $address) {
					$mail->addAddress($address);
				}
			} else {
				$mail->addAddress($mailaddress);	// Name is optional: addAddress($mailaddress, 'Name')
			}
			if ($CC!='')   { $mail->addCC($CC); }
			if ($BCC!='')  { $mail->addBCC($BCC); }
			if ($Reply!=''){ $mail->addReplyTo($Reply); }

//		Attachments
//			$mail->addAttachment('/var/tmp/file.tar.gz');         // Add attachments
//			$mail->addAttachment('/tmp/image.jpg', 'new.jpg');    // Optional name

//		Content
			if ($isHTML) {
				$mail->isHTML(true);	//Set email format to HTML
				if ($AltBody!='') { $mail->AltBody = $AltBody; }	// body in plain text for non-HTML mail clients
			}
			$mail->Subject = $betreff;
			$mail->Body    = $nachricht;

			$mail->send();
			$txt = "Mail wurde mit PHPMailer via $MailHost:$MailPort verschickt.";
			write_log($txt);
			return true;
		} catch (Exception $e) {
			$txt = "PHPMailer konnte Mail nicht versenden, Fehler: {$mail->ErrorInfo}";
			write_log($txt);
			return false;
		}
	}
}
// ----------------- Die Suchfunktion: ----------------------------------
function Suchen($Content,$page='') {
	echo suchform($page);
}
function suchform($action='', $txt='') {
	global $MultiLang,$mylang,$MyLanguages, $strSearch,$u;
	if ($MultiLang && $action=='') {
		$action = $MyLanguages[$mylang] . ':search';
	}	// den Zeilenumbruch <br> kann man diskutieren...
	return '<form action="'.$u.$action.'" method="post" class="search">'.$txt.'<input type="text" name="suche" placeholder="Suchbegriff"><br><input type="submit" name="suchen" value="'.$strSearch[$mylang]."\"></form>\n";
}
function suche($suche='') {
	global $db,$WebStat, $u,$mylang,$MyPageType,$MyPageParam, $strNotFound,$strFound, $UseSearch, $UseDownloads,$UseIncludes, $UseKalender1,$strEvents,$Events,$ApproveCal,
		$UseProtocols,$strProtocols,$Protocols,$ApproveProt, $UseSidebar,$UseAutoNews, $UseForum1,$UseForum2,$UseForum3, $UsePlugins,$MyPlugins,$MyPlugData;
// common preparation:
	if ($suche=='')
		$suche = $_POST['suche'];
	$txt = '';
	$htmlsuche = htmlentities($suche);
	$suchmich  = htmlspecialchars($suche);
	if ($WebStat&1) {
		$WHERE = '';			// is Admin/Developer, may view all pages
	} elseif ($WebStat) {
		$WHERE = 'Login<99 AND';// is logged in, may view all pages except those for Admins/Developers only
	} else {
		$WHERE = 'Login<3 AND';	// not logged in, may view only free pages
	}
// prepare statement to find pages
	$sel = "SELECT URL,Link,Title,ID,Type,Parameter FROM Pages WHERE $WHERE Lang=$mylang AND Show>0 AND RefID=0 AND ";

// Suche in Seitentexten: wegen tinymce auch HTML-codiert
	$mysearch = "Content LIKE '%$suche%'"; $orsearch = "Title LIKE '%$suche%'";
	if ($htmlsuche != $suche) {
		$mysearch .= " OR Content LIKE '%$htmlsuche%'"; $orsearch .= " OR Title LIKE '%$htmlsuche%'";
	}
	$sql = $sel . "(($orsearch) OR (($mysearch) AND (Type='Text' OR (NOT Type='Text' AND AddC=1))))";
	$res = $db->query($sql);
	$FoundIDs = array();
	while ($rec = $res->fetchArray()) {
		$txt .= '<a href="'.$u.$rec[0].'&search='.$suchmich.'" title="'.$rec[2].'">'.$rec[1]." <small>(Seite)</small></a><br>\n";
		$FoundIDs[]=$rec[3];
	}

// Jetzt noch weitere Module abfragen
// Das Problem ist das Highlighting der Trefferstellen in den Ausgabeseiten....

	// Search in Include-Files: -> Highlighting missing! Aber wie???
	if ($UseIncludes) {
		$sql = $sel . "Type='Include'";
		$res = $db->query($sql);
		while ($rec = $res->fetchArray()) {
			$searchpage = $rec[0];
			if (is_file("data/includes/$searchpage.php")) { $datei="data/includes/$searchpage.php"; }
			elseif (is_file("data/includes/".deprefix($searchpage).".php")) { $datei="data/includes/".deprefix($searchpage).".php"; }
			else {$datei='';}
			if ($datei!='') {
				$text = file_get_contents($datei);
				if (stristr($text,$suche)!==false) {
					$txt .= '<a href="'.$u.$rec[0].'&search='.$suchmich.'" title="'.$rec[2].'">'.$rec[1]." <small>(Spezialseite)</small></a><br>\n";
				}
			}
		}
	}

	// Search in Plugins:
	if ($UsePlugins) {
		$sql = $sel . "Type LIKE 'Plugin%'";
		$res = $db->query($sql);
		while ($rec = $res->fetchArray()) {
			$plug = substr($rec[4],7);
			$MyFind = "$MyPlugins/$plug/find.php";
			if (is_file($MyFind))
				include $MyFind;
		}
	}

	// Search im Kalender/Protokollen: wegen tinymce auch HTML-codiert
	if ($UseKalender1 or $UseProtocols) {
		$mysearch = "Titel LIKE '%$suche%' OR Text LIKE '%$suche%'";
		if ($htmlsuche != $suche) {
			$mysearch .= " OR Titel LIKE '%$htmlsuche%' OR Text LIKE '%$htmlsuche%'";
		}
		$sql = "SELECT ID,Modus,Titel,Zeit FROM Events WHERE $mysearch";
		if ($ApproveProt) {
			$sql .= " AND ((Modus LIKE '1-%' AND Approved>0)";
			if ($ApproveCal) {
				$sql .= " AND (Modus LIKE '0%' AND Approved>0)";
			} else {
				$sql .= " OR Modus LIKE '0%')";
			}
		} else {
			if ($ApproveCal) {
				$sql .= " AND ((Modus LIKE '0%' AND Approved>0) OR Modus LIKE '1-%')";
			}
		}
		$OK = $db->query($sql);
		if (!empty($OK)) {
			$findCal = true;
			while ($rec = $OK->fetchArray()) {
				$Mode = substr($rec['Modus'],0,1);
				if ($UseKalender1 and $findCal and $Mode=='0') {	// Fall 1: es gibt nur einen (1) Kalender als Seite! Wenn passender Termin vorhanden: diese anzeigen
					$findCal = false;	// damit derselbe Kalender nicht mehrmals angezeigt wird
					$sql = $sel . "Type='Kalender1'";
					$res = $db->query($sql);
					while ($erg = $res->fetchArray()) {	// Jetzt doch mehrere Kalender suchen -> verschiedene Darstellungsformen...
						$txt .= '<a href="'.$u.$erg[0].'&search='.$suchmich.'" title="'.$erg[2].'">Kal '.$erg[1]." <small>($strEvents)</small></a><br>\n";
					}
				}
				if ($UseProtocols and $Mode=='1') {	// Fall 2: Kalendermodul für Protokolle benutzt
					$Cat = substr($rec['Modus'],2);
					$sql = $sel . "Type='Protocols' AND Parameter='$Cat'";
					$res = $db->querySingle($sql,1);
					$txt .= '<a href="'.$u.$res['URL'].'&search='.$suchmich.'">'.$res['Title'].'</a> -> '.date('d.m.Y',$rec[3]).': '.$rec[2]."<small> ($strProtocols ".$Protocols[$Cat].")</small><br>\n";
				}
			}
		}
	}

	// Search in Blog, Forum, Guestebook:
	if ($UseForum1 || $UseForum2 || $UseForum3) {
	//	Forenthemen / Überschriften
		$sql = "SELECT ID,Typ,Name FROM Foren WHERE Parent>0 AND Show>0 AND (Name LIKE '%$suche%' OR Comment LIKE '%$suche%' OR Subject LIKE '%$suche%')";
		$txt .= LinkToForum($sql,$suche);

	//	Beiträge an sich:
		$sql = "SELECT ID,ForenID FROM Forum WHERE Stat>0 AND Beitrag LIKE '%$suche%' AND ForenID IN (SELECT ID FROM Foren WHERE Parent>0 AND Show>0)";
		debug($sql,3);
		$res = $db->query($sql);
		while ($rec = $res->fetchArray()) {
			$sql = "SELECT ID,Typ,Name FROM Foren WHERE ID=".$rec[1];
			debug($sql,3);
			$txt .= LinkToForum($sql,$suche);
		}
	}

	// Search in Infoboxes/News:
	if ($UseSidebar || $UseAutoNews) {
		$FoundAutoNews = 0;
		$mysearch = "Lang=$mylang AND Titel LIKE '%$suche%' OR Text LIKE '%$suche%'";
		if ($htmlsuche != $suche) {
			$mysearch .= " OR Titel LIKE '%$htmlsuche%' OR Text LIKE '%$htmlsuche%'";
		}
		$sql = "SELECT ID,Titel,Typ FROM Infos WHERE $mysearch";	// Zeitgesteuerte ggf. ausblenden
		$res = $db->query($sql);
		while ($rec = $res->fetchArray()) {	// 
			if ($rec['Typ']==0 && $UseSidebar) {	// ist Infobox in der Sidebar -> Seite dazu suchen:
				$sql = $sel . "Info LIKE '".$rec['ID']."'";	// ----------------------- LIKE fehlerbehaftet... (1,11...) -------------------------
				if (!empty($FoundIDs))	// bereits gefundene Contentseiten nicht erneut aufnehmen
					$sql.=" AND ID NOT IN (".join(',',$FoundIDs).")";
				$rs  = $db->querySingle($sql,1);	// 1 Eintrag auf dieselbe Infobox reicht ja, oder???
				if (!empty($rs))
					$txt .= '<a href="'.$u.$rs['URL'].'&search='.$suchmich.'" title="'.$rs['Title'].'">'.$rs['Link']." <small>(Infobox)</small></a><br>\n";
			} elseif ($rec['Typ']==1 && $UseAutoNews && !$FoundAutoNews) {
				// News noch nicht generell implementiert (ABIC)
				// ist AutoNews -> Seite dazu suchen:
				$sql = $sel . "Type='AutoNews'";
				$rs  = $db->querySingle($sql,1);
				if (!empty($rs)) {
					$txt .= '<a href="'.$u.$rs['URL'].'&search='.$suchmich.'&showid='.$rec['ID'].'" title="'.$rs['Title'].'">'.$rs['Link']." <small>(News-Seite)</small></a><br>\n";
					$FoundIDs[]=$rs['ID'];
//					$FoundAutoNews = 1;	// es reicht/gibt nur 1 AutoNews-Seite -> aber mehrere Beiträge!
				}
			}
		}
	}

	// Search in KissGallery:	// Highlighting fehlt noch? // Galerie1=Diashow auch indizieren?
	if (true) {
		// suche nach Galerien
		$mysearch = "Name LIKE '%$suche%' OR Comment LIKE '%$suche%' OR C_Text LIKE '%$suche%'";	// evtl. noch checken, ob Titel und Comment hier überhaupt angezeigt werden
		if ($htmlsuche != $suche) {
			$mysearch .= " OR Name LIKE '%$htmlsuche%' OR Comment LIKE '%$htmlsuche%' OR C_Text LIKE '%$suche%'";
		}
		// AND Typ=.. // Typ: evtl. filtern nach normal/Merkliste/Bildleiste...
		$sql = "SELECT ID FROM Gallery WHERE $mysearch";
		$res = $db->query($sql);
		$gal = array();
		while ($rec = $res->fetchArray()) {
			// Hier werden Unteralben nicht gefunden (da nicht in Seitenstruktur aufgeführt!)
			$gal[] = $rec[0];
			$sql = $sel . "(Type='KissGallery' OR Type='KissMemory' OR Type='Galerie1' OR Type='KissAlbum') AND Parameter=".$rec[0];
			$rs  = $db->querySingle($sql,1);	// 1 Eintrag auf dieselbe Galerie reicht ja, oder???
			if (!empty($rs))
				$txt .= '<a href="'.$u.$rs['URL'].'&search='.$suchmich.'" title="'.$rs['Title'].'">'.$rs['Link']." <small>(Bildergalerie)</small></a><br>\n";
		}
		// suche nach Bildern (evtl. noch checken, ob Desc1234 überhaupt angezeigt werden)
		$mysearch = "File LIKE '%$suche%' OR Desc1 LIKE '%$suche%' OR Desc2 LIKE '%$suche%' OR Desc3 LIKE '%$suche%' OR Desc4 LIKE '%$suche%'";
		if ($htmlsuche != $suche) {
			$mysearch .= " OR File LIKE '%$htmlsuche%' OR Desc1 LIKE '%$htmlsuche%' OR Desc2 LIKE '%$htmlsuche%' OR Desc3 LIKE '%$htmlsuche%' OR Desc4 LIKE '%$htmlsuche%'";
		}
		$sql = "SELECT DISTINCT GalleryID FROM Galerie WHERE ($mysearch)";
		if (!empty($gal))
			$sql .= " AND GalleryID NOT IN (".join(',',$gal).")";
//		echo "<p>$sql</p>\n";
		$res = $db->query($sql);
		while ($rec = $res->fetchArray()) {
			$sql = $sel . "(Type='KissGallery' OR Type='KissMemory' OR Type='Galerie1' OR Type='KissAlbum') AND Parameter=".$rec[0];
//			echo "<p>$sql</p>\n";
			$rs  = $db->querySingle($sql,1);	// 1 Eintrag auf dieselbe Galerie reicht ja, oder???
			if (!empty($rs))
				$txt .= '<a href="'.$u.$rs['URL'].'&search='.$suchmich.'" title="'.$rs['Title'].'">'.$rs['Link']." <small>(Bild in Galerie)</small></a><br>\n";
		}
	}

	// Search in Downloads:
	if ($UseDownloads) {
		$mysearch = "Text LIKE '%$suche%' OR Datei LIKE '%$suche%'";
		if ($htmlsuche != $suche) {
			$mysearch .= " OR Text LIKE '%$htmlsuche%' OR Datei LIKE '%$htmlsuche%'";
		}
		$sql = $sel . "ID IN (SELECT DISTINCT Kategorie FROM Downloads WHERE ($mysearch))";
//		echo "<p>$sql</p>\n";
		$res = $db->query($sql);
		while ($rs = $res->fetchArray()) {
			$txt .= '<a href="'.$u.$rs['URL'].'&search='.$suchmich.'" title="'.$rs['Title'].'">'.$rs['Link']." <small>(Downloads)</small></a><br>\n";
		}
//		Search in pdf-files:

	}
/*
	if ($UseAlben) {
		$sql = "SELECT ... FROM Alben WHERE (Text LIKE '%$suche%' OR Datei LIKE '%$suche%')";
		$sql = "SELECT URL,Link,Title FROM Pages WHERE ID IN ()";
	}
*/
	// now show all collected hits:
	if ($txt!='') {
		$txt = $strFound[$mylang] . ":<br>$txt";
	} else {
		$txt = $strNotFound[$mylang];
	}
	$txt = "<span class=\"hilite\"> $suche </span> $txt";
	if ($UseSearch&1 && $MyPageType!='Suchen') {
		$txt = suchform('', $txt.'<br>');
	} else {
		$txt = "<p class=\"search\">$txt</p>\n";
	}

	return $txt;
}
function LinkToForum($sql,$suche) {
	global $db,$mylang,$u;
	$txt = '';
	$suchmich = htmlspecialchars($suche);
	$rs = $db->query($sql);
	while ($rc = $rs->fetchArray()) {
		$sql = "SELECT URL,Link,Title FROM Pages WHERE Type='Forum".$rc['Typ']."' AND Parameter=".$rc['ID']." AND Lang=$mylang AND Show>0";
		$rec  = $db->querySingle($sql,1);
		debug($sql,3);
		if (!empty($rec)) {	// direkter Link vorhanden?
//				echo $sql . " -> Found!<br>\n";
			$txt .= '<a href="'.$u.$rec['URL'].'&search='.$suchmich.'" title="'.$rec['Title'].'">'.$rec['Link']." <small>(Beitrag)</small></a><br>\n";
			$found++;
		} else {
			$sql = "SELECT URL,Link,Title FROM Pages WHERE Type='Forum".$rc['Typ']."' AND Lang=$mylang AND Show>0";
			debug($sql,3);
			$rec  = $db->querySingle($sql,true);
			if (!empty($rec)) {	// Navigation OK, erweitern
				$txt .= '<a href="'.$u.$rec['URL'].'&forum='.$rc['ID'].'&search='.$suchmich.'" title="'.$rec['Title'].'">'.$rc['Name']." <small>(Forum)</small></a><br>\n";
			}
		}
	}
	return $txt;
}

// ---------------------- Downloads anbieten: ------------------------------
// Hilfsfunktion Dateigröße:
function txtFileSize($Datei) {
	$filesize = filesize($Datei)/1024; $E = 'KB';
	if ($filesize>1024) {
		$filesize = $filesize/1024; $E = 'MB';
		$filesize = (int)(100*$filesize + .5) / 100;
	} else {
		$filesize = (int)($filesize + 0.5);
	}
	return "$filesize&nbsp;$E";
}
// ermitteln max. Dateigrößen für Uploads:
function ini_upload() {
	$PostMaxSize = ini_get('post_max_size');
	$FileMaxSize = ini_get('upload_max_filesize');
	$MAXFILESIZE = intval($FileMaxSize);
	$last = strtolower($FileMaxSize[strlen($FileMaxSize)-1]);
	switch ($last) {
		case 'g': $MAXFILESIZE *= 1024;
		case 'm': $MAXFILESIZE *= 1024;
		case 'k': $MAXFILESIZE *= 1024;
	}
	$MaxBytes = number_format($MAXFILESIZE,0,',','.');
	return [$PostMaxSize,$FileMaxSize,$MAXFILESIZE,$MaxBytes];
}
function printDown($row,$ShowFileSize,$ShowFileDate,$DLFolder) {
	global $search;
	if ($search!='') {
		$row[1] = highlight($row[1],$search);
	}
	$MyDatei = $DLFolder.$row[0];
	$MyFileProp = '';
	if ($ShowFileSize) {
		$MyFileProp = txtFileSize($MyDatei);
	}
	if ($ShowFileDate) {
		if ($ShowFileSize) $MyFileProp .= ', ';
		$MyFileProp .= date('d.m.Y',filemtime($MyDatei));
	}
	if ($MyFileProp != '') {
		$MyFileProp = " <small>($MyFileProp)</small>";
	}
	echo '	<li><a target="_blank" href="'.$MyDatei.'">'.$row[1]."$MyFileProp</a></li>\n";
}
// ToDo: von ABIC-spezifischem Zeugs befreien:
// spaltenparent / Spalten divs/h3 / Anzahl Spalten=2 / zick-zack / Kategorien auf Pages-Ebene 3 fest verdrahtet...
function listDownloads($content) {
	global $db,$DLFolder, $mypagenum,$mylang, $ShowFileSize,$ShowFileDate,$ShowDownTitle, $DefaultLang;
	global $AnzahlSpalten, $divSParent,$divSpalte1,$divSpalte2,$divSpalte3,$divSpalte4;
	$DLFolder.='/';
	$style = array('','h1','h2','h3','h4','h5','h6','p');

// Zuerst schauen: gibt es direkte Downloads (ohne weitere Kategorien) auf dieser Seite?
	if ($mylang == $DefaultLang) {
		$kat = "Kategorie=$mypagenum";
	} else {
		$kat = "Kategorie=(SELECT Ist FROM Pages WHERE Lang=$mylang AND ID=$mypagenum)";
	}
	$sql = "SELECT Datei,Text FROM Downloads WHERE $kat ORDER BY Folge";
	$res = $db->query($sql);
	$cntdir = 0;
	$dldir = array();
	$strDldir = array();
	while ($rec = $res->fetchArray()) {
		$down[$cntdir] = [$rec[0],$rec[1]];
		$dldir[$cntdir] = $rec[0];
		$strDldir[$cntdir] = $rec[1];
		$cntdir++;
	}

// Danach schauen, welche (und wie viele) Download-Produktkategorien es auf dieser Seite gibt:
	$sql = "SELECT ID,Link FROM Pages WHERE Parent=$mypagenum ORDER BY Folge";
	$res = $db->query($sql);
	$i = 0;
	$prod = array();
	$strProd = array();
	while ($row = $res->fetchArray()) {
		$prod[$i] = $row[0];
		$strProd[$i] = $row[1];
		$i++;
	}

// Jetzt Zusatztext einfügen:
	$count = 0;
	$gesamt = $i+(int)($cntdir>0);
	if ($gesamt%2 == 1 && $AnzahlSpalten>1) {	// ungerade Anzahl von Kategorien: Zusatztext in linke Spalte:
		echo $divSParent . $divSpalte1 . "\n";
		echo $content;
		echo '</div>';
		$count = 1;
	} else {
		echo $content;
	}
// gibt es direkte Downloads (ohne weitere Kategorien) auf dieser Seite?
	if ($cntdir>0) {
		if ($AnzahlSpalten>1) {
			if ($count==0) {
				echo $divSParent . $divSpalte1 . "\n";
			} else {
				echo "\n$divSpalte2\n";
			}
		}
		echo "	<ul class=\"downloads\">\n";
		foreach($down as $row) {
			printDown($row,$ShowFileSize,$ShowFileDate,$DLFolder);
		}
		echo "	</ul>\n";
		if ($AnzahlSpalten>1) {
			echo "</div>\n";
			$count++;
			if ($count==$AnzahlSpalten) {
				echo "</div>\n";
				$count=0;
			}
		}
	}
// Jetzt die Kategorien:
	foreach($prod as $key => $val) {
		if ($AnzahlSpalten>1) {
/*			switch($count) {
				case 0: echo $divSParent . $divSpalte1 . "\n"; break;
				case 1: echo "\n$divSpalte2\n"; break;
				case 2: echo "\n$divSpalte3\n"; break;
				case 3: echo "\n$divSpalte4\n"; break;
			}	*/
			if ($count==0) {
				echo $divSParent . $divSpalte1 . "\n";
			} else {
				echo "\n$divSpalte2\n";
			}
		}
		$sql = "SELECT Datei,Text FROM Downloads WHERE Kategorie=$val ORDER BY Folge";
		$res = $db->query($sql);
		if ($i>1 && $ShowDownTitle>0) {
			echo '<'.$style[$ShowDownTitle].'>'. $strProd[$key] ."</".$style[$ShowDownTitle].">\n";
		}
		echo "	<ul class=\"downloads\">\n";
		while ($row = $res->fetchArray()) {
			printDown($row,$ShowFileSize,$ShowFileDate,$DLFolder);
		}
		echo "	</ul>\n";
		if ($AnzahlSpalten>1) {
			echo "</div>\n";
			$count++;
			if ($count==$AnzahlSpalten) {
				echo "</div>\n";
				$count=0;
			}
		}
	}
}

function txtDateSelect($prefix="Bis", $Time=0, $disabled=0, $ValTag=0, $ValMonat=0, $ValJahr=0, $ValStd=99, $ValMin=99, $Note='') {
	$Monat = monat();
	$sel = ($disabled) ? "disabled>\n" : 'onchange="ChangeOptionDays(\''. $prefix ."')\">\n";
	$txt = '<select class="selTag" id="'. $prefix .'Tag" name="'. $prefix .'Tag" ' . $sel;
	for ($i=1; $i<32; $i++) {
		$txt.= txtOption($i,$i,$ValTag);
	}
	$txt .= '</select>&nbsp;<select class="selMon" id="'. $prefix .'Monat" name="'. $prefix .'Monat" ' . $sel;
	for($i=1; $i<13; $i++) {
		$txt.= txtOption($i,$Monat[$i],$ValMonat);
	}
	$txt .= '</select>&nbsp;<select class="selYear" id="'. $prefix .'Jahr" name="'. $prefix .'Jahr" ' . $sel;
	$Jahr = date('Y');
	for ($i=-1; $i<3; $i++) {
		$txt.= txtOption($Jahr+$i,$Jahr+$i,$ValJahr);
	}
	$txt .= "</select>\n";

	if ($Time) {
		$txt .= '<select class="selStd" id="'.$prefix.'Std" name="'.$prefix.'Std" ' . $sel;
		for ($i=0; $i<24; $i++) {	// str_pad($i, 2 ,'0', STR_PAD_LEFT);
			$txt.= txtOption($i,sprintf("%02d", $i),$ValStd);
		}
		$txt .= '</select>&nbsp;<select class="selMin" id="'.$prefix.'Min" name="'.$prefix.'Min" ' . $sel;
		for ($i=0; $i<60; $i++) {
			$txt.= txtOption($i,sprintf("%02d", $i),$ValMin);
		}
		$txt .= "</select>\n";
	} else {
		$txt .= '<input type="hidden" value="0" name="' .$prefix. 'Std"><input type="hidden" value="0" name="' .$prefix. "Min\">\n";
	}
	$txt .= '<input type="hidden" value="" name="'. $prefix. "\"> $Note<br>\n";
	return $txt;
}
// Datum auswählen mit 3 (5: mit Uhrzeit) Input-Feldern:
function selectDatum($labeltext="Abreise:", $prefix="Bis", $FormTyp=0) {
    echo '<label class="long" for="'. $prefix .'Tag">'. $labeltext .'</label>'. (($FormTyp==9)?"<br>":"");
	$Time = ($FormTyp==2 || $FormTyp==9);
	echo txtDateSelect($prefix,$Time);
}

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +++++++++++++++++++++++++++++++ Seitenmodule +++++++++++++++++++++++++++++++++++++++++++++++++++++++

// Liefert Termintext, ggf. mit grafischen Buttons:
function TerminText($zeit) {
	global $UseButtons,$db,$WibLang;

	if ($UseButtons) {
		$rec = $db->querySingle("SELECT CSS1,CSS2 FROM Buttons WHERE ID=".$zeit[4],1);
		$CSS1 = $rec['CSS1'];
		$CSS2 = $rec['CSS2'];
		$t = '<div class="'.$CSS1.'">';
		if ($CSS2) $t.='<div class="'.$CSS2.'">';
		$t.= wochentag($zeit[0]).'<br>'.date('j.n.Y',$zeit[0]).'<br>'.date('H:i',$zeit[0]).' Uhr</div>';
		if ($CSS2) $t.='</div>';
	} else {
		$t = '<div class="caltitle">'.wochentag($zeit[0]).'<br>'.date('j.n.Y',$zeit[0]).'<br>'.date('H:i',$zeit[0]).' Uhr</div>';
	}
	$t.= "\n<h2>".$zeit[2]."</h2>\n".$zeit[3];
	return $t;
}

// Kalender1 als einfache Liste, mit CSS- oder grafischen Buttons:
function Kalender($print=1) {	// $print: 0 ohne echo, 1 mit Ausgabe
	global $db, $MyPageParam,$search, $spaltentext, $CalImages,$UseButtons,$UseCalImages, $MyNoEvents;
	$CalText = '';

	$plusTermine = "<p class=\"calsummary\">...und es gibt noch weitere Termine:</p>\n";
	if (!isset($spaltentext[2])) $spaltentext[2]="";

	$Jetzt = time();
	$sql = "SELECT Zeit,Modus,Titel,Text,Button,Image,Bis FROM Events WHERE Modus=0 AND Zeit>=$Jetzt ORDER BY Zeit";
	$res = $db->query($sql);
	$count = 0;
	$HasImage = false;
	while ($rec = $res->fetchArray(SQLITE3_NUM)) {
		switch ($MyPageParam) {
		case 1:	// einfache Liste
			$CalText .= '<li>' . date('j.n.Y, H:i: ',$rec[0]) . '<br>' . $rec[2] . "</li>\n";
			break;
		case 2:	// CSS-Buttons
			switch ($count) {
			case 0:
			case 1:
			case 2:
				$CalText .= '<div class="calbutton">' .wochentag($rec[0]).'<br>'.date('j.n.Y',$rec[0]).'<br>'.date('H:i',$rec[0]).' Uhr</div>';
				$CalText .= "\n<h2>".$rec[2]."</h2>\n".$rec[3];
				break;
			case 3:
				$CalText .= $plusTermine;
			default:
				$CalText .= date('j.n.y, H:i : ',$rec[0]) . '<div class="calsummary">'. $rec[2] ."</div><br>\n";
			}
			break;
		case 9: // Buecherei 3-spaltig mit vordefinierten Spaltentexten[0]...[2]
			switch ($count) {
			case 0:  $spaltentext[1] = TerminText($rec);
					if ($UseCalImages && isset($rec[5]) && $rec[5]!='0') {
						$spaltentext[2]='<img class="calmissing" src="'.$CalImages.$rec[5].'" alt="Bild zur Veranstaltung">';
						$HasImage=true;
					}
					break;
			case 1:  $spaltentext[0] = $spaltentext[1];
					 if ($UseCalImages && !$HasImage && isset($rec[5]) && $rec[5]!='0') {
						 $spaltentext[2]='<img class="calmissing" src="'.$CalImages.$rec[5].'" alt="Bild zur Veranstaltung">';
					 } // extra kein break, weil das noch kommt:
			case 2:  $spaltentext[1] = $spaltentext[2]; $spaltentext[2] = TerminText($rec); break;
			case 3:  $spaltentext[2].= $plusTermine;
			default: $spaltentext[2].= date('j.n.y, H:i: ',$rec[0]) . '<div class="calsummary">'.$rec[2] ."</div><br>\n";
			}
			break;
		default:	// Nur-Text-Übersicht
			$CalText .= '<h2>' . date('j.n.Y, H:i : ',$rec[0]) . $rec[2] . "</h2>\n";
			$CalText .= '<p>' . $rec[3] . "</p>\n";
		}
		$count++;
	}
	// Zum Abschluss:
	if ($count==0) {
		$CalText = $MyNoEvents;	// Defaulttext für 0 Events
		$spaltentext = ['',$MyNoEvents,''];
	} elseif ($MyPageParam==1) {
		$CalText = "<ul>$CalText</ul>\n";	// Liste abschließen
	}

	if ($search!='' && $count>0) {
		if ($MyPageParam==9) {
			$spaltentext = highlight($spaltentext,$search);
		} else {
			$CalText = highlight($CalText,$search);
		}
	}

	if ($print) {	// gleich ausdrucken?
		if ($MyPageParam==9) {
			print3($spaltentext);
		} else {
			echo $CalText;
		}
	}
	return $CalText;
}

// Protokollprüfungsarten:
function ProtoChecks($key,$name,$val=99,$max=9) {
	startSelect($key,$name);
	echo txtOption(99,'Bitte wählen:',$val);
	echo txtOption(0,'keine Prüfung erforderlich, ohne Hinweis',$val);
	if ($max>=1) echo txtOption(1,'keine Prüfung erforderlich, mit Hinweis',$val);
	if ($max>=2) echo txtOption(2,'Teilnahme beinhaltet Prüfung',$val);
	if ($max>=3) echo txtOption(3,'Prüfung durch separate Nachweise',$val);
	if ($max>=4) echo txtOption(4,'Prüfung individuell, ohne Frist',$val);
	if ($max>=5) echo txtOption(5,'Prüfung individuell, mit Frist',$val);
	if ($max>=8) echo txtOption(8,'frei wählbar, außer individuell',$val);
	if ($max>=9) echo txtOption(9,'frei wählbar aus allen Optionen',$val);
	echo '</select> ';
}
// Bundesländer Deutschland:
function ArrayLaender($Land='DE') {
	switch ($Land) {
		case 'DE':
		$Laender = [
		'AA' => 'Alle (irgendwo)',
		'BW' => 'Baden-Württemberg',
		'BY' => 'Bayern',
		'BE' => 'Berlin',
		'BB' => 'Brandenburg',
		'HB' => 'Bremen',
		'HH' => 'Hamburg',
		'HE' => 'Hessen',
		'MV' => 'Mecklenburg-Vorpommern',
		'NI' => 'Niedersachsen',
		'NW' => 'Nordrhein-Westfalen',
		'RP' => 'Rheinland-Pfalz',
		'SL' => 'Saarland',
		'SN' => 'Sachsen',
		'ST' => 'Sachsen-Anhalt',
		'SH' => 'Schleswig-Holstein',
		'TH' => 'Thüringen',
		'XX' => 'bundeseinheitlich'];
		break;
	case 'AT':
		$Laender = [
		'AA' => 'Alle (irgendwo)',
		'B' => 'Burgenland',
		'K' => 'Kärnten',
		'N' => 'Niederösterreich',
		'O' => 'Oberösterreich',
		'S' => 'Salzburg',
		'St' => 'Steiermark',
		'T' => 'Tirol',
		'V' => 'Vorarlberg',
		'W' => 'Wien',
		'XX' => 'bundeseinheitlich'];
		break;
	}	
	return $Laender;
}
// Feiertagsberechnung:
function getHolidays($Jahr=0,$Land='XX',$Format='',$AddLand='',$AddWDay='') {
	if (!$Jahr)
		$Jahr = getdate()['year'];;
	$SecPerDay = 60*60*24;
	$Ostern = easter_date($Jahr);	// für bewegliche Feiertage, Bereich: 22. März bis 25. April
//	Korrekturen wegen Sommerzeit und dem Rechnen mit Zeitstempeln:
	$OsternIsSZ = date('I',$Ostern)==1;
	$OsternIsZU = date('I',$Ostern+$SecPerDay)==1 && !$OsternIsSZ;
	$FastKorr = 3600*$OsternIsSZ;
	$NachKorr = 3600*(1-$OsternIsSZ);
	$MontKorr = 3600*$OsternIsZU;
//	Weihnachten
	$XMas = strtotime("$Jahr-12-25");
	$WDXMas= getdate($XMas)['wday']; if ($WDXMas==0) $WDXMas=7;
	$Advent = $XMas - $WDXMas*$SecPerDay;

// https://de.wikipedia.org/wiki/Feiertag_(Deutschland)
// https://de.wikipedia.org/wiki/Feiertage_in_%C3%96sterreich
//	webcal://www.wien.gv.at/amtshelfer/feiertage/ics/feiertage.ics

$Holiday = [
	strtotime("$Jahr-01-01") => 'Neujahr:XX',
	strtotime("$Jahr-01-06") => 'Heilige Drei Könige:BW,BY,ST',
	$Ostern - 52*$SecPerDay + $FastKorr => 'Weiberfastnacht:YY',	// nur Info
	$Ostern - 48*$SecPerDay + $FastKorr => 'Rosenmontag:YY',		// nur Info
	$Ostern - 47*$SecPerDay + $FastKorr => 'Fastnacht:YY',			// nur Info
	$Ostern - 46*$SecPerDay + $FastKorr => 'Aschermittwoch:YY',		// nur Info
	$Ostern -  3*$SecPerDay => 'Gründonnerstag:YY',					// nur Info
	$Ostern -  2*$SecPerDay => 'Karfreitag:XX',
	$Ostern -  1*$SecPerDay => 'Karsamstag:YY',						// nur Info
	$Ostern => 'Ostersonntag:XX',
	$Ostern + $SecPerDay - $MontKorr => 'Ostermontag:XX',
	strtotime("$Jahr-05-01") => 'Maifeiertag:XX',
	$Ostern + 39*$SecPerDay - $NachKorr => 'Christi Himmelfahrt:XX',
	$Ostern + 49*$SecPerDay - $NachKorr => 'Pfingstsonntag:XX',
	$Ostern + 50*$SecPerDay - $NachKorr => 'Pfingstmontag:XX',
	$Ostern + 60*$SecPerDay - $NachKorr => 'Fronleichnam:BW,BY,HE,NW,RP,SL', // sowie in einigen Gemeinden in Sachsen & Thüringen
	strtotime("$Jahr-03-08") => 'Internationaler Frauentag:BE',
	strtotime("$Jahr-08-15") => 'Mariä Himmelfahrt:SL',	// sowie in Bayern in Gemeinden mit überwiegend katholischer Bevölkerung
	strtotime("$Jahr-10-03") => 'Nationalfeiertag:XX',
	strtotime("$Jahr-10-31") => 'Reformationstag:BB,HB,HH,MV,NI,SN,ST,SH,TH',
	strtotime("$Jahr-11-01") => 'Allerheiligen:BW,BY,NW,RP,SL',
//	strtotime("$Jahr-12-08") => 'Mariä Empfängnis:Österreich',
	$Advent - 32*$SecPerDay => 'Buß- und Bettag:SN',	// (schulfrei in Bayern)
	$Advent - 21*$SecPerDay => '1. Advent:XX',
	$Advent - 14*$SecPerDay => '2. Advent:XX',
	$Advent -  7*$SecPerDay => '3. Advent:XX',
	$Advent => '4. Advent:XX',
	strtotime("$Jahr-12-24") => 'Heilig Abend:XX-2',	// halber Tag
	$XMas => '1. Weihnachtsfeiertag:XX',
	strtotime("$Jahr-12-26") => '2. Weihnachtsfeiertag:XX',
	strtotime("$Jahr-12-31") => 'Silvester:XX-2'		// halber Tag
];
	ksort($Holiday);	// nach Datum sortieren
	$Array = [];
	foreach ($Holiday as $Date => $HDay) {
		$Feiertag = explode(':',$HDay);
		if (strpos($Feiertag[1],$Land)!==false || $Land=='AA' || $Feiertag[1]=='XX' || $Feiertag[1]=='XX-2') {
			$Datum = ($Format=='') ? $Date : date($Format,$Date);
			if ($AddLand!='')
				$Feiertag[0] .= $AddLand.$Feiertag[1];
			if ($AddWDay!='')
				$Feiertag[0] .= $AddWDay.getDate($Date)['wday'];
			$Array[$Datum] = $Feiertag[0];
		}
	}
	return $Array;
}

// eine KissGalerie erzeugen und Text dazu zurückgeben:
function getGallery($IsMemory=0,$sel=0) {
 	global $mypage, $MyMedia, $CrumbSign,$AlbenCovers, $GalleryType, $db,$search,$u;
	global $strKGNoFiles,$strKGClearThis,$strKGClearAll,$WishClick, $splitPage,$mylang, $showMemMiss,$strMemMiss,$DelMiss,$strDelMiss,$WLCols,$WLRows;

	// Initialisierung benötigter Werte:
	$tdclass = ['','','',''];
	$Groups  = 0;
	$tdgroup = 0;
	$kissShow= 0;
	$txt = '';
	$kissFilesInGroup=0;
	$images = [];

	$AlbenLinks = [];
	$AlbenBreadCrumb = '';
	$IsAlbum = 0;
	$shallglue = false;

	$splittext= $splitPage[$mylang];
	$thispage = $_GET['page'] ?? '0';

	// prepare wishlist:
	$WishUser = (isset($_SESSION['UserID'])) ? ('User:'.$_SESSION['UserID']) : session_id();
	$myWishes = [];
	$myWishIDs= [];
	$myWishOKs= [];
	$myVotes  = [];
	// extract all ids and votes for my wishlist:
	$sql = "SELECT Item,Typ,Vote,Value,Count FROM Wishes WHERE User='$WishUser'";
	$res = $db->query($sql);
	while ($rec = $res->fetchArray(SQLITE3_NUM)) {
		if ($sel==0 || $sel==$rec[1]) {
			$myWishes[] = $rec[0];
		}
		$myWishIDs[]= $rec[0];
		$myVotes[]  = $rec[2];
	}
	// end of wishlist preparation

	$picsel = "SELECT Galerie.ID,Datum,GalleryID,File,Galerie.Folge,aktiv,Desc1,Desc2,Desc3,Desc4,Img,Folder,Zeilen,T_Z,Down,DSize,DLBox,DLAll
				FROM Galerie,Gallery WHERE aktiv=1 AND Galerie.GalleryID=Gallery.ID ";

	if ($IsMemory) { // Dies ist eine Auswertung (Merkliste, Favoriten, Wertung... )
		// Bilder zusammensammeln (für eine (1) Art von Zusatz über alle Galerien):
		$sql = $picsel . 'AND Galerie.ID IN('.implode(',',$myWishes).')';
		$res = $db->query($sql);
		while ($rec = $res->fetchArray(SQLITE3_NUM)) {
			if ($rec[5]) {	// aktiv=1
				$images[] = $rec;
				$myWishOKs[] = $rec[0];
				$kissFilesInGroup += 1;
			} else {
				$myInactive[]= $rec[0];
			}
		}
		$Missing = count($myWishes) - count($myWishOKs);	// Amount of missing items = all - available
		$kissShow = $sel;
		$noofcols = $WLCols;
		$noofrows = $WLRows;
		$tablesplit=$noofcols*$noofrows;
	// wegen Fehler wieder hardcoded eingefügt:
		$AllDown = true;
	}

	if (!$IsMemory) {
		// Anzeige vorbereiten und Parameter lesen
		$txt='<div class="kissgallery_head">'."\n";
		$style = ['','h1','h2','h3','h4','h5','h6','p'];
		$sql = "SELECT Name,Comment,Typ,Zeilen,T_B,T_H,T_Z,Cols,Rows,ShowN,ShowC,App,Box,Groups,Down,DSize,DLBox,DLAll,Folder FROM Gallery WHERE ID=$sel";
		$rec = $db->querySingle($sql,true);
		$kissShow = $rec['Typ'];
		$showDesc = $rec['Zeilen'];
		$imgWidth = $rec['T_B'];
		$imgHeight= $rec['T_H'];
		$showthumbdesc=$rec['T_Z'];
		$noofcols = $rec['Cols'];
		$noofrows = $rec['Rows'];
		$tablesplit=$noofcols*$noofrows;
		$Name	= $rec['Name'];
		$MyGroups= $rec['Groups'];
		$Groups = $rec['Groups'] & 7;
		$Down	= $rec['Down'];
		$DSize	= $rec['DSize'];
		$DLBox	= $rec['DLBox'];
		$DLAll	= $rec['DLAll'];
		$IsAlbum= ($rec['App']==9);
		$KissFolder = $MyMedia.$rec['Folder'].'/';
		$KissThumbs = $KissFolder.'Thumbs/';
		$KissOrigin = $KissFolder.'Originals/';
		if ($rec['ShowN']>0) $txt.='<'.$style[$rec['ShowN']].'>'.$Name. "</".$style[$rec['ShowN']].">\n";
		if ($rec['ShowC']>0) $txt.='<'.$style[$rec['ShowC']].'>'.$rec['Comment']. "</".$style[$rec['ShowC']].">\n";
		if ($IsAlbum) {
			$album  = $_GET['album'] ?? $sel;	// aus der URL oder ist Hauptalbum
			$sql = "SELECT Cover,C_Text FROM Gallery WHERE ID=$album";
			$res = $db->querySingle($sql,1);
			if ($res['C_Text']!='')
				$txt.='<div class="kissalbum">'.$res['C_Text']."</div>\n";
//			Unteralben feststellen:
			$sql = "SELECT ID,Name,Comment,Cover,C_Text FROM Gallery WHERE Parent=$album";
			$res = $db->query($sql);
			while ($rec = $res->fetchArray()) {
				$kissFilesInGroup += 1;
				if (!empty($rec['Cover'])) {
					$link = $AlbenCovers.$rec['Cover'];
				} else {
					$link = 'core/grafix/Album.png';
				}
				$AlbenLinks[] = '<a href="'.$u.$mypage.'&amp;album='.$rec['ID'].'" title="Album öffnen"><img src="'.$link.'" class="album" style="width:'.$imgWidth.'px" alt="Album-Cover"><br>'.$rec['Name'].'</a><br>';;
//				UND noch Covertexte !?
			}
//			Parents (für Breadcrumb) feststellen:
			if ($album != $sel) {	// ist KEIN Hauptalbum, darum:
				$rec = $db->querySingle("SELECT Parent,Name FROM Gallery WHERE ID=$album",1);
				$AlbenBreadCrumb = $rec['Name'];
				$Parent = $rec['Parent'];
				while ($Parent>0) {
					$rec = $db->querySingle("SELECT ID,Parent,Name FROM Gallery WHERE ID=$Parent",1);
					$AlbenBreadCrumb = '<a href="'.$u.$mypage.'&amp;album='.$rec['ID'].'">'.$rec['Name']."</a> $CrumbSign $AlbenBreadCrumb";
					$Parent = $rec['Parent'];
				}
			}
			$sel = $album;
		}
		$txt.="</div>\n";	// kissgallery_head

//		Bilder zusammensammeln (für genau diese eine Galerie):
		$sql = $picsel . "AND aktiv=1 AND GalleryID=$sel ORDER BY Galerie.Folge";
		$res = $db->query($sql);
		$AllDown = true;
		$Nr = 0;	// hier müssen wir die Indizes synchron halten.
		while ($rec = $res->fetchArray(SQLITE3_NUM)) {
			$images[$Nr] = $rec;
			$kissFilesInGroup += 1;
			if (is_file($KissOrigin.$rec[3])) {
				$DLink[$Nr] = $KissOrigin.$rec[3];
			} else {
				$DLink[$Nr] = '';
				if ($DLAll) $AllDown = false;
			}
			$Nr++;
		}

//		Gruppierte Bilder vorbereiten / mehrere Bilder (max. 4) nebeneinander bilden eine "Gruppe"
		if (($MyGroups & 8) == 8) { // geklebt ohne Rahmen
			$shallglue = true;
		}
		if ($Groups>1) {
			$tdclass[0]=' groupleft';
			$tdclass[$Groups-1]=' groupright';
			if ($Groups>2) {
				$tdclass[1]=' groupmid01';
				if ($Groups>3)
					$tdclass[2]=' groupmid02';
			}
		}
	}

//	Wir haben jetzt alle Bilder zusammen. Jetzt anzeigen:
	$txt.='<div class="kissgallery">'."\n";

	$kissclick = ($kissShow<5) ? $WishClick[$kissShow] : '';
	switch ($kissShow) {
		case 1: $rel='wishlist'; $GalleryType='slimbox'; break;
		case 2: $rel='favorite'; $GalleryType='slimbox'; break;
		case 3: $rel='votepoll'; $GalleryType='slimbox'; break;
		case 4: $rel='articles'; $GalleryType='slimbox'; break;
		default:$rel='lightbox-gr-'.$sel;
	}

	if (sizeof($images)>0 || $IsAlbum) {

		if ($AlbenBreadCrumb!='') echo '<div class="locator">'.$AlbenBreadCrumb."</div>\n";

		if ($kissFilesInGroup>$tablesplit) {
			$txt.='<div>';
			for ($i=0;$i<($kissFilesInGroup/$tablesplit);$i++) {
				if ($thispage==$i)
					$txt.='<span class="pageselect"> '.$splittext. ($i+1) .' </span>';
				else
					$txt.='<a class="pageselect" href="'.$u.$mypage.'&page='.$i. (empty($search) ? '' : "&search=$search") .'"> '.$splittext. ($i+1) .' </a>';
			}
			$txt.="</div>\n";
		}

		$txt.='<div id="gallery"><table class="kissgallery_thumbs">'."\n";	// div für Photobox

		$count = 0;
		if ($IsAlbum && !(empty($AlbenLinks))) {
			foreach ($AlbenLinks as $link) {
				if (($count % $noofcols)==0) {
					if ($count>0) {
						$txt.="</tr>\n";
					}
					$txt.="\n<tr>\n";
				}
				$txt.='<td class="kissgallery_thumb_td">'.$link."</td>\n";
				$count++;
			}
		}

		foreach ($images as $Nr=>$img) {
//			Bilder eingrenzen auf diejenigen, die auf diese Seite gehören:
			if (($count>=($thispage*$tablesplit)) && ($count<(($thispage+1)*$tablesplit))) {
//				Zeilenwechsel?
				if (($count % $noofcols)==0) {
					if ($count>0) {
						$txt.="</tr>\n";
					}
					$txt.="\n<tr>\n";
				}

				$id		= $img[0];
				$desc1	= $img[6];
				$desc2	= $img[7];
				$desc3	= $img[8];
				$desc4	= $img[9];
				$src	= $img[10];
				$Folder = $MyMedia.$img[11].'/';
				$Thumbs = $Folder.'Thumbs/';
				$showDesc = $img[12];
				$showthumbdesc=$img[13];
				$Down	= $img[14];
				$DSize	= $img[15];
				$DLBox	= $img[16];
				$DLAll	= $img[17];
				$atitle ='';
				$DownOK = $Down;
				$DBoxOK = $DLBox;
				if (($Down || $DLBox) && $AllDown && $DLink[$Nr]) {
					$strDown = '<a href="core/wibcmsdownload.php?f='.$DLink[$Nr].'" class="kdown">Download';
					if ($DSize)
						$strDown .= ' ('.txtFileSize($DLink[$Nr]).')';
					$strDown .= '</a>';
				} else {
					$DownOK = 0;
					$DBoxOK = 0;
				}

				if ($GalleryType=='slimbox') {
					if ($DBoxOK==1) $atitle.= htmlentities($strDown).'&lt;br&gt;';
					if (strpos($showDesc,'1')!==false && $desc1) $atitle.='&lt;span class=&quot;desc1&quot;&gt;'.$desc1.'&lt;/span&gt;&lt;br&gt;';
					if (strpos($showDesc,'2')!==false && $desc2) $atitle.='&lt;span class=&quot;desc2&quot;&gt;'.$desc2.'&lt;/span&gt;&lt;br&gt;';
					if (strpos($showDesc,'3')!==false && $desc3) $atitle.='&lt;span class=&quot;desc3&quot;&gt;'.$desc3.'&lt;/span&gt;&lt;br&gt;';
					if (strpos($showDesc,'4')!==false && $desc4) $atitle.='&lt;span class=&quot;desc4&quot;&gt;'.$desc4.'&lt;/span&gt;&lt;br&gt;';
					if ($DBoxOK==2) $atitle.= htmlentities($strDown).'&lt;br&gt;';
				}

//			Eine Zelle erzeugen, ggf. gruppierte Bilder zusammenfassen (wir MÜSSEN davon ausgehen, dass alle gruppierten Bilder in EINER Zeile sind!!!):

				if ($shallglue) {
					if ($tdgroup==0) {	// first image in group
						$gluefile = 'glued_'.$MyGroups.'_'.$src;
					} elseif ($tdgroup==($Groups-1)) {	// last image in group
						$gluefile .= '_'.$src;
						$txt.='<td class="kissgallery_thumb_td'.$tdclass[$tdgroup].'_glued" colspan="'.$Groups.'">';
						$txt .= '<a href="'.$Folder.$gluefile.'" id="image'.$id.'" class="'.$rel.'"'. (($atitle!='') ? " title=\"$atitle\"" : '' );
						$txt.= '><img src="'.$Thumbs.$gluefile.'" alt="Bild zu: ' . $desc1 . '" title="' . $desc1 . "\"></a>\n";

					} else {
						$gluefile .= '_'.$src;
					}
					$DownOK = 0;
				} else {
					$txt.='<td class="kissgallery_thumb_td'.$tdclass[$tdgroup].'">';
					$txt.='<a href="'.$Folder.$src.'" id="image'.$id.'" class="'.$rel.'"'. (($atitle!='') ? " title=\"$atitle\"" : '' );
					$txt.='><img src="'.$Thumbs.$src.'" alt="Bild zu: ' . $desc1 . '" title="' . $desc1 . "\"></a>\n";
				}

				if (!$shallglue || $tdgroup==($Groups-1)) {
					if ($DownOK==1)
						$txt.='<br>'.$strDown;
					if (strpos($showthumbdesc,'1')!==false && $desc1) $txt.='<br><span class="desc1">'.$desc1."</span>\n";
					if (strpos($showthumbdesc,'2')!==false && $desc2) $txt.='<br><span class="desc2">'.$desc2."</span>\n";
					if (strpos($showthumbdesc,'3')!==false && $desc3) $txt.='<br><span class="desc3">'.$desc3."</span>\n";
					if (strpos($showthumbdesc,'4')!==false && $desc4) $txt.='<br><span class="desc4">'.$desc4."</span>\n";
	//			Hier jetzt genauer auf die unterschiedlichen KissShows eingehen, Zusatzzeilen generieren:
					switch ($kissShow) {
						case 1:
						case 2:
							$c = ($IsMemory || in_array($id,$myWishIDs)) ? ' checked="checked"' : '';
							$txt .= '<br><input type="checkbox" id="check'.$id.'"'.$c.' onclick="toggle(this.checked,'.$id.',-'.$kissShow.',0,0,0)"> '."$kissclick<br>\n";
							break;
						case 3:
						case 4:
							$c = array_search($id,$myWishIDs);
							$MyWishVote = $c ? $myVotes[$c] : 0;
							$txt .= '<br><select class="kissSelect" id="check'.$id.'" onchange="toggle(1,'.$id.',-'.$kissShow.',this.value,0,0)"><option value="0"></option>';
	//					Art des Votings, Min/Max konfigurierbar machen...
							for ($i=1; $i<10; $i++) {
								$txt .= txtOption($i,$i,$MyWishVote);
							}
							$txt .= "</select> $kissclick<br>\n";
					}
					if ($DownOK==2)
						$txt.='<br>'.$strDown;
					
					$txt.="</td>\n";
				}
//			Ende der Zelle, nächstes Bild

				if ($Groups>1) $tdgroup = (++$tdgroup % $Groups);
			}
			$count++;
		}
		// jetzt noch "leere" Bildfelder auffüllen:
		// $count=$count+1;
		if (($count % $noofcols)>0) {
			for ($j=1;$j<=($noofcols-($count % $noofcols));$j++) 
			{
				$txt.='<td class="kissgallery_thumb_td">&nbsp;</td>';
				// Hier fehlen noch </tr><tr> !!!
			}
		}
		$txt.= "</tr>\n</table></div>\n";	// div für Photobox

		if ($IsMemory) {
			$txt.='<p class="kissgallery_clearlist">'."\n".
			'<span class="pointer" onclick="toggle(true,0,'.$kissShow.',0,0,0)">'.$strKGClearThis.
			'</span> (<span class="pointer" onclick="toggle(true,0,0,0,0,0)">'.$strKGClearAll.'</span>)';
			if ($Missing && $showMemMiss) {
				$MyWishNOs = array_diff($myWishes,$myWishOKs);
				// es gibt auch noch $myInactive, die fehlen auch und sind in Missing enthalten, wären aber noch "erhältlich" falls reaktiviert
				$txt .= '<br>'. $Missing . ' ' . $strMemMiss . ' ['. implode(',',$MyWishNOs) . ']';
				if ($showMemMiss==2) {
					$txt .= ' (<span class="pointer" onclick="toggle(999,0,'.$kissShow.')">'.$strDelMiss."</span>)\n";
				}
			}
			$txt .= "</p>\n";
		}
	} else {
		$txt.=$strKGNoFiles;
	}
	$txt.="</div>\n";
	if ($search!='') {
		$txt = highlight($txt,$search);
	}

	return $txt;
}

function wishGallery($Typ,$wishuser,$Titel,$Fuss,$wishes,$KFolder) {
	global $db, $UseGetGallery, $MyMedia;	// 	,$KFolder
	global $strKGPcs,$strKGLen,$strKGCol,$strKGMat;

	$wishcounter = $wishes;
	$o = '';
	$display = !$UseGetGallery || ($Typ>3);

	$sql = "SELECT Item,Vote,Value,Count, Desc1,Img,GalleryID FROM Wishes,Galerie WHERE Typ=$Typ AND User='$wishuser' AND Galerie.ID=Wishes.Item";
	$res = $db->query($sql);
	while ($rec = $res->fetchArray()) {
		if ($wishes==$wishcounter && $display) {	// Überschrift
			$o .= '<div class="formWishlist">'.$Titel.":<br>\n";
			if ($Typ==4) {
				$o .= '	<input type="text" class="small short" disabled="disabled" value="'.$strKGPcs.'">';
				$o .= '	<input type="text" class="small short" disabled="disabled" value="'.$strKGLen.'">';
				$o .= '	<input type="text" class="small short" disabled="disabled" value="'.$strKGCol.'">&nbsp; ';
				$o .= '	<input type="text" class="small" disabled="disabled" value="'.$strKGMat.'"><br>'."\n";
			}
		}
		$wishes += 1;
		$KGFolder = $MyMedia.$KFolder[$rec['GalleryID']];
		switch ($Typ) {
		  case 1:
		  case 2:
			$o .= '	<input type="hidden" name="mywishcnt'.$wishes.'" value="-">';	// wegen Kompatibilität mit Wertungen/Artikeln...
			break;
		  case 3:
			$type = $display ? 'text' : 'hidden';
			$o .= '	<input type="'.$type.'" class="short" name="mywishcnt'.$wishes.'" value="'.$rec['Vote'].'">';
			break;
		  case 4:
			$o .= '	<input type="text" class="short" name="mywishcnt'.$wishes.'" value="'.$rec['Vote'].'">';
			$o .= '	<input type="text" class="short" name="mywishvot'.$wishes.'" value="'.$rec['Count'].'">';
			$o .= '	<input type="text" class="short" name="mywishval'.$wishes.'" value="'.$rec['Value'].'">';
			break;
		}
		$o .= '	<input type="hidden" name="mywish'.$wishes.'" value="ID='.$KGFolder.'/Thumbs/'.$rec['Img'].'='.$rec['Desc1'].'">';
		if ($display) {
			$o .= '&nbsp; <a href="'.$KGFolder.'/'.$rec['Img'].'" id="image'.$rec['Item'].'" class="lightbox-wl" title="'.$rec['Desc1'].'">';
//			$o .= '<img src="'.$MyMedia.$KFolder[$rec['GalleryID']].'/Thumbs/'.$rec['Img']."\"></a><br>\n";
			$o .= $rec['Desc1']."</a><br>\n";
		}
	}

	if (!$display)
		echo "$Titel:<br>\n" . getGallery(1,$Typ);
	if ($wishes>$wishcounter && $display)
		$o .= "</div>\n";
	if ($wishes>$wishcounter && $Fuss!='')
		$o .= "$Fuss<br>\n";
	return [$o,$wishes];
}

function formWishlist($FormTyp) {	// Für Kontaktformular mit Merklisten
	global $db, $MyMedia, $KissFolder, $strKGForm,$strKGArticles,$strKGFavorites, $strKGOrder,$strKGCol,$strKGLen,$strKGPcs,$strKGMat, $UseGetGallery;
/* FormTyp:
5: mit Merkliste (aus KissGallery) -> 8+1
6: mit Favoriten (aus KissGallery) -> 8+2
7: mit Merkliste und Favoriten	-> 8+3
8: mit Wertungen	-> 8+3
9: mit allem (Merkliste, Favoriten, Wertungen und Artikel)
10 mit Artikeln
Vote
Value
Count
*/
//	prepare wishlist
	$wishuser = (isset($_SESSION['UserID'])) ? ('User:'.$_SESSION['UserID']) : session_id();
	$wishes = 0;
	$o = '';

//	Folder der einzelnen Galleries:
	$res = $db->query('SELECT ID,Folder FROM Gallery');
	while ($rec = $res->fetchArray()) {
		$KFolder[$rec[0]] = $rec[1];
	}

//	jrtzt für jeden Typ:
	if (in_array($FormTyp,[5,7,9]))	{$x = wishGallery(1,$wishuser,$strKGForm[1],'',$wishes,$KFolder); $o.=$x[0]; $wishes=$x[1];}
	if (in_array($FormTyp,[6,7,9])) {$x = wishGallery(2,$wishuser,$strKGForm[2],'',$wishes,$KFolder); $o.=$x[0]; $wishes=$x[1];}
	if (in_array($FormTyp,[8,9]))	{$x = wishGallery(3,$wishuser,$strKGForm[3],'',$wishes,$KFolder); $o.=$x[0]; $wishes=$x[1];}
	if (in_array($FormTyp,[10,9]))	{$x = wishGallery(4,$wishuser,$strKGForm[4],$strKGOrder,$wishes,$KFolder); $o.=$x[0]; $wishes=$x[1];}

//	Anzahl der Items:
	$o .= '<input type="hidden" name="wishcnt" value="'. $wishes ."\">\n";
	return $o;
}

// Liest Bilddateien im Verzeichnis: (Version OHNE Ordner)
function getAlbumFiles($pfad) {
//	global $excludeit;
	$MyArray = array();
	if (is_dir($pfad)) {
		$rawArray = scandir($pfad);
		// $rawArray = array_diff(scandir($pfad),$excludeit);
		foreach($rawArray as $datei) {
			if (is_file("$pfad/$datei"))
				$MyArray[] = $datei;
		}
	}
	return $MyArray;
}
// Liest Bilddateien im Verzeichnis: (Achtung: liest auch Ordner!)
function getAlbum($pfad) {
	global $excludeit;
	if (is_dir($pfad)) {
		return array_diff(scandir($pfad),$excludeit);
	} else {
		return array();	// leeres Array oder besser false ?
	}
}
// Löscht Verzeichnis, falls leer und keine brauchbaren Unterordner mehr vorhanden sind:
function remove($pfad) {
	if (count(getAlbum($pfad))==0) {
		return delTree($pfad);
	} else {
		return false;
	}
}
?>