<?php
// STEP 0 ("Konstante" Vorgaben für das WIcms holen)
$WIBcmsFilePrefix = '../';
require 'wibcmsconstants.php';

// STEP 1 (Funktionen):
require 'wibcmsfunctions.php';

// STEP 2 (Spezialfunktionen)
require 'edit_functions.php';

$strGalType = ['Normale Galerie','mit Merkliste','mit &quot;gef&auml;llt mir&quot;','mit Punktvergabe','Artikel (Shop)'];

$img_UP  = '<img src="core/grafix/pfup.gif" alt="Pfeil nach oben/vorne" title="1 nach oben/vorne verschieben">';
$img_UPUP= '<img src="core/grafix/pfpfup.gif" alt="Pfeil nach ganz oben/vorne" title="ganz nach oben/vorne verschieben">';
$img_DOWN= '<img src="core/grafix/pfdown.gif" alt="Pfeil nach unten/hinten" title="1 nach unten/hinten verschieben">';
$img_DDWN= '<img src="core/grafix/pfpfdown.gif" alt="Pfeil nach ganz unten/hinten" title="ganz nach unten/hinten verschieben">';
$img_SWAP= '<img src="core/grafix/pfupdown.gif" alt="Pfeil hoch und runter" title="Reihenfolge umkehren">';

$WebStat = getWebStat();

if ($WebStat && isset($_GET['edit'])) {
	$User = $_SESSION['User'];
//	oeffne(edit,page,ConfigNr)
	$edit = $_GET['edit'];
	$gid  = $_GET['page'] ?? '';
	$parm = '';
	$z = strpos($edit,':');	// Für Plugins...
	if ($z>0) {
		$parm = $gid;
		$gid  = substr($edit,$z+1);
		$edit = substr($edit,0,$z);
	}

	$todo = $_GET['todo'] ?? '';
	$mylang = $_SESSION['WorkLang'];

//	echo $_SERVER['QUERY_STRING'] . "<br>edit:$edit-todo:$todo-gid:$gid-parm:$parm<br>\n";

// ############################################# Hier geht es jetzt richtig los #################################################

switch ($edit) {
// ------------------------------------------------------------------------------------------------
case 'delpage': //							Seite entfernen
// ------------------------------------------------------------------------------------------------
	formkopf('Hier entfernen Sie eine Seite aus der Seitenstruktur der Homepage','Hinweis');
	$Name = $db->querySingle("SELECT Link,Kopf FROM Pages WHERE ID=$gid",1);
	echo '<input type="hidden" name="PageID" value="'.$gid.'">';
	$helptext = "<p>Soll die Seite &quot;{$Name['Link']}&quot; ({$Name['Kopf']}) wirklich entfernt werden?<br>Hinweis: die Seite wird nur inaktiv gestellt.</p>\n";
	if ($May['EditNavi'])
		$helptext .= '<p>Endgültig löschen können Sie die Seite im Pflegemenü <span class="editlink" onclick="oeffne(\'edinavi\',0,0)">Seitenstruktur / Navigation</span></p>';
	echo "$helptext\n</fieldset>\n".formsave($edit);
	break;
// ------------------------------------------------------------------------------------------------
case 'usepage': //							Seitenattribute bearbeiten
// ------------------------------------------------------------------------------------------------
	$usepage = 1;
// ------------------------------------------------------------------------------------------------
case 'addpage':	//							Seite hinzufügen
// ------------------------------------------------------------------------------------------------
	$addpage = 1;
// ------------------------------------------------------------------------------------------------
case 'edinavi':	//							Seitenstruktur / Navigation
// ------------------------------------------------------------------------------------------------
	$usepage = $usepage ?? 0;	//	um von 'usepage' zu unterscheiden
	$addpage = $addpage ?? 0;	//	um von 'addpage' zu unterscheiden

	switch (true) {
		case $usepage:	formkopf('Hier bearbeiten Sie die Seitenattribute'); break;
		case $addpage:	formkopf('Hier legen Sie eine neue Seite an'); break;
		default:		formkopf('Hier bearbeiten Sie die Seitenstruktur der Homepage'); break;
	}

	if ($todo=='sort') {
		$ID = $_GET['id'];
		$to = $_GET['to'];
		$res= $db->querySingle("SELECT Folge,Show FROM Pages WHERE ID=$ID",1);
		$Show = $res['Show'];
		$Folge= $res['Folge'];
		Sortiere($ID,$to,'Pages',"Lang=$mylang AND Show=$Show AND Parent=$gid",$Folge,$db);
//		write_log("$User hat die Seiten neu geordnet");	// Verbosity...
		if ($MultiLang>0 AND $mylang==$DefaultLang) {
			foreach($LangSynch as $key=>$val) {
				if ($val==9 || $val==7) {	// strikt:
					$res  = $db->querySingle("SELECT ID,Parent,Folge,Show FROM Pages WHERE Lang=$key AND Ist=$ID",1);
					$NewID= $res['ID'];
					$NewP = $res['Parent'];
					$Show = $res['Show'];
					$Folge= $res['Folge'];
//					echo "Sort: $key ($ID -> $NewID)<br>";	//	write_log("Deshalb auch Sprache x neu sortiert");
					Sortiere($NewID,$to,'Pages',"Lang=$key AND Show=$Show AND Parent=$NewP",$Folge,$db);
				}
			}
		}
	}

//	Übersicht bei addpage verhindern und bei usepage ausblenden:
	if (!$addpage || $usepage) {
		$ShowIt = $usepage ? ' class="helper"' : '';
		echo '<fieldset'.$ShowIt.'><table style="width:100%"><tr><th class="edit">!</th>';
		if ($May['AddPages'])
			echo '<th class="del">X</th>';
		if ($May['SortPages'])
			echo '<th colspan="'.(($ShowPageFolge)?3:2).'">Sort</th>';
		echo '<th>';
		if ($CompactPageTable)
			echo '<img src="core/grafix/folder0.gif"> ';
		echo "Name</th><th>Anz.</th><th>URL</th><th>Browser-Titel</th><th>Überschrift</th><th>Modul</th><th>Lock</th></tr>\n";
		$maxnum = 0;
		echo PageTable(); // rekursive Auflistung aller Seiten
		if ($May['AddPages']) {
			echo '<tr><td><input type="radio" name="Seite" id="Seite" onclick="cleareditpage()" id="Page'.$maxnum.'" value="Page'.$maxnum.'" title="Neue Seite anlegen"></td><td><input type="radio" name="Seite" value="Page-1" hidden="hidden" checked="checked"></td><td colspan="11"><label for="Seite">Neue Seite anlegen</label></td></tr>'."\n";
		} else {
			echo "<tr><td colspan=\"12\"><strong>Hinweis:</strong> Sie sind nicht berechtigt, die Anzahl der Seiten zu verändern. Es lassen sich keine Seiten löschen oder hinzufügen.</td></tr>\n";
		}
		echo "</table></fieldset>\n";
	}
//	Ende Übersicht

	echo '<fieldset id="bgx" style="background-image:none"><legend>Meta-Angaben und Seitenattribute</legend><label for="Link" title="Bezeichnung in der Navigation der Homepage">Name im Menü</label><input type="text" id="Link" name="Link" value=""> ';
	startSelect('Login','Login');
	echo txtOption(0,'ohne Login (falls keine übergeordnete Seite Login erfordert)');
	echo txtOption(1,'Seite sichtbar, aber nur mit Login erreichbar');
	echo txtOption(2,'Seite und Unterseiten nur mit Login erreichbar');
	echo txtOption(3,'Seite und Unterseiten ohne Login unsichtbar');
	echo txtOption(99,'Seite und Unterseiten nur für Admins sichtbar');
	echo "</select> <br>\n";
	echo '<label for="URL" title="In der Adresszeile des Browsers (für direkte Links und Suchmaschinen)">eindeutiger URL</label><input type="text" id="URL" name="URL" value=""> '."\n";
	echo "<small>Ein + im URL trennt bei Spezialseiten (Includes) Dateinamen und Parameter</small><br>\n";
	echo '<label for="Title" title="Im Titel (Tabs/Register) des Browsers">Browser-Titel</label><input type="text" id="Title" name="Title" value=""> '."\n";
	echo '<label>Status</label><select name="Stat" id="Stat" disabled>';
	echo txtOption(0,'neu und noch ohne Inhalt');
	echo txtOption(1,'aktuell und freigegeben');
	echo txtOption(2,'Kopie ist in Bearbeitung');
	echo txtOption(3,'bearbeitete Kopie wartet auf Freigabe');
	echo txtOption(9,'archiviert');
	echo "</select><br>\n";
	echo '<label for="Kopf" title="Seitentitel / weitere Information beim Mouse-Over über die Navigation">Überschrift</label><input type="text" id="Kopf" name="Kopf" value=""> ';
	if (in_array($AllowComments,[1,2,3,4])) {
		startSelect('Comm','Kommentare');
		echo txtOption(0,'Keine Kommentare erlauben/anzeigen');
		echo '<optgroup label="nur nach Freigabe">';
		echo txtOption(1,'Kommentare nur für angemeldete Benutzer');
		echo txtOption(3,'Kommentare für alle Besucher erlauben');
		echo '</optgroup><optgroup label="OHNE Freigabe">';
		echo txtOption(2,'Kommentare nur für angemeldete Benutzer');
		echo txtOption(4,'Kommentare für alle Besucher erlauben');
		echo "</optgroup></select><br>\n";
	} else {
		echo '<label>Kommentare</label>Die Kommentarfunktion ist generell '.($AllowComments ? 'aktiviert':'deaktiviert');
		echo '<input type="hidden" id="Comm" name="Comm" value=""><br>';
	}

	echo '<label for="Desc" title="Kurzbeschreibung der Seite für Suchmaschinen">Beschreibung<br><small>(<span id="Desclength">0</span> Zeichen)<br>empfohlen: bis<br>etwa 160 Zeichen</small></label><textarea id="Desc" name="Desc" class="desc" placeholder="Standard: '.$metaDescPrefix.'" onkeyup="laenge(\'Desc\')"></textarea>'."\n";
	echo '<label for="Keys" title="Keywords der Seite für Suchmaschinen">Keywords<br><small>(<span id="Keyslength">0</span> Zeichen)<br>empfohlen: bis<br>etwa 60 Zeichen</small></label><textarea id="Keys" name="Keys" class="desc" placeholder="Standard: '.$metaKeywords.'" onkeyup="laenge(\'Keys\')"></textarea><br>'."\n";

	if ($addpage && !$usepage) {
		// Vorgaben für direkt platzierte neue Seiten sowie Page0=neue Seite:
		echo '<input type="hidden" name="Icon" value="0"><input type="hidden" name="Show" value="1">
		<input type="hidden" name="Seite" id="Seite" value="Page0"><input type="hidden" name="Hier" value="'.$gid.'">';
	} else {
		if ($UseIconNavi) {
			startSelect('Icon','Navigations-Icon');
			echo '<option value="0">Kein Icon</option>';
			$MyIcons = getAlbumFiles($NaviIcons);
			foreach ($MyIcons as $value) {
				echo "<option value=\"$value\">$value</option>\n";
			}
			echo '</select> <input type="checkbox" name="Iconplus" id="Iconplus" value="1"> mit Seitenname<br>'."\n";
		} else {
			echo '<input type="hidden" id="Icon" name="Icon" value=""><input type="hidden" id="Iconplus" name="Iconplus" value="">';
		}
		startSelect('Show','Anzeige');
		echo txtOption(0,'keine Anzeige (oder spezielle Verwendung)');
		echo txtOption(1,'normale Navigation');
		echo txtOption(2,'erweiterte Navigation');
		echo txtOption(3,'Fußleiste');
		echo txtOption(8,'Aktionsseite');
/*		echo txtOption(9,'Aktionsseite, auch in normaler Navigation');
		echo txtOption(10,'Aktionsseite, auch in ereiterter Navigation');
		echo txtOption(11,'Aktionsseite, auch in Fußleisten-Navigation');	*/
		echo "</select> Wo und wie soll diese Seite angezeigt werden?<br>\n";
		startSelect('Hier','Hierarchie');
		echo '<option value="0">Ist Hauptseite</option><optgroup label="Ist Unterseite von">'."\n";
		if ($SortMainFirst) {
			$query = "SELECT ID,Link FROM Pages WHERE Parent=0 AND Show<2 AND Lang=$mylang AND NOT Type IN ('LinkPrint','LinkHome','LinkLang') ORDER BY Folge";	// normalerweise Show=1
			$result = $db->query($query);
			while ($rec = $result->fetchArray()) {
				echo '<option value="'.$rec[0].'">'.$rec[1]."</option>\n"; // URL als möglicher Parent
			}
		}
		// alle oder zusätzliche Ebenen:
		echo pagemap(0,0);
		echo '</optgroup></select> Seitenhierarchie &nbsp; ';
	}

	echo '<span id="ToTop"'. ($addpage ? '':' class="helper"') .'>'.setSelCheck('ToTop','Gleich ganz an den Anfang stellen?</span>','nach oben',0);
//	Seitenmodule:
	echo '<label for="Type" title="Einzubindendes Modul nach Vorgabe des Webmasters...">Seitenmodul</label><select id="Type" name="Type" onchange="selectParameter(value,0)" onsubmit="alert(value)">';
	echo txtOption('Text','Nur Text (Fließtext und Bilder, ohne Module)');
	if ($UseKontakt&1) echo txtOption('Form','Standard-Kontaktformular');
	if ($UseKontakt&2) echo txtOption('Forms','frei gestaltetes Formular');
	if ($RoutePlan)    echo txtOption('Route','Routenplaner');	// Google oder OSM
	if ($UseAutoNews)  echo txtOption('AutoNews','automatisch generierte News-Seite');
	if ($DiaShows)	   echo txtOption('Galerie1','Diaschau mit Überblendbildern');
	if ($UseAlben&1)   echo txtOption('Fotoalben','Foto-Alben (1 Seite mit allen Alben und Text)');
	if ($UseAlben&2)   echo txtOption('KissAlbum','Foto-Album (KissGallery)');
	if ($UseGals)	   echo txtOption('KissGallery','KissGallery (interaktive Bildergalerien)');
	if ($UseGals)	   echo txtOption('KissMemory','KissMemory (Auswertung interaktiver Galerien)');
	if ($UsePairs)	   echo txtOption('Pairs','Spiel: Pairs');
	if ($UseKalender1) echo txtOption('Kalender1','Kalender1 (Veranstaltungskalender)');
	if ($UseTimeLine)  echo txtOption('TimeLine','Zeitleiste (Timeline)');
	if ($UseProtocols) echo txtOption('Protocols','Ereignisse / Protokolle');
	if ($UseSitemap)   echo txtOption('Sitemap','Sitemap (Übersicht aller Seiten)');
	if ($UseDownloads) echo txtOption('Download','Downloadsammlung');
	if ($UseIncludes)  echo txtOption('Include','Spezielle Seite per Include einbinden');
	echo txtOption('Suchen','Inhalte Suchen (Eingabeseite)');
	echo txtOption('Login','An- und Abmeldung');
	$MyPlugs = getAlbum($MyPlugins);
	if ($UsePlugins && !empty($MyPlugs)) {
//		echo txtOption("Plugin","durch ein Plugin bereitgestellte Seite");
		foreach ($MyPlugs as $plug) {
			echo txtOption("Plugin-$plug","Plugin: $plug");
		}
	}
	if (!$addpage) {
		echo txtOption('LinkPrint','NUR LINK: Diese Seite ausdrucken');
		echo txtOption('LinkHome','NUR LINK: Zurück zur Startseite');
		if ($MultiLang)    echo txtOption('LinkLang','NUR LINK: Sprachauswahl');
	//	echo txtOption('LinkSearch','NUR LINK: Suchen');
	}
	echo "</select>\n";
//	Parameter:
	echo '<select class="helper" id="TextParam" name="TextParam">'."\n";
	echo txtOption(0,'1 Spalte ohne Extras');
	echo txtOption(1,'2 Spalten zickzack ohne Linie');
	echo txtOption(2,'2 Spalten zickzack mit Linie');
	echo txtOption(3,'2 Spalten zickzack mit Linie, letzte Spalte einspaltig');
	echo "</select>\n";

	echo '<select class="helper" id="LoginParam" name="LoginParam">'."\n";
	echo txtOption(0,'ohne Parameter');
	echo txtOption(1,'Benutzerdaten bearbeiten');
	echo "</select>\n";

	echo '<select class="helper" id="FormParam" name="FormParam">'."\n";
	echo "	<option value=\"0\">Basisformular ohne Extras</option>\n";
	echo "	<option value=\"1\">Basisformular mit An- und Abreise (nur Tage)</option>\n";
	echo "	<option value=\"2\">Basisformular mit An- und Abreise (Tage mit Uhrzeit)</option>\n";
	if ($UseGals) {
		echo "	<option value=\"5\">mit Merkliste (aus KissGallery)</option>\n";
		echo "	<option value=\"6\">mit Favoriten (aus KissGallery)</option>\n";
		echo "	<option value=\"8\">mit Wertungen (aus KissGallery)</option>\n";
		echo "	<option value=\"10\">mit Artikeln  (aus KissGallery)</option>\n";
		echo "	<option value=\"7\">mit Merkliste und Favoriten</option>\n";
		echo "	<option value=\"9\">mit Merkliste, Favoriten, Wertungen und Artikel</option>\n";
	}
	echo "</select>\n";

	echo '<select class="helper" id="FormsParam" name="FormsParam">'."\n";
	$res = $db->query("SELECT Form,Label FROM Forms WHERE Typ=0");
	while ($rec = $res->fetchArray()) {
		echo txtOption($rec['Form'],$rec['Label']);
	}
	echo "</select>\n";

	if ($UseKalender1) {
		echo '<select class="helper" id="Kalender1Param" name="Kalender1Param">'."\n";
		echo txtOption(0,'Textliche Übersicht');
		echo txtOption(1,'einfache Aufzählungsliste ohne Langtext');
		echo txtOption(2,'Übersicht mit CSS-Buttons');
		echo txtOption(9,'dreispaltig mit Grafik-Buttons');
		echo "</select>\n";
	}
	if ($UseTimeLine) {
		echo '<select class="helper" id="TimeLineParam" name="TimeLineParam">'."\n";
		echo txtOption(0,'Textliche Übersicht');
		echo txtOption(1,'einfache Aufzählungsliste ohne Langtext');
		echo txtOption(2,'Übersicht mit CSS-Buttons');
		echo txtOption(9,'dreispaltig mit Grafik-Buttons');
		echo "</select>\n";
	}

	if ($UseProtocols) {
		echo '<select class="helper" id="ProtocolsParam" name="ProtocolsParam">'."\n";
		foreach($Protocols as $key=>$val) {
			echo txtOption($key,$val);
		}
		echo "</select>\n";
	}

	if ($UsePlugins && !empty($MyPlugs)) {
		$PlugSelection = [];
		$OtherPlugs = [];
//	we need one field for each plugin since it may hold individual selections for plugin parameters:
		foreach ($MyPlugs as $plug) {
			$pp = 'Plugin'.$plug.'Param';
			$nf = true;
//			$MyPlugSelFile = "$MyPlugins/$plug/select.php";
			$MyPlugSelFile = "$MyPlugData/$plug/select.php";
			if (is_file($MyPlugSelFile)) {
				include $MyPlugSelFile;
				if (isset($MyPluginParameter) && !empty($MyPluginParameter) && is_array($MyPluginParameter)) {
					$PlugSelection[] = $plug;
					$nf = false;
					echo '<select class="helper" id="'.$pp.'" name="'.$pp."\">\n";
					foreach($MyPluginParameter as $key=>$val) {
						echo "<option value=\"$key\">$val</option>\n";
					}
					echo "</select>\n";
				}
			}
			if ($nf) {
				$OtherPlugs[] = $plug;
				echo '<input type="text" class="helper" value="" id="'.$pp.'" name="'.$pp."\">\n";
			}
		}
		echo '<input type="hidden" id="PlugSelections" value="'.implode(',',$PlugSelection).'">';
		echo '<input type="hidden" id="OtherPlugs" value="'.implode(',',$OtherPlugs).'">';
	}

	if ($UseIncludes) {
		echo '<input type="text" class="helper" id="IncludeParam" name="IncludeParam" value="">';
	}

	if ($UseSearch) {
		echo '<select class="helper" id="SuchenParam" name="SuchenParam">'."\n";
		echo txtOption(0,'auf allen freigegebenen Seiten suchen');
		echo txtOption(1,'nur im öffentlichen Archiv suchen');
		echo txtOption(2,'auf freigegebenen Seiten und im Archiv suchen');
		echo "</select>\n";
	}

	if ($UseGals) {	// KissGalleries -> eigentlich jetzt immer...
		$KissGalText = '';
		$ParKissAlbum= '';
		$ParKissDias = '';
		$Bildleisten = '';
		$PairsSpiele = '';
		$Hintergrund = '';
		$Titelbilder = '';
		$Titelgallery= '';
		$TitelgalID  = 0;
		$res = $db->query('SELECT ID,Name,App,Folder FROM Gallery WHERE Parent=0 AND NOT App<2');
		while ($gal = $res->fetchArray(SQLITE3_NUM)) {
			$OptText = '<option value="'.$gal[0]."\">$gal[1]</option>\n";
			if ($gal[2]==2 || $gal[2]==10)
				$KissGalText .= $OptText;
			if ($gal[2]==2 || $gal[2]==9)
				$ParKissAlbum .= $OptText;
			if ($gal[2]==2 || $gal[2]==3)
				$ParKissDias .= $OptText;
			if ($gal[2]==8)
				$Bildleisten .= $OptText;
			if ($gal[2]==15)
				$PairsSpiele .= $OptText;
			if ($gal[2]==12) {
				$picts = $db->query("SELECT ID,Desc1,File,Img FROM Galerie WHERE GalleryID=$gal[0]");
				while ($rs = $picts->fetchArray()) {
					$Hintergrund .= '<option value="'.$gal[3].'/'.$rs[3]."\">$rs[1]</option>\n";
				}
			}
			if ($gal[2]==14) {
				$TitelgalID  = $gal[0];
				$Titelgallery= $gal[1];
				$picts = $db->query("SELECT ID,Desc1,File,Img FROM Galerie WHERE GalleryID=$gal[0]");
				while ($rs = $picts->fetchArray()) {
					$Titelbilder .= '<option value="'.$gal[3].'/'.$rs[3]."\">$rs[1]</option>\n";
				}
			}
		}
		echo '<select class="helper" id="KissGalleryParam" name="KissGalleryParam">'."\n$KissGalText</select>\n";
		echo '<select class="helper" id="Galerie1Param" name="Galerie1Param">'."\n$ParKissDias</select>\n";
		echo '<select class="helper" id="KissAlbumParam" name="KissAlbumParam">'."\n$ParKissAlbum</select>\n";
		echo '<select class="helper" id="KissMemoryParam" name="KissMemoryParam">'."\n";
		echo txtOption(0,'Merkliste, Favoriten, Wertungen und Artikel');
		echo txtOption(1,'Nur Merkliste');
		echo txtOption(2,'Nur Favoriten');
		echo txtOption(3,'Nur Wertungen');
		echo txtOption(4,'Nur Artikel');
		echo "</select>\n";
		echo '<select class="helper" id="PairsParam" name="PairsParam">'."\n$PairsSpiele</select>\n";	//	if ($UsePairs) {
	}
	if ($MultiLang) {
		echo '<select class="helper" id="LinkLangParam" name="LinkLangParam">';
		foreach($MyLanguages as $key=>$val) {
			$val = $WIBcmsLang[$val];
			echo "<option value=\"$key\">$val</option>\n";
		}
		echo "</select>\n";
	}

	echo '<div class="helper" id="AddCWrap"> <input type="checkbox" name="AddC" id="AddC" value="1">Fließtext erlauben</div>';

	echo '<input class="helper" type="text" name="Param" id="Param" placeholder="Parameter" value="">';

//	Sidebar -> Infoboxen:
	if ($UseSidebar && (!$addpage || $usepage)) {
		echo '<br><label for="Info" title="Welche Infobox soll angezeigt werden? (Mehrere Einträge durch Komma trennen, oder ALLE, LOGIN oder NEXT)">Infobox</label><input type="text" id="Info" name="Info" value=""> ';
		$ticker = getTicker();
/*
		foreach($ticker as $num => $rec) {
			echo '<input type="button" value="'.$num.'" style="width:24px" onclick="showinfo('.$num.')" title="Infobox zur Kontrolle anzeigen"><div id="preview'.$num.'" class="preview helper"><h4>'.$rec[0].'</h4><p>'.$rec[1]."</p></div>\n";
		}
*/
		$val = '';
		echo '<label>Box-Auswahl</label><select onchange="showinfo(this.value)">';
		foreach($ticker as $num => $rec) {
			echo txtOption($num,"$num: ".$rec[0]);
			$val .= '<div id="preview'.$num.'" class="preview helper"><h4>'.$rec[0].'</h4><p>'.$rec[1]."</p></div>\n";
		}
		echo txtOption('alle','ALLE: alle Boxen');
		echo txtOption('login','LOGIN: Anmeldeformular');
		echo txtOption('search','SEARCH: Suchformular');
		echo txtOption('next','NEXT: Nächster Kalendereintrag');
		$val .= '<div id="previewalle" class="preview helper"><h4>Alle Boxen</h4><p>'."Nur in Verbindung mit einer Zeitsteuerung sinnvoll - sonst werden ALLE Infoboxen angezeigt!</p></div>\n";
		$val .= '<div id="previewlogin" class="preview helper"><h4>Anmeldeformular</h4><p>'."Login für registrierte Benutzer</p></div>\n";
		$val .= '<div id="previewsearch" class="preview helper"><h4>Suchformular</h4><p>'."Eingabe eines Suchbegriffs</p></div>\n";
		$val .= '<div id="previewnext" class="preview helper"><h4>Nächster Kalendertermin</h4><p>'."Hier erscheint dann der nächste Eintrag im Kalender.</p></div>\n";
		echo "</select>\n$val";

/*		echo "<br>\n";	// Version zum Ankreuzen... so aber keine Reihenfolge möglich. Und LOGIN, ALLE, NEXT...?
		foreach($ticker as $num => $rec) {
			echo '<input type="checkbox" name="Info" value="'.$num.'"> &nbsp;';
		}
		//echo '<div id="preview" class="preview"></div>'."\n";	*/
	} else {
		echo '<input type="hidden" id="Info" name="Info" value="">';
	}

//	Sidebar -> Bildleiste:
	if ($UsePicts && (!$addpage || $usepage)) {
		if ($UsePicts&2) {
			echo '<br><label for="Image" title="Welche Bilder sollen als Bildleiste angezeigt werden?">Bildleiste</label>';
			echo '<select id="Image" name="Image"><option value="">keine Bildleiste</option>'.$Bildleisten."</select>\n";
		} else {
			$Images = getAlbumFiles($WIBcmsFilePrefix.$GalDir3);
			echo '<br><label for="Image" title="Welche Bilder sollen als Bildleiste angezeigt werden? (Mehrere Einträge durch Komma trennen)">Bildleiste</label>';
			echo '<input type="text" id="Image" name="Image" value=""> &nbsp; ';
			foreach($Images as $num => $rec) {
				echo '<input type="button" value="'.$num.'" style="width:24px" onclick="showimg('.$num.')" title="Imagebild zur Kontrolle anzeigen"><img id="imgpreview'.$num.'" class="preview" style="display:none" src="'.$GalDir3.'Thumbs/'. $rec ."\">\n";
			}
		}
		// echo '<img id="preview" class="preview">'."\n";
	} else {
		echo '<input type="hidden" id="Image" name="Image" value="">';
	}

// Hintergründe:
	if ($UseBacks && (!$addpage || $usepage)) {
		echo '<br>';
		startSelect('Back','Hintergrundbild','onchange="setBackVal(this.value)"');
		echo '<option value="">Standard-Hintergrund</option>'.$Hintergrund."</select>\n";
	} else {
		echo '<input type="hidden" id="Back" name="Back" value="">';
	}

// Titelbilder:
	if ($UseTitlePicts && (!$addpage || $usepage)) {
		echo '<br>';
		startSelect('Pict','Titelbild','onchange="setBackVal(this.value)"');
		echo '<option value="">kein Titelbild</option>'.$Titelbilder.
			'</select> (<span class="kiss" onclick="oeffne('."'KissPicsFile',$TitelgalID,0)\">zu den Bildern der KissGallery '$Titelgallery'</span>)\n";
	} else {
		echo '<input type="hidden" id="Pict" name="Pict" value="">';
	}

// Zeitsteuerung:
	if ($UsePageTime) {
		echo '</fieldset><fieldset><legend>Zeitsteuerung</legend><label for="Auto">Automatik</label><input type="checkbox" name="Auto" id="Auto" value="1"> zeitgesteuerte Veröffentlichung aktivieren<br>'."\n";
		selectDatum('Zeitgesteuerte Anzeige VON','editVon',9);
		selectDatum('Zeitgesteuerte Anzeige BIS','editBis',9);
	} else {
		echo '<input type="hidden" name="Auto" id="Auto" value="0">';
		echo '<input type="hidden" name="Tim1" id="Tim1" value="0"><input type="hidden" name="Tim2" id="Tim2" value="0">'."\n";
	}

	echo "</fieldset>\n".formsave($edit);
	break;
// ------------------------------------------------------------------------------------------------
case 'gallery':	//							Konfig KissGallery
// ------------------------------------------------------------------------------------------------
	formkopf('Hier konfigurieren Sie das Erscheinungsbild der KissGalleries','KissGallery');
	if ($gid=='') $gid='0';
	// ---------------------- Auswahl der Galerie:
	echo '<label for="gid">Galerie</label><select id="gid" name="gid" onchange="oeffne(\'gallery\',this.options[this.selectedIndex].value,0)"><option value="0">Neue Galerie anlegen</option>';
	$query = 'SELECT ID,Name FROM Gallery WHERE Parent=0 ORDER BY Folge';	// Bislang können nur Fotoalben (Typ=9) Parents sein, dann vererben die automatisch alle Eigenschaften
	$result = $db->query($query);
	while ($rec = $result->fetchArray(SQLITE3_NUM)) {
		echo txtOption($rec[0],$rec[1],$gid);
	}
	echo "</select> (Bitte Galerie auswählen) ";
	if ($gid!='0') {
		$query = "SELECT * FROM Gallery WHERE ID=$gid";
		$bg = $db->querySingle($query,1);
		if ($bg['App']==16) {
			echo 'Anhänge werden in der jeweiligen Anwendung verwaltet';
		} else {
			echo "<span class=\"kiss\" onclick=\"oeffne('KissPicsFile',$gid,0)\">Bilder dieser Galerie bearbeiten</span>";
		}
	//	print_r($bg);
	} else {
	//	Default values to avoid warnings
		$bg['Name'] = $bg['Comment'] = $bg['B'] = $bg['H'] = $bg['T_B'] = $bg['T_H'] = $bg['Zeilen'] = $bg['T_Z'] = $bg['Cols'] = $bg['Rows'] = '';
		$bg['Box'] = $bg['WM'] = $bg['DSize'] = $bg['DLAll'] = $bg['Cover'] = $bg['C_Text'] = '';
		$bg['Typ'] = $bg['ShowN'] = $bg['ShowC'] = $bg['Schutz'] = $bg['Groups'] = $bg['Down'] = $bg['DLBox'] = 0;
		$bg['X'] = $bg['T_X'] = '0';
		$bg['App'] = 2;
		$bg['Folder'] = 'KissGallery';
	}
	echo "</fieldset>\n";
	// --------------------- Eigenschaften:
	echo '<fieldset><legend>Erscheinungsbild</legend><label for="Name" title="Bezeichnung der Bildergalerie">Name</label><input type="text" id="Name" name="Name" required="required" value="'.$bg['Name'].'"><select name="ShowN">'.HeaderSelect($bg['ShowN']).'</select><br>';
	echo '<label for="Comment" title="Kommentar zur Bildergalerie">Kommentar</label><input type="text" id="Comment" name="Comment" value="'.$bg['Comment'].'"><select name="ShowC">'.HeaderSelect($bg['ShowC']).'</select><br>';
	echo '<label for="Typ" title="Verwendungsart der Bildergalerie">Verwendung</label><select id="Typ" name="Typ">';
//	for ($i=0; $i<4; $i++)
	foreach($strGalType as $i=>$strTyp)
		echo txtOption($i, "[$i] ".$strTyp, $bg['Typ']);
	echo txtOption(9,'Normale Galerie (BlueImp-Stil)',$bg['Typ']);
	echo '</select> (Einzelverwendung der Bilder ist auf Textseiten außerdem immer möglich.)<br>';
	echo '<label for="Breite" title="Abmessungen der Bilder">Dim. Lightbox</label><input type="text" name="Breite" id="Breite" class="tabzahl" value="'.$bg['B'].'"> x <input type="text" name="Hoehe" id="Hoehe" class="tabzahl" value="'.$bg['H'].'"> [B x H] / Skalierung: <select name="Scale">'.KissFixOptions($bg['X'])."</select>\n";
	echo ' Texte: ';
	setTextCheck('Zeilen','0',$bg['Zeilen'],'Titel');
	setTextCheck('Zeilen','1',$bg['Zeilen']);
	setTextCheck('Zeilen','2',$bg['Zeilen']);
	setTextCheck('Zeilen','3',$bg['Zeilen']);
	setTextCheck('Zeilen','4',$bg['Zeilen']);
	echo ' Lightbox aktivieren <input type="checkbox" name="Box"'. (($bg['Box'])?' checked':'') ."><br>\n";
	echo '<label for="T_Breite" title="Abmessungen der Bilder">Dim. Vorschau</label><input type="text" name="T_Breite" id="T_Breite" class="tabzahl" value="'.$bg['T_B'].'"> x <input type="text" name="T_Hoehe" id="T_Hoehe" class="tabzahl" value="'.$bg['T_H'].'"> [B x H] / Skalierung: <select name="T_Scale">'.KissFixOptions($bg['T_X'])."</select>\n Texte: ";
	setTextCheck('T_Zeilen','0',$bg['T_Z'],'Titel');
	setTextCheck('T_Zeilen','1',$bg['T_Z']);
	setTextCheck('T_Zeilen','2',$bg['T_Z']);
	setTextCheck('T_Zeilen','3',$bg['T_Z']);
	setTextCheck('T_Zeilen','4',$bg['T_Z']);
	echo '<br><label for="Cols" title="Anordnung der Vorschau">Anordnung</label><input type="text" name="Cols" id="Cols" class="tabzahl" value="'.$bg['Cols'].'"> h 
		<input type="text" name="Rows" id="Rows" class="tabzahl" value="'.$bg['Rows'].'"> v / ';
	startSelect('Groups','Bildgruppen:');
	echo txtOption(0,'keine Gruppierung',$bg['Groups']);
	echo txtOption(2,'2 Bilder nebeneinander in Rahmen',$bg['Groups']);
	echo txtOption(3,'3 Bilder nebeneinander in Rahmen',$bg['Groups']);
	echo txtOption(4,'4 Bilder nebeneinander in Rahmen',$bg['Groups']);
	echo txtOption(10,'2 Bilder nebeneinander geklebt, ohne Rahmen',$bg['Groups']);	// +8
	echo txtOption(11,'3 Bilder nebeneinander geklebt, ohne Rahmen',$bg['Groups']);
	echo txtOption(12,'4 Bilder nebeneinander geklebt, ohne Rahmen',$bg['Groups']);
/*	echo txtOption(16,'3 Bilder im Quadrat',$bg['Groups']);	// 1 größeres: oben, rechts, unten oder links - aber dafür mehrere Bildgrößen erforderlich
	echo txtOption(17,'3 Bilder im Quadrat',$bg['Groups']);
	echo txtOption(18,'3 Bilder im Quadrat',$bg['Groups']);
	echo txtOption(19,'3 Bilder im Quadrat',$bg['Groups']);	
	echo txtOption(20,'4 Bilder im Quadrat',$bg['Groups']); */
	echo "</select> benachbarte Bilder bilden eine Gruppe<br>\n";
	echo setSelCheck('WM','Wasserzeichen verwenden','Wasserzeichen',$bg['WM']);
	echo "</fieldset><fieldset><legend>Speichern und Anwendung</legend>\n";
	echo txtInput('Folder','Speicherordner',$bg['Folder']);
	startSelect('Schutz','Schutz');
	echo txtOption(0,'Nicht schützen',$bg['Schutz']);
	echo txtOption(1,'Editoren dürfen nur lesen und benutzen',$bg['Schutz']);
	echo txtOption(2,'Editoren dürfen nur Bilder bearbeiten',$bg['Schutz']);
	echo "</select> Galerie beim Bearbeiten schützen<br>\n";
	// Crop: zentriert, links- rechtsbündig
	// Hochkant zulassen und wenn ja, wie?
	// -------------------- Anwendung:
	startSelect('App','Anwendung');
	echo txtOption( 0,'Diese Galerie LÖSCHEN (mit allen Bildern!)',$bg['App'],'','color:red;');
	echo txtOption( 1,'Diese Galerie ist inaktiv für alle Anwendungen',$bg['App']);
	echo txtOption( 2,'Diese Galerie ist aktiv für alle Anwendungen',$bg['App']);
	echo txtOption(10,'Diese Galerie nur verwenden als Galerie',$bg['App']);
	echo txtOption( 3,'Diese Galerie nur anbieten für eine Diashow',$bg['App']);
	echo txtOption( 4,'Diese Galerie nur anbieten für einen Kalender',$bg['App']);
	echo txtOption( 5,'Diese Galerie nur anbieten für Kalenderbuttons',$bg['App']);
	echo txtOption( 6,'Diese Galerie nur anbieten für eine Infobox',$bg['App']);
	echo txtOption( 7,'Diese Galerie nur anbieten für Designer (Gestaltungselemente für die Homepage)',$bg['App']);
	echo txtOption( 8,'Diese Galerie nur anbieten für eine Bildleiste',$bg['App']);
	echo txtOption(11,'Diese Galerie ist speziell für OpenGraph-Images',$bg['App']);
	echo txtOption(12,'Diese Galerie ist exklusiv für Seitenhintergründe',$bg['App']);
	echo txtOption(14,'Diese Galerie ist exklusiv für Menü-Titelbilder',$bg['App']);
	echo txtOption(18,'Diese Galerie ist exklusiv für (Navigations-)Icons',$bg['App']);
	echo txtOption(17,'Diese Galerie ist exklusiv für (Hinweis-)Buttons',$bg['App']);
	echo txtOption(16,'Multifunktionale Galerie exklusiv für Formularanhänge',$bg['App']);
	echo txtOption( 9,'Diese Galerie ist ein Fotoalbum',$bg['App']);
	echo txtOption(19,'Dies sind exklusiv Coverbilder für ein Fotoalbum',$bg['App']);
	echo txtOption(15,'Diese Galerie ist exklusiv für ein Pairs-Spiel',$bg['App']);
	echo '</select> ';
	if ($gid!='0') {
		echo '<span class="kiss" onclick="oeffne(';
		if ($bg['App']==9) {
			echo "'kissAlben',$gid,0)\">Albenstruktur bearbeiten</span><br>\n";
		} else {
			echo "'KissOrder',$gid,0)\">Reihenfolge der Galerien bearbeiten</span><br>\n";
		}
		echo '<label><span class="kiss" onclick="document.getElementById(\'gid\').selectedIndex=0;document.getElementById(\'Name\').value=\'Neue Galerie\';">Einst. kopieren</span></label>'.
		"<small>Neue, leere Galerie mit den angezeigten Einstellungen anlegen. Danach ggf. Änderungen vornehmen (Name!) und mit &quot;Anwenden&quot; speichern.</small><br>\n";
	}
	echo "</fieldset><fieldset><legend>Downloads anbieten (nur wenn Originale gespeichert werden)</legend>\n";
	startSelect('Down','Vorschau');
	echo txtOption(0,'keine Downloads anbieten',$bg['Down']);
	echo txtOption(1,'Downloads anbieten direkt unter dem Bild',$bg['Down']);
	echo txtOption(2,'Downloads anbieten nach Bildunterschriften',$bg['Down']);
	echo "</select> Downloadlink auf Vorschauseite\n";
	setTextCheck('DLAll','1',$bg['DLAll']);
	echo " Nur, wenn ALLE Bilder zum Download verfügbar sind<br>\n";
	startSelect('DLBox','Lightbox');
	echo txtOption(0,'keine Downloads anbieten',$bg['DLBox']);
	echo txtOption(1,'Downloads anbieten direkt unter dem Bild',$bg['DLBox']);
	echo txtOption(2,'Downloads anbieten nach Bildunterschriften',$bg['DLBox']);
	echo "</select> Downloadlink in der Lightbox<br>\n";
	echo setSelCheck('DSize','Dateigröße für Downloads anzeigen','Dateigröße',$bg['DSize']);
	echo "</fieldset>\n".formsave('gallery');
	break;
// ------------------------------------------------------------------------------------------------
case 'KissPicsFile':	//                         Bilder KissGallery
// ------------------------------------------------------------------------------------------------
	require 'edit_gallerypics.php';
	break;
// ------------------------------------------------------------------------------------------------
case 'KissOrder':	//                         Sortierung KissGallery
// ------------------------------------------------------------------------------------------------
	formkopf('Hier bearbeiten Sie die Reihenfolge der KissGalleries');

	if ($todo=='sort') {
		$ID = $_GET['id'];
		$to = $_GET['to'];
		$Folge= $db->querySingle("SELECT Folge FROM Gallery WHERE ID=$ID");
		Sortiere($ID,$to,'Gallery',"Parent=$gid",$Folge,$db);
//		write_log("$User hat die Kiss-Galerien neu geordnet");	// Verbosity...
	}

	echo '<fieldset><table><tr><th colspan="2">Sortierung</th><th>Name</th><th>Bilder bearbeiten</th></tr>';
	$GalName = sortKissAlben(0,0,$gid);
	echo '</table><br><span class="kiss" onclick="oeffne('."'gallery',$gid,0)\">Zurück zur letzten Galerie ($GalName)</span></fieldset>\n".formclose('KissOrder','',0);
	break;
// ------------------------------------------------------------------------------------------------
case 'kissAlben':	//                   Fotoalben unter Verwendung der KissGalleries
// ------------------------------------------------------------------------------------------------
	formkopf('Hier bearbeiten Sie die Struktur der Kiss-Alben');
	echo "<fieldset><table class=\"infobox\"><tr><th class=\"edit\">!</th><th class=\"del\">X</th><th>Galerie / Album</th></tr>\n";
	printKissAlben();
	echo '<tr><td><input type="radio" name="KissAlbum" id="Albumx" value="AlbumNew" onclick="clearkissalbum()" title="Neues Album erstellen" ></td><td><input type="radio" name="KissAlbum" value="Album-1" hidden="hidden" checked="checked"></td><td><label class="long" for="Albumx">Neues Album erstellen</label></td></tr>';
	echo '<tr><th colspan="3"><span class="kiss" onclick="oeffne(\'gallery\','.$gid.',0)">KissGallery konfigurieren</span><br></th></tr>';
	echo '<tr><th colspan="3"><span class="kiss" onclick="oeffne(\'KissPicsFile\','.$gid.',0)">Bilder verwalten</span><br></th></tr>';
	echo '<tr><th colspan="3"><span class="kiss" onclick="toggleID(\'MatList_0\')">Coverbilder verwalten</span><br></th></tr></table>';
	echo "\n<table class=\"overedit\"><tr><td>\n";
	echo '<textarea id="Content" name="CText" class="tinyMCE"></textarea>';
	echo txtInput('Name','Name des Albums');
	startSelect('Parent','Hierarchie');
	echo '<option value="0">Ist Hauptalbum</option><optgroup label="Ist Unteralbum von">'."\n";
	$res = $db->query("SELECT ID,Name FROM Gallery WHERE App=9");
	while ($rec = $res->fetchArray()) {
		echo txtOption($rec[0],$rec[1]);
	}
	echo '</optgroup></select><br>';
	startSelect('Cover','Coverbild');
	echo '<option value="">Bild dazu</option>'."\n";
		$dateiliste = array_diff(scandir($AlbenCovers),$excludeit);
		foreach ($dateiliste as $datei) {
			echo txtOption($datei,$datei,$Cover);
		}
	echo "</select><br>\n</td></tr></table>\n";
	echo '<div class="albumlist" id="MatList_0">'.AlbumList($AlbenCovers,$AlbenCovers,'Bild')."</div>\n";
	echo "</fieldset>\n".formsave('kissAlben');
	break;
// ------------------------------------------------------------------------------------------------
case 'autonews':	//                         Auto News
// ------------------------------------------------------------------------------------------------
	formkopf('Hier bearbeiten Sie die Inhalte der automatisch generierten News-Seite');
	echo "<fieldset><table class=\"infobox\">\n";
	echo "<tr><th class=\"edit\">!</th><th class=\"del\">X</th><th>Überschrift</th><th>Zeit</th></tr>\n";

	$ticker = getTicker(1);	// zukünftig evtl. mehrere Rubriken
	$strTitle = 'Auto-News zum Löschen markieren';
	foreach($ticker as $num => $rec) {
		echo '<tr><td><input type="radio" name="News" onclick="fillnewspage('.$num.')" id="Tick'.$num.'" value="Ticker'.$num.'" title="Diese Infobox bearbeiten"></td><td><input type="checkbox" name="del[]" value="'.$num.'" title="'.$strTitle.'"></td><td><label for="Tick'.$num.'" id="Head'.$num.'">'.$rec[0].'</label><div class="helper" id="Par1'.$num.'">'.$rec[1].'</div><div class="helper" id="Tim1'.$num.'">'.date("d.m.Y H:i",0+$rec[4]).'</div><div class="helper" id="Tim2'.$num.'">'.date("d.m.Y H:i",0+$rec[5]).'</div><div class="helper" id="InfoVon'.$num.'">'.$rec[4].'</div><div class="helper" id="InfoBis'.$num.'">'.$rec[5].'</div></td><td id="Auto'.$num.'">'.(($rec[3])?'ja':'nein')."</td></tr>\n";
	}
	echo '<tr><td><input type="radio" name="News" id="Tickx" value="TickerNew" onclick="clearnewspage()" title="Neue Infobox erstellen" ></td><td><input type="radio" name="News" value="Ticker-1" hidden="hidden" checked="checked"></td><td colspan="2"><label for="Tickx">Neuer Eintrag</label></td></tr></table>'."\n<table class=\"overedit\"><tr><td>\n";
	$BoxHeadLine='';
	echo txtBoxTitle(1,'Titel','Titel der Nachricht');
	echo '<br><textarea id="Content" name="Sidetext" class="tinyMCE"></textarea>';
	selectDatum('Veröffentlichungsdatum (zur Sortierung)','editVon',9);
	echo '<label class="long" for="Auto">Automatische Zeitsteuerung</label><input type="checkbox" name="Auto" id="Auto"><input type="checkbox" name="IsNew" id="IsNew" checked="checked" hidden="hidden"><br>'."\n";
	selectDatum('Zeitgesteuerte Anzeige BIS','editBis',9);
	echo "</td></tr></table>\n</fieldset>\n".formsave('autonews');
	break;
// ------------------------------------------------------------------------------------------------
case 'infobox':	//                             Seitentexte (Infoboxen)
// ------------------------------------------------------------------------------------------------
	formkopf('Hier bearbeiten Sie die Inhalte der Infoboxen');
	echo "<fieldset><table class=\"infobox\">\n";
	echo "<tr><th class=\"edit\">!</th><th class=\"del\">X</th><th>Überschrift</th><th>Zeit</th></tr>\n";

	$ticker = getTicker(0);
	$DefaultInfobox = $db->querySingle("SELECT ID FROM Infos WHERE Typ=0 AND Lang=$mylang");
	$num = 0;
	foreach($ticker as $num => $rec) {
		if ($num==0) {
			$disabled = ' disabled';
			$strTitle = 'Default-Infobox darf nicht gelöscht werden';
		} else {
			$disabled = '';
			$strTitle = 'Infobox zum Löschen markieren';
		}
		echo '<tr><td><input type="radio" name="News" onclick="fillnewspage('.$num.')" id="Tick'.$num.'" value="Ticker'.$num.'" title="Diese Infobox bearbeiten"></td><td><input type="checkbox" name="del[]"'.$disabled.' value="'.$num.'" title="'.$strTitle.'"></td><td><label for="Tick'.$num.'" id="Head'.$num.'">'.$rec[0].'</label><div class="helper" id="Par1'.$num.'">'.$rec[1].'</div><div class="helper" id="Tim1'.$num.'">'.date("d.m.Y H:i",0+$rec[4]).'</div><div class="helper" id="Tim2'.$num.'">'.date("d.m.Y H:i",0+$rec[5]).'</div><div class="helper" id="InfoVon'.$num.'">'.$rec[4].'</div><div class="helper" id="InfoBis'.$num.'">'.$rec[5].'</div></td><td id="Auto'.$num.'">'.(($rec[3])?'ja':'nein')."</td></tr>\n";
	}

	echo '<tr><td><input type="radio" name="News" id="Tickx" value="TickerNew" onclick="clearnewspage()" title="Neue Infobox erstellen" ></td><td><input type="radio" name="News" value="Ticker-1" hidden="hidden" checked="checked"></td><td colspan="2"><label for="Tickx">Neuer Eintrag</label></td></tr></table>'."\n<table class=\"overedit\"><tr><td>\n";
	$BoxHeadLine='';
	echo txtBoxTitle(1,($May['EditInfoTitle'])?'Titel':'','Titel der Infobox');
	echo '<br><textarea id="Content" name="Content" class="tinyMCE"></textarea>';

	if ($UseSideTime) {
		echo '<div style="display:inline-block; width:50%"><label class="long" for="Auto">Automatische Zeitsteuerung</label><input type="checkbox" name="Auto" id="Auto"></div>'."\n";
		echo '<div style="display:inline-block; width:45%; text-align:right;"><label class="long" for="IsNew">Infobox als NEU kennzeichnen</label><input type="checkbox" name="IsNew" id="IsNew" checked="checked"></div><br>'."\n";
		selectDatum('Zeitgesteuerte Anzeige VON','editVon',9);
		selectDatum('Zeitgesteuerte Anzeige BIS','editBis',9);
	} else {
		echo '<input type="hidden" name="Auto" id="Auto" value="0"><input type="hidden" name="IsNew" id="IsNew" value="0">';
		echo '<input type="hidden" name="Tim1" id="Tim1" value="0"><input type="hidden" name="Tim2" id="Tim2" value="0">'."\n";
	}
	echo "</td></tr></table>\n</fieldset>\n".formsave('infobox');
	break;
// ------------------------------------------------------------------------------------------------
case 'alben':	//                                  Foto-Alben (klassisch)
// ------------------------------------------------------------------------------------------------
	$pages = 0;
	formkopf("Hier verwalten Sie die klassischen $MyAlbenText, pflegen Text und Bild für die Beschreibung, löschen Bilder und laden neue Bilder hoch");
	echo "<div id=\"AlList\" style=\"float:right;\"></div>\n";
	echo "<fieldset><legend>$GalTxt9, Mindestgröße (B*H) $GalWid9 Pixel * $GalHgt9 Pixel</legend>";
	echo '<table  class="infobox"><tr><th class="edit">!</th><th class="del">X</th><th colspan="2">Albumtitel</th><th>aktiv</th><th>Ordner</th></tr>'."\n";

	$alben = file($MyAlben);
	AlbumTable(0,''); // Alle Fotoalben rekursiv ermitteln und anzeigen
	echo '<tr><td><input type="radio" name="Album" onclick="clearalbum()" id="Fold'.++$pages.'" value="Folder'.$pages.'" title="Neues (Unter-)Album anlegen"></td><td colspan="5"><label class="long" for="Fold'.$pages.'"><i>Neues Album (oder Unteralbum)</i></label></td></tr>'."\n";
	echo "</table><table class=\"overedit\"><tr><td>\n";	//	</fieldset><fieldset>\n";
	echo '<label for="AlKlar" title="Überschrift in der Navigation">Albumtitel</label><input type="text" id="AlKlar" name="AlKlar" value="" required="required"><br>'."\n";
	echo '<label for="AlLink" title="Upload-Ordner auf dem Webserver">Ordner</label><input type="text" id="AlLink" name="AlLink" value="" required="required"><br>'."\n";
	echo '<label for="AlComm" title="Kurze Beschreibung zu diesem Album">Kommentar</label><input type="text" id="AlComm" name="AlComm" value=""><br>'."\n";
	echo '<label for="AlAktiv" title="Auf der Homepage anbieten oder nicht">Ist aktiv</label><input type="checkbox" id="AlAktiv" name="AlAktiv" value="1"><br>'."\n";
	echo '<label for="AlHier" title="Sortierung">Hierarchie</label><select id="AlHier" name="AlHier"><option value="0-">Ist Hauptalbum</option><optgroup label="Ist Unteralbum von">'."\n";
	foreach($alben as $rec) {
		$album = explode("#", trim($rec,"\r\n"));
		if ($album[1]==0) {
			echo '<option value="'.$album[0].'-'.$album[3].'/">'.$album[2]."</option>\n";
		}
	}
	echo "</optgroup></select><br>\n";
	echo '<label for="AlBild" title="Titelbild als Cover">Titelbild</label><select id="AlBild" name="AlBild"><option value="Bild dazu">Bild dazu</option>'."\n";
	$dateiliste = array_diff(scandir($AlbenCovers),$excludeit);
	foreach ($dateiliste as $datei) {
		$myDatei = "$AlbenCovers/$datei";
		if (is_file($myDatei)) {
			echo "<option value=\"$datei\">$datei</option>\n";
		}
	}
	echo "</select><br>\n";
	echo '<textarea class="tinyMCE" name="AlText" id="Content">'."</textarea></td></tr></table>\n";
	echo "</fieldset>\n".formsave('alben');
	break;
// ------------------------------------------------------------------------------------------------
case 'material':	//                           Materialsammlung (Filebrowser)
// ------------------------------------------------------------------------------------------------
	formkopf("Hier können Sie Bilder und andere Materialien zum Download bereitstellen","");
	echo '<div id="MatList_" style="float:right;"></div><input type="hidden" name="MatFolder" value="">'."\n";
	echo "<fieldset><table><tr><th class=\"edit\">!</th><th>Ordner</th><th>Kommentar dazu</th></tr>\n";
		foreach($Materialsammlung as $num => $rec) {
			$Ordner = explode('#', trim($rec,"\r\n"));
			if ($Ordner[0]==1) echo matOrdner($Ordner[1],$Ordner[3]);
		}
		echo "<tr><td colspan=\"3\"><strong>Hinweis:</strong> Die o.a. Ordner sind nur Empfehlungen für Ihre Sortierung. Sie dürfen jedoch beliebige Dateien überall ablegen.</td></tr>\n";
		foreach($Materialsammlung as $num => $rec) {
			$Ordner = explode('#', trim($rec,"\r\n"));
			if ($Ordner[0]==0) echo matOrdner($Ordner[1],$Ordner[3]);
		}
	echo "<tr><td colspan=\"3\"><strong>Hinweis:</strong> Bilder für die Fotoalben und Bildergalerien, Hintergründe und Bilderleisten verwalten Sie über die entsprechenden Punkte im Administrationsmenü.</td></tr>\n";
	echo "<tr><td colspan=\"3\"><strong>Hinweis:</strong> Links auf diese Materialien werden NICHT automatisch aktualisiert! Achten Sie auf mögliche &quot;Broken Links&quot; z.B. in den Infoboxen und Fließtexten!</td></tr>\n";
	echo "</table></fieldset>\n".formsave('material');
	break;
// ------------------------------------------------------------------------------------------------
case 'kalender':	//                    einfacher Kalender 1 (Veranstaltungskalender)
// ------------------------------------------------------------------------------------------------
	formkopf('Hier können Sie den Kalender 1 (Typ: Veranstaltungskalender) bearbeiten');
	echo "<fieldset>\n<table style=\"float:left; margin-right:10px;\"><tr><th class=\"edit\">!</th><th class=\"del\">X</th><th>Termin</th><th>Titel</th></tr>\n";
	$res = $db->query("SELECT * FROM Events WHERE Modus LIKE '0%' ORDER BY Zeit");
	while ($rec = $res->fetchArray(SQLITE3_ASSOC)) {
		$num = $rec['ID'];
		echo '<tr><td><input type="radio" name="Termin" onclick="edittermin('.$num.')" id="Time'.$num.'" value="Time'.$num.'" title="Diesen Termin bearbeiten"><div class="helper" id="timestamp'.$num.'">'.$rec['Zeit'].'</div><div class="helper" id="CalModus'.$num.'">'.$rec['Modus'].'</div><div class="helper" id="CalButton'.$num.'">'.$rec['Button'].'</div><div class="helper" id="CalImage'.$num.'">'.$rec['Image'].'</div></td><td><input type="checkbox" name="delcal[]" value="'.$num.'" title="Termin zum Löschen markieren" onclick="if (this.checked) edittermin('.$num.')"></td><td><label for="Time'.$num.'" id="CalTermin'.$num.'">'.date("d.m.Y H:i",$rec['Zeit']).'</label><div class="helper" id="CalDetail'.$num.'">'.$rec['Text'].'</div></td><td id="CalTitel'.$num.'">'.$rec['Titel']."</td></tr>\n";
	}
	echo '<tr><td><input type="radio" name="Termin" id="Time0" value="Time0" onclick="cleartermin()" title="Neuen Termin erfassen"></td><td><input type="radio" name="Termin" value="Time-1" checked="checked" hidden="hidden"></td><td colspan="3"><label for="Time0">Neuer Termin</label></td></tr>';
	echo "</table><table class=\"overedit\"><tr><td>\n";
	selectDatum('Termin','editVon',9);
	echo '<label for="CalTitel" title="Titel / Überschrift dieses Termins">Titel</label><br><input type="text" id="CalTitel" name="CalTitel" required="required" value=""><br>'."\n";
	echo '<label for="CalDetail" title="Ausführlicher Text zu diesem Termin">Details / Text</label><br><textarea id="CalDetail" name="CalDetail"></textarea><br>';
	if ($UseCalModus)
		echo '<label for="CalModus" title="Veröffentlichungsautomatik (noch nicht benutzbar...)">Modus</label><br><input type="text" id="CalModus" name="CalModus" value=""><br>'."\n";
	else
		echo '<input type="hidden" id="CalModus" name="CalModus" value="0">'."\n";
	if ($UseButtons) {
		startSelect('CalButton','Button-Grafik');
		$res = $db->query("SELECT ID,Name FROM Buttons");
		while ($rec = $res->fetchArray()) {
			echo txtOption($rec[0],$rec[1]);
		}
		echo "</select><br>\n";
	} else
		echo '<input type="hidden" id="CalButton" name="CalButton" value="">'."\n";
	if ($UseCalImages) {
		startSelect('CalImage','Bild zum Termin');
		echo txtOption(0,'kein Bild');
		$bildliste = getAlbumFiles($WIBcmsFilePrefix.'media/Kalender');
		if (is_array($bildliste)) {
			foreach($bildliste as $rec) {
				echo txtOption($rec,$rec);
			}
		}
		echo "</select>\n";
	} else
		echo '<input type="hidden" id="CalImage" name="CalImage" value="">'."\n";
	echo "</td></tr></table></fieldset>\n".formsave('kalender');
	break;
// ------------------------------------------------------------------------------------------------
case 'editpage':	//									Contenttexte
// ------------------------------------------------------------------------------------------------
	$query   = "SELECT Content,Type,Parameter,Link,Kopf,AddC,URL,Status,Creator,Created,Changer,Changed,Approver,Approved,RefID FROM Pages WHERE ID=$gid";
	$result  = $db->querySingle($query, true);
	$text    = $result['Content'];
	$type    = $result['Type'];
	$parm    = $result['Parameter'];
	$link    = $result['Link'];
	$MyHeadLine=$result['Kopf'];
	$AddC    = $result['AddC'];
	$mypage  = $result['URL'];
	$Status  = $result['Status'];
	$Creator = $result['Creator'];
	$Created = $result['Created'];
	$Changer = $result['Changer'];
	$Changed = $result['Changed'];
	$ApproverID=$result['Approver'];
	$Approved= $result['Approved'];
	$RefID   = $result['RefID'];
/*	s.u.
	if (isset($_GET['ctxt'])) {
		$ctxt = $_GET['ctxt'];
		$sgn = $ctxt>0;
		$ctxt= abs($ctxt);
		$txt = $db->querySingle("SELECT Content FROM Pages WHERE ID=$ctxt");
//		$tc  = TextCompare($text,$txt);
//		$text = $tc[0] . "<hr>" . $tc[1];
		$text =  $sgn ? htmlDiff($text,$txt) :htmlDiff($txt,$text) ;	/* old=$gid - new=$ctxt : old=$ctxt - new=$gid
		// doesn't work if del/ins spans more than 1 line... tinymce is too smart for that. maybe a preg_replace?
//		$text = str_replace(['<del><li>','</li></del>','<ins><li>','</li></ins>'], ['<li><del>','</del></li>','<li><ins>','</ins></li>'], $text);
	}
*/
	$WorkPage = $db->querySingle("SELECT ID FROM Pages WHERE Status<8 AND RefID=$gid"); // returns ID or null
	$canSave = true;
	$helptext = '';
	$MayApprove = ($_SESSION['UserID']==$Approver);	// oder in Rights: May['Approve'];

	formkopf("Hier können Sie Überschrift und Fließtext der aktuellen Seite &quot;$link&quot; bearbeiten");	//  (Typ &quot;$type&quot; / Status $Status / ID=$gid)
	echo '<fieldset><input type="hidden" name="ConNr" value="'.$gid.'">';
	printPageTitle(1,($May['EditPageTitle'])?'Kopf':'','Überschrift');
//		echo '<br><div class="left">';
	if (isset($_GET['ctxt'])) {
		$ctxt = $_GET['ctxt'];
		$sgn = $ctxt>0;
		$ctxt= abs($ctxt);
		$txt = $db->querySingle("SELECT Content FROM Pages WHERE ID=$ctxt");
		$text =  $sgn ? htmlDiff($text,$txt) :htmlDiff($txt,$text) ;	/* old=$gid - new=$ctxt : old=$ctxt - new=$gid	*/
		$canSave = false;
		echo '<br><div class="left body" style="width:'.$EdiWidth.'px; height:'.$EdiHeight.'px; overflow:auto">'.$text;
	} else {
		echo '<br><div class="left"><textarea id="Content" name="Content" class="tinyMCE">'.$text."</textarea>";
	}
	echo "</div>\n<div id=\"EditHelp\" class=\"right\">";

	// Kommentare auf der rechten Seite:
	if ($type=='Download')
		$AddC = true;
	$editable = ($type=='Text');
	if (!$editable) {
		if ($type=='Include') {
			$helptext = "<p>Dies ist eine per Include eingebundene Spezialseite ($mypage).<br><br>";
			if ($May['EditIncludes']) {
				$psign = strpos($mypage,'+');
				if ($psign!==false) {	/* vielleicht eine Seite mit Parameter? */
					$mypage = substr($mypage,0,$psign);
					$MyIncParam= substr($mypage,$psign+1);
				}
				$helptext .= "<span class=\"editlink\" onclick=\"oeffne('incfile','$IncFolder".deprefix($mypage).".php',2);\">(".deprefix($mypage).".php bearbeiten)</span>";
				if ($mylang!=$DefaultLang) {
					$helptext .= " oder <br><span class=\"editlink\" onclick=\"oeffne('incfile','$IncFolder$mypage.php',2);\">($mypage.php bearbeiten)</span>";
				}
				$helptext .= '<hr size="1">';
			} else {
				$helptext .= 'Sie können diese Seite leider nicht bearbeiten.';
			}
		} else {
			$helptext = '<p>Diese Seite wird automatisch generiert!<br>';
		}
		$helptext .= "<br></p>\n";
		if ($AddC) {
			$helptext .= "<p>Sie können jedoch <strong>zusätzliche</strong> Textpassagen pflegen, die - je nach Vorgabe des Webdesigns - auf der Seite erscheinen sollen.<br><br></p>\n";
		}
	}
	if (($editable && $AnzahlSpalten>1) || $AddC) {
		if ($AddC) {
			$helptext .= '<p>Sie können den Text aufteilen in einen Teil über und einen Teil unter dem Modul, ';
			$txt = 'Inhalt des Moduls';
		} else {
			$helptext .= '<p>Einen Spalten- oder Abschnittswechsel erzeugen Sie,<br>';
			$txt = 'gewünschten Spaltenwechsel';
		}
		switch ($TextSplitType) {
			case 0:
				$helptext .= "indem Sie eine &quot;Überschrift 1&quot; einfügen:</p><h1>Spaltenüberschrift</h1>
				<p>Diese Überschrift wird auf der Homepage als Überschrift über der neuen Spalte angezeigt.</p>\n";
				break;
			case 1:
				$helptext .= "indem Sie eine &quot;Überschrift 6&quot; mit dem Text &quot;Spaltenwechsel&quot; (oder einem beliebigen anderen Text) einfügen:</p><h6>Spaltenwechsel</h6>
				<p>Diese Überschrift wird auf der Homepage entfernt und durch den $txt ersetzt.</p>\n";
				break;
		}
	}
	// --- Freigabe: --- (Status: siehe wibcmsconstants.php)
	$helptext .= '<hr size="1">';
	$apprtext = '';
	echo '<input type="hidden" name="Status" value="'.$Status.'"><input type="hidden" name="RefID" value="'.$RefID.'">';
	if ($editable or $AddC) {
	  if ($Approval) {
		$helptext .= "<p><i>Änderungen werden als Entwurf übernommen und müssen freigegeben werden.</i></p>\n";
		$IsInitial = ($RefID==0 and $Status>1 and empty($WorkPage));
		if ($RefID>0 or $IsInitial) {	// dies ist eine Seite in Bearbeitung (oder im Archiv)
			if ($Status<8) {
				if ($IsInitial) {
					$apprtext .= "<p>Dies ist der Entwurf für die initiale Version!</p>\n";
				} else {
					$apprtext .= "<p>Dies ist der Entwurf für die geänderte Version!<br><span class=\"cursor hilite\" onclick=\"contentswitch($RefID)\">-> Originalseite anschauen</span></p>\n";
				}
				if ($MayApprove) {
					$apprtext .= '<hr size="1">'.setSelCheck('ApproveIt','Diese Änderung freigeben','Freigabe',0);
				} elseif ($Status==2 && !isset($_GET['ctxt'])) {
					$apprtext .= '<hr size="1">'.setSelCheck('ToApprove','Zur Freigabe vorlegen','Fertigstellen',0);
				} elseif ($Status==3) {
					$canSave = false;
					$apprtext .= '<hr size="1"><p>Entwurf liegt bereits zur Freigabe vor,<br>keine Änderung mehr möglich.</p>';
				}
				if ($canSave) $apprtext .= setSelCheck('Cancel','Alle Änderungen verwerfen','Verwerfen',0);
			} elseif ($Status==8) {
				$canSave = false;
				$apprtext .= "<p>Dies ist eine verworfene Version.<br>Keine Änderung möglich.</p>\n";
			} elseif ($Status==9) {
				$canSave = false;
				$apprtext .= "<p>Dies ist eine archivierte Version.<br>Keine Änderung möglich.</p>\n";
			}
		} else {
			if ($Status>1) {
				$canSave = false;
				$apprtext .= "<p>Seite wird bereits bearbeitet!<br><span class=\"cursor hilite\" onclick=\"contentswitch($WorkPage)\">-> Weiter bearbeiten ($WorkPage)</span></p>\n";
			} else {
				$apprtext .= "<p>Dies ist die aktuell freigegebene Version.<br>Änderungsentwürfe sind zulässig.</p>\n";
			}
		}
		// --- History: ---
		$apprtext .= '<hr size="1">';
		$history = $db->query("SELECT ID,Status,Created,Changed,Approved FROM Pages WHERE ID=$RefID OR ID=$gid OR RefID=".(($Status>2) ? $RefID : $gid));
		while ($page = $history->fetchArray()) {
			if ($page['Status']==1 || ($page['Status']==2 && $page['ID']!=$gid)) {
				$aktVersion = $page['ID'];
				if ($aktVersion < $gid)
					$aktVersion *= -1;
			}
			$Stat = $strApproval[$page['Status']];
			$Datum = $page['Approved'] ? $page['Approved'] : ($page['Changed'] ? $page['Changed'] : ($page['Created'] ? $page['Created'] : "unbekannt"));
			if (is_numeric($Datum)) $Datum = date("d.m.Y",$Datum);
			if ($page['ID']==$gid) {
				$apprtext .= "<i>== Version: $Datum ($Stat)</i><br>\n";
			} else {
				$apprtext .= '--> <span class="cursor" onclick="contentswitch('.$page[0].")\">Version: $Datum ($Stat)</span><br>\n";
			}
		}
		if ($aktVersion != $gid) {
			if (!isset($_GET['ctxt']))
				$apprtext .= '<span class="cursor hilite" onclick="contentswitch('."'$gid&ctxt=$aktVersion')\">Versionsvergleich</span><br>\n";
			else
				$apprtext .= '<span class="cursor hilite" onclick="contentswitch('.($WorkPage ?? $gid).")\">Weiter arbeiten</span><br>\n";
		}
	  } else {
		$helptext .= "<p><i>Änderungen werden sofort übernommen und online gestellt.</i></p>\n";
	  }
	  $apprtext .= '<hr size="1">';

	}
	echo $helptext . $apprtext;
	echo credits($Approval,$Creator,$Created,$Changer,$Changed,$ApproverID,$Approved);

	echo '<hr size="1">'.setSelCheck('NoNewDate','(nur unwesentliche Korrektur)','Datum behalten',0);

//	--- Spontaner Datei-Upload: ---
	if ($dupMode!=0) {
		$dupType = explode('/',$dupMode);
		echo '</div></fieldset><fieldset><legend>Neue Bilder</legend><div class="left">';
		list($PostMaxSize,$FileMaxSize,$MAXFILESIZE,$MaxBytes) = ini_upload();
		$UploadWarn = '';	// = <strong>Achtung: Bitte E-Mails NICHT aus Thunderbird hier direkt hineinziehen,<br>sondern erst auf den PC-Desktop kopieren und von dort hierher ziehen!</strong>
//				Sie können aber auch mehrere Dateien nacheinander hier ablegen und sammeln.<br>
		echo '<div id="dropzone">Ziehen Sie Ihre Dateien mit Drag & Drop hier herein<br>
		(Durch Drücken der [Strg]-Taste können Sie mehrfach auswählen!)<br>
		Die Dateien werden dann sofort hochgeladen!<br>
		<div id="previews"><br>Vorschau<br>'.$UploadWarn.'</div><div id="filelist"><br>Liste</div></div>';
		echo "</div>\n<div id=\"EditHelp\" class=\"right\">";
		echo "<p><small><b>Bitte beachten:</b><br>max. einzelne Dateigröße $FileMaxSize ($MaxBytes Bytes),<br>Gesamtgröße aller Dateien zusammen $PostMaxSize</small></p>\n";
		echo "<p>Falls im Fließtext auf dieser Seite benötigt,<br>können Sie hier ad hoc neue Bilder hochladen.<br>\n";
		if ($dupType[0]=='media') {
			echo "Die Bilder stehen Ihnen anschließend sofort im Medien-Ordner '".$dupType[1]."' zur Verfügung.</p>\n";
			echo '<p><b>Die Bilder werden NICHT skaliert,<br>bitte auf die richtige Größe achten!</b></p>';
		} else {
			$kg = $db->querySingle('SELECT Name FROM Gallery WHERE ID='.$dupType[1]);
			echo "Die Bilder stehen Ihnen anschließend sofort in der KissGallery '$kg' zur Verfügung.</p>\n";
			if ($BlowUp)
				echo '<p>Alle Bilder werden automatisch skaliert.</p>';
			else
				echo '<p>Alle Bilder werden automatisch verkleinert.</p>';
		}
		echo '<div id="response"></div><div id="messages"></div><div id="dupmode" class="helper">'.$dupMode.'/page</div><progress id="progress" value="0" max="100"></progress>';
	}
	echo "</div></fieldset>\n" . formsave('editpage',0,$canSave);
	break;
// ------------------------------------------------------------------------------------------------
case 'incfile':	//                                 Include-Datei
// ------------------------------------------------------------------------------------------------
	formkopf('Hier bearbeiten Sie die gewählte Include-Datei','Edit');
	$conf = $_GET['conf'] ?? 2;
	echo '<input type="radio" name="File" id="File1" value="'.$gid.'" onclick="fillfile(1,'.$conf.')"><label for="File1" class="long">Include-Datei '.$gid.'</label> (Bitte einmal anklicken, um die Datei zu öffnen.)<div class="helper" id="Datei1">'. htmlspecialchars(file_get_contents($gid)) ."</div><br>\n";
	echo '<textarea name="Datei" id="Datei" class="Datei"></textarea>'."\n";
	echo "</fieldset>\n".formsave('incfile',$gid);
	break;
// ------------------------------------------------------------------------------------------------
case 'backup':	//                                  BackUps
// ------------------------------------------------------------------------------------------------
	formkopf('Hier verwalten Sie die BackUp-Versionen Ihrer Homepage','Verfügbare Backup-Versionen');
	echo '<div class="left"><h5>Einzeln wiederherstellbare Backups</h5>';
	$strType=['data'=>'Daten','alben'=>'Alben','media'=>'Medien','plug'=>'Plugins','full'=>'Komplett','site'=>'Homepage','prep'=>'Update'];
	$files = array_diff(scandir($MyBackUps),$excludeit);
	foreach($files as $rec) {
		if (is_file($MyBackUps.$rec)) {
			$datsize = number_format((.512 + filesize("$MyBackUps$rec") / 1024),0,',','.');
			$pos = strpos($rec,'_');
			$type = substr($rec,19,-4);
			$TypStr = $strType[$type];
			$zeit = strtotime(substr($rec,1,10).' '.substr($rec,12,2).':'.substr($rec,14,2).':'.substr($rec,16,2));
			echo '<input type="radio" name="restore" title="Version zur Wiederherstellung markieren" value="' . $rec . '"><input type="checkbox" title="Version zum Löschen markieren" name="del[]" value="'.$rec.'"> ' . date('d.m.Y (H:i:s)',$zeit) . " : <a href=\"BackUp/$rec\" target=\"_blank\">$TypStr-Backup</a> &nbsp; [ $datsize KByte ]<br>\n";
		}
	}
	echo '</div><div class="right"><h5>Backups in Ordnern, exportierbar</h5>';

	foreach($files as $rec) {
		if (is_dir($MyBackUps.$rec)) {
			$zeit = strtotime(substr($rec,1,10).' '.substr($rec,12,2).':'.substr($rec,14,2).':'.substr($rec,16,2));
			$anonym = substr($rec,0,1)=='A' ? '(anonymisiert)' : '';
			$type = substr($rec,19,-5);
			$TypStr = $strType[$type];
			echo '<input type="checkbox" title="Version zum Löschen markieren" name="del[]" value="'.$rec.'"> ' . date('d.m.Y (H:i:s)',$zeit)." $TypStr $anonym<br>\n";
		}
	}
	echo '</div></fieldset><fieldset><input type="radio" name="restore" id="restore" title="Backup anlegen" value="new"> <label class="long" for="restore">Neue BackUp-Version jetzt anlegen: </label> ';
	echo '<select name="type">';
	echo '<optgroup label="einzeln wiederherstellbar">';
	echo txtOption(2,"Nur Daten (Text, Konfiguration, Includes und Plugin-Daten)");
	echo txtOption(3,"Nur $MyAlbenText");
	echo txtOption(4,"Nur sonstige Medien (Bilder ohne Originale und Downloads)");
	echo txtOption(5,"Nur Plugins (Skripte)");
	echo txtOption(7,"Komplett (alle Daten und Medien ohne Originale)");
	echo txtOption(9,"Komplett, aber in einzelnen Dateien (ohne Originale)");
	echo txtOption(8,"Gesamte Homepage (ohne Bilder-Originale)");
	echo '</optgroup><optgroup label="in Ordnern, exportierbar">';
	echo txtOption(1,"Alle Daten in einzelnen Dateien (mit Originalbildern)");
	echo txtOption(21,"dito, (alle Daten mit Originalbildern) anonymisiert");
	echo txtOption(6,"Gesamte Homepage in einzelnen Dateien (mit Originalen)");
	echo txtOption(26,"dito, (gesamte Homepage mit Originalen) anonymisiert");
	echo "</optgroup></select>\n</fieldset>\n".formsave('backup');
	break;
// ------------------------------------------------------------------------------------------------
case 'downloads':	//                           Downloadsammlungen
// ------------------------------------------------------------------------------------------------
	formkopf('Hier verwalten Sie die auf der Homepage angebotenen Downloads','Downloads');
	if ($gid=='')
		$gid=0;	// gid = Kategorie = ID der Page
	startSelect('gid','Kategorie','onchange="oeffne(\'downloads\',this.options[this.selectedIndex].value,0)"');
	echo txtOption(0,'Ohne Kategorie oder neu auswählen:',$gid);

	$MyDLPage = $db->querySingle("SELECT ID,Link,Type,Parent FROM Pages WHERE ID=$gid",1);

	if ($gid==0 || empty($MyDLPage) || $MyDLPage['Type']!='Download') {
//		Das ist keine Downloadseite, also alle Downloadseiten anbieten: // später evtl. WHERE Lang=$DefaultLang AND...
		$KatSelect = DLPages(0,$gid);
	} else {
//		Kopfseite zur Downloadseite bzw. Kategorie finden und alle Nachbarkategorien anbieten:
		while ($MyDLPage['Type']=='Download' && $MyDLPage['Parent']>0) {
			$MyDLPage = $db->querySingle('SELECT ID,Link,Type,Parent FROM Pages WHERE ID='.$MyDLPage['Parent'],1);	// RefID=0 AND
		}
		$KatSelect = DLPages($MyDLPage['ID'],$gid);
	}

	$KatSelect .= "</select><br>\n";
	echo $KatSelect;

	if ($todo=='sort') {
		$ID = $_GET['id'];
		$to = $_GET['to'];
		$Folge= $db->querySingle("SELECT Folge FROM Downloads WHERE ID=$ID");
		Sortiere($ID,$to,'Downloads',"Kategorie=$gid",$Folge,$db);
	}

	if ($gid != 0) {
		echo "</fieldset><fieldset><legend>Downloadsammlung</legend>\n";
		echo '<table class="infobox"><tr><th class="edit">ID</th><th class="del">X</th><th colspan="2">Sortierung</th><th>Datei</th></tr>';
		$sql = "SELECT Count(ID) FROM Downloads WHERE Kategorie=$gid";
		$max = $db->querySingle($sql);
		$sql = "SELECT ID,Folge,Datei,Text FROM Downloads WHERE Kategorie=$gid ORDER BY Folge";
		$res = $db->query($sql);
		$cnt = 0;
		$clicksort='<span class="cursor" onclick="oeffne('."'downloads','$gid&todo=sort&id=";

		while ($row = $res->fetchArray()) {
			$cnt++;
			$id = $row[0];
			echo '<tr><td><input type="radio" name="ID" id="DL-'.$id.'" value="'.$id.'" onclick="filldown('.$id.')"></td><td><input type="checkbox" name="del[]" value="'.$id.'" title="Download entfernen"></td>'.ClickToSort($clicksort,$max,$cnt,$id).'<td><div class="helper" id="Text'.$id.'">'.$row['Text'].'</div><div class="helper" id="File'.$id.'">'.$row['Datei'].'</div><label for="DL-'.$id.'">' .$row['Text']. "</label></td></tr>\n";
		}
		echo '<tr><td><input type="radio" name="ID" id="DL-0" value="0" onclick="cleardown()"></td><td colspan="4"><label for="DL-0">Neuer Download</td></tr>'."\n</table>\n";
		echo '<table class="overedit"><tr><td>';
		echo txtInput('Text','Klartext');
		echo '<br><label for="Upload">Aktuelle Datei</label><span id="FileInfo"></span><input type="hidden" id="OldFile" name="OldFile" value=""><br><br>';
		$MAX_Size = ini_get('post_max_size');
//		$MAX_Byte = return_bytes($MAX_Size);
		echo '<input type="file" id="Upload" name="Upload"><br><small>Bitte beachten Sie die maximale Dateigröße von '.$MAX_Size." Byte.</small><br>";
		echo '<label for="DLKat">Kategorie</label><select id="DLKat" name="DLKat">';
		echo $KatSelect;
		echo "</td></tr></table>\n";
	}
	echo "</fieldset>\n".formsave('downloads');
	break;
// ------------------------------------------------------------------------------------------------
case 'editconfig':	//                          Editor-Konfiguration
// ------------------------------------------------------------------------------------------------
	formkopf('Hier konfigurieren Sie die Pflege der Homepage als "Editor"');
	echo "<fieldset><legend>Texteditor</legend>\n";
	if (is_dir("$MyModules/tinymce7")) {
		startSelect('UseTinyMCE','TinyMCE');
		echo txtOption(3,'TinyMCE 3',$UseTinyMCE);
		echo txtOption(7,'TinyMCE 7',$UseTinyMCE);
		echo "</select> Welche TinyMCE-Version möchten Sie verwenden?<br>\n<hr size=\"1\">\n";
		startSelect('TinySkinUI','Skin UI');
		$skin = getAlbum("$MyModules/tinymce7/skins/ui");
		foreach($skin as $s) {
			echo txtOption($s,$s,$TinySkinUI);
		}
		echo "</select> Nur TinyMCE 7: Benutzer-Oberfläche<br>\n";
		startSelect('TinySkinContent','Skin Text');
		$skin = getAlbum("$MyModules/tinymce7/skins/content");
		echo txtOption('/data/basic.css','Wie Homepage',$TinySkinContent);
		foreach($skin as $s) {
			echo txtOption($s,$s,$TinySkinContent);
		}
		echo "</select> Nur TinyMCE 7: Texteditor<br>\n";
	} else {
		echo 'Zurzeit steht nur der klassische TinyMCE-Editor (Version 3) zur Verfügung.<input type="hidden" name="UseTinyMCE" value="3">';
		echo '<input type="hidden" name="TinySkinUI" value="'.$TinySkinUI.'"><input type="hidden" name="TinySkinContent" value="'.$TinySkinContent."\"><br>\n";
	}
	echo '<hr size="1">';
	echo numInput('EdiWidth','Texteditor',$EdiWidth,400,800,20,'','px Breite / ').numInput('EdiHeight','',$EdiHeight,400,600,20,'','px Höhe')."<br>\n";
	echo numInput('FbWidth','Filebrowser',$FbWidth, 400,800,20,'','px Breite / ').numInput('FbHeight','', $FbHeight, 400,600,20,'','px Höhe')."<br>\n";
	
	echo "</fieldset><fieldset><legend>Benutzung des Administrationsbereichs / Komfortfunktionen</legend>\n";
	if ($UseAlben)
		echo setSelCheck('ShowAlbenAlways','Verwaltung der Fotoalben IMMER anbieten (sonst nur auf entsprechenden Seiten)','Fotoalben',$ShowAlbenAlways);
	else
		echo '<input type="hidden" name="ShowAlbenAlways" value="'.$ShowAlbenAlways.'">';
	if ($UseGals)
		echo setSelCheck('ShowKissAlways','Verwaltung der KissGallery IMMER anbieten (sonst nur auf entsprechenden Seiten)','KissGallery',$ShowKissAlways);
	else
		echo '<input type="hidden" name="ShowKissAlways" value="'.$ShowKissAlways.'">';
	if ($DiaShows || $UsePicts || $UseBacks)
		echo setSelCheck('ShowGalAlways','Verwaltung der Bilder (Diashow, Hintergrund, Bildleiste) IMMER anbieten (sonst nur auf entsprechenden Seiten)','Bildergalerien',$ShowGalAlways);
	else
		echo '<input type="hidden" name="ShowGalAlways" value="'.$ShowGalAlways.'">';
	if ($UseSidebar)
		echo setSelCheck('ShowInfoAlways','Verwaltung der Infoboxen IMMER anbieten (sonst nur auf entsprechenden Seiten)','Infoboxen',$ShowInfoAlways);
	else
		echo '<input type="hidden" name="ShowInfoAlways" value="'.$ShowInfoAlways.'">';
	if ($UseAutoNews)
		echo setSelCheck('ShowAutoNewsAlways','Verwaltung der Auto-News IMMER anbieten (sonst nur auf entsprechenden Seiten)','Auto-News',$ShowAutoNewsAlways);
	else
		echo '<input type="hidden" name="ShowAutoNewsAlways" value="'.$ShowAutoNewsAlways.'">';
	if ($UseKalender1)
		echo setSelCheck('ShowCalAlways','Verwaltung des Kalenders IMMER anbieten (sonst nur auf entsprechenden Seiten)','Kalender',$ShowCalAlways);
	else
		echo '<input type="hidden" name="ShowCalAlways" value="'.$ShowCalAlways.'">';
	if ($UsePlugins)
		echo setSelCheck('ShowPluginsAlways','Verwaltung der Plugins IMMER anbieten (sonst nur auf entsprechenden Seiten)','Plugins',$ShowPluginsAlways);
	else
		echo '<input type="hidden" name="ShowPluginsAlways" value="'.$ShowPluginsAlways.'">';
	echo setSelCheck('ShowDownsAlways','Download-Verwaltung IMMER anbieten (sonst nur auf entsprechenden Seiten)','Downloads',$ShowDownsAlways);
	echo setSelCheck('ShowFormsAlways','Formular-Editor IMMER anbieten (sonst nur auf entsprechenden Seiten)','Formulare',$ShowFormsAlways);
	echo setSelCheck('ShowHelp','Onlinehilfe als Standard generell anzeigen (sonst nur bei Klick auf Symbol, kann aber vom Benutzer überschrieben werden)','Onlinehilfe',$ShowHelp);
	echo setSelCheck('ShowValid','Validierung (auf valides (X)HTML, CSS, Barrierefreiheit) anbieten','Validierung',$ShowValid);
	echo setSelCheck('ShowPrintAlways','Druckansicht im Admin-Menü anbieten (wenn auf der Seite selbst keine Druckfunktion angeboten wird)','Druckansicht',$ShowPrintAlways);
	if ($UseAlben)
		echo setSelCheck('PopUpAlben','PopUp-Hinweis beim Löschen von Alben auf mögliches Inaktivstellen','PopUp Alben',$PopUpAlben);
	else
		echo '<input type="hidden" name="PopUpAlben" value="'.$PopUpAlben.'">';
	if ($May['AddPages'])
		echo setSelCheck('PopUpNavi','PopUp-Hinweis beim Löschen von Seiten auf mögliches Inaktivstellen','PopUp Seiten',$PopUpNavi);
	else
		echo '<input type="hidden" name="PopUpNavi" value="'.$PopUpNavi.'">';
//	enable direct uploads?
	startSelect('dupMode','Direkt-Upload');
	echo txtOption(0,'keine Uploads anbieten',$dupMode);
	echo '<optgroup label="Materialsammlung (media)">';
	foreach($Materialsammlung as $num => $rec) {
		$Ordner = explode('#', trim($rec,"\r\n"));
		$Type = explode('/',$Ordner[1]);
		if ($Type[0]=='media') echo txtOption($Ordner[1],$Type[1],$dupMode);
	}
	echo '</optgroup><optgroup label="KissGalleries">';
	$res = $db->query("SELECT ID,Name,Comment FROM Gallery WHERE App IN (2,7)");
	while ($gal = $res->fetchArray(SQLITE3_NUM)) {
		echo txtOption('kg/'.$gal[0],$gal[1],$dupMode);
	}
	echo "</optgroup></select> Wohin sollen Bilder bei der Seitenbearbeitung gespeichert werden?<br>\n";
	echo setSelCheck('KGdupMode','Direkt-Upload in den KissGallerys anbieten?','Galeriebilder',$KGdupMode);
	echo "</fieldset><fieldset><legend>Seitenstruktur / Navigation bearbeiten</legend>\n";
	echo setSelCheck('CompactPageTable','Beim Editieren der Seitenstruktur erst nur kompakte Tabelle anzeigen, ausklappbar','Kompakt',$CompactPageTable);
	echo setSelCheck('StraightPageTable','Beim Editieren der Seitenstruktur die Anzeigeart (0-3) in der Reihenfolge einreihen','eingereiht',$StraightPageTable);
	echo setSelCheck('SortMainFirst','Bei Auswahl der Seitenhierarchie die Hauptseiten (1. Ebene) am Anfang zusammenfassen','Hierarchie',$SortMainFirst);
	echo setSelCheck('ShowPageFolge','Folgenummer der Reihenfolge zur Kontrolle mit anzeigen','Reihenfolge',$ShowPageFolge);
	echo "</fieldset><fieldset><legend>Editier-Symbole</legend>\n";
	echo setSelCheck('editsymbols','Zur Bearbeitung Symbole auf der Webseite anzeigen','Anzeige',$editsymbols);
	echo "</fieldset><fieldset><legend>Pflegebereich / Speichern</legend>\n";
	startSelect('EditStay','Nach Anwenden');
	echo txtOption(0,'stets speichern und Editor verlassen',$EditStay);
	echo txtOption(1,'stets speichern und Editor erneut aufrufen',$EditStay);
	echo txtOption(2,'Rückkehr durch Checkbox wählbar (Vorauswahl leer)',$EditStay);
	echo txtOption(3,'Rückkehr durch Checkbox wählbar (Vorauswahl checked)',$EditStay);
//	echo txtOption(4,'Rückkehr durch 2. Button wählbar',$EditStay);
//	echo txtOption(5,'Nutzer kann selbst bestimmen',$EditStay);	// -> neue Variable in db User
	echo "</select> (falls in den einzelnen Pflegebereichen nichts anderes vorgegeben ist)<br>\n";
	echo "</fieldset>\n".formsave('editconfig');
	break;
// ------------------------------------------------------------------------------------------------
case 'layoutcfg':	//                             Layout-Konfiguration
// ------------------------------------------------------------------------------------------------
	formkopf('Hier konfigurieren Sie die Homepage als "Designer"');
	require 'edit_layoutcfg.php';
	break;
// ------------------------------------------------------------------------------------------------
case 'admincfg':	//                             Admin-Konfiguration
// ------------------------------------------------------------------------------------------------
	formkopf('Hier konfigurieren Sie die Pflege der Homepage als "Administrator"');
	require 'edit_admincfg.php';
	break;
// ------------------------------------------------------------------------------------------------
case 'customcfg':	//                            Custom-Kunden-Konfiguration
// ------------------------------------------------------------------------------------------------
	formkopf('Hier konfigurieren Sie kundenspezifische Einstellungen und Vorgaben');
	require 'edit_customcfg.php';
	break;
// ------------------------------------------------------------------------------------------------
case 'editfiles':	//                          Stylesheets & Homepage-Template
// ------------------------------------------------------------------------------------------------
	formkopf('Hier bearbeiten Sie die Stylesheets und das Homepage-Template','Styles');
	switch ($gid) {
		case  6: file_put_contents($MyAdminCSS,"\n");
		case  8: copy($MyCore.'lightbox/slimbox.css',$MySlimCSS); break;
		case  9: copy($MyCore.'lightbox/photobox.css',$MyPhotoCSS); break;
	}
	echo "<table>\n";
	echo '<tr><td><input type="radio" name="File" id="File2" value="basic" onclick="fillfile(2,1)"></td><td><label for="File2" class="long">Basis-Stylesheet für Homepage und TinyMCE-Editor</label></td><td>'.$MyBasicCSS.'<div class="helper" id="Datei2">'. htmlspecialchars(file_get_contents($MyBasicCSS)) ."</div></td></tr>\n";
	echo '<tr><td><input type="radio" name="File" id="File1" value="style" onclick="fillfile(1,1)"></td><td><label for="File1" class="long">Stylesheet der Homepage</label></td><td>'.$MyCSSheet.'<div class="helper" id="Datei1">'. htmlspecialchars(file_get_contents($MyCSSheet)) ."</div></td></tr>\n";
	if (is_file($MyAdminCSS)) {
		echo '<tr><td><input type="radio" name="File" id="File6" value="admin" onclick="fillfile(6,1)"></td><td><label for="File6" class="long">Extra-Stylesheet im Pflegebereich</label></td><td>'.$MyAdminCSS.'<div class="helper" id="Datei6">'. htmlspecialchars(file_get_contents($MyAdminCSS)) ."</div></td></tr>\n";
	} else {
		echo '<tr><td></td><td><span class="kiss" onclick="oeffne(\'editfiles\',6,0)">Extra-Stylesheet für den Pflegebereich erzeugen</span></td><td>'."$MyAdminCSS</td></tr>\n";
	}
	if (is_file($MySlimCSS)) {
		echo '<tr><td><input type="radio" name="File" id="File8" value="slimbox" onclick="fillfile(8,1)"></td><td><label for="File8" class="long">Eigenes Stylesheet für die slimbox</label></td><td>'.$MySlimCSS.'<div class="helper" id="Datei8">'. htmlspecialchars(file_get_contents($MySlimCSS)) ."</div></td></tr>\n";
	} else {
		echo '<tr><td></td><td><span class="kiss" onclick="oeffne(\'editfiles\',8,0)">Eigenes Stylesheet für die slimbox erzeugen</span></td><td>'."$MySlimCSS</td></tr>\n";
	}
	echo '<tr><td><input type="radio" name="File" id="File3" value="header" onclick="fillfile(3,2)"></td><td><label for="File3" class="long">Header-Bereich</label></td><td>'.$MyHeader.'<div class="helper" id="Datei3">'. htmlspecialchars(@file_get_contents($MyHeader)) ."</div></td></tr>\n";
	echo '<tr><td><input type="radio" name="File" id="File4" value="homepage" onclick="fillfile(4,2)"></td><td><label for="File4" class="long">Content-Bereich</label></td><td>'.$MyHomepage.'<div class="helper" id="Datei4">'. htmlspecialchars(file_get_contents($MyHomepage)) ."</div></td></tr>\n";
	echo '<tr><td><input type="radio" name="File" id="File5" value="footer" onclick="fillfile(5,2)"></td><td><label for="File5" class="long">Footer-Bereich</label></td><td>'.$MyFooter.'<div class="helper" id="Datei5">'. htmlspecialchars(@file_get_contents($MyFooter)) ."</div></td></tr>\n";
	echo '<tr><td><input type="radio" name="File" id="File7" value="robots" onclick="fillfile(7,1)"></td><td><label for="File7" class="long">robots.txt</label></td><td>../robots.txt<div class="helper" id="Datei7">'. htmlspecialchars(@file_get_contents('../robots.txt')) ."</div></td></tr>\n";
	echo '<tr><td><input type="radio" name="File" id="File10" value="htaccess" onclick="fillfile(10,1)"></td><td><label for="File10" class="long">htaccess</label></td><td>../.htaccess<div class="helper" id="Datei10">'. htmlspecialchars(@file_get_contents('../.htaccess')) ."</div></td></tr>\n";
	echo '</table><textarea name="Datei" id="Datei" class="Datei"></textarea>'."\n";
	echo "</fieldset>\n".formsave('editfiles');
	break;
// ------------------------------------------------------------------------------------------------
case 'users':	//                              Benutzerverwaltung
// ------------------------------------------------------------------------------------------------
	formkopf('Hier verwalten Sie alle registrierten Benutzer Ihrer Homepage');
	echo '<div class="configmenu"><span id="Config0">Benutzer</span><span id="Config1">Rollen</span><span id="Config2">Benutzergruppen</span></div>';

//	Config 0 User ----------------------------------------------------
	echo "<div id=\"divConfig0\" class=\"helper\"><fieldset><legend>Anmeldeinformationen</legend>\n";

	echo '<table><tr><th class="edit">!</th><th class="del">X</th><th>Name</th><th>Mail</th><th>Vorname</th><th>Nachname</th><th>Alias-Name</th><th>Status</th>';
	$MayBe = ($May['Be']) || isset($_SESSION['Saved']);
	if ($MayBe) {
		echo '<th>Be!</th>';
	}
	echo "</tr>\n";

	$AnzAdmins = $db->querySingle('SELECT COUNT(ID) FROM Users WHERE (RoleID=1 OR RoleID=3)');

	$sql = 'SELECT * FROM Users';
	$res = $db->query($sql);
	while($rec = $res->fetchArray()) {
		$num = $rec['ID'];
		if ($AnzAdmins==1 AND ($rec['RoleID']==1 OR $rec['RoleID']==3)) {
			$disabled = ' disabled';
			$strTitle = 'Einziger Admin darf nicht gelöscht werden';
		} else {
			$disabled = '';
			$strTitle = 'Benutzer zum Löschen markieren';
		}
		if ($MayBe) {
			if ($num!=$_SESSION['UserID']) {
				$be = '<td><input type="radio" name="be" value="'.$num.'"></td>';
			} else {
				$be = '<td></td>';
			}
		} else {
			$be = '';
		}
		echo '<tr><td><input type="radio" name="User" onclick="filluser('.$num.')" id="Tick'.$num.'" value="Ticker'.$num.'" title="Diesen Benutzer bearbeiten"></td><td><input type="checkbox" name="del[]"'.$disabled.' value="UsrDel'.$num.'" onclick="if (this.checked) filluser('.$num.');" title="'.$strTitle.'"></td><td><label for="Tick'.$num.'" id="Name'.$num.'">'.$rec['Name'].'</label><div class="helper" id="Pass'.$num.'"></div></td><td id="Mail'.$num.'">'.$rec['Mail'].'</td><td id="VName'.$num.'">'.$rec['VName'].'</td><td id="NName'.$num.'">'.$rec['NName'].'</td><td id="Real'.$num.'">'.$rec['RealName'].'</td><td>'.$WIBcmsRole[$rec['RoleID']].'<div class="helper" id="Stat'.$num.'">'.$rec['RoleID']."</div></td>$be</tr>\n";
	}
	echo '<tr><td><input type="radio" name="User" id="Tick0" value="Ticker0" onclick="clearuser()" title="Neuen Benutzer erstellen"></td><td><input type="radio" name="User" value="Ticker-1" hidden="hidden" checked="checked"></td><td colspan="6"><label for="Tick0">Neuer Benutzer</label></td>';
	if ($MayBe) {
		echo '<td></td>';
	}
	echo "</tr></table>\n</fieldset>\n<fieldset>\n";

	echo '<label for="Name">Benutzername</label><input type="text" id="Name" name="Name" value="Anmeldename" required="required"><br>'."\n";
	echo '<label for="Mail">E-Mail-Adresse</label><input type="email" id="Mail" name="Mail" value="mustermann@beispiel.de" required="required"><br>'."\n";
	echo '<label for="Real">Alias-Name</label><input type="text" id="Real" name="Real" value=""> nur für interne Verwendung/Anzeige<br>'."\n";
	echo '<label for="VName">Vorname</label><input type="text" id="VName" name="VName" value=""> Vorname<br>'."\n";
	echo '<label for="NName">Nachname</label><input type="text" id="NName" name="NName" value=""> Nachname<br>'."\n";
	echo '<label for="Pass">Passwort</label><input type="password" id="Pass" name="Pass" value=""> frei lassen, wenn keine Änderung erwünscht<br>'."\n";
	strPassRequirement(true);
	startSelect('Stat','Berechtigung');
	foreach($WIBcmsRole as $key=>$value) {
		echo "<option value=\"$key\">$value</option>\n";
	}
	echo "</select><br>\n";
	echo "</fieldset></div>\n";

//	Config 1 Rollen ----------------------------------------------------
	echo "<div id=\"divConfig1\" class=\"helper\"><fieldset><legend>Rollenzuweisungen</legend>\n";
	include 'personroles.php';
	echo "</fieldset></div>\n";

//	Config 2 Gruppen ----------------------------------------------------
	echo "<div id=\"divConfig2\" class=\"helper\"><fieldset><legend>Berechtigungsmatrix</legend>\n";
	if ($May['SetRights']) {
		echo '<table><thead><tr><th>Berechtigung</th>';
		foreach($WIBcmsRole as $Role) {
			echo "<th>$Role</th>";
		}
		echo "<th>Beschreibung</th></tr>\n";
		$sql = "SELECT * FROM Rights WHERE Var NOT IN ('Name','Exist')";
		$res = $db->query($sql);
		while ($rs = $res->fetchArray()) {
			echo '<tr><td>'.$rs[1].'</td>';
			for ($j=0; $j<8; $j++) {
				$c = ($rs[$j+2]) ? ' checked':'';
				echo '<td><input type="checkbox" name="'.$rs[1]."[$j]\"$c></td>\n";
			}
			echo "<td>{$rs['Desc']}</td></tr>\n";
		}
		echo "</table>\n";
	}
	else { NotAllowed();}
	echo "</fieldset></div>\n".formsave('users');
	break;
// ------------------------------------------------------------------------------------------------
case 'mySetup':	//                      Eigene Zugangsdaten / Einstellungen
// ------------------------------------------------------------------------------------------------
	formkopf('Hier verwalten Sie Ihre eigenen Zugangsdaten zum WIBcms','Benutzer');
	$sql = "SELECT ID,Name,Mail,Pass,Abos,Help,RealName,VName,NName,Mini FROM Users WHERE ID='".$_SESSION['UserID']."'";
	$rec = $db->querySingle($sql,true);
	echo '<label for="Name">Benutzername</label><input type="text" id="Name" name="Name" required="required" value="'.$rec['Name'].'"> mit diesem Namen melden Sie sich an<br>'."\n";
	echo '<label for="Mail">E-Mail-Adresse</label><input type="email" id="Mail" name="Mail" required="required" value="'.$rec['Mail'].'"><br>'."\n";
	echo '<label for="Real">Alias-Name</label><input type="text" id="Real" name="Real" value="'.$rec['RealName'].'"> nur für interne Verwendung/Anzeige<br>'."\n";
	echo '<label for="VName">Vorname</label><input type="text" id="VName" name="VName" value="'.$rec['VName'].'"> Vorname<br>'."\n";
	echo '<label for="NName">Nachname</label><input type="text" id="NName" name="NName" value="'.$rec['NName'].'"> Nachname<br>'."\n";
	echo '<label for="Pass">Passwort</label><input type="password" id="Pass" name="Pass" value=""> frei lassen, wenn keine Änderung erwünscht<br>'."\n";
	strPassRequirement(true);
	if ($EnableNotifications) {
		echo "</fieldset><fieldset><legend>Benachrichtigungen per E-Mail</legend>\n";
		echo '<label for="News1">CMS-Newsletter</label><input type="checkbox" id="News1" name="News1" '. (($rec['Abos']&1)?"checked ":"") ."><br>\n";
		echo '<label for="News2">Benachrichtigung</label><input type="checkbox" id="News2" name="News2" '. (($rec['Abos']&2)?"checked ":"") .">\n";
	} else {
		echo '<input type="hidden" name="News1" value="0"><input type="hidden" name="News2" value="0">';
	}
	echo "</fieldset><fieldset><legend>Persönliche Einstellungen für den Pflegebereich</legend>\n";
	$ThisHelp = (isset($rec['Help'])) ? $rec['Help'] : $ShowHelp;
	echo setSelCheck('Help','Online-Hilfe immer gleich mit anzeigen','Online-Hilfe',$ThisHelp);
	echo setSelCheck('Mini','Nach Login Mini-Menü anzeigen statt großem Admin-Menü','Mini-Menü',$rec['Mini']);
	if ($May['Debug']) {
		startSelect("DebugMode","Debug-Modus");
		$DebugMode = $_SESSION['Debug'] ?? 1;
		echo txtOption(0,'Debugging ausschalten',$DebugMode);
		echo txtOption(1,'Standard-Debugging',$DebugMode);
		echo txtOption(2,'Erweitertes Debugging',$DebugMode);
		echo txtOption(3,'Debugging mit SQL-Anweisungen',$DebugMode);
		echo "</select><br>\n";
	}
	echo '<input type="hidden" name="ID" value="'.$rec['ID'].'">';
	echo "</fieldset>\n".formclose('mySetup');
	break;
// ------------------------------------------------------------------------------------------------
case 'rights':	//                                Berechtigungsmatrix
// ------------------------------------------------------------------------------------------------
	formkopf('Hier verwalten Sie die Berechtigungen der Benutzergruppen','Auswahl');
	$CanSave = false;
	if ($May['SetRights']) {
		echo '<label for="SelByGroup">Benutzergruppe</label><select id="SelByGroup" name="SelByGroup" onchange="oeffne(\'rights\',this.options[this.selectedIndex].value,0)">';
		echo "<option>- Bitte auswählen -</option>\n";
		$sql = "SELECT * FROM Rights WHERE Var='Name'";
		$res = $db->querySingle($sql,1);
		foreach ($res as $var => $val) {
			if (strpos($var,'R') !== false)
			 echo txtOption($var,$val,$gid);
		}
		echo "</select> Wählen Sie eine Benutzergruppe aus<br>\n";
		/*
		echo '<label for="SelByRight">Berechtigung</label><select id="SelByRight" name="SelByRight" onchange="SelByRight()">';
		$sql = "SELECT ID,Var FROM Rights WHERE Var NOT IN ('Name','Exist')";
		$res = $db->query($sql);
		while ($rs = $res->fetchArray()) {
			echo txtOption($rs['ID'],$rs['Var'],$gr);
		}
		echo "</select> Wählen Sie eine Berechtigung aus<br>\n";
		*/
		$CanSave = (strpos($gid,'R') !== false);
		if ($CanSave) {
			echo "</fieldset><fieldset><legend>Berechtigungsmatrix für Benutzergruppe &quot;$res[$gid]&quot;</legend>\n";
			$sql = "SELECT Var,$gid FROM Rights WHERE Var NOT IN ('Name','Exist')";
			$res = $db->query($sql);
			while ($rs = $res->fetchArray()) {
				$c = ($rs[1]) ? ' checked':'';
				echo "<label for=\"$rs[0]\">$rs[0]</label><input type=\"checkbox\" name=\"$rs[0]\" id=\"$rs[0]\"$c><br>\n";
			}
		}
	}
	else {
		NotAllowed();
	}
	echo "</fieldset>\n".formsave('rights',$gid,$CanSave);
	break;
// ------------------------------------------------------------------------------------------------
case 'forms':	//                                  Formular-Editor
// ------------------------------------------------------------------------------------------------
	formkopf('Hier verwalten Sie die auf der Homepage verfügbaren Formulare','Formulare');
	require 'edit_forms.php';
	break;
// ------------------------------------------------------------------------------------------------
case 'logs':	//                                   Logdatei
// ------------------------------------------------------------------------------------------------
	$txt = ($May['EditLogs']) ? ' (und bearbeiten ;-)' : '';
	formkopf('Hier können Sie die Logdatei anschauen' . $txt,'Log-Meldungen');
	echo '<textarea class="log" name="logfile">';
	$logfile = fopen($MyLogFile,"r");
    while (!feof($logfile)) {echo fgets($logfile);} // \n ist in Dateizeile enthalten
	fclose($logfile);
	echo "</textarea></fieldset>\n".formclose('logs','Anwenden',$May['EditLogs']);
	break;
// ------------------------------------------------------------------------------------------------
case "validate":	//                           Validierungen (div.)
// ------------------------------------------------------------------------------------------------
	formkopf('Hier können Sie die gerade angezeigte Webseite validieren','Validierungsdienste');
	$http_prot = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!="off") ? 'https:':'http:';
	echo "<table><tr><th>Dienst</th><th>Prüfen</th><th>Erläuterung</th></tr>\n";
	echo '<tr><td>W3 HTML-Validator</td><td><a href="'.$http_prot.'//validator.w3.org/check?uri=referer" target="_blank">HTML</a></td><td>Prüft die angezeigte Seite auf fehlerfreien HTML-Code</td></tr>'."\n";
	echo '<tr><td>CSS-Validator Jigsaw</td><td><a href="'.$http_prot.'//jigsaw.w3.org/css-validator/check/referer" target="_blank" style="display:inline;">CSS</a></td><td>Prüft die angezeigte Seite auf fehlerfreie CSS-Styles</td></tr>'."\n";
	echo '<tr><td>WebAIM</td><td><a href="http://wave.webaim.org/report#/'.$_SERVER['SERVER_NAME'].'" target="_blank">WAVE web accessibility tool</a></td><td>Prüft die angezeigte Seite auf Barrierefreiheit ("Web Accessibility")</td></tr>'."\n";
	// http://achecker.ca/checker/index.php
	// http://validator.w3.org/feed/check.cgi?url=<rss-feed> </td><td>Check the syntax of Atom or RSS feeds</td></tr>
	// https://varvy.com/pagespeed/
	// https://developers.facebook.com/tools/debug/sharing/ // OpenGraph Debugger
	// https://cards-dev.twitter.com/validator
	echo '<tr><td>CSP-Validator Mozilla</td><td><a href="https://observatory.mozilla.org/analyze/'.$_SERVER['SERVER_NAME'].'" target="_blank">CSP</a></td><td>Prüft die angezeigte Seite auf Content Security Policies</td></tr>'."\n";
	echo '<tr><td>SSL Check</td><td><a href="https://www.ssllabs.com/ssltest/analyze.html?d='.$_SERVER['SERVER_NAME'].'&latest" target="_blank">SSL</a></td><td>Prüft die angezeigte Seite auf SSL-Sicherheit</td></tr>'."\n";
	echo '<tr><td>seobility</td><td><a href="https://freetools.seobility.net/de/seocheck/'.$_SERVER['SERVER_NAME'].'" target="_blank">SEO Check</a></td><td>Kostenloser SEO Check mit Seobility</td></tr>'."\n";
//	echo '<tr><td>PageSpeed Insights</td><td><a href="https://pagespeed.web.dev/analysis/https-'. str_replace('.','-',$_SERVER['SERVER_NAME']).'" target="_blank">Pagespeed Analyse</a></td><td>Leistungsbericht von "Google for Developers"</td></tr>'."\n"; https://pagespeed.web.dev/analysis/https-ak-produktionstechnik-de/xauz7t0tcc?form_factor=mobile
	echo '<tr><td>PageSpeed Insights</td><td><a href="https://pagespeed.web.dev/" target="_blank">Pagespeed Analyse</a></td><td>Leistungsbericht von "Google for Developers"</td></tr>'."\n";
	echo '<tr><td>SIWECOS</td><td><a href="https://siwecos.de/scanned-by-siwecos/?data-siwecos='.$_SERVER['SERVER_NAME'].'" target="_blank">
	<svg width="150" height="58" id="siwecos-seal" data-format="d.m.y"></a></td><td>Zeigt das Scanergebnis für ein SIWECOS-Siegel (falls eingerichtet)</td></tr>';
	echo "</table>\n<p>Beachten Sie, dass alle Validierungen für anonyme Besucher gelten (nicht eingeloggt).</p>\n";
	echo "</fieldset>\n".formclose('validate','',false);
	break;
// ------------------------------------------------------------------------------------------------
case 'wibcmsdb':	//                              WIBcms Datenbank
// ------------------------------------------------------------------------------------------------
	$sql3ver = SQLite3::version();
	$txt = 'SQLite3-Datenbanken / SQLite3-Version: ' . $sql3ver['versionString'];
	formkopf('Hier können Sie die WIBcms-Datenbank anschauen (und bearbeiten ;-)',$txt);

	if ($gid=='') $gid = 'sqlite_master';
	$editdb = ($gid!='sqlite_master');	// Datenbank editierbar oder nicht?

	echo '<label for="page">Datenbank</label><select name="page" onchange="oeffne(\'wibcmsdb\',this.options[this.selectedIndex].value,0)">';
	echo txtOption('sqlite_master','SQLite-Master',$gid);
	foreach($MyDBTables as $num => $rec) {
		$ok = $db->querysingle("SELECT type FROM sqlite_master WHERE name='$rec'");
	// rot einfärben, wenn nicht vorhanden !!!!!!!!
		echo txtOption($rec,$rec,$gid);
	}
	echo "</select></fieldset>\n";
	echo '<fieldset>';
//	Tabelle anzeigen:
	$result = @($db->query("SELECT * FROM $gid"));
	if ($result) {
		$num = $result->numColumns();
		echo "<table>\n  <tr>";
		if ($editdb)
			echo '<th class="del">X</th>';
		for($i=0; $i<$num; $i++) {
			echo "<th>".$result->columnName($i)."</th>";
		}
		echo "</tr>\n";

		while ($row = $result->fetchArray(SQLITE3_NUM)) {
			echo "  <tr>";
			if ($editdb)
				echo '<td><input type="checkbox" name="del[]" value="'.$row[0].'"></td>';
			foreach($row as $wert) {
				echo "<td>$wert</td>";
			}
			echo "</tr>\n";
		}
		if ($editdb) {
			echo '<tr><td><input type="checkbox" name="Neu"></td><td>Neu</td>';
			for($i=1; $i<$num; $i++) {
				echo '<td><input type="text" style="width:97%;" name="new['.$i.']" value="'.$result->columnName($i).'" onfocus="if (this.value==\''.$result->columnName($i)."') this.value='';\"></td>\n";
			}
			echo "</tr>\n";
		}
		echo "</table>\n";
	} else {
		echo "<p>Tabelle &quot;$gid&quot; existiert nicht!</p>";
	}
	echo "</fieldset>\n".formsave('wibcmsdb',$gid,$editdb);
	break;
// ------------------------------------------------------------------------------------------------
case 'wibcms':	//                         WIBcms Serverinfo und Update
// ------------------------------------------------------------------------------------------------
	formkopf('Hier finden Sie Informationen und Update-Hinweise zu Ihrem Webserver und Ihrer Software-Installation');
	echo '<div class="configmenu"><span id="Config0">Update</span><span id="Config1">Module</span><span id="Config2">Plugins</span><span id="Config3">Info</span><span id="Config4">Disclaimer</span></div>';
// --------------------------------------------------------------------------------
	$OpenURL = ini_get('allow_url_fopen');
	$sql3ver = SQLite3::version();
?>
	<div id="divConfig3" class="helper"><fieldset><legend>Server-Informationen</legend>
	<p>Hier können Sie:</p><ul>
	<li>(nur wenn im Webserver freigegeben:) die <a href="core/phpinfo.php" target="_blank">PHP-Konfiguration auf Ihrem Webserver abfragen und anzeigen</a></li>
	<li>Webserver: <?= $_SERVER['SERVER_SOFTWARE'] . ' / PHP-Version: ' . phpversion() . ' (per Gateway ' . $_SERVER['GATEWAY_INTERFACE'] ?>)</li>
	<li>die SQLite-Versionen erfahren: SQLite3: <?= $sql3ver['versionString'] . ' (' . $sql3ver['versionNumber'] ?> )</li>
	<li>die Zeitzone des Servers erfahren: <?= ini_get('date.timezone') ?></li>
	<li>die unterstützten Grafikbearbeitungen und Formate erfahren:<ul>
<?php
	$imagick_ext_installed = extension_loaded('imagick');
	$imagick_class_installed = class_exists('Imagick');
	if ($imagick_ext_installed or $imagick_class_installed) {
		$v = Imagick::getVersion();
		preg_match('/ImageMagick ([0-9]+\.[0-9]+\.[0-9]+)/', $v['versionString'], $v);
		echo '<li class="folder0 cursor" onclick="explore(this,\'IMinfo\')">Imagick ist installiert, Version: '.$v[1].", unterstützte Formate:<ul class=\"helper\" id=\"IMinfo\">\n"; $c = '0';
		$iminfo = Imagick::queryFormats();
		foreach ($iminfo as $type) {
			$a = $type[0]; if ($a!=$c) {
				$i=0; $c=$a;
			}
			$imformat[$c][$i++] = $type;
		}
		foreach ($imformat as $type) {
			$types = implode(', ',$type);
			echo "<li>$types</li>\n";
		}
		echo "</ul></li>\n";
	} else {
		echo '<li>Imagick ist nicht installiert'."</li>\n";
	}
	$gdinfo = gd_info(); $gdversion = $gdinfo['GD Version'];
	echo '<li class="folder0 cursor" onclick="explore(this,'."'GDinfo')\">GD: $gdversion, unterstützte Formate:<ul class=\"helper\" id=\"GDinfo\">\n";
	foreach ($gdinfo as $type=>$true) {
		if (is_bool($true))
			echo "<li>$type".':<input type="checkbox"'. ($true ? ' checked' : '') . "></li>\n";
	}
	echo "</ul>\n";
/*	echo 'IMG_GIF: '.IMG_GIF.' | IMG_JPG: '.IMG_JPG.' | IMG_PNG: '.IMG_PNG.' | IMG_WBMP: '.IMG_WBMP.' | IMG_XPM: '.IMG_XPM.' | IMG_WEBP: '.IMG_WEBP.' | IMG_BMP: '.IMG_BMP;
	echo ' | IMG_WEBP_LOSSLESS: '.IMG_WEBP_LOSSLESS;
	echo ' | IMG_AVIF: '.IMG_AVIF."<br>\n";	*/
?></li></ul></li>
	<li>Statistische Daten zu Ihrer WIBcms-Installation erfahren (zeigt auch NICHT verwendete Seiten und Medien):<ul>
<?php	
	// was ist in der DB an Sprachen verfügbar?
	$MySetLangs = $db->query('SELECT DISTINCT Lang FROM Pages');
	$Z = 0;
	while($rs = $MySetLangs->fetchArray()) {
		$AvaLangIds[] = $rs[0];
		$AvaLang[] = $WIBcmsLang[$MyLanguages[$rs[0]]];
		$Z++;
	}
	echo "<li>Verwendete Sprachen: $Z (" . implode(', ',$AvaLang) . ")<ul>\n";
	// wieviele Seiten und welche Seitenmodule?
	foreach ($AvaLangIds as $i) {
		$c = $db->querySingle("SELECT COUNT(ID) FROM Pages WHERE Lang=$i");	//	 AND Stat..."
		$PageLang = $WIBcmsLang[$MyLanguages[$i]];
		echo '<li class="folder0 cursor" onclick="explore(this,'."'LangPage$i')\">$PageLang: $c Seiten<ul class=\"helper\" id=\"LangPage$i\">\n";
		$t = $db->query("SELECT DISTINCT Type FROM Pages WHERE Lang=$i");
		while($rs = $t->fetchArray()) {
			$ct = $db->querySingle("SELECT COUNT(ID) FROM Pages WHERE Lang=$i AND Type='$rs[0]'");
			echo "<li>$rs[0]: $ct Seiten</li>\n";
		}
		echo "</ul></li>\n";
	}
	// Mediendateien:
	echo "</ul></li></ul></li>\n<ul><li>Verwendete Mediendateien<ul><li>";
	ScanMedia('../media');
	echo "</ul></li>\n<li>";
	ScanMedia('../Alben');
	echo "</ul></li>\n<li>";
	ScanMedia('../downloads',0);
	echo "</ul></li>\n<li>";
	ScanMedia('../favicons',0);
	echo "</ul></li>\n<li>";
	ScanMedia('../fonts');
	echo "</ul></li></ul></li></ul></fieldset>\n</div>";

// ----------------------- divConfig4: -----------------------
?>
	<div id="divConfig4" class="helper"><fieldset><legend>Copyright-Hinweise (Disclaimer, Legal Notes)</legend>
	<p>Das WIBcms ist in mehreren Lizenzvarianten erhältlich:</p>
	<ul>
	<li>GNU Public License (<a href="https://www.gnu.org/licenses/gpl-3.0.de.html" target="_blank">GNU GPLv3</a>):<br>Nimm es so wie es ist - als kostenlose Open-Source-Freeware-Lösung.<br>Ohne Gewähr(leistung) und ohne individuellen Support, außer den sowieso integrierten Hilfestellungen, Updates und Bugfixes...</li>
	<li>Commercial License:<br>Volle Unterstützung in allen inhaltlichen und technischen Fragen!!!</li>
	</ul>
	<p>Das WIBcms verwendet folgende freie Software:</p>
	<ul>
	<li>TinyMCE (Online-Texteditor, nur im internen Pflegebereich): <a href="http://www.tinymce.com/" target="_blank">www.tinymce.com</a></li>
	<li>CodeMirror (Texteditor mit Syntax-Highlighting, nur im internen Pflegebereich): <a href="https://codemirror.net/" target="_blank">codemirror.net</a></li>
	<li>PHPMailer (auf <a href="https://github.com/PHPMailer/PHPMailer" target="_blank">Github</a>)</li>
	<li>Slimbox 2 <a href="https://www.digitalia.be/software/slimbox2/" target="_blank">(Lightbox-Bildbetrachter)</a> mit <a href="https://jquery.com/" target="_blank">jQuery</a><ul>
	<li>alternativ dazu die <a href="https://github.com/blueimp/Gallery" target="_blank">blueimp Gallery</a> mit <a href="https://github.com/thebird/swipe/" target="_blank">Swipe</a></li>
	<li>oder die <a href="https://yaireo.github.io/photobox/" target="_blank">Photobox</a> (auf <a href="https://github.com/yairEO/photobox" target="_blank">Github</a>)</li></ul></li>
	<li>sowie optional in Modulen und Plugins:<ul>
		<li>PhpSpreadsheet (auf <a href="https://github.com/PHPOffice/PhpSpreadsheet" target="_blank">Github</a>)</li></ul></li>
	<li>und ist außerdem inspiriert von:<ul>
		<li><a href="https://www.cmsimple-xh.org/de/" target="_blank">CMSimple_XH</a> und <a href="https://www.ge-webdesign.de/cmsimpleplugins/?Eigene_Plugins___FotoGalerie" target="_blank">KissGallery (Plugin für CMSimple by Claus Højberg / modded by ge-webdesign)</a></li></ul></li>
	</ul></fieldset>
	</div>
	<div id="divConfig0" class="helper"><fieldset><legend>Versions-Hinweise</legend>
<?php
// ----------------------- divConfig0: -----------------------

	// Eigene Version(en) feststellen:
	$wibCMSVersion = getWIBcmsVersion();

	// Aktuelle Versionen auf WIBcms-Server abfragen:
	$CurrentVersion = 'unbekannt';
	if ($OpenURL) {
		$Versions = readVersions('https://wibcms.de/_Updates/CurrentVersions.inf');
		$Available=array();
		if (!empty($Versions)) {
			$CurrentVersion = $Versions[0];
			foreach ($Versions as $Version) {
				if ((float)$Version > (float)$wibCMSVersion) {
					$Available[] = $Version;
				}
			}
		}
	}
	if ($gid!='0') {
		echo "<p>Bei Fehlern bitte Seite im Browser neu laden!</p>\n";
		$txt = isset($PRB) ? 'ROLLBACK' : 'UPDATE';
		echo "<p class=\"success\">$txt FROM VERSION $gid TO VERSION $wibCMSVersion DONE!<br></p>\n";
	}
?>
	<fieldset><legend>WIBcms-Versionen</legend><p>Hier können Sie:</p><ul>
	<li>Ihre WIBcms-Installation auf mögliche Updates prüfen:<ul>
	<li>Installierte Version: <?= $wibCMSVersion ?></li>
	<li>Aktuell ist Version: <?= $CurrentVersion ?> [ <a href="https://wibcms.de/_Updates/checkversion.php?ver=<?= $wibCMSVersion ?>" target="_blank">Versionshinweise</a> ]</li>
<?php
	$txt = '<input type="hidden" id="OnlineUpdate" name="OnlineUpdate" value="0">';
	if ($CurrentVersion == 'unbekannt') {
		echo "		$txt<li>Die aktuelle Version lässt sich zur Zeit nicht feststellen. Bitte versuchen Sie es später noch einmal.</li>\n";
	} elseif ($wibCMSVersion==$CurrentVersion) {
		echo "		$txt<li>Ihre Version ist aktuell, Sie haben nichts zu tun!</li>\n";
	} else {
		echo '		<li>';
		if (count($Available)>1 && $UpdateKanal) {
			startSelect('OnlineUpdate','WIBcms-Version');
			echo txtOption(0,'bitte auswählen');
			foreach ($Available as $Version) {
				echo txtOption($Version,$Version);
			}
			echo '</select>';
		} else {
			echo '<input type="checkbox" id="OnlineUpdate" name="OnlineUpdate" value="'.$CurrentVersion.'">';
		}
		echo " Online-Update durchführen (hier auswählen und unten auf &quot;Update&quot; klicken)</li>\n";
	}
	echo '</ul></li>';
	$txt = '<input type="hidden" id="Nightly" name="Nightly" value="0">';
	if ($UpdateKanal==1) {
		$NightlyBuild = 0;
		if ($VersionFile = @fopen('https://wibcms.de/_Updates/NightlyBuild.inf', 'r')) {
			$NightlyBuild = trim(fgets($VersionFile));
			fclose($VersionFile);
		}
		$VersionFile = fopen('NightlyBuild.inf', 'r');
		$NightlyVersion = trim(fgets($VersionFile));
		fclose($VersionFile);
		echo "	<li>Nightly Builds testen:<ul><li>zuletzt installiert: $NightlyVersion / verfügbar: ". ($NightlyBuild>0 ? $NightlyBuild : 'unbekannt')."</li>\n<li>";
		if ($NightlyBuild != $NightlyVersion && floatval($NightlyBuild) >= floatval($wibCMSVersion)) {
			echo '<input type="checkbox" id="Nightly" name="Nightly" value="'.$NightlyBuild.'"> Nightly Build probieren (hier ankreuzen und unten auf &quot;Update&quot; klicken)';
		} else {
			echo "Kein neuer Nightly Build vorhanden $txt";
		}
		echo "</li></ul></li>\n";
	} else {
		echo $txt;
	}
//	PreBackUp
	echo "<li>Sie können vor dem Update auch ein Backup anlegen:<br>\n";
	echo setSelcheck('PreBackUp','</li>','BackUp',1);

	echo "</ul>\n";
//	if ($WebStat&1)
//		echo '<input type="button" id="check" onclick="checkperms()" value="Permissions">';
	echo "</fieldset></div>\n";

// ----------------------- divConfig1: -----------------------
?>
	<div id="divConfig1" class="helper"><fieldset><legend>Module nachladen oder aktualisieren</legend>
	<table><tr><th>Modul</th><th>Version installiert</th><th>Version aktuell</th><th>Laden</th><th>Entfernen</th></tr>
<?php
	if ($OpenURL) {
		$Versions = file('https://wibcms.de/_Updates/ModuleVersions.inf');
		foreach($Versions as $modul) {
			$part = explode(':',$modul);
			$veri = "../".$part[1]."/Version.inf";
			$WIBcmsVer = trim($part[2]);
			$MyVersion = is_file($veri) ? trim(file_get_contents($veri)) : 'n.a.';
			if ($MyVersion != 'n.a.' || $WIBcmsVer !='n.a.') {
				if ($MyVersion != $WIBcmsVer && $WIBcmsVer != 'n.a.') {
					$txt = '<input type="checkbox" name="'.$part[0].'">';
				} else {
					$txt = 'OK';
				}
				if (!in_array($part[0],['tinymce','codemirror']) && $MyVersion != 'n.a.') {
					$del = '<input type="checkbox" name="delmod['.$part[0].']" value="'.$part[1].'">';
				} else {
					$del = '';
				}
				echo '<tr><td>'.$part[0]."</td><td>$MyVersion</td><td>$WIBcmsVer</td><td>$txt</td><td>$del</td></tr>\n";
			}
		}
	} else {
		echo '<tr><td colspan="5">Ihr Provider erlaubt leider keine Fernabfrage von Daten.</td></tr>';
	}
	echo "</table></fieldset></div>\n";

// ----------------------- divConfig2: -----------------------

	echo '<div id="divConfig2" class="helper">';
	if (!$UsePlugins) {
		echo "<fieldset><legend>Plugin-Verwaltung</legend>Zurzeit ist die Verwendung von Plugins nicht freigegeben.</p>\n";
	} else {
	  if ($OpenURL) {
	  // Get list of all available plugins and their versions:
		$AvailablePlugs = [];
		$PluginVersions = [];
		$Versions = file('https://wibcms.de/_Updates/PluginVersions.inf');
		if ($Versions !== false) {
			foreach($Versions as $modul) {
				$part = explode(':',$modul);
				$AvailablePlugs[] = $part[0];
				$PluginVersions[$part[0]] = trim($part[1]);
			}
		}
		// -------------------
		echo '<fieldset><ul><li class="folder0" style="border-bottom:1px solid black"><label>Plugin</label><label class="big">Update / Installieren</label>
		Entfernen (Skripte UND Daten)</li></ul><small>Ein Klick auf den Plugin-Namen öffnet eine Beschreibung zu diesem Plugin.<br>
		Beim Löschen eines Plugins kann ein vorhandenes Daten-Backup die Daten wiederherstellen, das Plugin selbst muss jedoch erneut installiert werden.</small></fieldset>';
		echo "\n<fieldset><legend>Installierte Plugins</legend>\n";
		$MyPlugs = getAlbum($MyPlugins);
		if (count($MyPlugs)==0) {
			echo "<p>Zurzeit sind keine Plugins in dieser Installation vorhanden.</p>\n";
		} else {
			echo '<ul>';
			foreach ($MyPlugs as $plug) {
				$MyPlugin = "$MyPlugins/$plug/";
				$veri = "$MyPlugins/$plug/Version.inf";
				$PlugVersion = is_file($veri) ? trim(file_get_contents($veri)) : 'n.a.';
				if (isset($PluginVersions[$plug]) && ($PlugVersion != $PluginVersions[$plug])) {
					$txt = '<input type="checkbox" name="'.$plug.'"> Update von Version '.$PlugVersion.' auf '.$PluginVersions[$plug];
				} else {
					$txt = '<input type="checkbox" style="visibility:hidden"> ';
					if (isset($PluginVersions[$plug])) {
						$txt .= 'Version '.$PlugVersion.' ist aktuell';
					} else {
						$txt .= 'Plugin wird offiziell nicht unterstützt';
					}
				}
				$sql = "SELECT COUNT(ID) FROM Pages WHERE Type='Plugin-$plug'";
				$res = $db->querySingle($sql);
				
				echo '<li class="folder0"><label style="cursor:help" onclick="explore(this,\'Plugin_'.$plug.'\')">'.$plug.'</label><label class="big">'.$txt.
					'</label><input type="checkbox" name="delplug[]" value="'.$plug.'">';
				if ($res) {
					echo "OBACHT: $res ".($res==1 ? 'Seite nutzt':'Seiten nutzen')." dieses Plugin!";
				} else {
					echo '<small> - kann gefahrlos gelöscht werden</small>';
				}
				echo '<br><div class="helper" id="Plugin_'.$plug.'">';
				if (file_exists($MyPlugin.'info.php')) {
					include ($MyPlugin.'info.php');
				} else {
					echo "<p>Leider keine weiteren Informationen vorhanden.</p>\n";
				}
				echo "<br></div></li>\n";
			}
			echo '</ul>';
		}
		echo "</fieldset><fieldset><legend>Weitere erhältliche Plugins</legend>\n";
		$DiffPlugs = array_diff($AvailablePlugs,$MyPlugs);
		if (count($DiffPlugs)==0) {
			echo "<p>Zurzeit sind keine weiteren (offiziell unterstützte) Plugins erhältlich.</p>\n";
		} else {
			echo '<ul>';
			foreach($DiffPlugs as $plug) {
				$txt = '<input type="checkbox" name="'.$plug.'"> Version '.$PluginVersions[$plug].' installieren';
				echo '<li class="folder0"><label onclick="explore(this,\'Plugin_'.$plug.'\')">'.$plug.'</label>'.$txt.'<br><div class="helper" id="Plugin_'.$plug.'">';
				$strInfo = @file_get_contents("https://wibcms.de/plugins/$plug/info.php");
				if ($strInfo!==false) {
					echo $strInfo;
				} else {
					echo "<p>Leider keine weiteren Informationen vorhanden.</p>\n";
				}
				echo "<br></div></li>\n";
			}
			echo '</ul>';
		}
	  }
	}
	echo "</fieldset></div>\n";
	echo formbuttons('Update','wibcms',$wibCMSVersion,1,1);
	break;
// ------------------------------------------------------------------------------------------------
case 'feedback':	//                                Feedback
// ------------------------------------------------------------------------------------------------
	formkopf('Hier können Sie dem WIBcms-Service-Team Rückmeldungen geben, Fragen stellen oder Verbesserungen anregen','Ihre Rückmeldung');
	if ($UpdateKanal && ($VersionFile = fopen('NightlyBuild.inf', 'r'))) {
		$NightlyVersion = '(NightlyBuild: '.trim(fgets($VersionFile)).')';
		fclose($VersionFile);
	} else {
		$NightlyVersion = '';
	}
	echo "<label>An</label>service@wibcms.de<br>\n";
	echo '<label for="Opener">Vorspann</label><textarea name="Opener" id="Opener">Hallo,'."\n\nich möchte eine Rückmeldung zum WIBcms abgeben.
Installierte Version: ".getWIBcmsVersion()." $NightlyVersion\nInstallation auf: $Server</textarea><br>\n";
	echo '<label for="Texter">Kommentar</label><textarea name="Texter" id="Texter">Problem:'."\n\nVorschlag, Anregung:\n\nFrage:\n\n</textarea><br>\n";
	echo '<label for="Closer">Abspann</label><textarea name="Closer" id="Closer">Mit freundlichen Grüßen,'."\n\n$User (".$_SESSION['UserMail'].")</textarea><br>\n";
	echo '<label for="Self"></label><input type="checkbox" name="Self" id="Self">Ich möchte selbst auch eine Kopie bekommen<br>';
	echo "</fieldset>\n" . formclose('feedback');
	break;
// ------------------------------------------------------------------------------------------------
case 'Plugin': 	//                            Plugins
// ------------------------------------------------------------------------------------------------
	$url = "$MyPlugins/$gid/edit.php";
	include $url;
	break;
// ------------------------------------------------------------------------------------------------
default: 	//                                Hilfetexte für die Pflege
// ------------------------------------------------------------------------------------------------
	formkopf('Generelle Hilfestellung zum WIBcms','Das Verwaltungsmenü (in der Regel links oben) ist fünfgeteilt:');	?>
	<p>Im oberen Bereich finden Sie die Möglichkeiten zur inhaltlichen Pflege der Homepage:<br>Was direkt auf die Seite Einfluss hat, die gerade im Browser angezeigt wird, finden Sie auf alle Fälle hier.<br>Sie können unter "Editor-Konfiguration" (im untersten der 4 Bereiche) jedoch einstellen,<br>welche Pflegemöglichkeiten hier IMMER angezeigt werden und welche NUR auf der gerade angezeigten Seite.<br>Beispiel:</p><ul>
	<li>Nur wenn Sie z.B. auf einer Seite "Veranstaltungen" sind, lässt sich auch der Kalender bearbeiten.</li>
	<li>Nur wenn Sie auf einer Seite sind, die eine Infobox hat, lässt sich die Infobox bearbeiten.</li>
	<li>Nur wenn Sie auf der Bildergalerie sind, lassen sich die Alben pflegen.</li></ul>
	<hr size="1"><p>Im zweiten Bereich finden Sie weitere Möglichkeiten zur Pflege und Verwaltung Ihrer Homepage:</p><ul>
	<li>Sie können die Seitenstruktur Ihrer Homepage ändern sowie Seitentitel etc. zu den einzelnen Seiten bestimmen.</li>
	<li>Materialsammlung: Sie können Bilder, PDF-Dokumente und weitere Materialien bereitstellen, die Sie dann auf der Homepage verwenden und auf den Seiten einbinden können.</li>
	<li>Falls konfiguriert, können Sie hier auch die Bilder und Grafiken für den Seiten-Hintergrund und Image-Bildleisten verwalten.</li></ul>
	<hr size="1"><p>Im dritten Bereich finden Sie erweiterte Einstellungen zur Konfiguration und Verwaltung Ihrer Homepage.<p><ul>
	<li>Dies sind Voreinstellungen, die der Webdesigner und/oder Homepage-Programmierer für Ihre Webseite festgelegt haben und die das Aussehen wesentlich beeinflussen. In der Regel sollten Sie hier nichts ändern.</li>
	<li>Unter "Editor-Konfiguration" finden Sie<ul>
	<li>Einstellungen, die global für alle Seiten Ihrer Homepage gelten sollen sowie</li>
	<li>Auswahlmöglichkeiten zur Bedienung des Pflegebereichs, die Ihnen die Arbeit erleichtern können oder die Sie abwählen können.</li></ul></li></ul>
	<hr size="1"><p>Im zweitletzten Bereich finden Sie Einstellungen zur Pflege und Kontrolle Ihrer Homepage.<p><ul>
	<li>Falls konfiguriert, können Sie hier gesicherte BackUp-Versionen Ihrer Homepage wiederherstellen sowie in die Logdatei schauen.</li>
	<li>Wenn Sie Lust haben, können Sie die Seiten auch testen (Validierung), ob sie die aktuellen Webseiten-Standards erfüllen...</li></ul>
	<hr size="1"><p>Im untersten Bereich können Sie Ihre Zugangsdaten (also Anmeldename, E-Mail-Adresse und Passwort)<br>sowie Ihre Newsletter-Abonnements und weitere Einstellungen ändern.</p>
	<p>Mit dem <b>Mini-Menü</b> können Sie das Pflegemenü auf eine kleine Box verkleinern, so dass es nicht über dem Inhalt der Homepage evtl. Inhalte verdeckt.<br>Das Mini-Menü können Sie dann mit einem Klick auf das Kreuz <img src="core/grafix/delete.gif"> wieder auf das normale Pflegemenü vergrößern.</p>
	<p>Darunter finden Sie einen Link zur Online-Hilfestellung und den Link zum Abmelden, also Verlassen des Pflegebereichs.</p></fieldset>
<?php
	echo formclose('helpglobal');
  }

// ##################### UND HIER JETZT DIE ONLINE-HILFE: ###############################
	require 'edit_help.php';
// ENDE DER ONLINE-HILFE
} else {
	echo "<h2>Sie haben hier keine Zugangsberechtigung!</h2>\n";
}
?>