<?php
// wibcmsconstants.php:

// Server feststellen (Installation kann auch in Unterverzeichnissen sein):
$i = strpos($_SERVER['SCRIPT_NAME'],'/core');
$Server = ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS']!='off') ? 'https':'http').'://'.$_SERVER['SERVER_NAME'];
if ($i)
	$Server .= substr($_SERVER['SCRIPT_NAME'],0,$i);

// Konfiguration/Log in Dateien:
$MyData    = $WIBcmsFilePrefix.'data/';
$MyCustomer= $MyData.'custom.conf';
$MyFeatures= $MyData.'features.conf';
$MyLayouts = $MyData.'layout.conf';
$MyConfigs = $MyData.'config.php';
$MyLogFile = $MyData.'log';

// Diese Content-Dateien werden zukünftig nach und nach durch die Datenbank ersetzt:
$MyAlben   = $MyData.'album.csv';	// wohl nur auf wibcms.de noch existent... und auf buecherei

// für WIBcms-Updates:
$MyCore    = $WIBcmsFilePrefix.'core/';
$CVFile    = $MyCore.'CurrentVersion.inf';
$PostInstall=$MyCore.'postinstall.php';
$DoInstall = $MyCore.'DoPostInstall';
$DoPlugPost= $MyCore.'DoPlugPostInstall';

// SQLite3
$MyDatabase= $MyData.'WIBcms.db';	$db = new SQLite3($MyDatabase);
$MyDBTables= ['Pages','Roles','Abos','Users','Infos','Buttons','Events','Alben','Gallery','Galerie','Foren','Forum','Downloads','Wishes','Versions','Forms','FormSave','Rights','Comments'];

// Common Use
$WIBcmsRole= [0=>'gesperrt',1=>'Admin',2=>'Designer',3=>'Developer',4=>'Editor',8=>'Benutzer',12=>'Moderator',16=>'Gast'];
$strApproval=[0=>'neu ohne Inhalt/Freigabe',1=>'aktuell und freigegeben',2=>'in Überarbeitung',3=>'in Arbeit zur Freigabe',4=>'zurückgewiesen',8=>'verworfen',9=>'archiviert'];
$SpecialPage=['login','api'];
$excludeit = ['.','..','@eaDir','#recycle','Thumbs.db','.DS_Store','desktop.ini'];

// Multilang
$WIBcmsLang= ['de'=>'deutsch','en'=>'englisch','fr'=>'französisch','es'=>'spanisch','it'=>'italienisch','nl'=>'holländisch','pt'=>'portugiesisch'];
$LangPrefix= ['de','en','fr','es','it','nl','pt'];
$MissingText=['<h2>Wir bitten um Entschuldigung!</h2><p>Für diese Seite wurde noch kein Inhalt hinterlegt. Wir arbeiten daran...</p>',
			  '<h2>We apologize!</h2><p>There is no content for this page yet. We are working on it...</p>',
			  '<h2>Nous nous excusons !</h2><p>Il n\'y a pas encore de contenu pour cette page. Nous y travaillons...</p>',
			  '<h2>Nos disculpamos.</h2><p>No hay contenido para esta página todavía. Estamos trabajando en ello...</p>',
			  '<h2>Ci scusiamo!</h2><p>Non ci sono ancora contenuti per questa pagina. Ci stiamo lavorando...</p>',
			  '<h2>We verontschuldigen ons!</h2><p>Er is nog geen inhoud voor deze pagina. We werken eraan...</p>',
			  '<h2>Pedimos desculpa!</h2><p>Ainda não há nenhum conteúdo para esta página. Estamos a trabalhar nisso...</p>'];
$strSearch = ['Suchen','Search','Recherchez','Buscar','Cercare','Zoek','Buscar'];
$strNotFound=['leider nicht gefunden.','unfortunately not found.','malheureusement pas trouvé.','desafortunadamente no se encuentra.','purtroppo non trovato.','helaas niet gevonden.','infelizmente não encontrado.'];
$strFound  = ['gefunden in','found in','trouvé dans','encuentra en','trovata in','gevonden in','encontrada em'];
$splitPage = ['Seite ','Page ','Page ','Página ','Pagina ','Pagina ','Página '];
$strWebView =['Web-Ansicht','webview','Aperçu web','Vista Web','Visualizzazione web','Webweergave','Vista Web'];
$Unsubscribe=['Abmeldelink','unsubscribe','Lien de désinscription','Anular suscripcíon','Link di cancellazione','uitschrijven','Anular subscrição'];

// Konfigurierbar im Layout, used zur Anzeige oder in wibcmsedit.php bzw. wibcmssave.php:
$MyHomepage= $MyData.'homepage.php';// used zur Anzeige oder in wibcmssave.php
$MyCSSheet = $MyData.'style.css';	// used zur Anzeige oder in wibcmssave.php
$MyAdminCSS= $MyData.'admin.css';	// used zur Anzeige oder in wibcmssave.php
$MyBasicCSS= $MyData.'basic.css';	// used zur Anzeige oder in wibcmssave.php
$MyHeader  = $MyData.'header.php';	// Inhalt für den Header-Bereich
$MyFooter  = $MyData.'footer.php';	// Inhalt für den Footer-Bereich
$MySlimCSS = $MyData.'slimbox.css';	// eigenes Slimbox-Stylesheet (optional)
$MyPhotoCSS= $MyData.'photobox.css';// eigenes Photobox-Stylesheet (optional)

// Default-Folder:
$AlbenFolder= $WIBcmsFilePrefix.'Alben/';	// herkömmliche Fotoalben (kein Kiss)
$AlbenThumbs=  $AlbenFolder.'_Thumbs/';
$AlbenCovers=  $AlbenFolder.'_Covers/';
$AlbenOrigin=  $AlbenFolder.'_Originals/';

$MyMedia	= $WIBcmsFilePrefix.'media/';
$KissFolder =  $MyMedia.'KissGallery/';
$KissThumbs =	$KissFolder.'Thumbs/';
$KissOrigin =	$KissFolder.'Originals/';
$NaviIcons  =  $MyMedia.'Icons/';
$CalImages  =  $MyMedia.'Kalender/';
$AttImages  =  $MyMedia.'Attachments/';
$AttThumbs  =	$AttImages.'Thumbs/';
$AttOrigin  =	$AttImages.'Originals/';
$MyBackUps  = $WIBcmsFilePrefix.'BackUp/';
$DownFolder = $WIBcmsFilePrefix.'downloads/';
$MyFavicon  = $WIBcmsFilePrefix.'favicon.ico';	// used nur zur Anzeige
$MyFavicons = $WIBcmsFilePrefix.'favicons/';
$MyFonts	= $WIBcmsFilePrefix.'fonts';
$MyPlugins	= $WIBcmsFilePrefix.'plugins';
$MyModules	= $WIBcmsFilePrefix.'modules';

$IncFolder  = $MyData.'includes/';
$MyThemes   = $MyData.'themes';
$MyPlugData = $MyData.'plugins';

// Default-Dateien, -Werte, -Texte und -Verweise:
$EnableNotifications= false;
$ShowPrintAlways  = 0;

// einmalig:
$ShowLinkOnly = 1;	// Links auf Drucken und Home anzeigen? wegen Sitemap (nein) / Navigation (ja)
$maxbilder = 0;		// Startwert für Diashow

// Homepage-spezifische Vorgaben holen:
require $MyCustomer;	// Materialordner, DefaultSidebar, kundenspezifische Texte
require $MyFeatures;	// Admin-Konfiguration
require $MyLayouts;		// Layout-Konfiguration
require $MyConfigs;		// Editor-Konfiguration mit meta, Mail und Anzeigeoptionen

// aus Kompatibilitätsgründen als Array UND Einzelvariablen:
$i = ($classSParent=='') ? '':' class="'.$classSParent.'"'; $divSParent = "<div$i>"; $divSpalte[0] = $divSParent;
$i = ($classSpalte1=='') ? '':' class="'.$classSpalte1.'"'; $divSpalte1 = "<div$i>"; $divSpalte[1] = $divSpalte1;
$i = ($classSpalte2=='') ? '':' class="'.$classSpalte2.'"'; $divSpalte2 = "<div$i>"; $divSpalte[2] = $divSpalte2;
$i = ($classSpalte3=='') ? '':' class="'.$classSpalte3.'"'; $divSpalte3 = "<div$i>"; $divSpalte[3] = $divSpalte3;
$i = ($classSpalte4=='') ? '':' class="'.$classSpalte4.'"'; $divSpalte4 = "<div$i>"; $divSpalte[4] = $divSpalte4;

// Initialwerte für alle Seiten, unabhängig von der Konfiguration:
$WebStat = 0;
$HasGallery = false;	// Lightbox-/Gallery-Einbindung nötig?
$HasDate = false;		// Formular-Datumsfeld vorhanden und setzen?
$HasEditor  = false;	// Script für TinyMCE-Editor auf Seite bereits geladen?
$HasPrint = false;		// Button für Druckansicht vorhanden
$reloadStyles = '';		// nach Designwechsel css neu laden?
$FirstUse = true;		// Erster Aufruf der Seite? (Für Cookie-Hinweise)
$UseCalModus = false;	// Experimental
$Verbosity = 0;			// Feedback-Meldungen an Benutzer
$ups = ''; $e = '';		// Sammlung der Fehler- und Debug-Meldungen
$NightlyDiv = 100;		// Trennung zwischen regulären Versionen und NightlyBuilds, 100=1.23xxx
$MapInsert = 0;			// Zusätzliche Elemente innerhalb einer Navi-Map?
$strMapInsert = '';		// Das zusätzliche Element
?>