<?php
// STEP 1.1 ("Konstante" Vorgaben für das WIBcms und Basis-Konfigurationen holen):
	$WIBcmsFilePrefix='';
	require 'core/wibcmsconstants.php';

// STEP 1.2 (Funktionen):
	require 'core/wibcmsfunctions.php';

// STEP 2 (Feststellen, welche Seite jetzt angezeigt werden soll: Extraktion aus Querystring ohne weitere Prüfung):
	$query = explode('&', $_SERVER['QUERY_STRING']);
	$mylang = 0;			// Defaultsprache (Index=0) in der Datenbank
	$myptyp = '';	// PageType
	$myppar = '';	// PageParameter
	$error404 = false;
	if (empty($query[0]) || strpos($query[0],'=')!==false) {
		$isDefault = 1;			// Aufruf ohne benannte Seite!
		$mypage = $MyStartPage; // Defaultseite für DB-Sprache 0
	} else {
		$isDefault = 0;			// Aufruf mit benannter Seite
		$mypage = $query[0];	// "Seiten-URL" wie vom Browser angefordert, aber gibt es diese?
		$trylang = $db->querySingle("SELECT ID,Lang,Type,Parameter FROM Pages WHERE RefID=0 AND URL='$mypage'",1);
		if (!empty($trylang)) {					// Ja, $mypage gibt es als URL!
			$mylang = $trylang['Lang'];			// und zwar in dieser Sprache
			$myptyp = $trylang['Type'];			// und von diesem Typ
			$myppar = $trylang['Parameter'];	// und mit diesem Parameter
			$isDefault = ($mypage == $MyStartPage);	// gilt hier nur für Defaultsprache, andere s. u.
		} elseif (in_array(strtolower($mypage),$SpecialPage)) {
			// OK, das ist z.B. 'Login','API' in der Default-Sprache-> behandeln wir später...
		} elseif ($MultiLang) {	// mehrsprachig?
		//	Dann könnte ein URL mit Sprachpräfix bzw. mit delimiter OK sein:
			$strLang = substr($mypage,0,2);
			if (in_array($strLang,$MyLanguages)) {	// Prefix ('de' etc.) ist gültig!
				$mypage = substr($mypage,3);// der Rest nach 'de:', delimiter-Zeichen egal, aber genau 1 Zeichen
				$mylang = array_search($strLang,$MyLanguages);
				if (empty($mypage)) {
					$isDefault = 1;		// Aufruf ohne benannte Seite!
				} elseif (in_array(strtolower($mypage),$SpecialPage)) {
					// OK, das ist z.B. 'Login','API' mit Sprachpräfix -> behandeln wir später...
				} else {
					$trylang = $db->querySingle("SELECT ID,Lang,Type,Parameter FROM Pages WHERE RefID=0 AND URL='$mypage'",1);	// versuchen wir es damit...
					if (!empty($trylang)) {			// Ja, $mypage gibt es als URL!
//						$mylang = $trylang['Lang'];	// und zwar in dieser Original-Sprache
//						$myptyp = $trylang['Type'];	// und von diesem Typ
//						$myppar = $trylang['Parameter'];	// und mit diesem Parameter
					} else {
						// is missing in pages table or no special page and no reference in default language
						// any other chance?
						$error404 = true;
					}
				}
			} else {
				$error404 = true;
			}
		} else {
			$error404 = true;
		}
	}
	if ($mylang) {
//		Startseite für diese Sprache ermitteln:
		$ID = $db->querySingle("SELECT ID FROM Pages WHERE RefID=0 AND URL='$MyStartPage'");
		$MyStartPage = $db->querySingle("SELECT URL FROM Pages WHERE RefID=0 AND Lang=$mylang AND Ist=$ID");
		if ($mypage == $MyStartPage) {
//			$isDefault = 1;	// s. u.
		} elseif ($isDefault) {
			$mypage = $MyStartPage;
			$isDefault = 0;	// weil canonical zurzeit nur in Standardsprache!
		}
	}
	$strLang= $MyLanguages[$mylang];	// 'de' etc.
	$WibLang= array_search($strLang,$LangPrefix);

//	URL Rewrite benutzen?
	$u = $URLRewrite ? '' : '?';
// #########################################################################################################################################

// if this is an API call we don't have to do the whole work:
if ($mypage=='API' && $UseAPI) {
	include 'wibcmsapi.php';
} else {
	$WantLogin = strtolower($mypage)=='login' || $myptyp=='Login';	// weil evtl. gar keine Login-Seite in der Navigation vorhanden ist/gefunden wird
//	######### ggf. weitere Parameter feststellen:
	$ToDo = $_POST['ToDo'] ?? $_GET['ToDo'] ?? '';
/*	if ($myptyp=='Login' && $myppar=='1') {
		$ToDo = 'edit';
	}	*/
	$DruckAnsicht = $_GET['print'] ?? 0;		// Ansicht für Druckvorschau?
	$onload = '';

// STEP 3 (Webstatus lesen, Loginprüfung, Cookies setzen)
	// Wir haben dann: $WebStat, $Cookie-Anzeige-Variablen, die Session an sich (falls angemeldet) inkl. $May[]
	require 'core/wibcmsstatus.php';

	$showEditSymbols = $WebStat && $editsymbols && !$error404;	// && MayEdit... ?

//	Debug-Meldungen könnten nützlich ein - aber nur für Admins/Developer/FTP-User:
	$Debug = intval($May['Debug'] || is_file('data/_WIBcmsDebug'));
	if ($Debug>0) {
		if (isset($_SESSION['Debug'])) {
			$Debug = $_SESSION['Debug'];}
		error_reporting(E_ALL);
		ini_set('display_errors', TRUE);
		ini_set('display_startup_errors', TRUE);
		$Verbosity = 1;
	}

// ---------- STEP 4.1: Die Seite vorbereiten: ----------
//	inkl. benötigter JavaScripts, dem <head>-Bereich und den <body><div class="body"> - StartTags:
	require 'core/wibcmsprepare.php';

// ---------- STEP 4.2: Kommentare speichern? -----------
$CommEnable = $PageComment && ((in_array($AllowComments,[1,2,5,6]) && $WebStat) || in_array($AllowComments,[3,4,7,8]));
$CommSave   = $_POST['CommSave'] ?? '';
if ($CommEnable && $CommSave=='Kommentar abschicken') {
	$MyComm= text2br('CommText');	// inkl. POST + escapeString
	$Name  = empty($_POST['CommName']) ? 'Anonym' : $_POST['CommName'];
	$Name  = $db->escapeString($Name);
	$Mail  = $db->escapeString($_POST['CommMail']);
	$Reply = $_POST['CommReply'] ?? 0;
	$DSGVO = $_POST['CommDSGVO'] ?? 0;
	$Trap  = $_POST['Nickname'] ?? '';
	$Datum = time();
	$IP = $_SERVER['REMOTE_ADDR'];
	if ($DSGVO && empty($Trap) && !empty($MyComm)) {
		$Status = in_array($AllowComments,[2,4,6,8]) ? 1 : 0;
	//	$Status = 1;	// Zum Test ------------------------
		$OK = $db->exec("INSERT INTO Comments (Page,Reply,Mail,Name,Comment,Datum,Status,IP) VALUES ($mypagenum,$Reply,'$Mail','$Name','$MyComm',$Datum,$Status,'$IP')");
		if ($OK) {
			write_log("Kommentar auf Seite $mypagenum ($MyHeadLine) hinterlassen");
			$txt = "$Name hat einen Kommentar auf Seite $mypagenum ($MyHeadLine) hinterlassen:\n\n".br2text($MyComm);
			$Link = "$Server?$mypage&comm=$Datum&OK=";
			if ($Status) {
				$Link .= '2';
				$txt .= "\n\n- Der Beitrag ist bereits veröffentlicht.\n- Link zum Sperren:  $Link\n- Link zum Löschen:  $Link&del=1\n";
			} else {
				$Link .= '1';
				$txt .= "\n\n- Der Beitrag wird erst nach Freigabe veröffentlicht.\n- Link zur Freigabe: $Link\n- Link zum Löschen:  $Link&del=1\n";
			}
			$OK = SendMail($MailTo, "$SubjComm (Seite: $MyHeadLine)", $txt, 0);
		}
	} else {
		write_log("Trapped in Comments! (IP: $IP)");
	}
}
// ---------- STEP 4.3: Kommentare bearbeiten? -----------
$StatComm = $_GET['comm'] ?? 0;
if ($StatComm) {
	$Stat = $_GET['OK'] ?? 0;
	if ($Stat) {
		$Name = $db->querySingle("SELECT Name FROM Comments WHERE Datum=$StatComm");
		if (empty($Name)) {
			$Datum = date('d.m.Y, H:i',$StatComm);
			write_log("Kommentar vom $Datum zum Bearbeiten nicht gefunden");
		} else {
			$Del = $_GET['del'] ?? 0;
			if ($Del) {
				$sql = "DELETE FROM Comments WHERE Datum=$StatComm";
				$txt = "Kommentar von $Name löschen";
			} else {
				$Stat = 2-$Stat;
				$sql = "UPDATE Comments SET Status=$Stat WHERE Datum=$StatComm";
				$txt = "Kommentar von $Name ". ($Stat ? 'freigeben' : 'sperren');
			}
			$OK = $db->exec($sql);
			if ($OK) {
				write_log("$txt -> erfolgreich");
			} else {
				write_log("$txt -> NICHT erfolgreich");
			}
		}
	}
}

// ---------- STEP 5: Die Seite zusammenstellen: --------
/*
$NaviStyle
0: Die Navigation ist in einer horizontalen Leiste
1: Die Navigation ist links in einer vertikale Spalte
2: Die Navigation ist geteilt (horizontal und vertikal)
5: Die Navigation ist als Dropdown-Menü ausgeführt 4-1
9: Die Navigation ist in der header.php enthalten! 8-1
13:Dropdown-Menü ist in der header.php enthalten!  8-4-1

$SubMenu:
0: Nur Hauptnavigation ohne Unterpunkte
1: Hauptnavigation mit maximal 1 Unternavigation
2: Hauptnavigation mit maximal 2 Unternavigationen

$IncludeSubMenu:
0: Untermenü bekommt eine eigene Leiste
1: Untermenü ist im Hauptmenü integriert
-------------------------------------------------------
Hamburger ist bereits in wibcmsprepare erledigt!
Hier gibt es noch einiges zu tun!!!!
*/
//	Header und Navigation:
	$PageNaviOpened = false;
	$strSkipLink = $AddSkipLink ? '<a class="skip-link" href="#content">Weiter zum Inhalt / Skip to content'."</a>\n" : '';
	$strSkipTarget = '<a name="content"></a>';

	if ($NaviStyle&8) {
//	alles komplett aus der header.php:
		if ($Breadcrumb==1) {
			echo $strSkipLink . $MyBreadCrumb;
			$strSkipLink = '';
			$PageNaviOpened = true;
		} else {
			echo $strSkipLink;
			$strSkipLink = '';
			$PageNaviOpened = true;
		}
		require $MyHeader;
		if ($Breadcrumb==2)
			echo $MyBreadCrumb;
	} else {
		if ($HasHeader==1) {	// falls Header ÜBER der Navigation sein soll, fügen wir ihn HIER oben ein:
			if ($Breadcrumb == 1) {
				echo $strSkipLink . $MyBreadCrumb;
				$strSkipLink = '';
				$PageNaviOpened = true;
			}
			if (!$PageNaviOpened) { // ---------------------- nein, erst später vor der Navigation !
				echo $strSkipLink;
				$strSkipLink = '';
				$PageNaviOpened = true;
			}
			echo $headtag_open;
			include $MyHeader;
			echo $headtag_close;
			if ($Breadcrumb == 2)
				echo $MyBreadCrumb;
		}

		$forceNoUL = false;

		if (empty($NaviPlaceholder))
			$useNaviPlaceholder = false;

		if ($HasSecondNavi) {
			$NaviLevel0 = '<div class="HasSecondNavi">'.$DropDownMenu."</div>\n";
//			if ($Hamburger & 3)
//				$NaviLevel0 .= "</div><!-- end hamburger-wrapper -->\n";	// Problem bei BUF-UM !!!!!!!!!!!!!!!!
		} else {
			$NaviLevel0 = $forceNoUL ? $strNavi[0] : "<ul>\n".$uliNavi[0]."</ul>\n";
		}
		
		if (empty($strNavi[1])) {
			$NaviLevel1 = $useNaviPlaceholder ? $NaviPlaceholder : '';
		} else {
			$NaviLevel1 = $forceNoUL ? $SelectSubText.$strNavi[1] : "$SelectSubText <ul>\n".$uliNavi[1]." </ul>\n";
		}
		if (empty($strNavi[2])) {
			$NaviLevel2 = $useNaviPlaceholder ? $NaviPlaceholder : '';
		} else {
			$NaviLevel2 = $forceNoUL ? $SelectSubText.$strNavi[2] : "$SelectSubText <ul>\n".$uliNavi[2]." </ul>\n";
		}

//	Jetzt Ausgabe, zuerst noch Skip-Link beachten:
		if (!$PageNaviOpened) {
			echo $strSkipLink;
			$strSkipLink = '';
			$PageNaviOpened = true;
		}

		if ($NaviStyle==1 || $NaviStyle==5) {	// NUR links oder Dropdown:
			if ($NaviStyle==5 && $Breadcrumb==3) echo $MyBreadCrumb;
			echo $navitag_open;
			if ($IncludeSubMenu==1 || $NaviStyle==5) {
				echo $DropDownMenu;
			} else { // links in Spalte mit eigener Leiste
				echo $NaviLevel0;	// Hauptebene
				echo "$navitag_level<nav class=\"naviL2\">$NaviLevel1</nav>";	// Unter-Ebene	// --------------------- CHANGED --------------------------
			}
			echo $navitag_close;
			if ($NaviStyle==5 && $Breadcrumb==4) echo $MyBreadCrumb;
		} else {	// if ($NaviStyle!=1) nicht NUR links, also:
			if ($Breadcrumb==3) echo $MyBreadCrumb;
			echo $navitag_open;
			echo $NaviLevel0;
			if ($SubMenu==1 && $IncludeSubMenu==0) {		// hat Untermenü, das nicht eingebunden sein soll:
				echo "$navitag_level<nav class=\"naviL2\">$NaviLevel1</nav>";	// soll LINKS angezeigt werden!!!
			} elseif ($SubMenu==2 && $IncludeSubMenu==0) {
				if (isset($ulliMap[1])) {
					echo "$navitag_level<nav class=\"naviL2\"><ul>\n". $ulliMap[1] ."</ul>\n</nav>\n";
				} elseif (empty($NaviLevel1)) {
					echo "$navitag_level<nav class=\"naviL2\"><ul><li style=\"visibility:hidden\">-</li></ul></nav>\n";
				} else {
					echo "$navitag_level<nav class=\"naviL2\"><ul>\n$NaviLevel1</ul>\n</nav>\n";
				}
			} else {
//				echo $navitag_level;
			}
			echo $navitag_close;
			if ($Breadcrumb==4) echo $MyBreadCrumb;
		}

		if ($HasHeader==2) {
//		falls der Header UNTER der Navigation sein soll, fügen wir ihn HIER unten ein:
			if ($Breadcrumb == 1)
				echo $MyBreadCrumb;
			echo $headtag_open;
			include $MyHeader;
			echo $headtag_close;
			if ($Breadcrumb == 2)
				echo $MyBreadCrumb;
		}
	}

	if (!empty($ActionLink)) {
		echo $ActionLink;
	}

	// Die Wrapper (div contentwrapper / content / footer) sollten angepasst werden! (BodySize etc.)
	// bisher: contentwrapper / content -> wrapper + wrap / (+content?)
	// bei mehrspaltig OHNE Infoboxen/Bilderleisten reicht EIN Wrapper -> noch implementieren...
	echo $wraptag_open;

	// STEP 5.3.1: Infoboxen / Bilderleisten etc. links:
	if ($SidebarStyle == 1) {
		echo "<!-- Sidebar left -->\n<div class=\"sidebar sidebarleft\">\n";
		echo $MySideText;
		echo $MyImageBar;
		echo "</div>\n<!-- End of left sidebar -->\n";
	}

	echo "<div class=\"content\">\n";
//	echo "<main><div class=\"content\">\n"; mit main

// STEP 5.3.2: Content generieren - evtl. Login-Formular als Ersatz oder Overlay:
/*
Wie Login-Formular / Response anzeigen?
0: WIBcms-Overlay
1: Overlay eigener Stil
2: Standardseite (wenn es Loginseite gibt: diese verwenden, ansonsten WIBcms "ohne Overlay"
3: Include-Seite (wenn es diese gibt: s.o.)
*/
//	Ggf. Loginformular einbinden: ( $MustLogin kommt von wibcmsprepare.php, wo alle Seitenparameter geholt werden )
	if ($MustLogin || $WantLogin) {
		if ($myptyp=='Login' && $myppar=='1' && isset($_SESSION['UserID'])) {
			$ToDo = 'edit';
		}
		if ($AltLogForm==1 && is_file($ExtraLogForm)) {	
			include $ExtraLogForm;	// gibt es eine eigene spezielle Includedatei?
		} else {
			include 'wibcmslogin.php';
		}
		$PageComment = 0;
	} elseif ($error404) {
//	ggf. Hinweis auf fehlende Seite einbinden:
		echo '<h1>'.e404()."</h1>\n";
	} else {
//	"normale Seite" ausblenden, wenn Fehlerseite oder Loginformular als Seite und nicht als Overlay anzuzeigen ist
	//	if (!$error404 && (!($MustLogin || $WantLogin || $AltLogForm==1))) { 
		if ($UseSearch&2 && $search!='') {
			echo suche($search);
//			if ($UseSearch&1) { Suchen('',$mypage); }
		}
		printPageTitle();
//	Titelbild einbinden?
		if ($ShowTitlePicts && !empty($MyTitlePict)) {
			if ($ShowTitlePicts==9 || ($ShowTitlePicts==2 && $PageHasChild) || ($ShowTitlePicts==1 && $myParent==0))
			echo '<img class="titlepict" src="media/'.$MyTitlePict.'" alt="Titelbild zu dieser Seite">';
		}
		$GotContent = true;	// muss im Template auf 'false' gesetzt werden, wenn danach zusätzlich die interne Routine zur Content-Generierung ablaufen soll!
		if ($UseHpTemplate==1 || $UseHpTemplate==2) {
			include $MyHomepage;	// Template ausschließlich oder VOR der internen Routine ausführen
		}
//	Template nicht oder NACH der internen Routine ausführen oder davor nichts erreicht:
		if ($UseHpTemplate==0 || $UseHpTemplate==3 || !$GotContent) {
//			Der Hauptinhalt gemäß verwendetem Modul
			include 'wibcmspages.php';
		}
//	Template NACH der internen Routine ausführen
		if ($UseHpTemplate==3) {
			include $MyHomepage;
		}
		if ($UseSearch&4 && $search!='') {
			echo suche($search);
		}
	}
//	Ganz am Schluss die Kommentare:
	if ($PageComment) {
		$strComm = '<div class="CommWrap'.($PrintComments ? '' : ' noprint').'"><div class="CommComm">';
		$comm = getComments($mypagenum,0);	// rekursive Funktion
		if ($comm)  {
			$strComm .= '<h4>Kommentare zu dieser Seite</h4>'.$comm;
		}
		if ($CommEnable) {
			$strComm .= '</div><div id="CommForm"><h4>Hinterlassen Sie einen Kommentar</h4><form method="POST" accept-charset="utf-8">';
			$strComm .= '<label>Kommentar *)</label><br><textarea name="CommText" required></textarea><br>';
			$strComm .= '<label>Name</label><br><input type="text" name="CommName"><br>';
			$strComm .= '<label>E-Mail <small>(wird nicht veröffentlicht)</small></label><br><input type="text" name="CommMail"><br>';
			$strComm .= '<input type="checkbox" id="CommDSGVO" name="CommDSGVO" value="1" required>';
			$strComm .= '<label for="CommDSGVO">Ich habe die Datenschutzerklärung gelesen und akzeptiert. *)</label><br>';
			$strComm .= '<input type="text" id="Nickname" name="Nickname">';
			$strComm .= '<input type="submit" name="CommSave" value="Kommentar abschicken"><input type="hidden" name="CommReply" id="CommReply" value="0">';
			$strComm .= '<span id="noreply" class="helper cursor"> Eingabe abbrechen</span><br>';
			$strComm .= '<br></form></div>';
		}
		$strComm .= "</div>\n"; // div.CommWrap
		$strComm .= '<script src="core/comment.js"></script>';
		if ($CommStyle==1) {
			echo $strComm;
		}
	}

//	Pflegesymbole direkt auf der Seite:
if ($May['UseMenu']) {	// siehe Mini-Menü in wibcmsfoot.php !
	$isKG = ($MyPageType == 'KissGallery' || $MyPageType == 'Galerie1' || $MyPageType == 'KissAlbum');
	$kgal = $isKG ? $MyPageParam : 0;
	$form = ($MyPageType == 'Forms') ? $MyPageParam : -1;
	$MM = '';
	if ($May['EditPages']) {
		$MM .= '<img src="core/grafix/edit.gif" title="Seite bearbeiten" onclick="oeffne('. "'editpage',$mypagenum,0)" .'">
		<img src="core/grafix/tools.gif" title="Seitenattribute bearbeiten" onclick="oeffne('. "'usepage',$mypagenum,0)" .'">
		<img src="core/grafix/delete.gif" title="Seite entfernen" onclick="oeffne('. "'delpage',$mypagenum,0)\">\n";
	}
	if ($May['EditAlben'] && $MyPageType == 'Fotoalben') {
		$MM .= '<img src="core/grafix/pict.gif" title="Fotoalbum verwalten" onclick="oeffne(\'alben\',0,0)">';
	} elseif ($May['EditAlben'] && $MyPageType == 'KissAlbum') {
		$MM .= '<img src="core/grafix/pict.gif" title="Kiss-Album bearbeiten" onclick="oeffne('."'kissAlben',$kgal,0)\">";
	} elseif ($May['EditCal1'] && $MyPageType == 'Kalender1') {
		$MM .= '<img src="core/grafix/table.gif" title="Kalender verwalten" onclick="oeffne(\'kalender\',0,0)">';
	} elseif ($May['EditForms'] && $MyPageType == 'Forms') {
		$MM .= '<img src="core/grafix/htm.gif" title="Formular bearbeiten" onclick="oeffne('."'forms',$form,0)\">\n";
	} elseif ($May['EditKiss'] && $isKG) {
		$MM .= '<img src="core/grafix/pict.gif" title="Bilder in der KissGallery bearbeiten" onclick="oeffne('."'KissPicsFile',$kgal,0)\">\n";
	} elseif ($May['EditDowns'] && $MyPageType == 'Download') {
		$MM .= '<img src="core/grafix/htm.gif" title="Download-Sammlung" onclick="oeffne('."'downloads',$mypagenum,0)\">\n";
	} elseif ($MyPageType == 'Plugin') {
		$MM .= '<img src="core/grafix/zahnrad.gif" title="Plugin '.$MyPlugType.' bearbeiten" onclick="oeffne('."'Plugin:$MyPlugType','$MyPageParam',0)\">\n";
	} elseif ($May['EditAutoNews'] && $MyPageType == 'AutoNews') {
		$MM .= '<img src="core/grafix/htm.gif" title="Inhalte der Auto-News bearbeiten" onclick="oeffne('."'autonews',0,0)\">\n";
	}

	if ($showEditSymbols) {
		echo "\n<!-- Pflegesymbole -->\n<div class=\"editpagelink noprint\">\n";
		echo "$MM</div>\n<!-- Ende Pflegesymbole -->\n";
	}
}
	echo "\n</div>\n";	// Ende content (bzw. Infobox/Bilderleiste) / contentwrapper

// STEP 5.3.3: Infoboxen / Bilderleisten:
	if ($SidebarStyle == 2) {
		echo "<!-- Sidebar right -->\n<div class=\"sidebar sidebarright\">\n";
		echo $MySideText;
		echo $MyImageBar;
		echo "</div>\n<!-- End of right sidebar -->\n";
	}

//	echo "\n</main>\n";	// Ende content (bzw. Infobox/Bilderleiste) / contentwrapper MIT main

	echo $wraptag_close;	// Ende Wrapper

//	Kommentarbereich UNTER Inhalt und Sidebars:
	if ($PageComment && $CommStyle==0) {
		echo $strComm;
	}

// STEP 5.4: Inhalt abschließend mit evtl. Extra-Inhalt versehen:
	if ($MyExtraContent != '') {
		echo "<div class=\"contend\">$MyExtraContent</div>\n";
	}
	echo "<!-- Ende Content -->\n";

// STEP 5.6: Footer, falls vorhanden:
	if ($HasFooter && is_file($MyFooter)) {
		if ($Breadcrumb==5) echo $MyBreadCrumb;
		echo $foottag_open;
		include $MyFooter;
		echo $foottag_close;
		if ($Breadcrumb==6) echo $MyBreadCrumb;
	}

// ---------- STEP 6: Inhalt abschließen inkl. javascripts (Galerien), ggf. mit dem Admin-Teil:
	require 'core/wibcmsfoot.php';

	if ($DivBody) echo "</div>\n";

//	Druckansicht, falls nicht unterdrückt:
	if (!isset($_GET['nolegal'])) {
		echo "<p class=\"printlegal\">$MyPrintText</p>\n";
	}

	$db->close();

//	Cookie-Hinweis unten einblenden, falls nötig:
	if ($ShowCookieAccept==2) {
		printAcceptCookie();
	}

//	Seite abschließen mit extra Scripts:
	if ($MyExtraScripts != '') {
		echo $MyExtraScripts;
	}

// -------------------------- Debug- und Testmeldungen am Seitenende einfügen: ---------------------------
	debug('<small>PageTime: ' . date('s',(time()-$MyPageTime)) . '</small>',2);

	if (false && $WebStat&1) {
		echo '<div>';
		foreach($ulliMap as $nr=>$Map) {
			echo '<div style="display:inline-block"><h4>ulli '.$nr."</h4>\n<ul>".$Map."</ul></div>\n\n";
		}
		echo '</div><div>';
		foreach($strNavi as $nr=>$Map) {
			echo '<div style="display:inline-block"><h4>strN '.$nr."</h4>\n<ul>".$Map."</ul></div>\n\n";
		}
		echo '</div><div>';
		foreach($uliNavi as $nr=>$Map) {
			echo '<div style="display:inline-block"><h4>uliN '.$nr."</h4>\n<ul>".$Map."</ul></div>\n\n";
		}
		echo '</div>';
	}

	echo "</body>\n</html>";
}
?>