<?php
$WIBcmsFilePrefix = '../';
require 'wibcmsconstants.php';

// Make output a real JavaScript file!
header('Content-type: text/javascript'); // browser will now recognize the file as a valid JS file

// prevent browser from caching
header('pragma: no-cache');
header('expires: 0'); // i.e. contents have already expired

$strJSON = [];
$delimiter = "\n";
$Lang = $_GET['Lang'] ?? 0;
$strLang = $LangPrefix[$Lang];
$u = $URLRewrite ? '' : '?';

function pagelist($Parent=0, $Level=0, $Lang=0) {
	global $db, $delimiter,$u, $arrJSON,$strJSON;
	$text = '';
	$sql = "SELECT ID,URL,Link FROM Pages WHERE Parent=$Parent AND Lang=$Lang AND Show<2 AND RefID=0 AND NOT Type IN ('LinkPrint','LinkHome','LinkLang') ORDER BY Folge";
	$res = $db->query($sql);
	$ins = substr('.....................',0,$Level*3);
	while ($rec = $res->fetchArray()) {
		// Rekursion
		$sub = pagelist($rec[0],$Level+1, $Lang);
		$text .= $delimiter . '["Seite: ' . $ins . htmlentities($rec[2]) . '", "' .$u.$rec[1] .'"],' . $sub;
		$strJSON[] = "{title: 'Seite: $ins". $rec[2] . "', value: '$u" . $rec[1] . "'}";
	}
	return $text;
}

$output = 'var tinyMCELinkList = new Array(' . pagelist(0,0);

// AutoNews vorhanden?
$mypage = $db->querySingle("SELECT URL FROM Pages WHERE Show<2 AND Type='AutoNews'");
if (!empty($mypage)) {
	$res = $db->query("SELECT ID,Titel,Text,Auto,Von,Bis FROM Infos WHERE (Typ=1 AND Lang=$Lang) ORDER BY Von DESC");
	while ($rec = $res->fetchArray()) {
		$output .= $delimiter . '["AutoNews: ' . $rec[1] . '", "' .$u.$mypage . '&showid=' . $rec[0] .'"],';
		$strJSON[] = "{title: 'AutoNews: ". $rec[1] . "', value: '$u$mypage&showid=" . $rec[0] . "'}";
	}
}

// Links auf weitere Quellen laut custom.conf:
// include "../data/custom.conf"; // ist durch wibcmsconstants bereits eingebunden
foreach($Linksammlung as $rec) {
	$mypage = explode("#", trim($rec,"\r\n"));
	$mypage[1] = str_replace('?','',$mypage[1]);
	$output .= $delimiter . '["Links: ' . htmlentities($mypage[0]) . '", "' . $u.$mypage[1] . '"],';
	$strJSON[] = "{title: 'Links: ". $mypage[0] . "', value: '$u" . $mypage[1] . "'}";
}

$output = substr($output, 0, -1);
$output .= $delimiter . ');';

$type = $_GET['type'] ?? '';
$ver = $_GET['ver'] ?? 3;

if ($type == 'link') {

	echo $output;	// linklist für ver 3

} elseif ($ver == 3) {

?>
function initEditor() {
	// for pagebreak add plugin and button pagebreak, // strikethrough
	tinyMCE.init({
		theme: 'advanced',
		plugins: 'advimage,advlink,table,paste,media',
		pagebreak_separator : '<h6>Spaltenwechsel</h6>',
		theme_advanced_layout_manager : 'SimpleLayout',
		theme_advanced_toolbar_location: 'top',
		theme_advanced_blockformats : 'p,h1,h2,h3,h4,h5,h6,blockquote',
		theme_advanced_buttons1 : 'bold,italic,underline,sup,sub,|,justifyleft,justifycenter,justifyright,justifyfull,|, bullist,numlist,outdent,indent,|,formatselect,|,link,unlink,image,media,|,undo,cleanup,removeformat,redo',
		theme_advanced_buttons2 : 'paste,pastetext,pasteword,selectall,|,table,tablecontrols,|,hr,|,styleselect,|,code',
		theme_advanced_buttons3 : '',
		content_css : 'data/basic.css?' + new Date().getTime(),
		mode : 'specific_textareas',
		editor_selector : 'tinyMCE',
		file_browser_callback: 'myFileBrowser',
		language: '<?= $strLang ?>',
/*		external_image_list_url: 'core/imagelist.php',	// bringt ja nichts gegenüber filebrowser	*/
		external_link_list_url : 'core/tinyinit.php?type=link&Lang=' + <?= $Lang ?>,
/*		link_list: tinyMCELinkList,	*/
		width : <?= $EdiWidth ?>,
		height: <?= $EdiHeight ?>,
		element_format : 'html'
	});
}

function myFileBrowser (field_name, url, type, win) {
// alert("Field_Name: " + field_name + "\nURL: " + url + "\nType: " + type + "\nWin: " + win); // debug/testing

	let cmsURL = '/core/filebrowser.php?ver=3&type=' + type;

    tinyMCE.activeEditor.windowManager.open({
		file : cmsURL,
		width: <?= $FbWidth ?>, height: <?= $FbHeight ?>,
		resizable: 'yes',
		inline : 'yes',  // This parameter only has an effect if you use the inlinepopups plugin!
		close_previous : 'no',
		scrollbars : 'yes'
    }, {
		window : win,
		input : field_name
    });
    return false;
}
<?php

} elseif ($ver == 7) {

?>
function initEditor() {
	const useDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
	const isSmallScreen = window.matchMedia('(max-width: 1023.5px)').matches;
	tinymce.init({
		plugins: 'accordion anchor autolink charmap code codesample emoticons fullscreen help image importcss insertdatetime link lists media nonbreaking pagebreak preview quickbars searchreplace table visualblocks visualchars wordcount',	/* advlist autoresize autosave directionality save */
/*		menubar: 'edit insert view format',	*/
		menubar: false,
		toolbar1: 'bold italic underline superscript subscript | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link unlink image media',
		toolbar2: 'undo redo | blocks | table | pagebreak hr nonbreaking charmap emoticons | pastetext removeformat code help',
		promotion: false,
		highlight_on_focus: false,
		branding: false,
		license_key: 'gpl',
		selector: 'textarea.tinyMCE',
		resize: 'both',
		skin: '<?= $TinySkinUI ?>',
		content_css: '<?= $TinySkinContent ?>',
		width : <?= $EdiWidth ?>,
		height: <?= $EdiHeight ?>,
		image_advtab: true,
		image_title: true,
		image_caption: true,
		pagebreak_separator : '<h6>Spaltenwechsel</h6>',
		importcss_append: true,
		insertdatetime_formats: ["%H:%M:%S","%d.%m.%Y","%I:%M:%S %p","%D"],
		convert_urls: false,
		entity_encoding: 'raw',
		extended_valid_elements: 'span[*]',
/*		content_style: 'body {height:unset;}',	*/
		language: '<?= $strLang ?>',
/*		image_list: '/core/imagelist7.php', // bringt eh nichts, in filebrowser enthalten	*/
		link_list: [
<?= implode(",\n",$strJSON) ?>
		],
		file_picker_callback: myFileBrowser,
		importcss_selector_filter: /(?:([a-z0-9\-_]+))(\.[a-z0-9_\-\.]+)$/i
	});
}

function myFileBrowser (callback, value, meta) {
	let type = meta.filetype;
    let cmsURL = '/core/filebrowser.php?ver=7&type=' + type;
	switch (type) {
		case 'image': var titel = 'Bildauswahl'; break;
		case 'file':  var titel = 'Dateiauswahl'; break;
		case 'media': var titel = 'Medienauswahl'; break;
	}

    fbCallback = callback;
    fbWindow = tinymce.activeEditor.windowManager.openUrl({
        title: '' + titel,
        width: <?= $FbWidth ?>, height: <?= $FbHeight ?>,
        url: cmsURL
    });
    return false;
}
<?php

}

?>