/* jslint
  browser:true
*/
/* eslint
  operator-linebreak:["warn", "before"]
*/
/* global
  document,
  console,
  DOMParser,
*/
/*
  version: 1.2.4
*/
function sealInit () {
  'use strict'
  var imgurl = '/wp-content/plugins/seal-of-trust/seal.php/'
  var svg = document.getElementById('siwecos-seal')
  var sealgraphics = new DOMParser().parseFromString('<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 262.365 100.988">'
        + '  <defs><clipPath clipPathUnits="userSpaceOnUse" id="clip"><rect width="262.36499" height="100.988" x="3.4119999" y="40.965" /></clipPath></defs>'
        + '  <g id="layer2" transform="translate(-3.412 -40.965)" clip-path="url(#clip)">'
        + '  <g id="g4239" fill="#c31622" fill-rule="evenodd">'
        + '    <rect width="260.383" height="122.226" x=".806" y="32.667" fill="#fff" stroke="#c31622" stroke-width="2" ry="58" transform="matrix(1.00067 0 0 .81442 3.412 15)" />'
        + '    <path d="M74.546-5.357h2.143v205.239h-2.143z" transform="matrix(.86988 0 0 1.04379 3.5 -8.383)" />'
        + '    <path d="M81.689-5.773h2.143v204.882h-2.143z" transform="matrix(.86988 0 0 1.02342 3.5 -4.604)" />'
        + '    <path d="M88.622-5.207h2.143v204.525h-2.143z" transform="matrix(.86988 0 0 .98707 3.5 2.716)" />'
        + '    <path d="M101.984-10.355h2.143v214.168h-2.143z" transform="matrix(.86988 0 0 .96824 3.5 4.831)" />'
        + '    <path d="M95.303-5.773h2.143V200.18h-2.143z" transform="matrix(.86988 0 0 1.23587 3.5 -33.128)" />'
        + '    <rect width="70" height="194.882" ry="5.18" transform="matrix(1.09795 0 0 .94169 -12.465 8.485)" />'
        + '    <circle style="isolation:auto;mix-blend-mode:normal" cx="70.357" cy="79.882" r="48.571" fill="#fff" stroke-linecap="square" stroke-linejoin="round" stroke-width="5" color="#000" overflow="visible" transform="translate(3.5 21.732) scale(.86988)" />'
        + '    <g id="SIWECOS" transform="matrix(.91943 0 0 -.91943 -252.77 364.523)">'
        + '    <g id="g12">'
        + '      <g fill="none" id="g14">'
        + '      <path id="g20" fill="#a7a5a6" d="M0 0l13.875 13.874S8.548 19.61 8.548 25.782c0 15.055 15.287 15.859 15.287 15.859v19.564s-34.968-.51-34.968-38.019C-11.133 10.784 0 0 0 0" transform="translate(321.473 272.303)" />'
        + '      <path id="g24" stroke="#231f20" stroke-miterlimit="10" stroke-width=".709" d="M345.536 274.891c-12.319 0-22.305 9.987-22.305 22.305 0 12.317 9.53 22.302 21.85 22.302" />'
        + '      <path id="g28" stroke="#231f20" stroke-miterlimit="10" stroke-width=".709" d="M345.536 268.332c-15.942 0-28.864 12.924-28.864 28.864 0 15.94 12.465 28.859 28.408 28.859" />'
        + '      <path id="g32" stroke="#231f20" stroke-miterlimit="10" stroke-width="2" d="M345.536 261.771c-19.565 0-35.424 15.862-35.424 35.425 0 19.563 15.428 35.08 34.968 35.423" />'
        + '      <path id="g36" stroke="#231f20" stroke-linecap="round" stroke-miterlimit="10" stroke-width="4" d="M334.384 284.137l-16.964-16.964" />'
        + '      <path id="g40" stroke="#231f20" stroke-miterlimit="10" stroke-width="3" d="M361.28 297.196c0-8.694-7.048-15.744-15.743-15.744-8.696 0-15.743 7.05-15.743 15.744 0 8.695 7.047 15.744 15.743 15.744 8.695 0 15.744-7.049 15.744-15.744z" />'
        + '      <path id="g44" fill="#231f20" d="M12.57-10.035s2.786-2.823 6.687-2.823c2.45 0 4.53 1.374 4.53 3.863 0 5.682-12.7 4.457-12.7 12.516 0 4.085 3.527 7.317 8.466 7.317 4.866 0 7.428-2.638 7.428-2.638l-1.67-3.045S22.897 7.42 19.553 7.42c-2.785'
        + ' 0-4.753-1.746-4.753-3.826 0-5.422 12.703-3.974 12.703-12.48 0-4.047-3.121-7.39-8.321-7.39-5.57 0-8.691 3.454-8.691 3.454l2.08 2.786zm-19.237-2.86c5.347 0 9.656 4.457 9.656 10.362 0 5.72-4.31 10.028-9.656 10.028-5.35 0-9.694-4.308-9.694-10.028 0-5.905'
        + ' 4.344-10.362 9.694-10.362m0 23.733c7.576 0 13.443-5.831 13.443-13.371 0-7.725-5.867-13.742-13.443-13.742-7.578 0-13.483 6.017-13.483 13.742 0 7.54 5.905 13.37 13.483 13.37m-27.151 0c6.313 0 9.545-3.454 9.545-3.454l-1.82-2.748s-3.045 2.86-7.576 2.86c-5.87'
        + ' 0-9.694-4.457-9.694-10.028 0-5.608 3.899-10.362 9.73-10.362 4.94 0 8.097 3.417 8.097 3.417l1.968-2.637s-3.603-4.16-10.175-4.16c-7.875 0-13.41 6.017-13.41 13.705 0 7.614 5.72 13.408 13.335 13.408m-33.02-.446h15.229V7.198h-11.55V-1.01h9.396v-3.194h-9.396'
        + 'v-8.431h12.18v-3.194h-15.858v26.22zm-19.982 0l5.125-19.24c.37-1.447.557-2.784.557-2.784h.074s.112 1.374.483 2.785l4.828 19.239h3.789l-6.871-26.221h-4.272l-4.531 17.01c-.445 1.67-.78 3.714-.78 3.714h-.074s-.333-2.043-.78-3.714l-4.53-17.01h-4.272l-6.685'
        + ' 26.22h3.789l4.643-19.238c.334-1.411.482-2.785.482-2.785h.074s.186 1.337.557 2.785l5.125 19.239h3.269zm-26.777 0h3.676V-15.83h-3.676v26.22zm-20.576-20.427s2.785-2.823 6.685-2.823c2.452 0 4.53 1.374 4.53 3.863 0 5.682-12.701 4.457-12.701 12.516 0 4.085'
        + ' 3.529 7.317 8.468 7.317 4.866 0 7.428-2.638 7.428-2.638l-1.672-3.045s-2.414 2.266-5.756 2.266c-2.785 0-4.754-1.746-4.754-3.826 0-5.422 12.702-3.974 12.702-12.48 0-4.047-3.12-7.39-8.32-7.39-5.571 0-8.69 3.454-8.69 3.454l2.08 2.786z" transform="translate(516.142 301.007)" />'
        + '      </g>'
        + '    </g>'
        + '    </g>'
        + '    <g id="SCANNED" fill="#666" transform="scale(.99857 1.00143)">'
        + '    <path d="M117.414 66.21s1.68 1.86 4.68 1.86c2.8 0 4.48-1.8 4.48-3.98 0-4.58-6.84-3.8-6.84-6.72 0-1.12 1.06-2.06 2.56-2.06 1.8 0 3.1 1.22 3.1 1.22l.9-1.64s-1.38-1.42-4-1.42c-2.66 0-4.56 1.74-4.56 3.94 0 4.34 6.84 3.68 6.84 6.74 0 1.34-1.12 2.08-2.44 2.08-2.1 0-3.6-1.52-3.6-1.52l-1.12 1.5zm11.058-5.52c0 4.14 2.98 7.38 7.22 7.38 3.54 0 5.48-2.24 5.48-2.24l-1.06-1.42s-1.7 1.84-4.36 1.84c-3.14 0-5.24-2.56-5.24-5.58 0-3 2.06-5.4 5.22-5.4 2.44 0 4.08 '
        + '1.54 4.08 1.54l.98-1.48s-1.74-1.86-5.14-1.86c-4.1 0-7.18 3.12-7.18 7.22zm23.833 7.14h2.06l-5.08-14.12h-2.08l-5.08 14.12h2.04l1.4-4.06h5.32l1.42 4.06zm-4.04-12.18s.3 1.28.54 2l1.56 4.48h-4.28l1.58-4.48c.24-.72.56-2 .56-2h.04zm8.198 12.18h1.98v-9.16c0-.8-.14-2.06-.14-2.06h.04s.66 1.28 1.18 2.06l6.3 9.16h1.94V53.71h-1.98v9.18c0 .78.14 2.04.14 2.04h-.04s-.66-1.28-1.18-2.04l-6.28-9.18h-1.96v14.12zm15.157 0h1.98v-9.16c0-.8-.14-2.06-.14-2.06h.04s.66 1.28 1.18 '
        + '2.06l6.3 9.16h1.94V53.71h-1.98v9.18c0 .78.14 2.04.14 2.04h-.04s-.66-1.28-1.18-2.04l-6.28-9.18h-1.96v14.12zm15.156 0h8.54v-1.72h-6.56v-4.54h5.06v-1.72h-5.06v-4.42h6.22v-1.72h-8.2v14.12zm11.445 0h4.68c4.32 0 7.16-2.6 7.16-7.08 0-4.46-2.84-7.04-7.16-7.04h-4.68v14.12zm1.98-1.72V55.43h2.56c3.16 0 5.26 1.86 5.26 5.32 0 3.48-2.08 5.36-5.26 5.36h-2.56z" />'
        + '    </g>'
        + '    <g id="STANDBY" fill="#666" transform="matrix(.99857 0 0 1.00143 .028 .063)">'
        + '    <path d="M117.414 127.097s1.68 1.86 4.68 1.86c2.8 0 4.48-1.8 4.48-3.98 0-4.58-6.84-3.8-6.84-6.72 0-1.12 1.06-2.06 2.56-2.06 1.8 0 3.1 1.22 3.1 1.22l.9-1.64s-1.38-1.42-4-1.42c-2.66 0-4.56 1.74-4.56 3.94 0 4.34 6.84 3.68 6.84 6.74 0 1.34-1.12 2.08-2.44 2.08-2.1 0-3.6-1.52-3.6-1.52l-1.12 1.5zm15.038 1.62h1.98v-12.4h4.84v-1.72h-11.66v1.72h4.84v12.4zm16.416 0h2.06l-5.08-14.12h-2.08l-5.08 14.12h2.04l1.4-4.06h5.32l1.42 4.06zm-4.04-12.18s.3 1.28.54 2l1.56'
        + ' 4.48h-4.28l1.58-4.48c.24-.72.56-2 .56-2h.04zm8.198 12.18h1.98v-9.16c0-.8-.14-2.06-.14-2.06h.04s.66 1.28 1.18 2.06l6.3 9.16h1.94v-14.12h-1.98v9.18c0 .78.14 2.04.14 2.04h-.04s-.66-1.28-1.18-2.04l-6.28-9.18h-1.96v14.12zm15.156 0h4.68c4.32 0 7.16-2.6 7.16-7.08 0-4.46-2.84-7.04-7.16-7.04h-4.68v14.12zm1.98-1.72v-10.68h2.56c3.16 0 5.26 1.86 5.26 5.32 0 3.48-2.08 5.36-5.26 5.36h-2.56zm12.825 1.72h5.06c2.48 0 4.54-1.36 4.54-4.02 0-1.58-.84-2.98-2.32-3.42v-.04c1.08-.56'
        + ' 1.76-1.66 1.76-3.04 0-2.28-1.72-3.6-4.1-3.6h-4.94v14.12zm1.98-8.18v-4.22h2.92c1.36 0 2.12.84 2.12 2.08 0 1.24-.8 2.14-2.08 2.14h-2.96zm0 6.46v-4.82h3.16c1.48 0 2.44.98 2.44 2.42s-.9 2.4-2.42 2.4h-3.18zm13.539 1.72h1.98v-5.98l4.72-8.14h-2.24l-2.58 4.64c-.44.8-.86 1.78-.86 1.78h-.04s-.42-1-.86-1.78l-2.62-4.64h-2.24l4.74 8.14v5.98z" />'
        + '    </g>'
        + '  </g>'
        + '  </g>'
        + '</svg>',
  'application/xml')
  var siwecoslink
  var domain
  var format
  var img = null
  if (svg === null) {
    console.log('Missing <svg id="siwecos-seal"></svg>')
  } else {
    svg.appendChild(sealgraphics.firstChild)
    siwecoslink = svg
    if (typeof siwecoslink.dataset === 'object'
    && typeof siwecoslink.dataset.format === 'string') {
      format = siwecoslink.dataset.format
    } else {
      format = ''
    }
    while (siwecoslink.parentNode !== null) {
      if (siwecoslink.nodeName === 'A') {
        domain = siwecoslink.getAttribute('href')
        if (domain !== null) {
          if (domain.match(/\s/)) {
            break
          }
          if (format === '') {
            format = domain.replace(/^\S*[?&]format=(\S*?)(?:&\S*)?$/, '$1')
            if (format === domain) {
              format = ''
            }
          }
          format = format.replace(/[^-d/m.y]/g, '')
          if (format === null || format === '') {
            format = 'd.m.y'
          }
          imgurl = domain.replace(/^(https?:\/\/(\S*?))\/\S*$/, '$1') + imgurl
          domain = domain.replace(/^\S*[?&]data-siwecos=(\S*?)(?:&\S*)?$/, '$1')
          img = document.createElement('img')
          break
        }
      }
      siwecoslink = siwecoslink.parentNode
    }
    if (img !== null) {
      img.addEventListener('load', function () {
        svg.parentNode.replaceChild(img, svg)
      })
      img.addEventListener('error', function () {
        console.log('error')
      })
      img.width = svg.getBoundingClientRect().width
      img.src = imgurl + domain + '/' + format
    }
  }
}

