<?php
/*	save_functions.php
this script is included by wibcmsupdate.php (for wibcmssave.php) AND dup_save.php
just to reduce the size of those scripts...	*/

function delTree($dir,$verbose=1) {
	global $ups,$User;
	if (is_dir($dir)) {
		$files = array_diff(scandir($dir), array('.','..'));
		foreach ($files as $file) {
			(is_dir("$dir/$file")) ? delTree("$dir/$file") : @unlink("$dir/$file");
		}
		if (@rmdir($dir)) {
			$OK = true;
			if ($verbose) {
				$ups.= "<li>$dir gelöscht</li>\n";
				write_log("$User hat den Ordner $dir gelöscht");
			}
		} else {
			$OK = false;
			if ($verbose) {
				$ups.="<li>$dir NICHT gelöscht</li>\n";
			}
		}
	} else {
		$ups .= "<li>Ordner $dir nicht vorhanden</li>\n";
		$OK = false;
	}
	return $OK;
}

// Sitemap.XML generieren und in root speichern, für alle aktiven Sprachen:
function createSitemapXML() {
	global $db,$u, $Server,$CanonicalDomain, $MyLanguages;
	$URL = (!empty($CanonicalDomain) && $CanonicalDomain!=$Server) ? $CanonicalDomain : $Server;
	$XML = '<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xhtml="http://www.w3.org/1999/xhtml">
';
	$myLang = 0;
	$query = "SELECT ID,URL,Type FROM Pages WHERE (Show>0 AND Lang=0 AND RefID=0 AND Login=0 AND (Status BETWEEN 1 AND 3) AND Type NOT IN ('LinkPrint','LinkHome','LinkLang','LinkSearchVersuch'))";
	$result = $db->query($query);
	while ($row = $result->fetchArray()) {
		$Loc = $URL . "/$u". $row['URL'];
		$XML .= "<url>\n  <loc>$Loc</loc>\n";
		if (count($MyLanguages)>1) {
			$Alt = '	<xhtml:link rel="alternate" hreflang="'.$MyLanguages[0].'" href="'.$Loc."\"/>\n";
			$sql = "SELECT URL,Lang FROM Pages WHERE Ist=".$row['ID'];
			$res = $db->query($sql);
			while ($lang = $res->fetchArray()) {
				$l = $lang['Lang'];
				$Alt .= '	<xhtml:link rel="alternate" hreflang="'.$MyLanguages[$l].'" href="'.$URL . "/$u". $lang['URL']."\"/>\n";
				$x[$l] = $lang['URL'];
			}
			$XML .= $Alt . "</url>\n";
			// und jetzt die übrigen Referenzen:
			while ($lang = $res->fetchArray()) {
				$XML .= "<url>\n  <loc>$URL/$u". $lang['URL']."</loc>\n$Alt</url>\n";
			}
		} else {
			$XML .= "</url>\n";
		}
	}
	$XML .= "</urlset>\n";
	return file_put_contents('../sitemap.xml',$XML);
}

// Hilfsfunktionen für die Konfiguration:
// checkBox abfragen:
function getCheckButton($key) {
	$txt = isset($_POST[$key]) ? 'true':'false';
	return "$$key = $txt;\n";
}
// Array mit dedizierten Key-Value-Paaren abfragen:
function getKeyValArray($post,$addtxt='',$addEmpty=true) {
	$txt = '';
	if (isset($_POST[$post])) {
		foreach($_POST[$post] as $key=>$val) {
			if (!empty($val) or $addEmpty) {
				if (!empty($txt))
					$txt .= ', ';
				if (!is_numeric($val))
					$val = "'".$val."'";
				$txt .= $key . '=>' . $val;
			}
		}
	}
	if (!empty($addtxt)) {
		if (!empty($txt))
			$txt .= ', ';
		$txt .= $addtxt;
	}
	return "$$post = [$txt];\n";
}
// checkBox abfragen:
function checkTheBox($key) {
	$txt = $_POST[$key] ?? '';
	if (!is_numeric($txt)) { $txt = "'$txt'"; }
	return "$$key = $txt;\n";
}
// konvertiere Filenamen zu "problemlosen" Namen:
function ConvertName($text) {
//	https://www.php.net/manual/de/transliterator.transliterate.php
	$text = str_replace(['Ä','Ö','Ü','ä','ö','ü','ß'], ['Ae','Oe','Ue','ae','oe','ue','ss'], $text);
	$rule = transliterator_create_from_rules("::Any-Latin; ::Latin-ASCII; [^[:L:][:N:]]+ > '-';");	// ::Lower;
	return trim(transliterator_transliterate($rule, $text), ' _-');
}

// Bilder einer Galerie verschieben:
function moveGallery($OldFolder,$KFolder,$gid,$Name,$User,$MoveSubfolders=1) {
	global $db,$MyMedia,$ups;

	$KissFolder = $MyMedia.$OldFolder.'/';
	$KissThumbs = $KissFolder.'Thumbs/';
	$KissOrigin = $KissFolder.'Originals/';

	$NewFolder  = $MyMedia.$KFolder;
	// gibt es den neuen Ordner bereits?
	if (!is_dir($NewFolder)) {
		mkdir($NewFolder,0755);
		mkdir($NewFolder.'/Thumbs',0755);
		mkdir($NewFolder.'/Originals',0755);
		$ups = "<li>Neuen Ordner $NewFolder angelegt</li>\n";
	}
	$sql = "SELECT ID,Img FROM Galerie WHERE GalleryID=$gid";
	$res = $db->query($sql);
	while ($rec = $res->fetchArray()) {
	//	Auf doppelte Filenamen achten!
		$Datei = fittingname("$NewFolder/",$rec[1]);
		if ($Datei != $rec[1]) {
		//	Neuer Name erfordert auch DB-Update...!
			$db->exec("UPDATE Galerie SET Img='$Datei' WHERE ID=".$rec[0]);
		}
		 rename($KissFolder.$rec[1], "$NewFolder/$Datei");
		@rename($KissThumbs.$rec[1], "$NewFolder/Thumbs/$Datei");
		@rename($KissOrigin.$rec[1], "$NewFolder/Originals/$Datei");
	}
//	Ggf. alten Folder löschen -> remove(Ordner) testet auch, ob leer (also nicht von anderen Galleries benutzt):
	remove($KissThumbs);
	remove($KissOrigin);
	remove($KissFolder);
	$ups.="<li>KissGallery $Name verschoben</li>\n";
	write_log("$User hat die KissGallery '$Name' nach '$NewFolder' verschoben");
//	Ggf. auch Unterordner bei Alben berücksichtigen:
	if ($MoveSubfolders) {
		$sql = "SELECT ID,Folder,Name FROM Gallery WHERE Parent=$gid";
		$res = $db->query($sql);
		while ($rec = $res->fetchArray()) {
			$db->exec("UPDATE Gallery SET Folder='$KFolder' WHERE ID=".$rec[0]);
			moveGallery($rec[1], $KFolder, $rec[0], $rec[2], $User, $MoveSubfolders);
		}
	}
}

// Galerie komplett löschen:
function removeGallery($OldFolder,$gid,$Name,$User,$RemoveSubfolders=1) {
	global $db,$MyMedia,$ups;

	$KissFolder = $MyMedia.$OldFolder.'/';
	$KissThumbs = $KissFolder.'Thumbs/';
	$KissOrigin = $KissFolder.'Originals/';

//	alle Bilder löschen:
	$sql = "SELECT Img FROM Galerie WHERE GalleryID=$gid";
	$res = $db->query($sql);
	while ($rec = $res->fetchArray()) {
		 unlink($KissFolder.$rec[0]);
		@unlink($KissThumbs.$rec[0]);
		@unlink($KissOrigin.$rec[0]);
	}
//	Ggf. alten Folder löschen -> remove(Ordner) testet auch, ob leer (also nicht von anderen Galleries benutzt):
	remove($KissThumbs);
	remove($KissOrigin);
	remove($KissFolder);
//	Einträge in Datenbank löschen:
	$sql = "DELETE FROM Galerie WHERE GalleryID=$gid";	// alle Bilder
	if ($db->exec($sql)) {
		$sql = "DELETE FROM Gallery WHERE ID=$gid";		// die Galerie an sich
		$db->exec($sql);
		$ups.="<li>KissGallery $Name gelöscht</li>\n";
		write_log("$User hat die KissGallery '$Name' gelöscht");
	//	auch Seiten löschen, die auf diese Gallery verweisen:
		$sql = "DELETE FROM Pages WHERE Type='KissGallery' AND Parameter=$gid";
		if ($db->exec($sql)) {
			$anz = $db->changes();
			if ($anz > 0) {
				$ups.="<li>deshalb auch $anz Seiten gelöscht</li>\n";
				write_log("deshalb auch $anz Seiten gelöscht");
			}
		}
	}
//	Ggf. auch Unterordner bei Alben berücksichtigen:
	if ($RemoveSubfolders) {
		$sql = "SELECT ID,Folder,Name FROM Gallery WHERE Parent=$gid";
		$res = $db->query($sql);
		while ($rec = $res->fetchArray()) {
			removeGallery($rec[1], $rec[0], $rec[2], $User, $RemoveSubfolders);
		}
	}
}

// Check conflicting filenames and suggest a fitting name:
function fittingname($Ordner, $Datei) {
	if (substr($Ordner,-1) != '/') { $Ordner .= '/'; }	// check if foldername ends with a trailing slash
	$point = strrpos($Datei,'.');	// find last point
	$myfilename = substr($Datei,0,$point);
	$myfilextns = strtolower(substr($Datei,$point));	// d.h. inkl. Punkt! und kleingeschrieben
	$Datei = $myfilename.$myfilextns;
	$trial=1;
	while (is_file($Ordner.$Datei)) {
		$Datei = $myfilename.'_'.$trial++.$myfilextns;
	}
	return $Datei;
}
// Hochgeladene Datei in Ordner speichern:
function SaveDatei($Ordner, $Datei, $i=-1) {
	global $ups;
	// zur Sicherheit testen, ob $Ordner mit '/' endet:
	if (substr($Ordner,-1) != '/') { $Ordner .= '/'; }
	// Neue Datei hochgeladen?
	if ($i<0) {
		$file_error= $_FILES[$Datei]['error'];
	} else {
		$file_error= $_FILES[$Datei]['error'][$i];
	}
	if ($file_error==0) {
		if ($i<0) {
//			$file_name = ConvertName($_FILES[$Datei]['name']);	// remove critical characters - aber eliminiert die Punkte!!!!
			$file_name = str_replace(['Ä','Ö','Ü','ä','ö','ü','ß'], ['Ae','Oe','Ue','ae','oe','ue','ss'], $_FILES[$Datei]['name']);
			$file_tmp  = $_FILES[$Datei]['tmp_name'];
		} else {
//			$file_name = ConvertName($_FILES[$Datei]['name'][$i]);	// remove critical characters
			$file_name = str_replace(['Ä','Ö','Ü','ä','ö','ü','ß'], ['Ae','Oe','Ue','ae','oe','ue','ss'], $_FILES[$Datei]['name'][$i]);
			$file_tmp  = $_FILES[$Datei]['tmp_name'][$i];
		}
		// selbst eindeutigen Namen vergeben:
		$file_name = fittingname($Ordner, $file_name);
		move_uploaded_file($file_tmp, $Ordner.$file_name); // Bilder in Zielordner schieben
		return $file_name;
	} else {
		$ups .= "<li>".UploadErrorText($file_error)."</li>\n";
		return '';
	}
}
// Ersetze Ausdrücke in Datei:
function replace_in_file($file,$Old,$New) {
	$datei = file_get_contents($file);
	$c = 0;
	$Content = str_replace($Old,$New,$datei,$c);
	if ($c>0) { file_put_contents($file, $Content); }
	return $c;
}
// Arbeitsbild erstellen:
function CreateImage($format,$Source) {
	switch($format) {
		case 1:  $img = imagecreatefromgif($Source);  break;	// 1 IMG_GIF
		case 2:  $img = imagecreatefromjpeg($Source); break;	// 2 IMG_JPG
		case 4:  $img = imagecreatefrompng($Source);  break;	// 4 IMG_PNG
		case 8:  $img = imagecreatefromwbmp($Source); break;	// 8 IMG_WBMP
		case 16: $img = imagecreatefromxpm($Source);  break;	// 16 IMG_XPM
		case 32: $img = imagecreatefromwebp($Source); break;	// 32 IMG_WEBP
		case 64: $img = imagecreatefrombmp($Source);  break;	// 64 IMG_BMP
		case 256:$img = imagecreatefromavif($Source); break;	// 256 IMG_AVIF
		default: $img = false;
	}
	return $img;
}
// Arbeitsbild speichern:
function StoreImage($format,$img,$filename,$Folder,$Quality=75) {
	switch($format) {
		case 1:  $imgfile=$filename.'.gif';  @imagegif($img, $Folder.$imgfile); break;
		case 4:  $imgfile=$filename.'.png';  @imagepng($img, $Folder.$imgfile); break; // Compression: 0-9. defaults to 6
		case 32: $imgfile=$filename.'.webp'; @imagewebp($img,$Folder.$imgfile); break;
		case 256:$imgfile=$filename.'.avif'; @imageavif($img,$Folder.$imgfile); break; // Quality: 0-100. defaults to 30 / Speed: 0-10, defaults to 6
		case 2:	// we do not want bmp, wbmp and xpm images...
		default: $imgfile=$filename.'.jpg';  @imagejpeg($img,$Folder.$imgfile, $Quality);
	}
	return $imgfile;
}
// Bild in Galerie aufnehmen:
function SaveImage($Ordner, $width,$height,$fixit, $Originale='',$index='') {
	global $SaveOriginals;
	$Datei = 'Bild'.$index;
	$file_name = SaveDatei($Ordner,$Datei);
	if ($file_name!='') {
		if ($Originale!='' && $SaveOriginals)
			copy($Ordner.$file_name, $Originale.$file_name);
		// Jetzt noch skalieren...
		scaleImage($Ordner.$file_name, $width,$height,$fixit); // Skalieren (nur wenn nötig)
	}
	return $file_name;
}
// --------------- Hilfsfunktionen für die Bildskalierung: ---------------------
function getSizes($src_w, $src_h, $max_w, $max_h, $fixit='' ) {
	#### Calculate multipliers if needed
	switch ($fixit) {
	  case 'N': // keep size
	  case 'n':
		break;
	  default:
		$mlt_w = $max_w / $src_w;
		$mlt_h = $max_h / $src_h;
	}
	$old_w = $src_w;
	$old_h = $src_h;
//	echo "Old: $old_w * $old_h / Max: $max_w * $max_h<br>\n";

	switch ($fixit) {
	case 'F':
	case 'f': // fixed height and width
		break;
	case 'B':
	case 'b': // crop if needed
//		echo "crop: mlt_w=$mlt_w / mlt_h=$mlt_h<br>\n";
		if ($mlt_w > $mlt_h) {
			$mlt_h = $mlt_w;
			$old_h = round($max_h / $mlt_h);
//			echo "old_h=".$old_h . "<br>\n";
		}
		if ($mlt_w < $mlt_h) {
			$mlt_w = $mlt_h;
			$old_w = round($max_w / $mlt_w);
//			echo "old_w=".$old_w . "<br>\n";
		}
		break;
	case 'H':
	case 'h': // fixed height
		$mlt_w = $mlt_h;
		break;
	case 'W':
	case 'w': // fixed width
		$mlt_h = $mlt_w;
		break;
	case 'N': // keep size
	case 'n':
		$mlt_w = 1;
		$mlt_h = 1;
		break;
	default:
		$mlt_w = ($mlt_w < $mlt_h) ? $mlt_w : $mlt_h; // longest side
		$mlt_h = $mlt_w;
	}
	#### Calculate new dimensions
	switch ($fixit) {
		case 'B':
		case 'b': // crop if needed
			$img_new_w = $max_w;
			$img_new_h = $max_h;
			break;
		default:
			$img_new_w = round($src_w * $mlt_w);
			$img_new_h = round($src_h * $mlt_h);
	}
	return array("w" => $img_new_w, "h" => $img_new_h, "cw" => $old_w, "ch" => $old_h);
}

// liefert eine Farbangabe aus einem Hexwert #XXXXXX:
function GetColor($img,$color) {
	$red = hexdec(substr($color,1,2));
	$grn = hexdec(substr($color,3,2));
	$blu = hexdec(substr($color,5,2));
	return ImageColorAllocate($img, $red, $grn, $blu);
}
// generiert eine Thumbnail-Version vom $imgfile (Name mit Pfad zur - noch nicht skalierten, aber existenten - Bilddatei)
// mit maximaler Kantenlänge $dim , Resize-Optionen $fixit/$crop und Qualität $qual
function scaleImage($imgdir,$imgfile, $dimw=800,$dimh=600, $fixit='', $crop=1) {
	global $BlowUp,$doStamp,$forceFormat, $ImgQuality,$ups;
	global $WM_Width,$WM_Height,$WM_Border,$WM_BackCol,$WM_ForeCol,$WM_BorderCol,$WM_Trans,$WM_Font,$WM_Hor,$WM_Ver,$WM_MarginH,$WM_MarginV,$WM_PaddingH,$WM_PaddingV,$WM_Text;

	// 1.: get the dimensions
	$img_sz = getimagesize($imgdir.$imgfile);
//	var_dump($img_sz);

	// 2.: need to resize?
	$doResize = ($img_sz[0]>$dimw || $img_sz[1]>$dimh || ($BlowUp && ($img_sz[0]<$dimw || $img_sz[1]<$dimh)));
	$MustCreate = $doResize || $doStamp || ($forceFormat>0 && $img_sz[2]!=$forceFormat);

	if ($MustCreate) {
		$Source = $imgdir.$imgfile;
		$img = CreateImage($img_sz[2],$Source);
		if ($img == false)
			return false;	// abbrechen...
	}
	if ($doResize) {
		// yes: resize it
		// evtl. abfangen: Invalid image dimensions, wenn eine Dimension NICHT gesetzt (eigtl. schon beim Save der Galerie!)
		$wh = getSizes($img_sz[0], $img_sz[1], $dimw,$dimh,$fixit); // neue Maße für Skalierung
//		var_dump($wh);
		$img_new_w = $wh["w"];
		$img_new_h = $wh["h"];
		$old_w = $wh["cw"];
		$old_h = $wh["ch"];
		// Lage des Ausschnitts beim croppen:
		switch ($crop) {
		  case 1:	// left / top
			$src_x = 0;
			$src_y = 0;
			break;
		  case 2:	// center
			$src_x = ($img_sz[0] - $old_w)/2;
			$src_y = ($img_sz[1] - $old_h)/2;
			break;
		  case 3:	// bottom / right
			$src_x = $img_sz[0] - $old_w;
			$src_y = $img_sz[1] - $old_h;
		}
		// create new image:
		$img_resized = imagecreatetruecolor($img_new_w,$img_new_h);
		imagecopyresampled($img_resized, $img, 0, 0, $src_x, $src_y, $img_new_w, $img_new_h, $old_w, $old_h);
//		debug("imagecopyresampled($img_resized, $img, 0, 0, $src_x, $src_y, $img_new_w, $img_new_h, $old_w, $old_h) / $imgdir . $imgfile");

		// neu setzen, denn wir brauchen diese Variablen mit aktuellen Werten in "doStamp":
		$img = $img_resized;	// Kopie oder Pointer? imagedestroy($img_resized);? Lieber erst mal nicht...
		$img_sz[0] = $wh["w"];
		$img_sz[1] = $wh["h"];
	}
	debug("watermark = $WM_Text / doStamp = $doStamp");

	if ($doStamp) {
		// Da wir hier schon speichern, müssen wir hier auch das Wasserzeichen bereits einfügen:
		// TODO: MAYBE you want watermarks ONLY in big pictures OR thumbnails?

		$stamp = imagecreatetruecolor($WM_Width+2*$WM_Border, $WM_Height+2*$WM_Border);
		$BGCol = GetColor($stamp,$WM_BackCol);
		$FGCol = GetColor($stamp,$WM_ForeCol);
		$XXCol = GetColor($stamp,$WM_BorderCol);
		switch ($WM_Hor) {
			case 0: $XPos = $WM_MarginH; break;						  // links
			case 1: $XPos =($img_sz[0]-$WM_Width)/2; break;			  // mittig
			case 2: $XPos = $img_sz[0]-$WM_Width-$WM_MarginH; break;  // rechts
		}
		switch ($WM_Ver) {
			case 0: $YPos = $WM_MarginV; break;						  // oben
			case 1: $YPos =($img_sz[1]-$WM_Height)/2; break;		  // mittig
			case 2: $YPos = $img_sz[1]-$WM_Height-$WM_MarginV; break; // unten
		}
		if ($WM_Border>0) imagefilledrectangle($stamp, 0, 0, $WM_Width-1, $WM_Height-1, $XXCol);
		imagefilledrectangle($stamp, $WM_Border, $WM_Border, $WM_Width-1-$WM_Border, $WM_Height-1-$WM_Border, $BGCol);
		// imagestring($stamp, $WM_Font, $WM_PaddingH, 15, 'Copyright '.date("Y").' by', $FGCol);
		imagestring($stamp, $WM_Font, $WM_PaddingH, $WM_PaddingV, $WM_Text, $FGCol);
		imagecopymerge($img, $stamp, $XPos, $YPos, 0, 0, $WM_Width, $WM_Height, $WM_Trans);
		imagedestroy($stamp);
		unset($stamp);
	}
	if ($MustCreate) {
		// extract filename without extension:
		$trial = strrpos($imgfile,'.');
		$myfilename = substr($imgfile,0,$trial);
		if ($forceFormat>0)
			$img_sz[2] = $forceFormat;
		unlink($imgdir.$imgfile);	// alte (große) Version löschen
		// Speichern (hier schon?) (und warum gibt es hier evtl. Fehler (null given statt resource in Par.1)???)
		$imgfile = StoreImage($img_sz[2],$img,$myfilename,$imgdir,$ImgQuality);
		@imagedestroy($img);
		unset($img);
	}
	return $imgfile;
}
// Favicons generieren
function CreateFavicon($img, $file, $size, $width, $height) {
	$img_png = imagecreatetruecolor($size,$size);
	imagecopyresampled($img_png, $img, 0, 0, 0, 0, $size, $size, $width, $height);
	imagepng($img_png, $file, 6);
	imagedestroy($img_png);
}
// Notifications:
function notifyApproval($Item,$OldStat,$NewStat,$To) {
	global $db,$User,$strApproval;
//	$from = $db->querySingle("SELECT Name,Mail FROM Users WHERE ID=".$_SESSION['UserID'],1);	// Ist bereits in Session bekannt.
	$to   = $db->querySingle("SELECT Name,RealName,Mail FROM Users WHERE ID=$To",1);
	$toName=empty($to['RealName']) ? $to['Name'] : $to['RealName'];
	$body = "Hallo $toName,\r\n\r\n$User hat soeben (".date("d.m.Y, H:i").") die Seite $Item bearbeitet.\r\n";
	$body.= "Der Status hat sich damit geändert von: $OldStat ($strApproval[$OldStat]) zu: $NewStat ($strApproval[$NewStat]).\r\n";
	$OK = trymail('Freigabeänderung',$body,$to['Mail']);
	if ($OK && ($to['Name']!=$User)) {
		$body .= "(Dies ist eine Kopie der E-Mail an $toName.)\r\n";
		trymail('Freigabeänderung',$body,$_SESSION['UserMail']);
	}
}
?>