<?php
$gid	= $_GET['id'];
$f		= $_GET['f'];
$Groups	= $_GET['g'];
$space	= $_GET['s'];
$scol	= $_GET['c'];
$padding= $_GET['p'];
$pcol	= $_GET['pc'];
$border	= $_GET['b'];
$bcol	= $_GET['bc'];
$Faktor = $_GET['x'];
$img	= $_GET['img'];

function hex2RGB($hexStr, $returnAsString = false, $seperator = ',') {	//	https://www.php.net/manual/en/function.hexdec.php#99478
	$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
	$rgbArray = array();
	if (strlen($hexStr) == 6) { //If a proper hex code, convert using bitwise operation. No overhead... faster
		$colorVal = hexdec($hexStr);
		$rgbArray['R'] = 0xFF & ($colorVal >> 0x10);
		$rgbArray['G'] = 0xFF & ($colorVal >> 0x8);
		$rgbArray['B'] = 0xFF & $colorVal;
	} elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
		$rgbArray['R'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
		$rgbArray['G'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
		$rgbArray['B'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
	} else {
		return false; //Invalid hex color code
	}
	return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
}

$BorderColor  = hex2RGB($bcol);
$PaddingColor = hex2RGB($pcol);
$SpaceColor   = hex2RGB($scol);

$images = explode(',',$img);
$Anzahl = count($images);
$maxheight = $maxwidth = 0;
$height = $width = $type = [];
$sumheight = $sumwidth = 0;

$gluefile = $f.'glued_'.$Groups;
$gluethumb = $f.'Thumbs/glued_'.$Groups;

//	collect images:
foreach ($images as $nr => $image) {
	$size = getimagesize($f.$image);
	$width[$nr] = $size[0];
	$height[$nr]= $size[1];
	$type[$nr]  = $size[2];
	if ($size[0]>$maxwidth)
		$maxwidth = $size[0];
	if ($size[1]>$maxheight)
		$maxheight = $size[1];
	$sumheight += $size[1];
	$sumwidth  += $size[0];
}

$TotalWidth = $sumwidth + ($Anzahl-1)*$space + 2*$Anzahl*($border + $padding);
$TotalHeight= $maxheight + 2*($border + $padding);
$B_X1 = $B_Y1 = 0;
$B_X2 = $B_Y2 = 2*($border + $padding) - 2;	// später + width/height
$P_X1 = $P_Y1 = $border;
$P_X2 = $P_Y2 = 2*$padding;	// s.o.
$PiX1 = $PiY1 = $border + $padding;
$Dist = 2*($border + $padding) + $space;

// Zurzeit nur nebeneinander:
$im = imagecreatetruecolor($TotalWidth, $TotalHeight);

// set backgroundcolors:
$SColor = imagecolorallocate($im, $SpaceColor['R'], $SpaceColor['G'], $SpaceColor['B']);
$PColor = imagecolorallocate($im, $PaddingColor['R'], $PaddingColor['G'], $PaddingColor['B']);
$BColor = imagecolorallocate($im, $BorderColor['R'], $BorderColor['G'], $BorderColor['B']);

imagefill($im, 0, 0, $SColor);

$pos = 0;

foreach ($images as $nr => $image) {
	switch ($type[$nr]) {
		case 1:  $pict = imagecreatefromgif($f.$image);  break;	// 1 IMG_GIF
		case 2:  $pict = imagecreatefromjpeg($f.$image); break;	// 2 IMG_JPG
		case 4:  $pict = imagecreatefrompng($f.$image);  break;	// 4 IMG_PNG
		case 8:  $pict = imagecreatefromwbmp($f.$image); break;	// 8 IMG_WBMP
		case 16: $pict = imagecreatefromxpm($f.$image);  break;	// 16 IMG_XPM
		case 32: $pict = imagecreatefromwebp($f.$image); break;	// 32 IMG_WEBP
		case 64: $pict = imagecreatefrombmp($f.$image);  break;	// 64 IMG_BMP
		case 256:$pict = imagecreatefromavif($f.$image); break;	// 256 IMG_AVIF
		default: $pict = false;
	}
	if ($pict != false) {
		imagefilledrectangle($im, $B_X1, $B_Y1, $B_X2+$width[$nr], $B_Y2+$height[$nr], $BColor);	// draw the border
		imagefilledrectangle($im, $P_X1, $P_Y1, $P_X2+$width[$nr], $P_Y2+$height[$nr], $PColor);	// draw the padding
		imagecopy($im, $pict, $PiX1, $PiY1, 0, 0, $width[$nr], $height[$nr]);	// posx,posy top-left
		
		$B_X1 = $B_X1 + $width[$nr] + $Dist;
		$P_X1 = $P_X1 + $width[$nr] + $Dist;
		$B_X2 = $B_X2 + $width[$nr] + $Dist;
		$P_X2 = $P_X2 + $width[$nr] + $Dist;
		$PiX1 = $PiX1 + $width[$nr] + $Dist;

		$gluefile .= '_'.$image;
		$gluethumb.= '_'.$image;
	}
}

// Set the content type header - in this case image/jpeg
header('Content-Type: image/jpeg');

$NewWidth = $TotalWidth/$Faktor;

// Output the image
imagejpeg($im,$gluefile);
imagejpeg($im);

$Thumb = imagescale($im,$NewWidth);
imagejpeg($Thumb,$gluethumb);

// Free up memory
unset($im);
unset($Thumb);
?>
