<?php
/*	edit_functions.php
this script is included (only) by wibcmsedit.php
just to reduce the size of that script...	*/

// Anzeige Fileinfos:
function strInfo($datei) {
	$fileperms = substr(sprintf("%o",fileperms($datei)),-4);
	$fileowner = posix_getpwuid(fileowner($datei));
	$filegroup = posix_getgrgid(filegroup($datei));
	$strInfo = '<small>'.$fileperms.' | '.$fileowner['uid'].': '.$fileowner['name'].' | '.$filegroup['gid'].': '.$filegroup['name'].' </small>| ';
	return $strInfo;
}
// Webspace-Explorer:
function explorer($pfad,$Depth,$dir='',$Level=1) {
	global $MyRoot;
	$showrights = true;
	$dateiliste = getAlbum($pfad);
	if (is_array($dateiliste)) {
		echo '<ul>';
		foreach ($dateiliste as $datei) {
			$thispath = $pfad.'/'.$datei;
			if (is_dir($thispath)) {
				echo '<li class="folder0">';
				if ($showrights) {
					echo strInfo($thispath);
				}
				echo '<span onclick="explore(this,\''.$thispath.'\')">'.$datei."</span>\n<div class=\"helper\" id=\"$thispath\">";
				if ($Depth>$Level) {
					explorer($thispath,$Depth,$dir.'/'.$datei,$Level+1);
				}
				echo "</div></li>\n";
			} else {
				echo '<li class="file">';
				if ($showrights) {
					echo strInfo($thispath);
				}
//				echo '<a href="'.$dir.'/'.$datei.'" target="_blank">'.$datei."</a></li>\n";
				echo '<a href="'.$MyRoot.$dir.'/'.$datei.'" target="_blank">'.$datei."</a></li>\n";
			}
		}
		echo "</ul>\n";
	}
}
// Medienordner nur Info:
function ScanMedia($path,$t=true,$Level=1) {
	$dateiliste = getAlbum($path);
	$c = 0;
	if (is_array($dateiliste)) {
		if ($Level==1) {
			echo count($dateiliste).($t?' Unterordner':' Dateien')." in $path<ul>\n";
		}
		foreach ($dateiliste as $datei) {
			$thispath = "$path/$datei";
			if (is_dir($thispath)) {
				$c += ScanMedia($thispath,$t,$Level+1);
			} else {
				$c++;
			}
			if ($Level==1 && $t) {
				echo "<li>$datei: $c Dateien</li>\n";
				$c = 0;
			}
		}
	}
	return $c;
}
// Formboxkopf schreiben:
function formkopf($titel,$legend='',$right=1) {
	echo '<h3 onmousedown="movethis('."'formbox')\">$titel".'<img src="core/grafix/pinred.png" alt="Grafik: Pin" title="Positionen dauerhaft fixieren" onmouseover="setPin=1;" onmouseout="setPin=0;"></h3>'."\n";
	if ($legend!='')
		echo "<fieldset><legend>$legend</legend>\n";
	if ($right == 0)
		NotAllowed();
	return $right;
}

// Alle inputfelder nach wibcmsfunction verlegt, damit auch in Formularen nutzbar
// function txtInput($name,$text,$wert,$comment='') {
// }

// Funktionen für die Galerie-Layout-Konfiguration:
function KissFixOptions($fix='0') {
	if (is_array($fix)) $fix = $fix[0];
	$txt = txtOption('0','Proportional auf max. Breite ODER max. Höhe',$fix);
	$txt.= txtOption('W','Breite fixieren (Höhe variabel, proportional)',$fix);
	$txt.= txtOption('H','Höhe fixieren (Breite variabel, proportional)',$fix);
	$txt.= txtOption('F','Höhe UND Breite fixieren, ggf. NICHT proportional!',$fix);
	$txt.= txtOption('B','Höhe UND Breite fixieren, ggf. Ränder abschneiden',$fix);
	$txt.= txtOption('N','Nicht skalieren, Originalgröße des Bildes belassen',$fix);
	return $txt;
}
function GalFix($nr,$fix,$w=0) {	// noch benötigt auf dieser Seite in function Galerie(...)
	if($w==0)
		$txt = "<select name=\"GalFix$nr\">\n";
	elseif($w>0)
		$txt = '<select style="width:'.$w."px\" name=\"GalFix$nr\">\n";
	$txt.= KissFixOptions($fix) . "</select><br>\n";
	return $txt;
}
function HeaderSelect($wert=0) {
	$txt  = txtOption(0,'Nicht anzeigen',$wert);
	$txt .= txtOption(1,'Als Header h1 anzeigen',$wert);
	$txt .= txtOption(2,'Als Header h2 anzeigen',$wert);
	$txt .= txtOption(3,'Als Header h3 anzeigen',$wert);
	$txt .= txtOption(4,'Als Header h4 anzeigen',$wert);
	$txt .= txtOption(5,'Als Header h5 anzeigen',$wert);
	$txt .= txtOption(6,'Als Header h6 anzeigen',$wert);
	$txt .= txtOption(7,'Als Absatz p anzeigen',$wert);
	return $txt;
}
function FillSelect($Name,$Label,$Wert,$AddText='') {
	startSelect($Name,$Label);
	echo txtOption(0,'füllt die gesamte Breite / Grid-Breite',$Wert);
	echo txtOption(1,'füllt gesamte Breite, Inhalt zentriert',$Wert);
	echo txtOption(2,'ist zentriert &lt;div outer&gt;',$Wert);
	echo "</select> $AddText<br>\n";
}
function InStyle($Val,$Name) {
	$txt = "<label>$Name</label>";
	$Key = $Name.$Val;
	$Wert=[0,10,0,10,'px'];
	global $$Key;
	if (isset($$Key[4]))
		$Wert = $$Key;
	else
		$Wert = [0,10,0,10,'px'];
	for ($i=0;$i<4;$i++) {
		$txt .= '<input class="tabzahl" name="'. $Key.'['.$i.']" value="'. $Wert[$i] ."\">\n";
	}
	$txt .= Units($Key.'[4]',$Wert[4])."<br>\n";
	return $txt;
}
function SetStyles($Val,$Bezeichnung) {
	$txt = "<label><b>$Bezeichnung</b></label><br>\n";
	$txt.= InStyle($Val,'Margin');
	$txt.= InStyle($Val,'Padding');
	return $txt;
}
function UnitSelect($Item,$Wert,$Name,$Unit='em') {
	$txt  = '<input name="'.$Item.'" class="tabzahl" value="'.$Wert.'">' . Units($Name,$Unit);
	return $txt;
}
function Units($Name,$Unit='em') {
//	https://wiki.selfhtml.org/wiki/CSS/Wertetypen/Ma%C3%9Fangaben
	$txt  = '<select name="'.$Name.'" style="width:44px">';
	$txt .= txtOption('px','px',$Unit);
	$txt .= txtOption('em','em',$Unit);
	$txt .= txtOption('rem','rem',$Unit);
	$txt .= txtOption('%','%',$Unit);
	return $txt.'</select>';
}
function PageSelect($Var,$Val,$Label='',$Null='',$Desc='') {
	global $db;
	startSelect($Var, empty($Label) ? $Var : $Label);
	if ($Null)
		echo txtOption(0,$Null,$Val);
	$sql = "SELECT URL,Link FROM Pages WHERE Parent=0 AND Show>0 AND RefID=0 AND Lang=0 AND NOT Type LIKE 'Link%' ORDER BY Show,Folge";
	$res = $db->query($sql);
	while ($rec = $res->fetchArray()) {
		echo txtOption($rec[0],$rec[1],$Val);
	}
	echo "</select> $Desc<br>\n";
}
// Array mit allen Usern, ggf. mit Bedingung $cond
function getUsers($cond='') {
	global $db,$UserStyle;
	$NeedVN = !($UserStyle==0 || $UserStyle==5);
	$sql = 'SELECT ID,Name,RealName,VName,NName FROM Users' . (($cond!='') ? " WHERE $cond" : '');
	$rec = $db->query($sql);
	while ($res = $rec->fetchArray()) {
		$Users[$res[0]] = getUserName($res[1],$res[2],$res[3],$res[4]);
	}
	return $Users;
}
// erzeugt Text für die Historie
function credits($Approval,$Creator,$Created,$Changer,$Changed,$Approver,$Approved) {
	$Users = getUsers();
	$txt = '<p><small>';
	if ($Creator OR $Created) {
		$txt .= 'Erstellt';
		if ($Created) $txt .= ' am '.date('d.m.Y',$Created);
		if ($Creator) $txt .= ' von '.$Users[$Creator];
	} else {
		$txt .= 'Autor unbekannt';
	}
	$txt .= "<br>\nLetzte Änderung";
	if ($Changer OR $Changed) {
		if ($Changed) $txt .= ' am '.date('d.m.Y',$Changed);
		if ($Changer) $txt .= ' von '.$Users[$Changer];
	} else {
		$txt .= ' unbekannt';
	}
	$txt .= "<br>\n";
	if ($Approval) {
		$txt .= 'Letzte Freigabe';
		if ($Approver OR $Approved) {
			if ($Approved) $txt .= ' am '.date('d.m.Y',$Approved);
			if ($Approver) $txt .= ' von '.$Users[$Approver];
		} else {
			$txt .= ' unbekannt';
		}
	}
	$txt .= "</small></p>\n";
	return $txt;
}

function TextCompare($text1,$text2) {
	$array1 = explode(' ', str_replace(array("  ", "\r", "\n"), array(" ", "", ""), $text1));
	$array2 = explode(' ', str_replace(array("  ", "\r", "\n"), array(" ", "", ""), $text2));
	$max1 = count($array1);
	$max2 = count($array2);

	$start1 = $start2 = 0;
	$jump1 = $jump2 = 0;
	while($start1 < $max1 && $start2 < $max2){
		$pos11 = $pos12 = $start1;
		$pos21 = $pos22 = $start2;
		$diff2 = 0;
		// schaukel 1. Array hoch
		while($pos11 < $max1 && $array1[$pos11] != $array2[$pos21]){
			++$pos11;
		}
		// Ende des 1 Arrays erreicht ?
		if($pos11 == $max1){
			$start2++;
			continue;
		}
		// Gegenschaukel wenn übersprunge Wörter
		if(($diff1 = $pos11 - $pos21) > 1){
			while($pos22 < $max2 && $array1[$pos12] != $array2[$pos22]){
				++$pos22;
			}
			$diff2 = $pos22 - $pos12 + $jump2;
		} 
		// Ende des 2 Arrays erreicht ?
		if($pos22 == $max2){
			$start1++;
			continue;
		}
		$diff1 += $jump1;
		// Auswertung der Schaukel
		if($diff1 >= $diff2 && $diff2){
			unset($array1[$pos12], $array2[$pos22]);
			$start1 = $pos12 + 1;
			$start2 = $pos22 + 1;
			$jump2 = $diff2;
		}else{
			unset($array1[$pos11], $array2[$pos21]);
			$start1 = $pos11 + 1;
			$start2 = $pos21 + 1;
			$jump1 = $diff1;
		}
	}
	$safe1 = explode(' ', $text1);
	reset($array1);
	while(list($key1,) = each($array1)){
		$safe1[$key1] = '<span style="color:green">' . $safe1[$key1] . '</span>';
	}
	$safe2 = explode(' ', $text2);
	reset($array2);
	while(list($key2,) = each($array2)){
		$safe2[$key2] = '<span style="color:red">' . $safe2[$key2] . '</span>';
	}
	$rtn = array(implode(' ', $safe1), implode(' ', $safe2));
	return $rtn;
}
//-------------------------------------------------------------------------------
/*
	Paul's Simple Diff Algorithm v 0.1 (https://github.com/paulgb/simplediff)
	(C) Paul Butler 2007 <http://www.paulbutler.org/>
	May be used and distributed under the zlib/libpng license.*/
function diff($old, $new){
	$matrix = array();
	$maxlen = 0;
	foreach($old as $oindex => $ovalue){
		$nkeys = array_keys($new, $ovalue);
		foreach($nkeys as $nindex){
			$matrix[$oindex][$nindex] = isset($matrix[$oindex - 1][$nindex - 1]) ?
				$matrix[$oindex - 1][$nindex - 1] + 1 : 1;
			if($matrix[$oindex][$nindex] > $maxlen){
				$maxlen = $matrix[$oindex][$nindex];
				$omax = $oindex + 1 - $maxlen;
				$nmax = $nindex + 1 - $maxlen;
			}
		}	
	}
	if($maxlen == 0) return array(array('d'=>$old, 'i'=>$new));
	return array_merge(
		diff(array_slice($old, 0, $omax), array_slice($new, 0, $nmax)),
		array_slice($new, $nmax, $maxlen),
		diff(array_slice($old, $omax + $maxlen), array_slice($new, $nmax + $maxlen)));
}

function htmlDiff($old, $new) {
	$ret = '';
//	$diff = diff(explode(' ', $old), explode(' ', $new));
	$old = html_entity_decode(str_replace(['<br>','</p>'],[' &crarr;<br> ',' &para;</p> '],$old));	// &crarr; &para; [' ↵<br> ',' ¶</p> ']
	$new = html_entity_decode(str_replace(['<br>','</p>'],[' &crarr;<br> ',' &para;</p> '],$new));
	$diff = diff(preg_split("/[\s]+/", $old), preg_split("/[\s]+/", $new));
	foreach($diff as $k){
		if(is_array($k))
			$ret .= (!empty($k['d'])?"<del>".implode(' ',$k['d'])."</del> ":'').
				(!empty($k['i'])?"<ins>".implode(' ',$k['i'])."</ins> ":'');
		else $ret .= $k . ' ';
	}
	return $ret;	// "Old:\n$old\nNew:\n$new\n$ret";
}
//-------------------------------------------------------------------------------
function Galerie($nr,$Use,$w,$h,$txt,$dir,$fix,$tmb,$tw=0,$th=0) {
	global $MyAlbenText;
	switch ($nr) {
		case 1: $txtGal = '(1) Diashow'; break;
		case 2: $txtGal = '(2) Tabelle'; break;
		case 3: $txtGal = '(3) Bildleiste'; break;
		case 4: $txtGal = '(4) Hintergrund'; break;
		case 5: $txtGal = '(5) ...'; break;
		case 6: $txtGal = '(6) Attachments'; break;
		case 7: $txtGal = '(7) ...'; break;
		case 8: $txtGal = '(8) KissGallery'; break;
		case 9: $txtGal = '(9) '.$MyAlbenText; break;
	}
	echo '<tr><td>'.$txtGal.'</td><td><input type="checkbox" name="UseGal'.$nr.'" '.($Use?"checked ":"").'/></td><td><input type="text" class="tabzahl" name="GalWid'.$nr.'" value="'.$w.'"></td><td><input type="text" class="tabzahl" name="GalHgt'.$nr.'" value="'.$h.'"></td><td>'.GalFix($nr,$fix).'</td><td><input type="text" class="tabtext" name="GalTxt'.$nr.'" value="'.$txt.'"></td><td><input type="text" class="tabtext" name="GalDir'.$nr.'" value="'.$dir.'"></td><td><input type="checkbox" name="UseTmb'.$nr.'" '.($tmb?"checked ":"").'/></td><td><input type="text" class="tabzahl" name="GalThW'.$nr.'" value="'.$tw.'"></td><td><input type="text" class="tabzahl" name="GalThH'.$nr.'" value="'.$th.'"></td></tr>'."\n";
}
function GalTypeSelect($type,$nr) {
	global $strGalType;
	$txt = '<select style="width:100px;" name="KissGal['.$nr.'][4]">';
	for ($i=0; $i<4; $i++)
		$txt .= '<option value="' . $i . '"' . (($type==$i)?' selected="selected"':'') . '>' . $strGalType[$i] . "</option>\n";
	return $txt."</select>\n";
}

// Funktionen für die Bildergalerien / Alben:
// Bildfiles als Liste anzeigen (für Admin):
function listAlbum($pfad,$GalTxt,$GalWid,$GalHgt,$txtGal,$edit) {
	formkopf("Hier löschen Sie Bilder von der Bildergalerie $txtGal oder laden neue Bilder hoch",'');
	$legend = $GalTxt.", Mindestgröße (B*H) $GalWid Pixel * $GalHgt Pixel";
	echo AlbumList($pfad,'','Bild',$legend);
	echo formclose($edit);
}
// listet die Dateien in einem Album auf:
function AlbumList($pfad,$index='',$was='Bild',$legend='') {
	$bildliste = getAlbumFiles($pfad);
	$text = "<fieldset><legend>$legend</legend>\n";
	foreach ($bildliste as $datei) {
		$text.= '<label for="'.$datei.'">Löschen:</label><input type="checkbox" id="'.$datei.'" name="del[]" value="'.$datei.'" title="'.$was.' zum Löschen markieren"> <a href="'.$pfad."/".$datei.'" '. (($was=="Bild")?('class="lightbox-'.$pfad.'"'):('target="_blank"')) .' title="'.$datei.'">'.$datei."</a><br>\n";
	}
	$text.= '<label>'.$was.' neu:</label><input type="file" name="'.$was.$index.'"><br>';
	$text.= "</fieldset>\n";
	return $text;
}
// listet rekursiv die (klassischen) Foto-Alben auf:
function AlbumTable($Parent=0,$ParentFolder='') {
	global $alben,$pages,$AlbenFolder,$PopUpAlben;
	$popup = ($PopUpAlben) ? 'if (this.checked) this.checked=confirm(\'Sind Sie sicher? Sie können Alben auch inaktiv stellen!\');' : '';
	$td = ($Parent==0) ? '<td colspan="2">' : '<td>&nbsp;-&gt;&nbsp;</td><td>';
	foreach($alben as $rec) {
		$album = explode("#", trim($rec,"\r\n"));
		if ($album[1]==$Parent) {
			$Nr = $album[0];
			$MyAlbum = $AlbenFolder.$ParentFolder.$album[3];
			echo '<tr><td><input type="radio" name="Album" onclick="fillalbum('.$Nr.')" id="Fold'.$Nr.'" value="Folder'.$Nr.'" title="Dieses Album bearbeiten"><div class="helper" id="AlComm'.$Nr.'">'.$album[4].'</div></td><td><input type="checkbox" name="delAl[]" value="'.$ParentFolder.$album[3].'" title="Dieses Album zum Löschen markieren" onclick="' . $popup . 'if (this.checked) fillalbum('.$Nr.');"></td>' . $td . '<label for="Fold'.$Nr.'" id="AlKlar'.$Nr.'">'.$album[2]."</label>\n	<div id=\"AlList".$Nr.'" class="albumlist">'.AlbumList($MyAlbum,$Nr,'Bild','Bilder in diesem Album')."</div>\n	<div id=\"AlHier".$Nr.'" class="helper">'.$album[1].'-'.$ParentFolder.'</div><div class="helper" id="AlBild'.$Nr.'">'.$album[6].'</div><div class="helper" id="AlText'.$Nr.'">'.$album[7].'</div></td><td id="AlAktiv'.$Nr.'">'. (($album[5])?"ja":"nein") .'</td><td id="AlLink'.$Nr.'">'.$album[3]."</td></tr>\n";
			if ($Nr>$pages) $pages=$Nr;
			// und hier jetzt die Rekursion:
			AlbumTable($Nr,$album[3]."/");
		}
	}
}
// listet rekursiv die Kiss-Alben auf:
function printKissAlben($Parent=0,$Level=0){
	global $db;
	$Inset = substr('>>>>>>>>>',0,$Level);
	$sql = "SELECT ID,Parent,Name,Cover,C_Text FROM Gallery WHERE App=9 AND Parent=$Parent ORDER BY Folge";
	$res = $db->query($sql);
	while ($rec = $res->fetchArray()) {
		$ID = $rec[0];
		echo '<tr><td><input type="radio" id="ka'.$ID.'" name="KissAlbum" onclick="fillkissalbum('.$ID.')" value="Album'.$ID.'"><div class="helper" id="Cover'.$ID.'">'.$rec[3].'</div><div class="helper" id="CText'.$ID.'">'.$rec[4].'</div><div class="helper" id="Parent'.$ID.'">'.$rec[1].'</div></td><td><input type="checkbox" name="del[]" value="'.$ID.'"></td><td>'.$Inset.' <label for="ka'.$ID.'" class="long" id="Name'.$ID.'">'.$rec[2]."</label></td></tr>\n";
		printKissAlben($ID,$Level+1);
	}
}
// listet rekursiv die Kiss-Alben zum Sortieren auf:
function sortKissAlben($Parent,$Level,$gid){
	global $db;

	$clicksort="<span class=\"cursor\" onclick=\"oeffne('KissOrder','$Parent&todo=sort&id=";
	$Inset = substr('>>>>>>>>>',0,$Level) . ' ';
	$count = 0;
	$GalName = '';
	$Anzahl= $db->querySingle("SELECT COUNT(ID) FROM Gallery WHERE Parent=$Parent");
	$sql = "SELECT ID,Name,App FROM Gallery WHERE Parent=$Parent ORDER BY Folge";
	$res = $db->query($sql);
	while ($rec = $res->fetchArray()) {
		$count++;
		$ID = $rec['ID'];
		if ($ID == $gid)
			$GalName = $rec['Name'];
		echo '<tr>';
		if ($Anzahl>1) {
			echo ClickToSort($clicksort,$Anzahl,$count,$ID);
		} else {
			echo '<td></td><td></td>';
		}
		$Oeffne = ($rec['App'] == 9 && $Parent>0) ? 'kissAlben' : 'gallery';
		echo '<td><span class="kiss" onclick="oeffne(' . "'$Oeffne',$ID,0)\">$Inset" . $rec['Name'] .
			 '</span></td><td><span class="kiss" onclick="oeffne(' . "'KissPicsFile',$ID,0)\">bearbeiten</span></td></tr>\n";
		$txt = sortKissAlben($ID,$Level+1,$gid);
		if ($txt != '')
			$GalName = $txt;
	}
	return $GalName;
}
// rekursive Liste der Kiss-Alben für das Auswahlfeld
function selectKissAlben($Parent,$Level,$gid,$App=null){
	global $db, $AnzGal;
	$txt = '';
	$where = (empty($App)) ? '' : "App=$App AND";
	$Inset = substr('>>>>>>>>>',0,$Level) . ' ';
	$sql = "SELECT ID,Name FROM Gallery WHERE $where Parent=$Parent ORDER BY Folge";
	$res = $db->query($sql);
	while ($rec = $res->fetchArray()) {
		$ID = $rec['ID'];
		$AnzGal++;
		$txt .= txtOption($ID, $Inset.$rec['Name'], $gid);
		$txt .= selectKissAlben($ID,$Level+1,$gid,$App);
	}
	return $txt;
}

// listet rekursiv alle Seiten für Edit der Seitenstruktur/Navigation auf:
function PageTable($Parent='0',$Level=0, $num='', $isLocked=false) {
	global $db, $May, $PopUpNavi;
	global $CompactPageTable;	// Tabelle kompakt/erweiterbar oder gleich komplett mit allen Ebenen
	global $StraightPageTable;	// Show-Status in Folge integriert oder separat sortiert
	global $ShowPageFolge;
	global $AutoNumbers, $StartNumber, $EndNumber;	// Kapitelnummerierung

	$clicksort="<span class=\"cursor\" onclick=\"oeffne('edinavi','$Parent&todo=sort&id=";

	$popup = ($PopUpNavi) ? 'if (this.checked) this.checked=confirm(\'Sind Sie sicher? Sie können Seiten auch inaktiv stellen!\');' : '';
	$td = '<td class="nowrap">'.substr('.....................',0,$Level*3);
	$table = '';
	$mylang = $_SESSION['WorkLang'];

	$Anzahl= $db->querySingle("SELECT COUNT(ID) FROM Pages WHERE Parent=$Parent AND Lang=$mylang AND RefID=0");
	$query = "SELECT * FROM Pages WHERE Parent=$Parent AND Lang=$mylang AND RefID=0 ORDER BY ". (($StraightPageTable)?'':'Show,') .'Folge';
	$result = $db->query($query);
	if ($result->numColumns()) {
		$count = 0;
		while ($rec = $result->fetchArray(SQLITE3_ASSOC)) {
			$count++;
			$ID = $rec['ID'];

		//	Kapitelnummerierung:
			$Number = '';
			if ($AutoNumbers) {
				if ($Level==0 && $rec['Folge'] >= $StartNumber && $rec['Folge'] <= $EndNumber) {
					$Number = ($rec['Folge'] - $StartNumber - 1 + $AutoNumbers).'';
				} elseif ($num!="") {
					$Number = $num . '.' . $rec['Folge'];	// bei Unterkapiteln einen Punkt in der Nummerierung hinzufügen
				}
			}

			$Icon = ($rec['Icon']=='') ? 0 : $rec['Icon'];
			$zeile = '<td><input type="radio" name="Seite" onclick="filleditpage('.$ID.')" id="Page'.$ID.'" value="Page'.$ID.'" title="Die Vorgaben dieser Seite bearbeiten"></td>';
			if ($May['AddPages']) {
				$zeile .= '<td><input type="checkbox" title="Diese Seite zum Löschen markieren" name="delpage[]" value="'.$ID.'" onclick="' . $popup . '"></td>';
//				$zeile .= '... onclick="' . $popup . 'if (this.checked) filleditpage('.$ID.');">'; -> gefährlich, da bereits andere Seite ausgewählt sein kann und Nummer bleibt!!!!
			}
			if ($May['SortPages']) {
				$zeile .= ClickToSort($clicksort,$Anzahl,$count,$ID);
			}
			if ($AutoNumbers) {
				$zeile .= "</td><td>".$Number;
			} elseif ($ShowPageFolge) {
				$zeile .= "</td><td>".$rec['Folge'];
			}
			$AddC = $rec['AddC'] & 1;
			$Comm = (int)($rec['AddC']/2);
			$zeile .= $td .'<label for="Page'.$ID.'" id="Link'.$ID.'">'.$rec['Link'].'</label><div class="helper" id="Hier'.$ID.'">'.$rec['Parent'].'</div><div class="helper" id="Param'.$ID.'">'.$rec['Parameter']. '</div><div class="helper" id="AddC'.$ID.'">'.$AddC.'</div><div class="helper" id="Comm'.$ID.'">'.$Comm.'</div><div class="helper" id="Icon'.$ID.'">'.$Icon. '</div><div class="helper" id="Info'.$ID.'">'.$rec['Info']. '</div><div class="helper" id="Image'.$ID.'">'.$rec['Image']. '</div><div class="helper" id="Stat'.$ID.'">'.$rec['Status']. '</div><div class="helper" id="Back'.$ID.'">'.$rec['Back']. '</div><div class="helper" id="Desc'.$ID.'">'.$rec['Desc']. '</div><div class="helper" id="Keys'.$ID.'">'.$rec['Keys']. '</div></td><td id="Show'.$ID.'">'.$rec['Show'].'</td><td><a href="?'.$rec['URL'].'" title="Seite aufrufen" id="URL'.$ID.'">'.$rec['URL'].'</a></td><td id="Title'.$ID.'">'.$rec['Title'].'</td><td id="Kopf'.$ID.'">'.$rec['Kopf'].'</td><td id="Type'.$ID.'">'.$rec['Type']. '</td><td id="Lock'.$ID.'">'.(($rec['Login'] || $isLocked)?'ja':'nein').'<div class="helper" id="Login'.$ID.'">'.$rec['Login']. '</div><div class="helper" id="Pict'.$ID.'">'.$rec['Picture']. '</div><div class="helper" id="Auto'.$ID.'">'.$rec['Auto'].'</div><div class="helper" id="InfoVon'.$ID.'">'.$rec['Von'].'</div><div class="helper" id="InfoBis'.$ID.'">'.$rec['Bis']."</div></td></tr>\n";
			// und hier jetzt die Rekursion:
			$snum = $ID;
//			$isLocked = $isLocked || ($rec['Login']==2);
			$text = PageTable($ID,$Level+1,$Number, $rec['Login']==2);
			$Ln = 'L'.($Level+1);
			if ($text!='') {
				if ($CompactPageTable && $Level==0) {	// OBACHT: <tbody> (auch vom Browser automatisch eingefügt!) lässt sich nicht verschachteln!!!!
					$table .= "<tr class=\"isParent $Ln\">$zeile<tbody id=\"Sub$snum\" class=\"helper\">$text</tbody>";
//					$table .= "<tr class=\"isParent $Ln\">$zeile<tr id=\"Sub$snum\"><td colspan=\"11\"><table>$text</table></td></tr>";
				} else {
					$table .= "<tr class=\"isParent $Ln\">$zeile $text";
				}
			} else {
				$table .= "<tr class=\"noChild $Ln\">$zeile";
			}
		}
	}
	return $table;
}
// listet rekursiv alle Seiten für Hierarchieauswahl der Seitenstruktur/Navigation auf:
function pagemap($Parent=0,$Level=0,$num='') {
	global $db, $SortMainFirst;
	global $AutoNumbers, $StartNumber, $EndNumber;	// Kapitelnummerierung

	$mylang = $_SESSION['WorkLang'];
	$text = '';
	$sql = "SELECT ID,Link,Folge FROM Pages WHERE Parent=$Parent AND Show<2 AND Lang=$mylang AND RefID=0 AND NOT Type IN ('LinkPrint','LinkHome','LinkLang') ORDER BY Folge";	// normalerweise Show=1
	$res = $db->query($sql);
	$ins = substr('.....................',0,$Level*3);
	while ($rec = $res->fetchArray()) {
		// Kapitelnummerierung:
		$Number = '';
		if ($AutoNumbers) {
			if ($Level==0 && $rec['Folge'] >= $StartNumber && $rec['Folge'] <= $EndNumber) {
				$Number = ($rec['Folge'] - $StartNumber - 1 + $AutoNumbers).'';
			} elseif ($num!="") {
				$Number = $num . '.' . $rec[2];	// bei Unterkapiteln einen Punkt in der Nummerierung hinzufügen
			}
			$ins = $Number." ";
		}
		// Rekursion
		$sub = pagemap($rec[0],$Level+1,$Number);
		if ($SortMainFirst && $Level==0) {
			if ($sub!='') $text .= '</optgroup><optgroup label="Ist in \''.$rec[1].'\' Unterseite von">'.$sub;
		} else {
			$text .= '<option value="'.$rec[0].'">'.$ins.$rec[1]."</option>\n$sub";
		}
	}
	return $text;
}
function LangList($sel='',$erlaubt=false) {
	global $WIBcmsLang,$excludeLang;
	foreach($WIBcmsLang as $key=>$val) {
		// background-image:url('core/flags/$key.gif');
		if (empty($excludeLang) || (in_array($key,$excludeLang)==$erlaubt))
			echo txtOption($key,$val,$sel);
	}
}
function selectLangSynch($select,$val,$dis) {
	startSelect($select,"Synchronisation",$dis);
	echo txtOption(0,"keine Synchronisation ",$val);
	echo txtOption(1,"nur Startseite wird synchronisiert",$val);
	echo txtOption(2,"nur Hauptseiten werden synchronisiert",$val);
	echo txtOption(3,"nur aktive Seiten werden synchronisiert",$val);
	echo txtOption(5,"alle Seiten werden synchronisiert",$val);
	echo txtOption(7,"Seiten und Navigation stimmen überein",$val);
//	echo txtOption(8,"strikte Synchronisation ohne Löschen",$val);
	echo txtOption(9,"strikte Synchronisation inkl. Löschen",$val);
	echo "</select>\n";
}
function selectLangMatch($select,$val,$dis) {
	startSelect($select,"Übereinstimmung",$dis);
	echo '<optgroup label="Für Ersterstellung und spätere Pflege:">';
	echo txtOption(0,"Inhalte 1:1 aus der Standardsprache übernehmen",$val);
	echo txtOption(1,"Inhalte nur übernehmen, wenn Bilder vorkommen",$val);
	echo txtOption(2,"alle Textinhalte komplett weglassen",$val);
	echo '</optgroup><optgroup label="Zusätzlich nur für spätere Pflege:">';
	echo txtOption(4,"neue Seiten deaktivieren",$val);
	echo "</select><br>\n";
}
// listet die Downloadseiten auf ('Kategorien' und Unterkategorien):
function DLPages($Parent,$Kategorie=0,$isDL=false) {	// siehe ABIC: function DLMap()
	global $db,$mylang;
	$DLmap = '';
	$query = "SELECT ID,Link,Type FROM Pages WHERE Parent=$Parent AND Lang=$mylang ORDER BY Folge";
	$result = $db->query($query);
	while ($row = $result->fetchArray(SQLITE3_NUM)) {
		if ($isDL || $row[2]=='Download') {
			$DLmap .= txtOption($row[0],$row[1],$Kategorie);
			$temp = DLPages($row[0],$Kategorie,true);
		} else {
			$temp = DLPages($row[0],$Kategorie,false);
		}
		if (!empty($temp)) {
			if (substr($temp,0,5)=='<optg') {
				$DLmap .= $temp;
			} else {
				$DLmap .= '<optgroup label="'.$row[1].'-Kategorien:">' .$temp. "</optgroup>\n";
			}
		}
	}
	return $DLmap;
}
// schreibt eine Zeile in die Materialübersicht:
function matOrdner($folder,$comment='&nbsp;') {
	global $db, $WIBcmsFilePrefix;	// ../ voranstellen, da Ordnernamen ohne ../ aus dem Config-File daherkommen
	$text = '<tr><td><input type="radio" name="MatOrdner" id="Mat_'.$folder.'" value="'.$folder.'" onclick="matlist(\''.$folder.'\')"></td><td><label for="Mat_'.$folder.'">'.$folder.'</label><div class="albumlist" id="MatList_'.$folder.'">'.AlbumList($WIBcmsFilePrefix.$folder,$folder,"Datei")."</div></td><td>$comment</td></tr>\n";
	return $text;
}

// zeigt Sortier-Felder an:
function ClickToSort($clicksort,$Anzahl,$count,$ID) {
	global $img_UP,$img_UPUP,$img_DOWN,$img_DDWN,$img_SWAP;
	$txt = '';
	if ($count==1) {
		$txt = "<td style=\"text-align:center\">$clicksort$ID&to=swap',0)\">$img_SWAP</span></td>";
	} else {
		$txt = "<td nowrap>$clicksort$ID&to=upup',0)\">$img_UPUP</span> $clicksort$ID&to=up',0)\">$img_UP</span></td>";
	}
	if ($count<$Anzahl) {
		$txt .= "<td nowrap>$clicksort$ID&to=down',0)\">$img_DOWN </span> $clicksort$ID&to=ddwn',0)\">$img_DDWN</span></td>";
	} else {
		$txt .= '<td> </td>';
	}
	return $txt;
}
// sortiert Einträge in der Datenbank neu (ReihenFolge):
function Sortiere($ID,$to,$Table,$Where,$Folge,$db) {
//	global $db;
	$sql = "SELECT ID,Folge FROM $Table WHERE $Where";
	switch ($to) {
	  case 'up':
		$sql .= " AND Folge<$Folge ORDER BY Folge DESC";
		$res = $db->querySingle($sql,1);
		$db->exec("UPDATE $Table SET Folge=$Folge WHERE ID=".$res['ID']);
		$db->exec("UPDATE $Table SET Folge=".$res['Folge']." WHERE ID=$ID");
		break;
	  case 'upup':
		$sql .= " AND Folge<$Folge ORDER BY Folge ASC";
		$res = $db->querySingle($sql,1);
		$db->exec("UPDATE $Table SET Folge=Folge+1 WHERE $Where AND Folge<$Folge");
		$db->exec("UPDATE $Table SET Folge=".$res['Folge']." WHERE ID=$ID");
		break;
	  case 'down':
		$sql .= " AND Folge>$Folge ORDER BY Folge ASC";
		$res = $db->querySingle($sql,1);
		$db->exec("UPDATE $Table SET Folge=$Folge WHERE ID=".$res['ID']);
		$db->exec("UPDATE $Table SET Folge=".$res['Folge']." WHERE ID=$ID");
		break;
	  case 'ddwn':
		$sql .= " AND Folge>$Folge ORDER BY Folge DESC";
		$res = $db->querySingle($sql,1);
		$db->exec("UPDATE $Table SET Folge=Folge-1 WHERE $Where AND Folge>$Folge");
		$db->exec("UPDATE $Table SET Folge=".$res['Folge']." WHERE ID=$ID");
		break;
	  case 'swap':
		$Where = str_replace(['Show=0','Show=1','Show=2','Show=3'],'ID>0',$Where);	// bei: pages
		$res = $db->querySingle("SELECT MAX(Folge) FROM $Table WHERE $Where") + 1;
		$db->exec("UPDATE $Table SET Folge=$res-Folge WHERE $Where");
		break;
	}
}
?>