/* ### javascript-Funktionen für den Kommentarbereich ### */

// languages: [0=>'deutsch', 1=>'englisch', 2=>'französisch', 3=>'spanisch', '4'=>'italienisch', 5=>'holländisch', 6=>'portugiesisch'];
let head,reply;
switch (MyLang) {
	case 0:	head = 'Hinterlassen Sie einen Kommentar'; reply = 'Antwort auf diesen Kommentar'; break;
	case 1: head = 'Leave a comment'; reply = 'Reply to this comment'; break;
	case 2: head = 'Laisser un commentaire'; reply = 'Répondre à ce commentaire'; break;
	case 3: head = 'Deja un comentario'; reply = 'Responder a este comentario'; break;
	case 4: head = 'Lascia un commento'; reply = 'Rispondi a questo commento'; break;
	case 5: head = 'Laat een reactie achter'; reply = 'Reageer op deze opmerking'; break;
	case 6: head = 'Deixe um comentário'; reply = 'Responder a este comentário'; break;
	default:head = 'Hinterlassen Sie einen Kommentar'; reply = 'Antwort auf diesen Kommentar';
}
// identify DOM elements:
let CommForm = document.getElementById('CommForm');
let CommHead = CommForm.firstChild;
let replies = document.getElementsByClassName('replyto');

// initialize first comment:
let MyReplyTo = 0;

// listen to clickable replies
for (let i = 0; i < replies.length; i++) {
	replies[i].addEventListener('click', activateReply);
}

function activateReply(event) {
	CommHead.innerHTML = reply;
	CommForm.style.display = 'none';
	id = event.target.id;
	if (MyReplyTo>0) {
		deleteForm(MyReplyTo);
	}
	MyReplyTo = id.substr(6);
//	alert (id + ': ' + MyReplyTo);
	NewForm = document.getElementById('repform_'+MyReplyTo);
	NewForm.innerHTML = CommForm.innerHTML;
	NewForm.style.display='block';
	document.getElementById('CommReply').value = MyReplyTo;
	NoReply = document.getElementById('noreply');
	NoReply.style.display = 'inline';
	NoReply.addEventListener('click', deactivateReply);
}

function deactivateReply() {
	if (MyReplyTo>0) {
		deleteForm(MyReplyTo);
	}
	MyReplyTo = 0;
	CommHead.innerHTML = head;
	CommForm.style.display = 'block';
	document.getElementById('CommReply').value = MyReplyTo;
	NoReply = document.getElementById('noreply');
	NoReply.style.display = 'none';
}

function deleteForm(nr) {
	NoReply = document.getElementById('noreply');
	NoReply.removeEventListener('click', deactivateReply);
	OldForm = document.getElementById('repform_'+nr);
	OldForm.style.display = 'none';
	OldForm.innerHTML = '';
}