// Übergangsfunktion in einer Bildergalerie:
// Index fuer das aktuelle Bild:
var bildindex = 1;
// Für wechselseitiges Bildwechseln der 2 IDs (Home0 / Home1)
var FromID = "Home0";
var ToID = "Home1";
var phase = 0;

// Default-Vorgaben:
var diaeffekt = 0;
var diawechsel= 0;
var wartezeit = 4000;
var blend = 20;
var step  = 0.01;
var zufall= false;

// Bilderliste holen:
var src = document.getElementById(FromID).src;
// alert(src);


var effects = new Array(0, 1,2, 3,4,5,6,7,8, 10,11,12,13,14,15); // erlaubte Effekte
var effAnzahl = 15;	// Anzahl der erlaubten Effekte

var position1=0, position2, fertig=0, positionmax=900; // für den Slider

function getRandom(min, max) {
	r = (Math.floor(Math.random()*(max-min+1)))+min;
	return r;
}

function diainit(e,w,h,b,s,pw,ph) {
	diaeffekt = e;
	diawechsel = w;
	wartezeit = h;
	blend= b;
	step = 1/s;
	if (typeof pw !== 'undefined') positionmax = pw;
	else positionmax = document.getElementById(FromID).width;
	if (diaeffekt>89) {
		if (diaeffekt==93) zufall=true;
		diaeffekt=effects[getRandom(0,14)];
	}
	if (diaeffekt==0) bildindex=0;
	window.setTimeout('startshow()',wartezeit);
}
function showdia(index) {
	if (index!=bildindex) {
		indexid = "showdia" + bildindex;
		document.getElementById(indexid).className = "normal";
		bildindex = index;
		indexid = "showdia" + bildindex;
		document.getElementById(indexid).className = "aktiv";
		document.getElementById(ToID).src = bildordner + bildliste[index];
	}
	if (diaeffekt==0)
		document.getElementById(FromID).src = bildordner + bildliste[index];
	else {
		startshow();
		swapID = FromID;
		FromID = ToID;
		ToID = swapID;
	}
}

function startshow() {
	if (FromID == ToID) {
		// Übergangseffekt auf das gleiche Bild ist nicht möglich!
		alert ('Sie muessen die IDs zweier unterschiedlicher HTML-Elemente angeben!');
	} else {
		if (zufall) diaeffekt=effects[getRandom(0,14)]; // Leerbilder möglich!!!
		switch(diaeffekt) {
		case 1: // Überblendung (Cross Fade)
			phase = 3;
			fader(FromID,ToID); break;
		case 2: // Ein-Aus-Blende (FadeOut - FadeIn)
			phase = 1;
			fader(FromID,ToID); break;

		case 3: // SlideOver r to l
			phase = 0;
			slider(FromID,ToID); break;
		case 4: // SlideOver l to r
			phase = 2;
			slider(FromID,ToID); break;
		case 5: // SlideAway r to l
			phase = 1;
			slider(FromID,ToID); break;
		case 6: // SlideAway l to r
			phase = 3;
			slider(FromID,ToID); break;
		case 7: // SlideFree r to l
			phase = 4;
			slider(FromID,ToID); break;
		case 8: // SlideFree l to r
			phase = 5;
			slider(FromID,ToID); break;

		case 10: // Falling down
			phase = 2;
			faller(FromID,ToID); break;
		case 11: // Falling down
			phase = 0;
			faller(FromID,ToID); break;
		case 12: // Slide Away up
			phase = 3;
			faller(FromID,ToID); break;
		case 13: // Slide Away down
			phase = 1;
			faller(FromID,ToID); break;
		case 14: // Falling down
			phase = 5;
			faller(FromID,ToID); break;
		case 15: // Falling down
			phase = 4;
			faller(FromID,ToID); break;

		default: // kein Effekt (harter Wechsel)
			// Jetzt das nächste Bild vorbereiten:
			bildindex++;
			if (bildindex==maxbilder) bildindex=0;
			document.getElementById(FromID).src = bildordner + bildliste[bildindex];
			window.setTimeout("startshow()",wartezeit);
		}
	}
}

function nextprepare() {
	// Jetzt das nächste Bild vorbereiten:
	bildindex++;
	if (bildindex==maxbilder) bildindex=0;
	document.getElementById(FromID).src = bildordner + bildliste[bildindex];
	swapID = FromID;
	FromID = ToID;
	ToID = swapID;
	window.setTimeout("startshow()",wartezeit);
}

// Funktion zum Überblenden von einem Bild auf ein anderes
// Mit den beiden Parametern werden die IDs der Bildelemente angegeben,
// die ineinander übergeblendet werden sollen.
function fader(el1,el2) {
  // Verweise auf die Elemente holen:
  var e1 = document.getElementById(el1);
  var e2 = document.getElementById(el2);
  // Prozess noch nicht gestartet?
  if (!this.proc) {
	// Prozess starten:
	fertig = 0;
	this.proc = window.setInterval ('fader(\'' + el1 + '\', \'' + el2 + '\')', blend);
  }
  else {
    // Effekt läuft bereits
    var opakwert1, opakwert2;
    // Aktuelle Transparenz der beiden Bilder bei
    // Opera und Mozilla-Abkömmlingen mit opacity Style-Eigenschaft..
    if (!e1.filters) {
		if (phase & 1) opakwert1 = !e1.style.opacity ? 1 : parseFloat (e1.style.opacity);
		if (phase & 2) opakwert2 = !e2.style.opacity ? 0 : parseFloat (e2.style.opacity);
    }
    // bzw. über die Filter des IE ermitteln.
    else {
		if (phase & 1) opakwert1 = !e1.filters.alpha.opacity ? 1 : parseFloat (e1.filters.alpha.opacity) / 100;
		if (phase & 2) opakwert2 = !e2.filters.alpha.opacity ? 0 : parseFloat (e2.filters.alpha.opacity) / 100;
    }
	// Transparenz der beiden Bilder um 2% (step) in die unterschiedlichen
	// Richtungen anpassen.
	if (phase & 1) {
		opakwert1 -= step;
		opakwert1 = opakwert1 < 0 ? 0 : opakwert1;
	}
	if (phase & 2) {
		opakwert2 += step;
		opakwert2 = opakwert2 > 1 ? 1 : opakwert2;
	}
	// Anpassung der Styles erfolgt wieder browserabhängig
	if (!e1.filters) {
		if (phase & 1) e1.style.opacity = opakwert1;
		if (phase & 2) e2.style.opacity = opakwert2;
	}
	else {
		if (phase & 1) e1.filters.alpha.opacity = opakwert1 * 100;
		if (phase & 2) e2.filters.alpha.opacity = opakwert2 * 100;
	}
    if (((phase & 1) && opakwert1==0) || (phase==2 && opakwert2==1)) {
		// Volle Transparenz von Bild 1 erreicht!
		// Das andere Bild ist in diesem Fall vollständig eingeblendet!
		phase++;
		if (phase>=3) {
		// Überblendung fertig, Prozess stoppen:
		window.clearInterval (this.proc);
		this.proc = null;
		// falls Automatik, nächstes Bild vorbereiten und Standzeit setzen:
		if (diawechsel<4) nextprepare();
		}
    }
  }
}

function slider(el1,el2) {
	// Verweise auf die Elemente holen...
	var e1 = document.getElementById(el1);
	var e2 = document.getElementById(el2);
	if (!this.proc) {
		// Prozess starten
		this.proc = window.setInterval ('slider(\'' + el1 + '\', \'' + el2 + '\')', blend);
		fertig = 0;
		// Zur Sicherheit Transparenz ausschalten: 
		if (!e1.filters) {
			e1.style.opacity = 1;
			e2.style.opacity = 1;
		}
		else {
			e1.filters.alpha.opacity = 100;
			e2.filters.alpha.opacity = 100;
		}

		position1 = 0;
		e2.style.zIndex = 2;

		switch (phase) {
		case 0:
		case 1:
			position2 = positionmax;
			e1.style.zIndex = 1;
			break;
		case 2:
		case 3:
			position2 = -positionmax;
			e1.style.zIndex = 1;
			break;
		case 4:
		case 5:
			position2 = 0;
			e1.style.zIndex = 3;
		}
	} else {
		// Effekt läuft bereits
		switch (phase) {
		case 0:
		case 1:
			position2 -= step*positionmax;
			if (position2<0) {position2 = 0; fertig = 1;}
			if (phase & 1) position1 -= step*positionmax; // wegschieben...
			break;
		case 2:
		case 3:
			position2 += step*positionmax;
			if (position2>0) {position2 = 0; fertig = 1;}
			if (phase & 1) position1 += step*positionmax; // wegschieben...
			break;
		case 4:
			position1 -= step*positionmax;
			if (position1<-positionmax) {position1 = -positionmax; fertig = 1;}
			break;
		case 5:
			position1 += step*positionmax;
			if (position1>positionmax) {position1 = positionmax; fertig = 1;}
			break;
		}
	}
	// Jetzt Positionen neu setzen:
	e1.style.left = position1 + "px";
	e2.style.left = position2 + "px";

	if (fertig==1) {
		// Endposition erreicht!
		// Das andere Bild ist in diesem Fall vollständig abgedeckt oder weg!
		// D.h.: Effekt fertig, Prozess stoppen:
		window.clearInterval (this.proc);
		this.proc = null;
		// falls Automatik, nächstes Bild vorbereiten und Standzeit setzen:
		if (diawechsel<4) nextprepare();
	}
}


function faller(el1,el2) {
	// Verweise auf die Elemente holen...
	var e1 = document.getElementById(el1);
	var e2 = document.getElementById(el2);
	if (!this.proc) {
		// Prozess starten
		this.proc = window.setInterval ('faller(\'' + el1 + '\', \'' + el2 + '\')', blend);
		fertig = 0;
		// Zur Sicherheit Transparenz ausschalten: 
		if (!e1.filters) {
			e1.style.opacity = 1;
			e2.style.opacity = 1;
		}
		else {
			e1.filters.alpha.opacity = 100;
			e2.filters.alpha.opacity = 100;
		}

		position1 = 0;
		e2.style.zIndex = 2;

		switch (phase) {
		case 0:
		case 1:
			position2 = positionmax;
			e1.style.zIndex = 1;
			break;
		case 2:
		case 3:
			position2 = -positionmax;
			e1.style.zIndex = 1;
			break;
		case 4:
		case 5:
			position2 = 0;
			e1.style.zIndex = 3;
		}
	} else {
		// Effekt läuft bereits
		switch (phase) {
		case 0:
		case 1:
			position2 -= step*positionmax;
			if (position2<0) {position2 = 0; fertig = 1;}
			if (phase & 1) position1 -= step*positionmax; // wegschieben...
			break;
		case 2:
		case 3:
			position2 += step*positionmax;
			if (position2>0) {position2 = 0; fertig = 1;}
			if (phase & 1) position1 += step*positionmax; // wegschieben...
			break;
		case 4:
			position1 -= step*positionmax;
			if (position1<-positionmax) {position1 = -positionmax; fertig = 1;}
			break;
		case 5:
			position1 += step*positionmax;
			if (position1>positionmax) {position1 = positionmax; fertig = 1;}
			break;
		}
	}
	// Jetzt Positionen neu setzen:
	e1.style.top = position1 + "px";
	e2.style.top = position2 + "px";

	if (fertig==1) {
		// Endposition erreicht!
		// Das andere Bild ist in diesem Fall vollständig abgedeckt oder weg!
		// D.h.: Effekt fertig, Prozess stoppen:
		window.clearInterval (this.proc);
		this.proc = null;
		// falls Automatik, nächstes Bild vorbereiten und Standzeit setzen:
		if (diawechsel<4) nextprepare();
	}
}
